# GoalRelationshipType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GoalRelationshipType**

## CodeSystem: GoalRelationshipType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/goal-relationship-type | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:GoalRelationshipType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1269 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Types of relationships between two goals. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GoalRelationshipType](ValueSet-goal-relationship-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "goal-relationship-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/goal-relationship-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1269"
    }
  ],
  "version" : "1.0.0",
  "name" : "GoalRelationshipType",
  "title" : "GoalRelationshipType",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Types of relationships between two goals.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/goal-relationship-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "predecessor",
      "display" : "Predecessor",
      "definition" : "Indicates that the target goal is one which must be met before striving for the current goal."
    },
    {
      "code" : "successor",
      "display" : "Successor",
      "definition" : "Indicates that the target goal is a desired objective once the current goal is met."
    },
    {
      "code" : "replacement",
      "display" : "Replacement",
      "definition" : "Indicates that this goal has been replaced by the target goal."
    },
    {
      "code" : "milestone",
      "display" : "Milestone",
      "definition" : "Indicates that the target goal is considered to be a \"piece\" of attaining this goal."
    },
    {
      "code" : "other",
      "display" : "Other",
      "definition" : "Indicates that the relationship is not covered by one of the pre-defined codes.  (An extension may convey more information about the meaning of the relationship.)."
    }
  ]
}

```
