# Example Related Claim Relationship Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Related Claim Relationship Codes**

## CodeSystem: Example Related Claim Relationship Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-relatedclaimrelationship | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleRelatedClaimRelationshipCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1159 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes sample Related Claim Relationship codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleRelatedClaimRelationshipCodes](ValueSet-related-claim-relationship.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-relatedclaimrelationship",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-relatedclaimrelationship",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1159"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleRelatedClaimRelationshipCodes",
  "title" : "Example Related Claim Relationship Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes sample Related Claim Relationship codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/related-claim-relationship",
  "content" : "complete",
  "concept" : [
    {
      "code" : "prior",
      "display" : "Prior Claim",
      "definition" : "A prior claim instance for the same intended suite of services."
    },
    {
      "code" : "associated",
      "display" : "Associated Claim",
      "definition" : "A claim for a different suite of services which is related the suite claimed here."
    }
  ]
}

```
