# Encounter subject status - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter subject status**

## CodeSystem: Encounter subject status 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/encounter-subject-status | *Version*:2.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EncounterSubjectStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1420 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This example value set defines a set of codes that can be used to indicate the status of the subject within the encounter 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EncounterSubjectStatus](ValueSet-encounter-subject-status.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "encounter-subject-status",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/encounter-subject-status",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1420"
    }
  ],
  "version" : "2.0.1",
  "name" : "EncounterSubjectStatus",
  "title" : "Encounter subject status",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This example value set defines a set of codes that can be used to indicate the status of the subject within the encounter",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/encounter-subject-status",
  "content" : "complete",
  "concept" : [
    {
      "code" : "arrived",
      "display" : "Arrived",
      "definition" : "The subject has arrived at the physical or virtual location and is ready to receive care."
    },
    {
      "code" : "triaged",
      "display" : "Triaged",
      "definition" : "The subject has been seen triaged by staff and is waiting for further care."
    },
    {
      "code" : "receiving-care",
      "display" : "Receiving Care",
      "definition" : "The subject is present and commenced receiving care.  This can include periods of waiting between care."
    },
    {
      "code" : "on-leave",
      "display" : "On Leave",
      "definition" : "The subject has left the physical or virtual location, but is expected to return and resume care as part of this encounter."
    },
    {
      "code" : "departed",
      "display" : "Departed",
      "definition" : "The subject has left the physical or virtual location, and is not expected to return as part of this encounter."
    }
  ]
}

```
