# Discharge disposition - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Discharge disposition**

## CodeSystem: Discharge disposition 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/discharge-disposition | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DischargeDisposition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1093 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set defines a set of codes that can be used to where the patient left the hospital. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ClinicalDischargeDisposition](ValueSet-clinical-discharge-disposition.md)
* [DischargeDisposition](ValueSet-encounter-discharge-disposition.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "discharge-disposition",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/discharge-disposition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1093"
    }
  ],
  "version" : "1.0.1",
  "name" : "DischargeDisposition",
  "title" : "Discharge disposition",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes that can be used to where the patient left the hospital.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/encounter-discharge-disposition",
  "content" : "complete",
  "concept" : [
    {
      "code" : "home",
      "display" : "Home",
      "definition" : "The patient was dicharged and has indicated that they are going to return home afterwards."
    },
    {
      "code" : "alt-home",
      "display" : "Alternative home",
      "definition" : "The patient was discharged and has indicated that they are going to return home afterwards, but not the patient's home - e.g. a family member's home."
    },
    {
      "code" : "other-hcf",
      "display" : "Other healthcare facility",
      "definition" : "The patient was transferred to another healthcare facility."
    },
    {
      "code" : "hosp",
      "display" : "Hospice",
      "definition" : "The patient has been discharged into palliative care."
    },
    {
      "code" : "long",
      "display" : "Long-term care",
      "definition" : "The patient has been discharged into long-term care where is likely to be monitored through an ongoing episode-of-care."
    },
    {
      "code" : "aadvice",
      "display" : "Left against advice",
      "definition" : "The patient self discharged against medical advice."
    },
    {
      "code" : "exp",
      "display" : "Expired",
      "definition" : "The patient has deceased during this encounter."
    },
    {
      "code" : "psy",
      "display" : "Psychiatric hospital",
      "definition" : "The patient has been transferred to a psychiatric facility."
    },
    {
      "code" : "rehab",
      "display" : "Rehabilitation",
      "definition" : "The patient was discharged and is to receive post acute care rehabilitation services."
    },
    {
      "code" : "snf",
      "display" : "Skilled nursing facility",
      "definition" : "The patient has been discharged to a skilled nursing facility for the patient to receive additional care."
    },
    {
      "code" : "oth",
      "display" : "Other",
      "definition" : "The discharge disposition has not otherwise defined."
    }
  ]
}

```
