# DefinitionTopic - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DefinitionTopic**

## CodeSystem: DefinitionTopic 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/definition-topic | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DefinitionTopic |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1244 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
High-level categorization of the definition, used for searching, sorting, and filtering. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DefinitionTopic](ValueSet-definition-topic.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "definition-topic",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/definition-topic",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1244"
    }
  ],
  "version" : "1.0.1",
  "name" : "DefinitionTopic",
  "title" : "DefinitionTopic",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "High-level categorization of the definition, used for searching, sorting, and filtering.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/definition-topic",
  "content" : "complete",
  "concept" : [
    {
      "code" : "treatment",
      "display" : "Treatment",
      "definition" : "The definition is related to treatment of the patient."
    },
    {
      "code" : "education",
      "display" : "Education",
      "definition" : "The definition is related to education of the patient."
    },
    {
      "code" : "assessment",
      "display" : "Assessment",
      "definition" : "The definition is related to assessment of the patient."
    }
  ]
}

```
