# CQL Access Modifier - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQL Access Modifier**

## CodeSystem: CQL Access Modifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cql-access-modifier | *Version*:1.0.0 | |
| Draft as of 2024-02-16 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CqlAccessModifier |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Access modifiers defined by the Clinical Quality Language (CQL) specification in the[Access Modifiers](https://cql.hl7.org/03-developersguide.html#access-modifiers)topic. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CqlAccessModifier](ValueSet-cql-access-modifier.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cql-access-modifier",
  "url" : "http://terminology.hl7.org/CodeSystem/cql-access-modifier",
  "version" : "1.0.0",
  "name" : "CqlAccessModifier",
  "title" : "CQL Access Modifier",
  "status" : "draft",
  "experimental" : false,
  "date" : "2024-02-16",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Access modifiers defined by the Clinical Quality Language (CQL) specification in the [Access Modifiers](https://cql.hl7.org/03-developersguide.html#access-modifiers) topic.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/cql-access-modifier",
  "content" : "complete",
  "concept" : [
    {
      "code" : "public",
      "display" : "Public",
      "definition" : "The component is public, meaning it can be referenced from any CQL Library that references the library in which the component is defined."
    },
    {
      "code" : "private",
      "display" : "Private",
      "definition" : "The component is private, meaning it can only be referenced within the library in which the declaration is defined."
    }
  ]
}

```
