# Contributor Summary Style - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contributor Summary Style**

## CodeSystem: Contributor Summary Style 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/contributor-summary-style | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:ContributorSummaryStyle |

 
Used to code the format of the display string. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContributorSummaryStyle](ValueSet-contributor-summary-style.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "contributor-summary-style",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/contributor-summary-style",
  "version" : "1.0.0",
  "name" : "ContributorSummaryStyle",
  "title" : "Contributor Summary Style",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Used to code the format of the display string.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/contributor-summary-style",
  "content" : "complete",
  "concept" : [
    {
      "code" : "a1full",
      "display" : "First author (full name) et al",
      "definition" : "Example: Jennifer Laskowski et al."
    },
    {
      "code" : "a1init",
      "display" : "First author (last name first initials) et al",
      "definition" : "Example: Laskowski J et al."
    },
    {
      "code" : "a3full",
      "display" : "First 3 authors (full name) et al",
      "definition" : "Example: Jennifer Laskowski, Brandon Renner, Matthew C. Pickering, et al."
    },
    {
      "code" : "a3init",
      "display" : "First 3 authors (last name first initials) et al",
      "definition" : "Example:  Laskowski J, Renner B, Pickering MC, et al."
    },
    {
      "code" : "a6full",
      "display" : "First 6 authors (full name) et al",
      "definition" : "Example: Jennifer Laskowski, Brandon Renner, Matthew C. Pickering, Natalie J. Serkova, Peter M. Smith-Jones, Eric T. Clambey, et al."
    },
    {
      "code" : "a6init",
      "display" : "First 6 authors (last name first initials) et al",
      "definition" : "Example: Laskowski J, Renner B, Pickering MC, Serkova NJ, Smith-Jones PM, Clambey ET, et al."
    },
    {
      "code" : "aallfull",
      "display" : "All authors (full name)",
      "definition" : "Example: Jennifer Laskowski, Brandon Renner, Matthew C. Pickering, Natalie J. Serkova, Peter M. Smith-Jones, Eric T. Clambey, Raphael A. Nemenoff, Joshua M. Thurman."
    },
    {
      "code" : "aallfullwithand",
      "display" : "All authors (full name) with and before last author",
      "definition" : "Example: Jennifer Laskowski, Brandon Renner, Matthew C. Pickering, Natalie J. Serkova, Peter M. Smith-Jones, Eric T. Clambey, Raphael A. Nemenoff, and Joshua M. Thurman."
    },
    {
      "code" : "aallfullwithampersand",
      "display" : "All authors (full name) with an ampersand before last author",
      "definition" : "Example: Jennifer Laskowski, Brandon Renner, Matthew C. Pickering, Natalie J. Serkova, Peter M. Smith-Jones, Eric T. Clambey, Raphael A. Nemenoff, & Joshua M. Thurman."
    },
    {
      "code" : "aallinit",
      "display" : "All authors (last name first initials)",
      "definition" : "Example: Laskowski J, Renner B, Pickering MC, Serkova NJ, Smith-Jones PM, Clambey ET, Nemenoff RA, Thurman JM."
    },
    {
      "code" : "aallinitwithand",
      "display" : "All authors (last name first initials) with and before last author",
      "definition" : "Example: Laskowski J, Renner B, Pickering MC, Serkova NJ, Smith-Jones PM, Clambey ET, Nemenoff RA, and Thurman JM."
    },
    {
      "code" : "aallinitwithampersand",
      "display" : "All authors (last name first initials) with an ampersand before last author",
      "definition" : "Example: Laskowski J, Renner B, Pickering MC, Serkova NJ, Smith-Jones PM, Clambey ET, Nemenoff RA, & Thurman JM."
    },
    {
      "code" : "contr-full-by-person",
      "display" : "Contributorship statement listed by person with full names",
      "definition" : "Jennnifer Laskowski designed project; developed and performed experiments; collected and analyzed data; wrote and revised manuscript. Brandon Renner performed critical review of manuscript. Matthew C. Pickering provided technical advice and contributed to study design. Natalie J. Serkova and Peter M. Smith-Jones performed PET imaging and associated analyses. Eric T. Clambey and Raphael A. Nemenoff provided conceptual and technical guidance and critical review of manuscript. Joshua M. Thurman contributed to experimental design and wrote manuscript."
    },
    {
      "code" : "contr-init-by-person",
      "display" : "Contributorship statement listed by person with initials",
      "definition" : "J.L. designed project; developed and performed experiments; collected and analyzed data; wrote and revised manuscript. B.R. performed critical review of manuscript. M.C.P. provided technical advice and contributed to study design. N.J.S and P.M.S.-J. performed PET imaging and associated analyses. E.T.C. and R.A.N provided conceptual and technical guidance and critical review of manuscript. J.M.T contributed to experimental design and wrote manuscript."
    },
    {
      "code" : "contr-full-by-contr",
      "display" : "Contributorship statement listed by contribution with full names",
      "definition" : "Project design by Jennnifer Laskowski (JL), Experiment design by JL and Joshua M. Thurman (JMT), technical advice and study design contribution by Matthew C. Pickering, experiments performed by JL, data collection and analysis by JL, PET imaging and associated analyses by Natalie J. Serkova and Peter M. Smith-Jones, conceptual and technical guidance by Eric T. Clambey (etc.) and Raphael A. Nemenoff (RAN), manuscript writing by JL and JMT, manuscript revised critically by JL, Brandon Renner, etc., and RAN."
    },
    {
      "code" : "contr-init-by-contr",
      "display" : "Contributorship statement listed by contribution with initials",
      "definition" : "Project design by JL, Experiment design by JL and JMT, technical advice and study design contribution by MCP, experiments performed by JL, data collection and analysis by JL, PET imaging and associated analyses by NJS and PMS-J, conceptual and technical guidance by etc. and RAN, manuscript writing by JL and JMT, manuscript revised critically by JL, BR, etc., and RAN."
    }
  ]
}

```
