# Cited Medium - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cited Medium**

## CodeSystem: Cited Medium 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cited-medium | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:CitedMedium |

 
NLM codes Internet or Print. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CitedMedium](ValueSet-cited-medium.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cited-medium",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/cited-medium",
  "version" : "1.0.0",
  "name" : "CitedMedium",
  "title" : "Cited Medium",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "NLM codes Internet or Print.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/cited-medium",
  "content" : "complete",
  "concept" : [
    {
      "code" : "internet",
      "display" : "Internet",
      "definition" : "Online publication in a periodic release. Used to match NLM JournalIssue CitedMedium code for online version."
    },
    {
      "code" : "print",
      "display" : "Print",
      "definition" : "Print publication in a periodic release. Used to match NLM JournalIssue CitedMedium code for print version."
    },
    {
      "code" : "offline-digital-storage",
      "display" : "Offline Digital Storage",
      "definition" : "Publication in a physical device for electronic data storage, organized in issues for periodic release."
    },
    {
      "code" : "internet-without-issue",
      "display" : "Internet without issue",
      "definition" : "Online publication without any periodic release. Used for article specific publication date which could be the same as or different from journal issue publication date."
    },
    {
      "code" : "print-without-issue",
      "display" : "Print without issue",
      "definition" : "Print publication without any periodic release."
    },
    {
      "code" : "offline-digital-storage-without-issue",
      "display" : "Offline Digital Storage without issue",
      "definition" : "Publication in a physical device for electronic data storage, without any periodic release."
    }
  ]
}

```
