# Cited Artifact Part Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cited Artifact Part Type**

## CodeSystem: Cited Artifact Part Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cited-artifact-part-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:CitedArtifactPartType |

 
To describe the reason for the variant citation, such as version number or subpart specification. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CitedArtifactPartType](ValueSet-cited-artifact-part-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cited-artifact-part-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/cited-artifact-part-type",
  "version" : "1.0.0",
  "name" : "CitedArtifactPartType",
  "title" : "Cited Artifact Part Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "To describe the reason for the variant citation, such as version number or subpart specification.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/cited-artifact-part-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "chapters",
      "display" : "chapters",
      "definition" : "Denotes specific chapter or chapters of an article or artifact."
    },
    {
      "code" : "pages",
      "display" : "pages",
      "definition" : "Denotes specific page or pages of an article or artifact."
    },
    {
      "code" : "sections",
      "display" : "sections",
      "definition" : "Denotes specific section or sections of an article or artifact."
    },
    {
      "code" : "paragraphs",
      "display" : "paragraphs",
      "definition" : "Denotes specific paragraph or paragraphs of an article or artifact."
    },
    {
      "code" : "lines",
      "display" : "lines",
      "definition" : "Denotes specific line or lines of an article or artifact."
    },
    {
      "code" : "tables",
      "display" : "tables",
      "definition" : "Denotes specific table or tables of an article or artifact."
    },
    {
      "code" : "figures",
      "display" : "figures",
      "definition" : "Denotes specific figure or figures of an article or artifact."
    },
    {
      "code" : "supplement",
      "display" : "Supplement or Appendix",
      "definition" : "Used to denote a supplementary file, appendix, or additional part that is not a subpart of the primary article."
    },
    {
      "code" : "supplement-subpart",
      "display" : "Supplement or Appendix Subpart",
      "definition" : "Used to denote a subpart within a supplementary file or appendix."
    },
    {
      "code" : "article-set",
      "display" : "Part of an article set",
      "definition" : "Used to distinguish an individual article within an article set where the article set is a base citation."
    }
  ]
}

```
