# Benefit Type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Benefit Type Codes**

## CodeSystem: Benefit Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/benefit-type | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:BenefitTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1176 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes a smattering of Benefit type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BenefitTypeCodes](ValueSet-benefit-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "benefit-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/benefit-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1176"
    }
  ],
  "version" : "1.0.1",
  "name" : "BenefitTypeCodes",
  "title" : "Benefit Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes a smattering of Benefit type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/benefit-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "benefit",
      "display" : "Benefit",
      "definition" : "Maximum benefit allowable."
    },
    {
      "code" : "deductible",
      "display" : "Deductible",
      "definition" : "Cost to be incurred before benefits are applied"
    },
    {
      "code" : "visit",
      "display" : "Visit",
      "definition" : "Service visit"
    },
    {
      "code" : "room",
      "display" : "Room",
      "definition" : "Type of room"
    },
    {
      "code" : "copay",
      "display" : "Copayment per service",
      "definition" : "Copayment per service"
    },
    {
      "code" : "copay-percent",
      "display" : "Copayment Percent per service",
      "definition" : "Copayment percentage per service"
    },
    {
      "code" : "copay-maximum",
      "display" : "Copayment maximum per service",
      "definition" : "Copayment maximum per service"
    },
    {
      "code" : "vision-exam",
      "display" : "Vision Exam",
      "definition" : "Vision Exam"
    },
    {
      "code" : "vision-glasses",
      "display" : "Vision Glasses",
      "definition" : "Frames and lenses"
    },
    {
      "code" : "vision-contacts",
      "display" : "Vision Contacts Coverage",
      "definition" : "Contact Lenses"
    },
    {
      "code" : "medical-primarycare",
      "display" : "Medical Primary Health Coverage",
      "definition" : "Medical Primary Health Coverage"
    },
    {
      "code" : "pharmacy-dispense",
      "display" : "Pharmacy Dispense Coverage",
      "definition" : "Pharmacy Dispense Coverage"
    }
  ]
}

```
