# Artifact Relationship Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Artifact Relationship Type**

## CodeSystem: Artifact Relationship Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/artifact-relationship-type | *Version*:2.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:ArtifactRelationshipType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.4.100 | | | |

 
This artifact incorporates the target artifact. This artifact is constructed with the target artifact as a component. The target artifact is a part of this artifact. (A dataset is composed of data.). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ArtifactRelationshipType](ValueSet-artifact-relationship-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "artifact-relationship-type",
  "meta" : {
    "lastUpdated" : "2023-03-26T15:21:02.749+11:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/artifact-relationship-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.4.100"
    }
  ],
  "version" : "2.0.0",
  "name" : "ArtifactRelationshipType",
  "title" : "Artifact Relationship Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-02-24",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "This artifact incorporates the target artifact. This artifact is constructed with the target artifact as a component. The target artifact is a part of this artifact. (A dataset is composed of data.).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/artifact-relationship-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "documentation",
      "display" : "Documentation",
      "definition" : "Additional documentation for the knowledge resource. This would include additional      instructions on usage as well as additional information on clinical context or      appropriateness."
    },
    {
      "code" : "justification",
      "display" : "Justification",
      "definition" : "The target artifact is a summary of the justification for the knowledge resource      including supporting evidence, relevant guidelines, or other clinically important      information. This information is intended to provide a way to make the justification      for the knowledge resource available to the consumer of interventions or results      produced by the knowledge resource."
    },
    {
      "code" : "citation",
      "display" : "Citation",
      "definition" : "Bibliographic citation for papers, references, or other relevant material for the      knowledge resource. This is intended to allow for citation of related material,      but that was not necessarily specifically prepared in connection with this knowledge      resource."
    },
    {
      "code" : "predecessor",
      "display" : "Predecessor",
      "definition" : "The previous version of the knowledge artifact, used to establish an ordering of      versions of an artifact, independent of the status of each version."
    },
    {
      "code" : "successor",
      "display" : "Successor",
      "definition" : "The subsequent version of the knowledge artfact, used to establish an ordering      of versions of an artifact, independent of the status of each version."
    },
    {
      "code" : "derived-from",
      "display" : "Derived From",
      "definition" : "This artifact is derived from the target artifact. This is intended to capture      the relationship in which a particular knowledge resource is based on the content      of another artifact, but is modified to capture either a different set of overall      requirements, or a more specific set of requirements such as those involved in      a particular institution or clinical setting. The artifact may be derived from      one or more target artifacts."
    },
    {
      "code" : "depends-on",
      "display" : "Depends On",
      "definition" : "This artifact depends on the target artifact. There is a requirement to use the      target artifact in the creation or interpretation of this artifact."
    },
    {
      "code" : "composed-of",
      "display" : "Composed Of",
      "definition" : "This artifact incorposrates the target artifact."
    },
    {
      "code" : "part-of",
      "display" : "Part Of",
      "definition" : "This artifact is a part of the target artifact. The target artifact is composed      of this artifact (and possibly other artifacts)."
    },
    {
      "code" : "amends",
      "display" : "Amends",
      "definition" : "This artifact amends or changes the target artifact. This artifact adds additional      information that is functionally expected to replace information in the target      artifact. This artifact replaces a part but not all of the target artifact."
    },
    {
      "code" : "amended-with",
      "display" : "Amended With",
      "definition" : "This artifact is amended with or changed by the target artifact. There is information      in this artifact that should be functionally replaced with information in the target      artifact."
    },
    {
      "code" : "appends",
      "display" : "Appends",
      "definition" : "This artifact adds additional information to the target artifact. The additional      information does not replace or change information in the target artifact."
    },
    {
      "code" : "appended-with",
      "display" : "Appended With",
      "definition" : "This artifact has additional information in the target artifact."
    },
    {
      "code" : "cites",
      "display" : "Cites",
      "definition" : "This artifact cites the target artifact. This may be a bibliographic citation for      papers, references, or other relevant material for the knowledge resource. This      is intended to allow for citation of related material, but that was not necessarily      specifically prepared in connection with this knowledge resource."
    },
    {
      "code" : "cited-by",
      "display" : "Cited By",
      "definition" : "This artifact is cited by the target artifact."
    },
    {
      "code" : "comments-on",
      "display" : "Is Comment On",
      "definition" : "This artifact contains comments about the target artifact."
    },
    {
      "code" : "comment-in",
      "display" : "Has Comment In",
      "definition" : "This artifact has comments about it in the target artifact.  The type of comments      may be expressed in the targetClassifier element such as reply, review, editorial,      feedback, solicited, unsolicited, structured, unstructured."
    },
    {
      "code" : "contains",
      "display" : "Contains",
      "definition" : "This artifact is a container in which the target artifact is contained. A container      is a data structure whose instances are collections of other objects. (A database      contains the dataset.)."
    },
    {
      "code" : "contained-in",
      "display" : "Contained In",
      "definition" : "This artifact is contained in the target artifact. The target artifact is a data      structure whose instances are collections of other objects."
    },
    {
      "code" : "corrects",
      "display" : "Corrects",
      "definition" : "This artifact identifies errors and replacement content for the target artifact."
    },
    {
      "code" : "correction-in",
      "display" : "Correction In",
      "definition" : "This artifact has corrections to it in the target artifact. The target artifact      identifies errors and replacement content for this artifact."
    },
    {
      "code" : "replaces",
      "display" : "Replaces",
      "definition" : "This artifact replaces or supersedes the target artifact. The target artifact may      be considered deprecated."
    },
    {
      "code" : "replaced-with",
      "display" : "Replaced With",
      "definition" : "This artifact is replaced with or superseded by the target artifact. This artifact      may be considered deprecated."
    },
    {
      "code" : "retracts",
      "display" : "Retracts",
      "definition" : "This artifact retracts the target artifact. The content that was published in the      target artifact should be considered removed from publication and should no longer      be considered part of the public record."
    },
    {
      "code" : "retracted-by",
      "display" : "Retracted By",
      "definition" : "This artifact is retracted by the target artifact. The content that was published      in this artifact should be considered removed from publication and should no longer      be considered part of the public record."
    },
    {
      "code" : "signs",
      "display" : "Signs",
      "definition" : "This artifact is a signature of the target artifact."
    },
    {
      "code" : "similar-to",
      "display" : "Similar To",
      "definition" : "This artifact has characteristics in common with the target artifact. This relationship      may be used in systems to “deduplicate” knowledge artifacts from different sources,      or in systems to show “similar items”."
    },
    {
      "code" : "supports",
      "display" : "Supports",
      "definition" : "This artifact provides documentation or other support for the target artifact. This could      include additional instructions on usage as well as additional information on clinical      context or appropriateness."
    },
    {
      "code" : "supported-with",
      "display" : "Supported With",
      "definition" : "The target artifact contains additional information related to the knowledge artifact. This may include an associated dataset or additional information that describes, explains, or instructs regarding the knowledge artifact content or its application."
    },
    {
      "code" : "transforms",
      "display" : "Transforms",
      "definition" : "This artifact was generated by transforming the target artifact (e.g., format or      language conversion). This is intended to capture the relationship in which a particular      knowledge resource is based on the content of another artifact, but changes are      only apparent in form and there is only one target artifact with the “transforms”      relationship type."
    },
    {
      "code" : "transformed-into",
      "display" : "Transformed Into",
      "definition" : "This artifact was transformed into the target artifact (e.g., by format or language      conversion)."
    },
    {
      "code" : "transformed-with",
      "display" : "Transformed With",
      "definition" : "This artifact was generated by transforming a related artifact (e.g., format or      language conversion), noted separately with the “transforms” relationship type.      This transformation used the target artifact to inform the transformation. The      target artifact may be a conversion script or translation guide."
    },
    {
      "code" : "documents",
      "display" : "Documents",
      "definition" : "This artifact provides additional documentation for the target artifact. This could      include additional instructions on usage as well as additional information on clinical      context or appropriateness."
    },
    {
      "code" : "specification-of",
      "display" : "Specification Of",
      "definition" : "The target artifact is a precise description of a concept in this artifact. This      may be used when the RelatedArtifact datatype is used in elements contained in      this artifact."
    },
    {
      "code" : "created-with",
      "display" : "Created With",
      "definition" : "This artifact was created with the target artifact. The target artifact is a tool      or support material used in the creation of the artifact, and not content that      the artifact was derived from."
    },
    {
      "code" : "cite-as",
      "display" : "Cite As",
      "definition" : "The related artifact is the citation for this artifact."
    },
    {
      "code" : "reprint",
      "display" : "Reprint",
      "definition" : "A copy of the artifact in a publication with a different artifact identifier."
    },
    {
      "code" : "reprint-of",
      "display" : "Reprint Of",
      "definition" : "The original version of record for which the current artifact is a copy."
    },
    {
      "code" : "summarizes",
      "display" : "Summarizes",
      "definition" : "This document summarizes the content from the (source) target document."
    }
  ]
}

```
