# Surface Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Surface Codes**

## CodeSystem: Surface Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/FDI-surface | *Version*:1.0.0 | | |
| Draft as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SurfaceCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1154 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This value set includes a smattering of FDI tooth surface codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SurfaceCodes](ValueSet-surface.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "FDI-surface",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/FDI-surface",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1154"
    }
  ],
  "version" : "1.0.0",
  "name" : "SurfaceCodes",
  "title" : "Surface Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes a smattering of FDI tooth surface codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/surface",
  "content" : "complete",
  "concept" : [
    {
      "code" : "M",
      "display" : "Mesial",
      "definition" : "The surface of a tooth that is closest to the midline (middle) of the face."
    },
    {
      "code" : "O",
      "display" : "Occlusal",
      "definition" : "The chewing surface of posterior teeth."
    },
    {
      "code" : "I",
      "display" : "Incisal",
      "definition" : "The biting edge of anterior teeth."
    },
    {
      "code" : "D",
      "display" : "Distal",
      "definition" : "The surface of a tooth that faces away from the midline of the face."
    },
    {
      "code" : "B",
      "display" : "Buccal",
      "definition" : "The surface of a posterior tooth facing the cheeks."
    },
    {
      "code" : "V",
      "display" : "Ventral",
      "definition" : "The surface of a tooth facing the lips."
    },
    {
      "code" : "L",
      "display" : "Lingual",
      "definition" : "The surface of a tooth facing the tongue."
    },
    {
      "code" : "MO",
      "display" : "Mesioclusal",
      "definition" : "The Mesioclusal surfaces of a tooth."
    },
    {
      "code" : "DO",
      "display" : "Distoclusal",
      "definition" : "The Distoclusal surfaces of a tooth."
    },
    {
      "code" : "DI",
      "display" : "Distoincisal",
      "definition" : "The Distoincisal surfaces of a tooth."
    },
    {
      "code" : "MOD",
      "display" : "Mesioclusodistal",
      "definition" : "The Mesioclusodistal surfaces of a tooth."
    }
  ]
}

```
