# hl7.terminology#7.0.0: HL7 Terminology (THO)

## Pages

* [HL7 Terminology Home Page](index.md)
* [Artifacts Summary](artifacts.md)
* [Changes](Changes.md)
* [CDA Code Systems](codesystems-cda.md)
* [Deprecated Code Systems](codesystems-deprecated.md)
* [FHIR Code Systems](codesystems-fhir.md)
* [Retired Code Systems](codesystems-retired.md)
* [Unified Code Systems](codesystems-unified.md)
* [V2 Code Systems](codesystems-v2.md)
* [V3 Code Systems](codesystems-v3.md)
* [HL7 Code Systems](codesystems.md)
* [Concept Maps](conceptmaps.md)
* [Using CPT with HL7 Standards](CPT.md)
* [Using CVX with HL7 Standards](CVX.md)
* [Documentation](documentation.md)
* [Downloads](downloads.md)
* [American Dental Association Area of Oral Cavity System Metadata Record](ECS_MR-ADAAreaOralCavitySystem.md)
* [ADA Tooth Surface Codes Metadata Record](ECS_MR-ADAToothSurfaceCodes.md)
* [ADA Universal Tooth Designation System Metadata Record](ECS_MR-ADAUniversalToothDesignationSystem.md)
* [AHA NUBC Condition Codes Metadata Record](ECS_MR-AHANUBCConditionCodes.md)
* [AHA NUBC Patient Discharge Status Codes Metadata Record](ECS_MR-AHANUBCPatientDischargeStatus.md)
* [AHA NUBC Point of Origin for Newborn Metadata Record](ECS_MR-AHANUBCPointOfOriginNewborn.md)
* [AHA NUBC Point of Origin for Non-newborn Metadata Record](ECS_MR-AHANUBCPointOfOriginNonnewborn.md)
* [AHA NUBC Priority (Type) of Admission or Visit Metadata Record](ECS_MR-AHANUBCPriorityTypeOfAdmitOrVisit.md)
* [AHA NUBC Revenue Codes Metadata Record](ECS_MR-AHANUBCRevenueCodes.md)
* [AHA NUBC Type Of Bill Codes Metadata Record](ECS_MR-AHANUBCTypeOfBill.md)
* [AHA NUBC Value Codes and Amounts Metadata Record](ECS_MR-AHANUBCValueCodesAndAmounts.md)
* [All Patient Diagnosis Related Groups (AP DRGs) Metadata Record](ECS_MR-APDRG.md)
* [All Patient Refined Diagnosis Related Groups (APR DRGs) Metadata Record](ECS_MR-APRDRG.md)
* [Health Canada Drug Id Number Metadata Record](ECS_MR-ca-hc-din.md)
* [Health Canada Drug Product Database - Schedule Metadata Record](ECS_MR-ca-hc-dpd-schedule.md)
* [Canada Post Province Codes Metadata Record](ECS_MR-CanadaProvinceCodes.md)
* [College of American Pathologists (CAP) eCC (electronic Cancer Checklists) Metadata Record](ECS_MR-CAPeCC.md)
* [Clinical Care Classification System Metadata Record](ECS_MR-CCC.md)
* [CDC Local Coding System Metadata Record](ECS_MR-CDCLocal.md)
* [NHSN Surveillance System Codes Metadata Record](ECS_MR-CDCNHSN.md)
* [CDC Race and Ethnicity Metadata Record](ECS_MR-CDCREC.md)
* [Vaccine Information Statements (VIS) Metadata Record](ECS_MR-CDCVIS.md)
* [Chronic Illness and Disability Payment System (CDPS) Metadata Record](ECS_MR-CDPS.md)
* [Code on Dental Procedures and Nomenclature Metadata Record](ECS_MR-CDT.md)
* [ClinicalTrials.gov Metadata Record](ECS_MR-ClinicalTrialsGov.md)
* [ClinVar Variant ID Metadata Record](ECS_MR-ClinVarV.md)
* [CMS Hierarchical Condition Categories Metadata Record](ECS_MR-cmshcc.md)
* [CMS Place of Service Codes (POS) Metadata Record](ECS_MR-CMSPlaceofServiceCodes.md)
* [CMS Prescription Drug Hierarchical Condition Categories Metadata Record](ECS_MR-cmsrxhcc.md)
* [Current Procedural Terminology (CPT�) Metadata Record](ECS_MR-CPT.md)
* [Canadian Triage and Acuity Scale (CTAS) Metadata Record](ECS_MR-CTAS.md)
* [Vaccine Administered Code Set (CVX) Metadata Record](ECS_MR-CVX.md)
* [Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2) Metadata Record](ECS_MR-FIPS52.md)
* [Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4) Metadata Record](ECS_MR-FIPS64.md)
* [Global Medical Device Nomenclature Metadata Record](ECS_MR-GMDN.md)
* [Genetic Testing Registry Metadata Record](ECS_MR-GTR.md)
* [Canadian Clinical Drug Data Set Metadata Record](ECS_MR-hc-CCDD.md)
* [The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories Metadata Record](ECS_MR-hcp-lan-apm-framework.md)
* [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes Metadata Record](ECS_MR-hcpcs-Level-II.md)
* [HUGO Gene Nomenclature Committee Gene Group Metadata Record](ECS_MR-HGNCGeneGroup.md)
* [Health Insurance Prospective Payment System (HIPPS) Metadata Record](ECS_MR-HIPPS.md)
* [Human Phenotype Ontology Metadata Record](ECS_MR-HPO.md)
* [NHSN Healthcare Facility Patient Care Location Metadata Record](ECS_MR-hsloc.md)
* [IANA Time Zone Database Metadata Record](ECS_MR-IANATimeZoneDatabase.md)
* [ISBT Metadata Record](ECS_MR-ib.md)
* [International Civil Aviation Organization Sex Metadata Record](ECS_MR-icaosex.md)
* [ICD-9-CM (diagnosis codes) Metadata Record](ECS_MR-ICD-9CM-diagnosiscodes.md)
* [ICD-9-CM (procedure codes) Metadata Record](ECS_MR-ICD-9CM-procedurecodes.md)
* [International Classification of Diseases for Oncology, version 3. Metadata Record](ECS_MR-icd-o-3.md)
* [International Statistical Classification of Diseases and Related Health Problems, 10th Revision, Canada Metadata Record](ECS_MR-icd10-CA.md)
* [International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM) Metadata Record](ECS_MR-icd10CM.md)
* [ICD-10 Procedure Codes Metadata Record](ECS_MR-icd10PCS.md)
* [International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) Metadata Record](ECS_MR-ICD11MMS.md)
* [International Classification of Functioning, Disability and Health Metadata Record](ECS_MR-ICF.md)
* [International Classification of Functioning, Disability and Health, Dutch Translation Metadata Record](ECS_MR-ICFDut.md)
* [ICH Context of Use Metadata Record](ECS_MR-ICHContextOfUse.md)
* [International Classification for Nursing Practice Metadata Record](ECS_MR-icnp.md)
* [International Classification of Primary Care - Third Revision Metadata Record](ECS_MR-ICPC3.md)
* [IEC 61966-2-1: Colour measurement and management - Part 2-1: Colour management - Default RGB colour space - sRGB Metadata Record](ECS_MR-IECColourManagement.md)
* [Interagency Language Roundtable Speaking Skill Scale Metadata Record](ECS_MR-ILRSpeakingSkillScale.md)
* [Intelligent Medical Objects Metadata Record](ECS_MR-IMO.md)
* [ISBT 128 Product Description Codes](ECS_MR-ISBT128ProductDescriptionCodes.md)
* [ISBT 128 Property Types](ECS_MR-ISBT128PropertyTypes.md)
* [International System for Human Cytogenomic Nomenclature (ISCN) Metadata Record](ECS_MR-ISCN.md)
* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions � Part 1: Country code Metadata Record](ECS_MR-ISO3166Part1.md)
* [ISO 3166-2 Codes for the representation of names of countries and their subdivisions � Part 2: Country subdivision code Metadata Record](ECS_MR-ISO3166Part2.md)
* [ISO 3166-3 Codes for the representation of names of countries and their subdivisions � Part 3: Code for formerly used names of countries Metadata Record](ECS_MR-ISO3166Part3.md)
* [Medical Dictionary for Regulatory Activities Metadata Record](ECS_MR-mdr.md)
* [Medication Reference Terminology (MED-RT) Metadata Record](ECS_MR-MEDRT.md)
* [Medical Subject Headings Metadata Record](ECS_MR-MeSH.md)
* [Mondo Disease Ontology Metadata Record](ECS_MR-MONDO.md)
* [Medicare Severity Diagnosis Related Groups (MS-DRGs) Metadata Record](ECS_MR-MSDRG.md)
* [Manufacturers of Vaccines (MVX) Metadata Record](ECS_MR-MVX.md)
* [NANDA International Metadata Record](ECS_MR-nanda-i.md)
* [NCPDP Brand Generic Indicator Metadata Record](ECS_MR-NCPDPBrandGenericIndicator.md)
* [NCPDP Compound Code Metadata Record](ECS_MR-NCPDPCompoundCode.md)
* [NCPDP Dispense As Written (DAW)/Product Selection Code Metadata Record](ECS_MR-NCPDPDispensedAsWrittenOrProductSelectionCode.md)
* [NCPDP Pharmacy Type Metadata Record](ECS_MR-NCPDPPharmacyType.md)
* [NCPDP Prescription Origin Code Metadata Record](ECS_MR-NCPDPPrescriptionOriginCode.md)
* [NCPDP Provider Identification Number Metadata Record](ECS_MR-NCPDPProviderIdentificationNumber.md)
* [NCPDP Reject Code Metadata Record](ECS_MR-NCPDPRejectCode.md)
* [National Drug File Reference Terminology (NDF-RT) Metadata Record](ECS_MR-NDFRT.md)
* [Nursing Intervention Classification Metadata Record](ECS_MR-nic.md)
* [NOC Metadata Record](ECS_MR-noc.md)
* [Nomenclature for Properties and Units (NPU) Metadata Record](ECS_MR-NPU.md)
* [National Uniform Billing Council, UB 92 Metadata Record](ECS_MR-nubc-UB92.md)
* [OHDSI Standardized Vocabularies Metadata Record](ECS_MR-OMOP.md)
* [Omaha System Metadata Record](ECS_MR-oms.md)
* [Open Eligibility Taxonomy Metadata Record](ECS_MR-OpenEligibilityTaxonomy.md)
* [Online Product Identification Number Index of Nova Scotia Metadata Record](ECS_MR-opinions.md)
* [pan-Canadian LOINC Observation Code Database Metadata Record](ECS_MR-pclocd.md)
* [Pharmacogene Variation Metadata Record](ECS_MR-PharmVar.md)
* [Industry CDC Census 2010 Metadata Record](ECS_MR-PHIndustryCDCCensus2010.md)
* [Occupational Data for Health (ODH) Metadata Record](ECS_MR-PHOccupationalDataForHealthODH.md)
* [Occupation CDC Census 2010 Metadata Record](ECS_MR-PHOccupationCDCCensus2010.md)
* [PMIX Method of Payment Metadata Record](ECS_MR-PMIXMethodofPayment.md)
* [PMIX Opioid Treatment Code Metadata Record](ECS_MR-PMIXOpioidTreatmentCode.md)
* [PMIX Patient Alert Category Code Metadata Record](ECS_MR-PMIXPatientAlertCatCode.md)
* [PMIX Species Type Code Metadata Record](ECS_MR-PMIXSpeciesTypeCode.md)
* [PMIX Status Code Metadata Record](ECS_MR-PMIXStatusCode.md)
* [PMIX Transmission Form Of Rx Origin Code Type Metadata Record](ECS_MR-PMIXTransmissionFormRxOriginCodeType.md)
* [POS Codes Metadata Record](ECS_MR-POS.md)
* [CMS Present on Admission (POA) Indicator Metadata Record](ECS_MR-presentOnAdmission.md)
* [RadLex radiology lexicon Metadata Record](ECS_MR-RadLex.md)
* [X12 Remittance Advice Remark Codes Metadata Record](ECS_MR-RARC.md)
* [Scientific Evidence Code System (SEVCO) Metadata Record](ECS_MR-SEVCO.md)
* [US Census Bureau Metadata Record](ECS_MR-sic.md)
* [Sequence Ontology Metadata Record](ECS_MR-SO.md)
* [Source of Payment Typology Metadata Record](ECS_MR-SOPT.md)
* [Standard Billing Unit Metadata Record](ECS_MR-standardBillingUnit.md)
* [OMAHA Tangram Medical Terminology Metadata Record](ECS_MR-TangramMedicalTerminology.md)
* [TNM Staging System Metadata Record](ECS_MR-TNM.md)
* [Unique Ingredient Identifier (UNII) Metadata Record](ECS_MR-UNII.md)
* [USPS State Codes Metadata Record](ECS_MR-USPSStateCodes.md)
* [nubc-OccurrenceCode-cs Metadata Record](ECS_MR-v2-0350.md)
* [nubc-OccurrenceSpan-cs Metadata Record](ECS_MR-v2-0351.md)
* [nubc-ServiceLineRevenue-cs Metadata Record](ECS_MR-v2-0456.md)
* [nubc-PresentOnAdmission-cs Metadata Record](ECS_MR-v2-0895.md)
* [Systematized Nomenclature of Dentistry (SNODENT) Metadata Record](ECS_MR-v3-ada-snodent.md)
* [Canadian Classification of Health Interventions Metadata Record](ECS_MR-v3-cci.md)
* [DICOM Controlled Terminology Metadata Record](ECS_MR-v3-DCM.md)
* [Active Ingredient Code Metadata Record](ECS_MR-v3-hc-aic.md)
* [Active Ingredient Group Code Metadata Record](ECS_MR-v3-hc-aigc.md)
* [Active Ingredient Group Number Metadata Record](ECS_MR-v3-hc-aign.md)
* [Health Canada Natural Product Number Metadata Record](ECS_MR-v3-hc-npn.md)
* [HUGO Gene Nomenclature Committee Genes Metadata Record](ECS_MR-v3-hgnc.md)
* [Human Genome Variation Society nomenclature Metadata Record](ECS_MR-v3-hgvs.md)
* [International Classification of Primary Care, 1993 edition Metadata Record](ECS_MR-v3-icpc.md)
* [International Classification of Primary Care, second edition (1998) Metadata Record](ECS_MR-v3-icpc2E.md)
* [Tags for the Identification of Languages Metadata Record](ECS_MR-v3-ietf3066.md)
* [Logical Observation Identifiers, Names and Codes (LOINC) Metadata Record](ECS_MR-v3-loinc.md)
* [ISO/IEEE 11073 Medical Device Communication Nomenclature Metadata Record](ECS_MR-v3-mdc.md)
* [IANA Media Types Metadata Record](ECS_MR-v3-mediaType.md)
* [NCI Thesaurus Metadata Record](ECS_MR-v3-nciThesaurus.md)
* [National drug codes Metadata Record](ECS_MR-v3-ndc.md)
* [NUCC Health Care Provider Taxonomy Metadata Record](ECS_MR-v3-nuccProviderCodes.md)
* [RxNorm Metadata Record](ECS_MR-v3-rxNorm.md)
* [pan-Canadian Provider Qualification Types Metadata Record](ECS_MR-v3-scpqual.md)
* [pan-Canadian Provider Types Metadata Record](ECS_MR-v3-scptype.md)
* [pan-Canadian Temporary Codes Metadata Record](ECS_MR-v3-sctemp.md)
* [SNOMED�CT International Edition Metadata Record](ECS_MR-v3-snomed-CT.md)
* [Unified Code for Units of Measure (UCUM) Metadata Record](ECS_MR-v3-ucum.md)
* [WHO ATC Metadata Record](ECS_MR-v3-WC.md)
* [W3C Decentralized Identifier (DID) Metadata Record](ECS_MR-W3CDID.md)
* [X12.3 Data Elementary Dictionary Metadata Record](ECS_MR-X12.3.md)
* [X12 Ambulance Transport Reason Codes Metadata Record](ECS_MR-X12AmbulanceTransportReasonCodes.md)
* [X12 Claim Adjustment Reason Codes Metadata Record](ECS_MR-X12ClaimAdjustmentReasonCodes.md)
* [X12 Service Type Codes Metadata Record](ECS_MR-X12ServiceTypeCodes.md)
* [External Code Systems](external_code_systems.md)
* [External Content](external_content.md)
* [Deprecated Content](external_deprecated.md)
* [Retired Content](external_retired.md)
* [Using ICD with HL7 Standards](ICD.md)
* [External Identifier Systems](identifiers.md)
* [Using ISO3166 with HL7 Standards](ISO3166.md)
* [THO License](license.md)
* [Using LOINC with HL7 Standards](LOINC.md)
* [Using MDC with HL7 Standards](MDC.md)
* [Using MED-RT with HL7 Standards](MEDRT.md)
* [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes - Testing](NamingSystem-hcpcs-Level-II-testing.md)
* [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes - Resource Change History](NamingSystem-hcpcs-Level-II.change.history.md)
* [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes](NamingSystem-hcpcs-Level-II.md)
* [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes - JSON Representation](NamingSystem-hcpcs-Level-II.json.md)
* [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes - TTL Representation](NamingSystem-hcpcs-Level-II.ttl.md)
* [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes - XML Representation](NamingSystem-hcpcs-Level-II.xml.md)
* [Using NDC with HL7 Standards](NDC.md)
* [Using NDF-RT with HL7 Standards](NDFRT.md)
* [Using pCLOCD with HL7 Standards](pCLOCD.md)
* [Using RxNorm with HL7 Standards](RxNorm.md)
* [Using SNOMED CT with HL7 Standards](SNOMEDCT.md)
* [Using UCUM with HL7 Standards](UCUM.md)
* [Using UNII with HL7 Standards](UNII.md)
* [CDA Value Sets](valuesets-cda.md)
* [Deprecated ValueSets](valuesets-deprecated.md)
* [FHIR Value Sets](valuesets-fhir.md)
* [Retired Value Sets](valuesets-retired.md)
* [Unified Value Sets](valuesets-unified.md)
* [V2 Value Sets](valuesets-v2.md)
* [V3 Value Sets](valuesets-v3.md)
* [Value Sets](valuesets.md)

## Resources

### CodeSystems

* [ADA Tooth Surface Codes](CodeSystem-ADAToothSurfaceCodes.md)
* [ADA Universal Tooth Designation System](CodeSystem-ADAUniversalToothDesignationSystem.md)
* [CMS Place of Service Codes (POS)](CodeSystem-CMSPlaceofServiceCodes.md)
* [Surface Codes](CodeSystem-FDI-surface.md)
* [Interagency Language Roundtable Speaking Skill Scale](CodeSystem-ILRSpeakingSkillScale.md)
* [Accepting Patients](CodeSystem-accepting-patients.md)
* [ActionType](CodeSystem-action-type.md)
* [ActivityDefinitionCategory](CodeSystem-activity-definition-category.md)
* [Adjudication Error Codes](CodeSystem-adjudication-error.md)
* [Adjudication Reason Codes](CodeSystem-adjudication-reason.md)
* [Adjudication Value Codes](CodeSystem-adjudication.md)
* [Admit source](CodeSystem-admit-source.md)
* [AdverseEventCategory](CodeSystem-adverse-event-category.md)
* [AdverseEventCausalityAssessment](CodeSystem-adverse-event-causality-assess.md)
* [AdverseEventCausalityMethod](CodeSystem-adverse-event-causality-method.md)
* [AdverseEventSeriousness](CodeSystem-adverse-event-seriousness.md)
* [AdverseEventSeverity](CodeSystem-adverse-event-severity.md)
* [AllergyIntoleranceSubstanceExposureRisk](CodeSystem-allerg-intol-substance-exp-risk.md)
* [AllergyIntolerance Clinical Status Codes](CodeSystem-allergyintolerance-clinical.md)
* [AllergyIntolerance Verification Status](CodeSystem-allergyintolerance-verification.md)
* [Benefit cost applicability](CodeSystem-applicability.md)
* [Appointment cancellation reason](CodeSystem-appointment-cancellation-reason.md)
* [Appropriateness Score](CodeSystem-appropriateness-score.md)
* [Artifact Contribution Instance Type](CodeSystem-artifact-contribution-instance-type.md)
* [Artifact Identifier Type Codes](CodeSystem-artifact-identifier-type.md)
* [Artifact Relationship Type](CodeSystem-artifact-relationship-type.md)
* [Artifact Url Classifier](CodeSystem-artifact-url-classifier.md)
* [Artifact Version Policy Codes](CodeSystem-artifact-version-policy-codes.md)
* [StatisticAttribute Estimate Type](CodeSystem-attribute-estimate-type.md)
* [Audit event entity type](CodeSystem-audit-entity-type.md)
* [AuditEventOutcome](CodeSystem-audit-event-outcome.md)
* [Audit Event ID](CodeSystem-audit-event-type.md)
* [Basic Resource Types](CodeSystem-basic-resource-type.md)
* [Network Type Codes](CodeSystem-benefit-network.md)
* [Benefit Term Codes](CodeSystem-benefit-term.md)
* [Benefit Type Codes](CodeSystem-benefit-type.md)
* [Unit Type Codes](CodeSystem-benefit-unit.md)
* [Can-push-updates](CodeSystem-can-push-updates.md)
* [Care Service Accessibility](CodeSystem-care-service-accessibility.md)
* [CatalogType](CodeSystem-catalogType.md)
* [CDS Hooks Card Types](CodeSystem-cdshooks-card-type.md)
* [CDS Hooks Indicator](CodeSystem-cdshooks-indicator.md)
* [StatisticCertaintyRating](CodeSystem-certainty-rating.md)
* [StatisticCertaintySubcomponentRating](CodeSystem-certainty-subcomponent-rating.md)
* [StatisticCertaintySubcomponentType](CodeSystem-certainty-subcomponent-type.md)
* [Evidence Certainty Type](CodeSystem-certainty-type.md)
* [CharacteristicMethod](CodeSystem-characteristic-method.md)
* [ChargeItemCode](CodeSystem-chargeitem-billingcodes.md)
* [ChoiceListOrientation](CodeSystem-choice-list-orientation.md)
* [chromosome-human](CodeSystem-chromosome-human.md)
* [Citation Artifact Classifier](CodeSystem-citation-artifact-classifier.md)
* [Citation Classification Type](CodeSystem-citation-classification-type.md)
* [Citation Summary Style](CodeSystem-citation-summary-style.md)
* [Cited Artifact Abstract Type](CodeSystem-cited-artifact-abstract-type.md)
* [Cited Artifact Classification Type](CodeSystem-cited-artifact-classification-type.md)
* [Cited Artifact Contribution Type](CodeSystem-cited-artifact-contribution-type.md)
* [Cited Artifact Part Type](CodeSystem-cited-artifact-part-type.md)
* [Cited Artifact Status Type](CodeSystem-cited-artifact-status-type.md)
* [Cited Medium](CodeSystem-cited-medium.md)
* [Exception Codes](CodeSystem-claim-exception.md)
* [Claim Type Codes](CodeSystem-claim-type.md)
* [Claim Care Team Role Codes](CodeSystem-claimcareteamrole.md)
* [Claim Information Category Codes](CodeSystem-claiminformationcategory.md)
* [AlternativeCodeKind](CodeSystem-codesystem-altcode-kind.md)
* [Common Tags](CodeSystem-common-tags.md)
* [CommunicationCategory](CodeSystem-communication-category.md)
* [CommunicationNotDoneReason](CodeSystem-communication-not-done-reason.md)
* [CommunicationTopic](CodeSystem-communication-topic.md)
* [CompositeMeasureScoring](CodeSystem-composite-measure-scoring.md)
* [AlternativeCodeKind](CodeSystem-composition-altcode-kind.md)
* [Concept Domains](CodeSystem-conceptdomains.md)
* [Condition Category Codes](CodeSystem-condition-category.md)
* [Condition Clinical Status Codes](CodeSystem-condition-clinical.md)
* [ConditionState](CodeSystem-condition-state.md)
* [ConditionVerificationStatus](CodeSystem-condition-ver-status.md)
* [ConformanceExpectation](CodeSystem-conformance-expectation.md)
* [Consent Action Codes](CodeSystem-consentaction.md)
* [Consent Category Codes](CodeSystem-consentcategorycodes.md)
* [Consent PolicyRule Codes](CodeSystem-consentpolicycodes.md)
* [Consent Scope Codes](CodeSystem-consentscope.md)
* [Consent Verification Codes](CodeSystem-consentverification.md)
* [Contact entity type](CodeSystem-contactentity-type.md)
* [ContainerCap](CodeSystem-container-cap.md)
* [Contract Content Derivation Codes](CodeSystem-contract-content-derivative.md)
* [ContractDataMeaning](CodeSystem-contract-data-meaning.md)
* [Contract Type Codes](CodeSystem-contract-type.md)
* [Contract Action Codes](CodeSystem-contractaction.md)
* [Contract Actor Role Codes](CodeSystem-contractactorrole.md)
* [Contract Signer Type Codes](CodeSystem-contractsignertypecodes.md)
* [Contract Subtype Codes](CodeSystem-contractsubtypecodes.md)
* [Contract Term Subtype Codes](CodeSystem-contracttermsubtypecodes.md)
* [Contract Term Type Codes](CodeSystem-contracttermtypecodes.md)
* [Contributor Role](CodeSystem-contributor-role.md)
* [Contributor Summary Source](CodeSystem-contributor-summary-source.md)
* [Contributor Summary Style](CodeSystem-contributor-summary-style.md)
* [Contributor Summary Type](CodeSystem-contributor-summary-type.md)
* [CopyNumberEvent](CodeSystem-copy-number-event.md)
* [Coverage Class Codes](CodeSystem-coverage-class.md)
* [Coverage Copay Type Codes](CodeSystem-coverage-copay-type.md)
* [Coverage SelfPay Codes](CodeSystem-coverage-selfpay.md)
* [CoverageEligibilityResponse Auth Support Codes](CodeSystem-coverageeligibilityresponse-ex-auth-support.md)
* [CQL Access Modifier](CodeSystem-cql-access-modifier.md)
* [CRD Coverage Detail Codes](CodeSystem-crd-coverage-detail.md)
* [DataAbsentReason](CodeSystem-data-absent-reason.md)
* [DefinitionStatus](CodeSystem-definition-status.md)
* [DefinitionTopic](CodeSystem-definition-topic.md)
* [Structure Definition Use Codes / Keywords](CodeSystem-definition-use.md)
* [FHIRDeviceStatusReason](CodeSystem-device-status-reason.md)
* [Device Alert Activation State](CodeSystem-devicealert-activationState.md)
* [Device Alert Priority](CodeSystem-devicealert-priority.md)
* [DeviceAssociation Relationship Codes](CodeSystem-deviceassociation-relationship.md)
* [DeviceAssociation Status Reason Codes](CodeSystem-deviceassociation-status-reason.md)
* [Diagnosis Role](CodeSystem-diagnosis-role.md)
* [Diagnosis Type Codes](CodeSystem-diagnosistype.md)
* [DICOM Audit Message Record Lifecycle Events](CodeSystem-dicom-audit-lifecycle.md)
* [Diet](CodeSystem-diet.md)
* [EvidenceDirectness](CodeSystem-directness.md)
* [Discharge disposition](CodeSystem-discharge-disposition.md)
* [DoseAndRateType](CodeSystem-dose-rate-type.md)
* [Special arrangements](CodeSystem-encounter-special-arrangements.md)
* [Encounter subject status](CodeSystem-encounter-subject-status.md)
* [Encounter type](CodeSystem-encounter-type.md)
* [Endpoint Connection Type](CodeSystem-endpoint-connection-type.md)
* [Endpoint Payload Type](CodeSystem-endpoint-payload-type.md)
* [Enteral Formula Additive Type Code](CodeSystem-entformula-additive.md)
* [Episode of care type](CodeSystem-episodeofcare-type.md)
* [QualityOfEvidenceRating](CodeSystem-evidence-quality.md)
* [USCLS Codes](CodeSystem-ex-USCLS.md)
* [Benefit Category Codes](CodeSystem-ex-benefitcategory.md)
* [Example Claim SubType Codes](CodeSystem-ex-claimsubtype.md)
* [Example Coverage Financial Exception Codes](CodeSystem-ex-coverage-financial-exception.md)
* [Example Diagnosis on Admission Codes](CodeSystem-ex-diagnosis-on-admission.md)
* [Example Diagnosis Related Group Codes](CodeSystem-ex-diagnosisrelatedgroup.md)
* [Example Diagnosis Type Codes](CodeSystem-ex-diagnosistype.md)
* [ClaimPayeeResourceType](CodeSystem-ex-payee-resource-type.md)
* [Example Payment Type Codes](CodeSystem-ex-paymenttype.md)
* [Example Procedure Type Codes](CodeSystem-ex-procedure-type.md)
* [Example Program Reason Codes](CodeSystem-ex-programcode.md)
* [Example Provider Qualification Codes](CodeSystem-ex-providerqualification.md)
* [Example Related Claim Relationship Codes](CodeSystem-ex-relatedclaimrelationship.md)
* [Example Revenue Center Codes](CodeSystem-ex-revenue-center.md)
* [Example Service Place Codes](CodeSystem-ex-serviceplace.md)
* [Oral Site Codes](CodeSystem-ex-tooth.md)
* [Example Vision Prescription Product Codes](CodeSystem-ex-visionprescriptionproduct.md)
* [ExpansionParameterSource](CodeSystem-expansion-parameter-source.md)
* [ExpansionProcessingRule](CodeSystem-expansion-processing-rule.md)
* [Security Role Type](CodeSystem-extra-security-role-type.md)
* [Failure-action](CodeSystem-failure-action.md)
* [Financial Task Codes](CodeSystem-financialtaskcode.md)
* [Financial Task Input Type Codes](CodeSystem-financialtaskinputtype.md)
* [Flag Category](CodeSystem-flag-category.md)
* [Form Codes](CodeSystem-forms-codes.md)
* [Funds Reservation Codes](CodeSystem-fundsreserve.md)
* [GoalAcceptanceStatus](CodeSystem-goal-acceptance-status.md)
* [Goal achievement status](CodeSystem-goal-achievement.md)
* [Goal category](CodeSystem-goal-category.md)
* [Goal priority](CodeSystem-goal-priority.md)
* [GoalRelationshipType](CodeSystem-goal-relationship-type.md)
* [Group Code](CodeSystem-group-code.md)
* [GuideParameterCode](CodeSystem-guide-parameter-code.md)
* [HandlingConditionSet](CodeSystem-handling-condition.md)
* [FamilyHistoryAbsentReason](CodeSystem-history-absent-reason.md)
* [HL7Workgroup](CodeSystem-hl7-work-group.md)
* [HL7 Terminology Maintenance Infrastructure Vocabulary](CodeSystem-hl7TermMaintInfra.md)
* [Immunization Evaluation Dose Status Reason codes](CodeSystem-immunization-evaluation-dose-status-reason.md)
* [Immunization Evaluation Dose Status codes](CodeSystem-immunization-evaluation-dose-status.md)
* [Immunization Funding Source](CodeSystem-immunization-funding-source.md)
* [Immunization Origin Codes](CodeSystem-immunization-origin.md)
* [Immunization Program Eligibility](CodeSystem-immunization-program-eligibility.md)
* [Immunization Recommendation Status Codes](CodeSystem-immunization-recommendation-status.md)
* [Immunization Subpotent Reason](CodeSystem-immunization-subpotent-reason.md)
* [Implant Status](CodeSystem-implantStatus.md)
* [Insurance Coverage Type](CodeSystem-insurance-coverage-type.md)
* [Insurance plan type](CodeSystem-insurance-plan-type.md)
* [Insurance Product Type](CodeSystem-insurance-product-type.md)
* [Insuranceplan Plan Type](CodeSystem-insuranceplan-plan-type.md)
* [ISO 21089 2017 Health Record Lifecycle Events](CodeSystem-iso-21089-lifecycle.md)
* [LibraryType](CodeSystem-library-type.md)
* [List Empty Reasons](CodeSystem-list-empty-reason.md)
* [Example Use Codes for List](CodeSystem-list-example-use-codes.md)
* [List Order Codes](CodeSystem-list-order.md)
* [Location type](CodeSystem-location-physical-type.md)
* [MatchGrade](CodeSystem-match-grade.md)
* [Measure Aggregate Method](CodeSystem-measure-aggregate-method.md)
* [MeasureDataUsage](CodeSystem-measure-data-usage.md)
* [MeasureImprovementNotation](CodeSystem-measure-improvement-notation.md)
* [Measure Population Type](CodeSystem-measure-population.md)
* [Measure Scoring](CodeSystem-measure-scoring.md)
* [Measure Supplemental Data](CodeSystem-measure-supplemental-data.md)
* [MeasureType](CodeSystem-measure-type.md)
* [MedicationAdministration Performer Function Codes](CodeSystem-med-admin-perform-function.md)
* [Digital Media Category](CodeSystem-media-category.md)
* [Medical Management Type](CodeSystem-medical-management-type.md)
* [MedicationAdministration Location Codes](CodeSystem-medication-admin-location.md)
* [MedicationUsage Administration Location Codes](CodeSystem-medication-usage-admin-location.md)
* [MedicationDispense Performer Function Codes](CodeSystem-medicationdispense-performer-function.md)
* [MedicationKnowledge Characteristic Codes](CodeSystem-medicationknowledge-characteristic.md)
* [MedicationKnowledge Package Type Codes](CodeSystem-medicationknowledge-package-type.md)
* [MedicationKnowledge Status Codes](CodeSystem-medicationknowledge-status.md)
* [Medication request  administration  location  codes](CodeSystem-medicationrequest-admin-location.md)
* [MedicationRequest Category Codes](CodeSystem-medicationrequest-category.md)
* [MedicationRequest Course of Therapy Codes](CodeSystem-medicationrequest-course-of-therapy.md)
* [MedicationRequest Status Reason Codes](CodeSystem-medicationrequest-status-reason.md)
* [Example Message Reason Codes](CodeSystem-message-reasons-encounter.md)
* [Missing Tooth Reason Codes](CodeSystem-missingtoothreason.md)
* [Modifier type Codes](CodeSystem-modifiers.md)
* [HumanNameAssemblyOrder](CodeSystem-name-assembly-order.md)
* [NDH Healthcare Service Category](CodeSystem-ndh-healthcare-service-category.md)
* [Need](CodeSystem-need.md)
* [Nutrition intake category codes](CodeSystem-nutrition-intake-category.md)
* [Nutrition Intake Status Reason Codes](CodeSystem-nutritionintake-status-reason.md)
* [AuditEventEntityRole](CodeSystem-object-role.md)
* [Observation Category Codes](CodeSystem-observation-category.md)
* [StatisticsCode](CodeSystem-observation-statistics.md)
* [Operation Outcome Codes](CodeSystem-operation-outcome.md)
* [Organization Affiliation Role for HIE](CodeSystem-organization-affiliation-role-for-hie.md)
* [Organization Affiliation Role](CodeSystem-organization-affiliation-role.md)
* [Organization Alias Type](CodeSystem-organization-alias-type.md)
* [Organization type](CodeSystem-organization-type.md)
* [DeviceDefinitionParameterGroup](CodeSystem-parameter-group.md)
* [Participant type](CodeSystem-participant-type.md)
* [Payee Type Codes](CodeSystem-payeetype.md)
* [Payment Adjustment Reason Codes](CodeSystem-payment-adjustment-reason.md)
* [Payment Type Codes](CodeSystem-payment-type.md)
* [Payment Status Codes](CodeSystem-paymentstatus.md)
* [PlanDefinitionType](CodeSystem-plan-definition-type.md)
* [Practitioner role](CodeSystem-practitioner-role.md)
* [CMS Present on Admission (POA) Indicator](CodeSystem-presentOnAdmission.md)
* [Primary-source-type](CodeSystem-primary-source-type.md)
* [Procedure Type Codes](CodeSystem-procedure-type.md)
* [Process Priority Codes](CodeSystem-processpriority.md)
* [Professional Credential Status](CodeSystem-professional-credential-status.md)
* [Program](CodeSystem-program.md)
* [Provenance participant type](CodeSystem-provenance-participant-type.md)
* [Published In Type](CodeSystem-published-in-type.md)
* [Push-type-available](CodeSystem-push-type-available.md)
* [MaxOccurs](CodeSystem-question-max-occurs.md)
* [QuestionnaireItemUsageMode](CodeSystem-questionnaire-usage-mode.md)
* [AllergyIntoleranceCertainty](CodeSystem-reaction-event-certainty.md)
* [Reason Medication Given Codes](CodeSystem-reason-medication-given.md)
* [StrengthOfRecommendationRating](CodeSystem-recommendation-strength.md)
* [Observation Reference Range Meaning Codes](CodeSystem-referencerange-meaning.md)
* [RejectionCriterion](CodeSystem-rejection-criteria.md)
* [ResearchStudyObjectiveType](CodeSystem-research-study-objective-type.md)
* [Research Study Party Role](CodeSystem-research-study-party-role.md)
* [ResearchStudyPhase](CodeSystem-research-study-phase.md)
* [ResearchStudyPrimaryPurposeType](CodeSystem-research-study-prim-purp-type.md)
* [ResearchStudyReasonStopped](CodeSystem-research-study-reason-stopped.md)
* [Research Study Status](CodeSystem-research-study-status.md)
* [ResearchSubjectMilestone](CodeSystem-research-subject-milestone.md)
* [ResearchSubjectStateType](CodeSystem-research-subject-state-type.md)
* [ResearchSubjectState](CodeSystem-research-subject-state.md)
* [ResourceSecurityCategory](CodeSystem-resource-security-category.md)
* [PayeeResourceType](CodeSystem-resource-type-link.md)
* [Risk Probability](CodeSystem-risk-probability.md)
* [Audit Event Source Type](CodeSystem-security-source-type.md)
* [Service category](CodeSystem-service-category.md)
* [Service Delivery Method](CodeSystem-service-delivery-method.md)
* [ServiceProvisionConditions](CodeSystem-service-provision-conditions.md)
* [ReferralMethod](CodeSystem-service-referral-method.md)
* [Service type](CodeSystem-service-type.md)
* [Sex Parameter For Clinical Use](CodeSystem-sex-parameter-for-clinical-use.md)
* [SmartCapabilities](CodeSystem-smart-capabilities.md)
* [Software System Type Codes](CodeSystem-software-system-type-codes.md)
* [SpecialValues](CodeSystem-special-values.md)
* [StandardsStatus](CodeSystem-standards-status.md)
* [StateChangeReason](CodeSystem-state-change-reason.md)
* [Statistic Model Code](CodeSystem-statistic-model-code.md)
* [StatisticStatisticType](CodeSystem-statistic-type.md)
* [StatisticStudyType](CodeSystem-study-type.md)
* [SubscriberPolicyholder Relationship Codes](CodeSystem-subscriber-relationship.md)
* [SubscriptionChannel Type Codes](CodeSystem-subscription-channel-type.md)
* [Subscription Error Codes](CodeSystem-subscription-error.md)
* [SubscriptionStatusAtEvent](CodeSystem-subscription-status-at-event.md)
* [SubscriptionTag](CodeSystem-subscription-tag.md)
* [Substance Category Codes](CodeSystem-substance-category.md)
* [Supply Item Type](CodeSystem-supply-item-type.md)
* [Supply Type](CodeSystem-supply-kind.md)
* [SupplyRequestReason](CodeSystem-supplyrequest-reason.md)
* [StatisticSynthesisType](CodeSystem-synthesis-type.md)
* [Test script operation code](CodeSystem-testscript-operation-codes.md)
* [Test script profile destination type](CodeSystem-testscript-profile-destination-types.md)
* [Test script profile origin type](CodeSystem-testscript-profile-origin-types.md)
* [Time Period Ranges](CodeSystem-time-period-ranges.md)
* [Title Type](CodeSystem-title-type.md)
* [Trigger Event ID](CodeSystem-triggerEventID.md)
* [UsageContextType](CodeSystem-usage-context-type.md)
* [UTG Specific Concept Properties](CodeSystem-utg-concept-properties.md)
* [administrativeSex](CodeSystem-v2-0001.md)
* [maritalStatus](CodeSystem-v2-0002.md)
* [event](CodeSystem-v2-0003.md)
* [patientClass](CodeSystem-v2-0004.md)
* [PH_RaceAndEthnicity_CDC](CodeSystem-v2-0005.md)
* [religion2](CodeSystem-v2-0006.md)
* [admissionType](CodeSystem-v2-0007.md)
* [acknowledgmentCodes](CodeSystem-v2-0008.md)
* [ambulatoryStatus](CodeSystem-v2-0009.md)
* [stockLocation](CodeSystem-v2-0012.md)
* [transactionType](CodeSystem-v2-0017.md)
* [priority](CodeSystem-v2-0027.md)
* [route](CodeSystem-v2-0033.md)
* [siteAdministered](CodeSystem-v2-0034.md)
* [orderStatus](CodeSystem-v2-0038.md)
* [whatSubjectFilter](CodeSystem-v2-0048.md)
* [diagnosisType](CodeSystem-v2-0052.md)
* [checkDigitScheme](CodeSystem-v2-0061.md)
* [eventReason](CodeSystem-v2-0062.md)
* [relationship](CodeSystem-v2-0063.md)
* [specimenAction](CodeSystem-v2-0065.md)
* [employmentStatus](CodeSystem-v2-0066.md)
* [hospitalService](CodeSystem-v2-0069.md)
* [specimenSourceCodes](CodeSystem-v2-0070.md)
* [diagnosticServiceSectionId](CodeSystem-v2-0074.md)
* [messageType](CodeSystem-v2-0076.md)
* [natureOfAbnormalTesting](CodeSystem-v2-0080.md)
* [outlierType](CodeSystem-v2-0083.md)
* [observationResultStatusCodesInterpretation](CodeSystem-v2-0085.md)
* [queryPriority](CodeSystem-v2-0091.md)
* [re-admissionIndicator](CodeSystem-v2-0092.md)
* [typeOfAgreement](CodeSystem-v2-0098.md)
* [invocationEvent](CodeSystem-v2-0100.md)
* [delayedAcknowledgmentType](CodeSystem-v2-0102.md)
* [processingId](CodeSystem-v2-0103.md)
* [versionId](CodeSystem-v2-0104.md)
* [sourceOfComment](CodeSystem-v2-0105.md)
* [queryResponseFormat](CodeSystem-v2-0106.md)
* [deferredResponseType](CodeSystem-v2-0107.md)
* [queryResultsLevel](CodeSystem-v2-0108.md)
* [reportPriority](CodeSystem-v2-0109.md)
* [bedStatus](CodeSystem-v2-0116.md)
* [orderControlCodes](CodeSystem-v2-0119.md)
* [responseFlag](CodeSystem-v2-0121.md)
* [chargeType](CodeSystem-v2-0122.md)
* [resultStatus](CodeSystem-v2-0123.md)
* [transportationMode](CodeSystem-v2-0124.md)
* [quantityLimitedRequest](CodeSystem-v2-0126.md)
* [allergenType](CodeSystem-v2-0127.md)
* [allergySeverity](CodeSystem-v2-0128.md)
* [visitUserCodes](CodeSystem-v2-0130.md)
* [contactRole2](CodeSystem-v2-0131.md)
* [procedurePractitionerIdentifierCodeType](CodeSystem-v2-0133.md)
* [assignmentOfBenefits](CodeSystem-v2-0135.md)
* [mailClaimParty](CodeSystem-v2-0137.md)
* [militaryService](CodeSystem-v2-0140.md)
* [militaryStatus](CodeSystem-v2-0142.md)
* [eligibilitySource](CodeSystem-v2-0144.md)
* [roomType](CodeSystem-v2-0145.md)
* [amountType](CodeSystem-v2-0146.md)
* [policyType](CodeSystem-v2-0147.md)
* [moneyOrPercentageIndicator](CodeSystem-v2-0148.md)
* [dayType](CodeSystem-v2-0149.md)
* [certificationPatientType](CodeSystem-v2-0150.md)
* [accept-applicationAcknowledgmentConditions](CodeSystem-v2-0155.md)
* [whichDate-timeQualifier](CodeSystem-v2-0156.md)
* [whichDate-timeStatusQualifier](CodeSystem-v2-0157.md)
* [date-timeSelectionQualifier](CodeSystem-v2-0158.md)
* [dietCodeSpecificationType](CodeSystem-v2-0159.md)
* [trayType](CodeSystem-v2-0160.md)
* [allowSubstitution](CodeSystem-v2-0161.md)
* [routeOfAdministration](CodeSystem-v2-0162.md)
* [bodySite](CodeSystem-v2-0163.md)
* [administrationDevice](CodeSystem-v2-0164.md)
* [administrationMethod](CodeSystem-v2-0165.md)
* [rxComponentType](CodeSystem-v2-0166.md)
* [substitutionStatus](CodeSystem-v2-0167.md)
* [processingPriority](CodeSystem-v2-0168.md)
* [reportingPriority](CodeSystem-v2-0169.md)
* [derivedSpecimen](CodeSystem-v2-0170.md)
* [coordinationOfBenefits](CodeSystem-v2-0173.md)
* [natureOfServiceTestObservation](CodeSystem-v2-0174.md)
* [masterFileIdentifierCodes](CodeSystem-v2-0175.md)
* [confidentialityCodes](CodeSystem-v2-0177.md)
* [file-levelEvent](CodeSystem-v2-0178.md)
* [responseLevel](CodeSystem-v2-0179.md)
* [masterfileActionCode](CodeSystem-v2-0180.md)
* [mfnRecord-levelErrorReturn](CodeSystem-v2-0181.md)
* [active-inactive](CodeSystem-v2-0183.md)
* [preferredMethodOfContact](CodeSystem-v2-0185.md)
* [providerBilling](CodeSystem-v2-0187.md)
* [ethnicGroup](CodeSystem-v2-0189.md)
* [addressType](CodeSystem-v2-0190.md)
* [typeOfReferencedData](CodeSystem-v2-0191.md)
* [amountClass](CodeSystem-v2-0193.md)
* [nameType2](CodeSystem-v2-0200.md)
* [telecommunicationUse](CodeSystem-v2-0201.md)
* [telecommunicationEquipmentType](CodeSystem-v2-0202.md)
* [identifierType](CodeSystem-v2-0203.md)
* [organizationalNameType](CodeSystem-v2-0204.md)
* [priceType](CodeSystem-v2-0205.md)
* [segmentAction](CodeSystem-v2-0206.md)
* [processingMode](CodeSystem-v2-0207.md)
* [queryResponseStatus](CodeSystem-v2-0208.md)
* [relationalOperator](CodeSystem-v2-0209.md)
* [relationalConjunction](CodeSystem-v2-0210.md)
* [alternateCharacterSets](CodeSystem-v2-0211.md)
* [purgeStatus](CodeSystem-v2-0213.md)
* [specialProgram](CodeSystem-v2-0214.md)
* [publicity](CodeSystem-v2-0215.md)
* [patientStatus](CodeSystem-v2-0216.md)
* [visitPriority](CodeSystem-v2-0217.md)
* [livingArrangement](CodeSystem-v2-0220.md)
* [livingDependency2](CodeSystem-v2-0223.md)
* [transportArranged](CodeSystem-v2-0224.md)
* [escortRequired](CodeSystem-v2-0225.md)
* [diagnosisClassification](CodeSystem-v2-0228.md)
* [procedureFunctionalType](CodeSystem-v2-0230.md)
* [studentStatus](CodeSystem-v2-0231.md)
* [insuranceCompanyContactReason](CodeSystem-v2-0232.md)
* [reportTiming](CodeSystem-v2-0234.md)
* [reportSource](CodeSystem-v2-0235.md)
* [eventReportedTo](CodeSystem-v2-0236.md)
* [eventQualification](CodeSystem-v2-0237.md)
* [eventSeriousness](CodeSystem-v2-0238.md)
* [eventExpected](CodeSystem-v2-0239.md)
* [eventConsequence](CodeSystem-v2-0240.md)
* [patientOutcome](CodeSystem-v2-0241.md)
* [primaryObserverQualification](CodeSystem-v2-0242.md)
* [identityMayBeDivulged](CodeSystem-v2-0243.md)
* [statusOfEvaluation](CodeSystem-v2-0247.md)
* [productSource](CodeSystem-v2-0248.md)
* [relatednessAssessment](CodeSystem-v2-0250.md)
* [actionTakenInResponseToTheEvent](CodeSystem-v2-0251.md)
* [causalityObservations](CodeSystem-v2-0252.md)
* [indirectExposureMechanism](CodeSystem-v2-0253.md)
* [kindOfQuantity](CodeSystem-v2-0254.md)
* [durationCategories](CodeSystem-v2-0255.md)
* [timeDelayPostChallenge](CodeSystem-v2-0256.md)
* [natureOfChallenge](CodeSystem-v2-0257.md)
* [relationshipModifier](CodeSystem-v2-0258.md)
* [patientLocationType](CodeSystem-v2-0260.md)
* [locationEquipment](CodeSystem-v2-0261.md)
* [privacyLevel](CodeSystem-v2-0262.md)
* [levelOfCare](CodeSystem-v2-0263.md)
* [specialtyType](CodeSystem-v2-0265.md)
* [daysOfTheWeek](CodeSystem-v2-0267.md)
* [override](CodeSystem-v2-0268.md)
* [chargeOnIndicator](CodeSystem-v2-0269.md)
* [documentType](CodeSystem-v2-0270.md)
* [documentCompletionStatus](CodeSystem-v2-0271.md)
* [documentConfidentialityStatus2](CodeSystem-v2-0272.md)
* [documentAvailabilityStatus](CodeSystem-v2-0273.md)
* [documentStorageStatus](CodeSystem-v2-0275.md)
* [appointmentReason](CodeSystem-v2-0276.md)
* [appointmentType](CodeSystem-v2-0277.md)
* [fillerStatus](CodeSystem-v2-0278.md)
* [allowSubstitution](CodeSystem-v2-0279.md)
* [referralPriority](CodeSystem-v2-0280.md)
* [referralType](CodeSystem-v2-0281.md)
* [referralDisposition](CodeSystem-v2-0282.md)
* [referralStatus](CodeSystem-v2-0283.md)
* [referralCategory](CodeSystem-v2-0284.md)
* [providerRole](CodeSystem-v2-0286.md)
* [problem-goalAction](CodeSystem-v2-0287.md)
* [mimeBase64EncodingCharacters](CodeSystem-v2-0290.md)
* [subtypeOfReferencedData](CodeSystem-v2-0291.md)
* [timeSelectionCriteriaParameterClass](CodeSystem-v2-0294.md)
* [cpRangeType](CodeSystem-v2-0298.md)
* [encoding](CodeSystem-v2-0299.md)
* [universalIdType](CodeSystem-v2-0301.md)
* [personLocationType](CodeSystem-v2-0305.md)
* [coverageType](CodeSystem-v2-0309.md)
* [jobStatus](CodeSystem-v2-0311.md)
* [livingWillCodes](CodeSystem-v2-0315.md)
* [organDonorCodes](CodeSystem-v2-0316.md)
* [annotations](CodeSystem-v2-0317.md)
* [dispenseMethod](CodeSystem-v2-0321.md)
* [completionStatus](CodeSystem-v2-0322.md)
* [actionCodes](CodeSystem-v2-0323.md)
* [locationCharacteristic](CodeSystem-v2-0324.md)
* [locationRelationship](CodeSystem-v2-0325.md)
* [visitIndicator](CodeSystem-v2-0326.md)
* [quantityMethod](CodeSystem-v2-0329.md)
* [marketingBasis](CodeSystem-v2-0330.md)
* [facilityType](CodeSystem-v2-0331.md)
* [sourceType](CodeSystem-v2-0332.md)
* [disabilityInformationRelationship](CodeSystem-v2-0334.md)
* [repeatPattern](CodeSystem-v2-0335.md)
* [referralReason](CodeSystem-v2-0336.md)
* [certificationStatus](CodeSystem-v2-0337.md)
* [advancedBeneficiaryNotice](CodeSystem-v2-0339.md)
* [patientsRelationshipToInsured](CodeSystem-v2-0344.md)
* [cweStatuses](CodeSystem-v2-0353.md)
* [messageStructure](CodeSystem-v2-0354.md)
* [primaryKeyValueType](CodeSystem-v2-0355.md)
* [alternateCharacterSetHandlingScheme](CodeSystem-v2-0356.md)
* [messageErrorCondition](CodeSystem-v2-0357.md)
* [diagnosisPriority](CodeSystem-v2-0359.md)
* [degreeLicenseCertificate](CodeSystem-v2-0360.md)
* [commentType](CodeSystem-v2-0364.md)
* [equipmentState](CodeSystem-v2-0365.md)
* [local-remoteControlState](CodeSystem-v2-0366.md)
* [alertLevel](CodeSystem-v2-0367.md)
* [remoteControlCommand](CodeSystem-v2-0368.md)
* [specimenRole](CodeSystem-v2-0369.md)
* [containerStatus](CodeSystem-v2-0370.md)
* [additivePreservative](CodeSystem-v2-0371.md)
* [specimenComponent](CodeSystem-v2-0372.md)
* [treatment](CodeSystem-v2-0373.md)
* [systemInducedContaminants](CodeSystem-v2-0374.md)
* [artificialBlood](CodeSystem-v2-0375.md)
* [specialHandling](CodeSystem-v2-0376.md)
* [environmentalFactors](CodeSystem-v2-0377.md)
* [substanceStatus](CodeSystem-v2-0383.md)
* [substanceType](CodeSystem-v2-0384.md)
* [commandResponse](CodeSystem-v2-0387.md)
* [processingType](CodeSystem-v2-0388.md)
* [analyteRepeatStatus](CodeSystem-v2-0389.md)
* [segmentGroup](CodeSystem-v2-0391.md)
* [matchReason](CodeSystem-v2-0392.md)
* [matchAlgorithms](CodeSystem-v2-0393.md)
* [responseModality](CodeSystem-v2-0394.md)
* [modifyIndicator](CodeSystem-v2-0395.md)
* [codingSystem](CodeSystem-v2-0396.md)
* [sequencing](CodeSystem-v2-0397.md)
* [continuationStyle](CodeSystem-v2-0398.md)
* [governmentReimbursementProgram](CodeSystem-v2-0401.md)
* [schoolType](CodeSystem-v2-0402.md)
* [languageAbility](CodeSystem-v2-0403.md)
* [languageProficiency](CodeSystem-v2-0404.md)
* [organizationUnitType](CodeSystem-v2-0406.md)
* [applicationChangeType](CodeSystem-v2-0409.md)
* [drgTransferType](CodeSystem-v2-0415.md)
* [procedureDrgType](CodeSystem-v2-0416.md)
* [tissueType](CodeSystem-v2-0417.md)
* [procedurePriority](CodeSystem-v2-0418.md)
* [severityOfIllness](CodeSystem-v2-0421.md)
* [triageType](CodeSystem-v2-0422.md)
* [caseCategory](CodeSystem-v2-0423.md)
* [gestationCategory](CodeSystem-v2-0424.md)
* [newbornType](CodeSystem-v2-0425.md)
* [bloodProduct](CodeSystem-v2-0426.md)
* [riskManagementIncident](CodeSystem-v2-0427.md)
* [incidentType](CodeSystem-v2-0428.md)
* [productionClass](CodeSystem-v2-0429.md)
* [arrivalMode](CodeSystem-v2-0430.md)
* [recreationalDrugType](CodeSystem-v2-0431.md)
* [admissionLevelOfCare](CodeSystem-v2-0432.md)
* [precaution](CodeSystem-v2-0433.md)
* [patientCondition](CodeSystem-v2-0434.md)
* [advanceDirective](CodeSystem-v2-0435.md)
* [sensitivityToCausativeAgent](CodeSystem-v2-0436.md)
* [alertDevice](CodeSystem-v2-0437.md)
* [allergyClinicalStatus](CodeSystem-v2-0438.md)
* [dataTypes](CodeSystem-v2-0440.md)
* [immunizationRegistryStatus](CodeSystem-v2-0441.md)
* [locationServiceType](CodeSystem-v2-0442.md)
* [providerRole](CodeSystem-v2-0443.md)
* [nameAssemblyOrder](CodeSystem-v2-0444.md)
* [identityReliability](CodeSystem-v2-0445.md)
* [eventType](CodeSystem-v2-0450.md)
* [overallClaimDisposition](CodeSystem-v2-0457.md)
* [name-addressRepresentation](CodeSystem-v2-0465.md)
* [ambulatoryPaymentClassification](CodeSystem-v2-0466.md)
* [paymentAdjustmentInformation](CodeSystem-v2-0468.md)
* [packagingStatus](CodeSystem-v2-0469.md)
* [reimbursementType](CodeSystem-v2-0470.md)
* [tqConjunctionId](CodeSystem-v2-0472.md)
* [formularyStatus](CodeSystem-v2-0473.md)
* [organizationUnitType](CodeSystem-v2-0474.md)
* [chargeTypeReason](CodeSystem-v2-0475.md)
* [controlledSubstanceSchedule](CodeSystem-v2-0477.md)
* [formularyStatus](CodeSystem-v2-0478.md)
* [pharmacyOrderTypes](CodeSystem-v2-0480.md)
* [orderType](CodeSystem-v2-0482.md)
* [authorizationMode](CodeSystem-v2-0483.md)
* [dispenseType](CodeSystem-v2-0484.md)
* [extendedPriorityCodes](CodeSystem-v2-0485.md)
* [specimenType](CodeSystem-v2-0487.md)
* [specimenCollectionMethod](CodeSystem-v2-0488.md)
* [risks](CodeSystem-v2-0489.md)
* [specimenRejectReason](CodeSystem-v2-0490.md)
* [specimenQuality](CodeSystem-v2-0491.md)
* [specimenAppropriateness](CodeSystem-v2-0492.md)
* [specimenCondition](CodeSystem-v2-0493.md)
* [specimenChildRole](CodeSystem-v2-0494.md)
* [bodySiteModifier](CodeSystem-v2-0495.md)
* [consentType](CodeSystem-v2-0496.md)
* [consentMode](CodeSystem-v2-0497.md)
* [consentStatus](CodeSystem-v2-0498.md)
* [consentBypassReason](CodeSystem-v2-0499.md)
* [consentDisclosureLevel](CodeSystem-v2-0500.md)
* [consentNon-disclosureReason](CodeSystem-v2-0501.md)
* [non-subjectConsenterReason](CodeSystem-v2-0502.md)
* [sequenceResultsFlag](CodeSystem-v2-0503.md)
* [sequenceCondition](CodeSystem-v2-0504.md)
* [cyclicEntryExitIndicator](CodeSystem-v2-0505.md)
* [serviceRequestRelationship](CodeSystem-v2-0506.md)
* [observationResultHandling](CodeSystem-v2-0507.md)
* [bloodProductProcessingRequirements](CodeSystem-v2-0508.md)
* [bloodProductDispenseStatus](CodeSystem-v2-0510.md)
* [bpObservationStatusCodesInterpretation](CodeSystem-v2-0511.md)
* [bloodProductTransfusion-dispositionStatus](CodeSystem-v2-0513.md)
* [transfusionAdverseReaction](CodeSystem-v2-0514.md)
* [errorSeverity](CodeSystem-v2-0516.md)
* [informInstructions](CodeSystem-v2-0517.md)
* [overrideType](CodeSystem-v2-0518.md)
* [messageWaitingPriority](CodeSystem-v2-0520.md)
* [computationType](CodeSystem-v2-0523.md)
* [sequenceCondition](CodeSystem-v2-0524.md)
* [calendarAlignment](CodeSystem-v2-0527.md)
* [eventRelatedPeriod](CodeSystem-v2-0528.md)
* [precision](CodeSystem-v2-0529.md)
* [organization-Agency-Department](CodeSystem-v2-0530.md)
* [expandedYes-NoIndicator](CodeSystem-v2-0532.md)
* [clergyNotificationType](CodeSystem-v2-0534.md)
* [signatureType](CodeSystem-v2-0535.md)
* [certificateStatus](CodeSystem-v2-0536.md)
* [institutionRelationshipType](CodeSystem-v2-0538.md)
* [inactiveReason](CodeSystem-v2-0540.md)
* [containerCondition](CodeSystem-v2-0544.md)
* [jurisdictionalBreadth](CodeSystem-v2-0547.md)
* [signatorysRelationshipToSubject](CodeSystem-v2-0548.md)
* [bodyParts](CodeSystem-v2-0550.md)
* [invoiceControl](CodeSystem-v2-0553.md)
* [invoiceReason](CodeSystem-v2-0554.md)
* [invoiceType](CodeSystem-v2-0555.md)
* [benefitGroup](CodeSystem-v2-0556.md)
* [payeeType](CodeSystem-v2-0557.md)
* [payeeRelationshipToInvoice](CodeSystem-v2-0558.md)
* [product-serviceStatus](CodeSystem-v2-0559.md)
* [Quantity Units](CodeSystem-v2-0560.md)
* [product-servicesClarification](CodeSystem-v2-0561.md)
* [processingConsideration](CodeSystem-v2-0562.md)
* [adjustmentCategory](CodeSystem-v2-0564.md)
* [providerAdjustmentReason](CodeSystem-v2-0565.md)
* [bloodUnitType](CodeSystem-v2-0566.md)
* [adjustmentAction](CodeSystem-v2-0569.md)
* [paymentMethod](CodeSystem-v2-0570.md)
* [invoiceProcessingResultsStatus](CodeSystem-v2-0571.md)
* [taxStatus](CodeSystem-v2-0572.md)
* [userAuthenticationCredentialType](CodeSystem-v2-0615.md)
* [addressExpirationReason](CodeSystem-v2-0616.md)
* [addressUsage](CodeSystem-v2-0617.md)
* [protection](CodeSystem-v2-0618.md)
* [itemStatus](CodeSystem-v2-0625.md)
* [itemImportance](CodeSystem-v2-0634.md)
* [reorderTheory](CodeSystem-v2-0642.md)
* [laborCalculationType](CodeSystem-v2-0651.md)
* [dateFormat](CodeSystem-v2-0653.md)
* [deviceType](CodeSystem-v2-0657.md)
* [lotControl](CodeSystem-v2-0659.md)
* [deviceDataState](CodeSystem-v2-0667.md)
* [loadStatus](CodeSystem-v2-0669.md)
* [deviceStatus](CodeSystem-v2-0682.md)
* [cycleType](CodeSystem-v2-0702.md)
* [accessRestrictionValue](CodeSystem-v2-0717.md)
* [cclValue](CodeSystem-v2-0728.md)
* [drgDiagnosisDeterminationStatus](CodeSystem-v2-0731.md)
* [grouperStatus](CodeSystem-v2-0734.md)
* [drgStatusPatient](CodeSystem-v2-0739.md)
* [drgStatusFinancialCalculation](CodeSystem-v2-0742.md)
* [drgGroupingStatus](CodeSystem-v2-0749.md)
* [drgstatusWeightAtBirth](CodeSystem-v2-0755.md)
* [drgStatusRespirationMinutes](CodeSystem-v2-0757.md)
* [drgstatusAdmission](CodeSystem-v2-0759.md)
* [drgProcedureDeterminationStatus](CodeSystem-v2-0761.md)
* [drgProcedureRelevance](CodeSystem-v2-0763.md)
* [itemStatus](CodeSystem-v2-0776.md)
* [itemType](CodeSystem-v2-0778.md)
* [approvingRegulatoryAgency](CodeSystem-v2-0790.md)
* [rulingAct](CodeSystem-v2-0793.md)
* [sterilizationType](CodeSystem-v2-0806.md)
* [package](CodeSystem-v2-0818.md)
* [mimeTypes](CodeSystem-v2-0834.md)
* [telecommunicationExpirationReason](CodeSystem-v2-0868.md)
* [supplyRisk](CodeSystem-v2-0871.md)
* [roleExecutingPhysician](CodeSystem-v2-0881.md)
* [medicalRoleExecutingPhysician](CodeSystem-v2-0882.md)
* [sideOfBody](CodeSystem-v2-0894.md)
* [securityCheckScheme](CodeSystem-v2-0904.md)
* [shipmentStatus](CodeSystem-v2-0905.md)
* [actpriority](CodeSystem-v2-0906.md)
* [confidentiality](CodeSystem-v2-0907.md)
* [patientResultsReleaseCategorizationScheme](CodeSystem-v2-0909.md)
* [participation](CodeSystem-v2-0912.md)
* [rootCause](CodeSystem-v2-0914.md)
* [relevantClincialInformation](CodeSystem-v2-0916.md)
* [bolusType](CodeSystem-v2-0917.md)
* [pcaType](CodeSystem-v2-0918.md)
* [exclusiveTest](CodeSystem-v2-0919.md)
* [preferredSpecimen-AttributeStatus](CodeSystem-v2-0920.md)
* [certificationType](CodeSystem-v2-0921.md)
* [certificationCategory](CodeSystem-v2-0922.md)
* [processInterruption](CodeSystem-v2-0923.md)
* [cumulativeDosageLimitUom](CodeSystem-v2-0924.md)
* [phlebotomyIssue](CodeSystem-v2-0925.md)
* [phlebotomyStatus](CodeSystem-v2-0926.md)
* [armStick](CodeSystem-v2-0927.md)
* [intendedProcedureType](CodeSystem-v2-0933.md)
* [processInterruptionReason](CodeSystem-v2-0935.md)
* [observationType](CodeSystem-v2-0936.md)
* [observationSubtype](CodeSystem-v2-0937.md)
* [collectionEvent](CodeSystem-v2-0938.md)
* [communicationLocation](CodeSystem-v2-0939.md)
* [limitationTypeCode](CodeSystem-v2-0940.md)
* [equipmentStateIndicator](CodeSystem-v2-0942.md)
* [auto-DilutionType](CodeSystem-v2-0945.md)
* [supplierType](CodeSystem-v2-0946.md)
* [v2CS-relationshipType](CodeSystem-v2-0948.md)
* [orderControlCodeReason](CodeSystem-v2-0949.md)
* [orderStatusModifier](CodeSystem-v2-0950.md)
* [reasonForStudy](CodeSystem-v2-0951.md)
* [onlineVerificationResult](CodeSystem-v2-0970.md)
* [onlineVerificationResultErrorCodes](CodeSystem-v2-0971.md)
* [name-addressRepresentation](CodeSystem-v2-4000.md)
* [V2 Table List](CodeSystem-v2-tables.md)
* [AcknowledgementCondition](CodeSystem-v3-AcknowledgementCondition.md)
* [AcknowledgementDetailCode](CodeSystem-v3-AcknowledgementDetailCode.md)
* [AcknowledgementDetailType](CodeSystem-v3-AcknowledgementDetailType.md)
* [AcknowledgementType](CodeSystem-v3-AcknowledgementType.md)
* [ActClass](CodeSystem-v3-ActClass.md)
* [ActCode](CodeSystem-v3-ActCode.md)
* [ActExposureLevelCode](CodeSystem-v3-ActExposureLevelCode.md)
* [ActInvoiceElementModifier](CodeSystem-v3-ActInvoiceElementModifier.md)
* [ActMood](CodeSystem-v3-ActMood.md)
* [ActPriority](CodeSystem-v3-ActPriority.md)
* [ActReason](CodeSystem-v3-ActReason.md)
* [ActRelationshipCheckpoint](CodeSystem-v3-ActRelationshipCheckpoint.md)
* [ActRelationshipJoin](CodeSystem-v3-ActRelationshipJoin.md)
* [ActRelationshipSplit](CodeSystem-v3-ActRelationshipSplit.md)
* [ActRelationshipSubset](CodeSystem-v3-ActRelationshipSubset.md)
* [ActRelationshipType](CodeSystem-v3-ActRelationshipType.md)
* [ActSite](CodeSystem-v3-ActSite.md)
* [ActStatus](CodeSystem-v3-ActStatus.md)
* [ActUSPrivacyLaw](CodeSystem-v3-ActUSPrivacyLaw.md)
* [ActUncertainty](CodeSystem-v3-ActUncertainty.md)
* [AddressPartType](CodeSystem-v3-AddressPartType.md)
* [AddressUse](CodeSystem-v3-AddressUse.md)
* [AdministrativeGender](CodeSystem-v3-AdministrativeGender.md)
* [AmericanIndianAlaskaNativeLanguages](CodeSystem-v3-AmericanIndianAlaskaNativeLanguages.md)
* [Calendar](CodeSystem-v3-Calendar.md)
* [Calendar Cycle Codes](CodeSystem-v3-CalendarCycle.md)
* [CalendarType](CodeSystem-v3-CalendarType.md)
* [Charset](CodeSystem-v3-Charset.md)
* [CodeSystem](CodeSystem-v3-CodeSystem.md)
* [HL7 Code System Type](CodeSystem-v3-CodeSystemType.md)
* [CodingRationale](CodeSystem-v3-CodingRationale.md)
* [CommunicationFunctionType](CodeSystem-v3-CommunicationFunctionType.md)
* [CompressionAlgorithm](CodeSystem-v3-CompressionAlgorithm.md)
* [Possible Concept Code Relationships](CodeSystem-v3-ConceptCodeRelationship.md)
* [ConceptGenerality](CodeSystem-v3-ConceptGenerality.md)
* [HL7 Value Set and Coded Concept Property Codes](CodeSystem-v3-ConceptProperty.md)
* [HL7 Coded Concept Status](CodeSystem-v3-ConceptStatus.md)
* [Confidentiality](CodeSystem-v3-Confidentiality.md)
* [ContainerCap](CodeSystem-v3-ContainerCap.md)
* [ContainerSeparator](CodeSystem-v3-ContainerSeparator.md)
* [ContentProcessingMode](CodeSystem-v3-ContentProcessingMode.md)
* [ContextControl](CodeSystem-v3-ContextControl.md)
* [Country](CodeSystem-v3-Country.md)
* [Currency](CodeSystem-v3-Currency.md)
* [DataOperation](CodeSystem-v3-DataOperation.md)
* [DataType](CodeSystem-v3-DataType.md)
* [Dentition](CodeSystem-v3-Dentition.md)
* [DeviceAlertLevel](CodeSystem-v3-DeviceAlertLevel.md)
* [DocumentCompletion](CodeSystem-v3-DocumentCompletion.md)
* [DocumentStorage](CodeSystem-v3-DocumentStorage.md)
* [EditStatus](CodeSystem-v3-EditStatus.md)
* [Education Level](CodeSystem-v3-EducationLevel.md)
* [EmployeeJobClass](CodeSystem-v3-EmployeeJobClass.md)
* [EncounterAccident](CodeSystem-v3-EncounterAccident.md)
* [Encounter Acuity](CodeSystem-v3-EncounterAcuity.md)
* [EncounterAdmissionSource](CodeSystem-v3-EncounterAdmissionSource.md)
* [EncounterReferralSource](CodeSystem-v3-EncounterReferralSource.md)
* [EncounterSpecialCourtesy](CodeSystem-v3-EncounterSpecialCourtesy.md)
* [EntityClass](CodeSystem-v3-EntityClass.md)
* [EntityCode](CodeSystem-v3-EntityCode.md)
* [EntityDeterminer](CodeSystem-v3-EntityDeterminer.md)
* [EntityHandling](CodeSystem-v3-EntityHandling.md)
* [EntityNamePartQualifier](CodeSystem-v3-EntityNamePartQualifier.md)
* [EntityNamePartQualifierR2](CodeSystem-v3-EntityNamePartQualifierR2.md)
* [EntityNamePartType](CodeSystem-v3-EntityNamePartType.md)
* [EntityNamePartTypeR2](CodeSystem-v3-EntityNamePartTypeR2.md)
* [EntityNameUse](CodeSystem-v3-EntityNameUse.md)
* [EntityNameUseR2](CodeSystem-v3-EntityNameUseR2.md)
* [EntityRisk](CodeSystem-v3-EntityRisk.md)
* [EntityStatus](CodeSystem-v3-EntityStatus.md)
* [EquipmentAlertLevel](CodeSystem-v3-EquipmentAlertLevel.md)
* [Ethnicity](CodeSystem-v3-Ethnicity.md)
* [ExposureMode](CodeSystem-v3-ExposureMode.md)
* [GTSAbbreviation](CodeSystem-v3-GTSAbbreviation.md)
* [GenderStatus](CodeSystem-v3-GenderStatus.md)
* [HL7CommitteeIDInRIM](CodeSystem-v3-HL7CommitteeIDInRIM.md)
* [HL7ConformanceInclusion](CodeSystem-v3-HL7ConformanceInclusion.md)
* [HL7ContextConductionStyle](CodeSystem-v3-HL7ContextConductionStyle.md)
* [HL7DefinedRoseProperty](CodeSystem-v3-HL7DefinedRoseProperty.md)
* [HL7 Document Format Codes](CodeSystem-v3-HL7DocumentFormatCodes.md)
* [HL7StandardVersionCode](CodeSystem-v3-HL7StandardVersionCode.md)
* [HL7UpdateMode](CodeSystem-v3-HL7UpdateMode.md)
* [Healthcare Provider Taxonomy HIPAA](CodeSystem-v3-HealthcareProviderTaxonomyHIPAA.md)
* [HtmlLinkType](CodeSystem-v3-HtmlLinkType.md)
* [ISO 3166 2 Character Country Codes](CodeSystem-v3-ISO3166-1retired.md)
* [ISO 3166 3 Character Country Codes](CodeSystem-v3-ISO3166-2retired.md)
* [ISO 3166 Numeric country Codes](CodeSystem-v3-ISO3166-3retired.md)
* [IdentifierReliability](CodeSystem-v3-IdentifierReliability.md)
* [IdentifierScope](CodeSystem-v3-IdentifierScope.md)
* [IntegrityCheckAlgorithm](CodeSystem-v3-IntegrityCheckAlgorithm.md)
* [LanguageAbilityMode](CodeSystem-v3-LanguageAbilityMode.md)
* [LanguageAbilityProficiency](CodeSystem-v3-LanguageAbilityProficiency.md)
* [LivingArrangement](CodeSystem-v3-LivingArrangement.md)
* [LocalMarkupIgnore](CodeSystem-v3-LocalMarkupIgnore.md)
* [LocalRemoteControlState](CodeSystem-v3-LocalRemoteControlState.md)
* [MDFAttributeType](CodeSystem-v3-MDFAttributeType.md)
* [MDFSubjectAreaPrefix](CodeSystem-v3-MDFSubjectAreaPrefix.md)
* [ManagedParticipationStatus](CodeSystem-v3-ManagedParticipationStatus.md)
* [ManufacturerModelNameExample](CodeSystem-v3-ManufacturerModelNameExample.md)
* [MapRelationship](CodeSystem-v3-MapRelationship.md)
* [MaritalStatus](CodeSystem-v3-MaritalStatus.md)
* [MaterialForm](CodeSystem-v3-MaterialForm.md)
* [MaterialType](CodeSystem-v3-MaterialType.md)
* [MdfHmdMetSourceType](CodeSystem-v3-MdfHmdMetSourceType.md)
* [MdfHmdRowType](CodeSystem-v3-MdfHmdRowType.md)
* [MdfRmimRowType](CodeSystem-v3-MdfRmimRowType.md)
* [MessageCondition](CodeSystem-v3-MessageCondition.md)
* [MessageWaitingPriority](CodeSystem-v3-MessageWaitingPriority.md)
* [ModifyIndicator](CodeSystem-v3-ModifyIndicator.md)
* [NullFlavor](CodeSystem-v3-NullFlavor.md)
* [ObservationCategory](CodeSystem-v3-ObservationCategory.md)
* [ObservationInterpretation](CodeSystem-v3-ObservationInterpretation.md)
* [ObservationMethod](CodeSystem-v3-ObservationMethod.md)
* [ObservationValue](CodeSystem-v3-ObservationValue.md)
* [OrganizationNameType](CodeSystem-v3-OrganizationNameType.md)
* [ParameterizedDataType](CodeSystem-v3-ParameterizedDataType.md)
* [ParticipationFunction](CodeSystem-v3-ParticipationFunction.md)
* [ParticipationMode](CodeSystem-v3-ParticipationMode.md)
* [ParticipationSignature](CodeSystem-v3-ParticipationSignature.md)
* [ParticipationType](CodeSystem-v3-ParticipationType.md)
* [PatientImportance](CodeSystem-v3-PatientImportance.md)
* [PaymentTerms](CodeSystem-v3-PaymentTerms.md)
* [PersonDisabilityType](CodeSystem-v3-PersonDisabilityType.md)
* [PostalAddressUse](CodeSystem-v3-PostalAddressUse.md)
* [ProbabilityDistributionType](CodeSystem-v3-ProbabilityDistributionType.md)
* [ProcessingID](CodeSystem-v3-ProcessingID.md)
* [ProcessingMode](CodeSystem-v3-ProcessingMode.md)
* [QueryParameterValue](CodeSystem-v3-QueryParameterValue.md)
* [QueryPriority](CodeSystem-v3-QueryPriority.md)
* [QueryQuantityUnit](CodeSystem-v3-QueryQuantityUnit.md)
* [QueryRequestLimit](CodeSystem-v3-QueryRequestLimit.md)
* [QueryResponse](CodeSystem-v3-QueryResponse.md)
* [QueryStatusCode](CodeSystem-v3-QueryStatusCode.md)
* [Race](CodeSystem-v3-Race.md)
* [RelationalOperator](CodeSystem-v3-RelationalOperator.md)
* [RelationshipConjunction](CodeSystem-v3-RelationshipConjunction.md)
* [Religious Affiliation](CodeSystem-v3-ReligiousAffiliation.md)
* [ResponseLevel](CodeSystem-v3-ResponseLevel.md)
* [ResponseModality](CodeSystem-v3-ResponseModality.md)
* [ResponseMode](CodeSystem-v3-ResponseMode.md)
* [RoleClass](CodeSystem-v3-RoleClass.md)
* [RoleCode](CodeSystem-v3-RoleCode.md)
* [RoleLinkStatus](CodeSystem-v3-RoleLinkStatus.md)
* [RoleLinkType](CodeSystem-v3-RoleLinkType.md)
* [RoleStatus](CodeSystem-v3-RoleStatus.md)
* [RouteOfAdministration](CodeSystem-v3-RouteOfAdministration.md)
* [Sequencing](CodeSystem-v3-Sequencing.md)
* [SetOperator](CodeSystem-v3-SetOperator.md)
* [SoftwareNameExample](CodeSystem-v3-SoftwareNameExample.md)
* [SpecimenType](CodeSystem-v3-SpecimenType.md)
* [SubstitutionCondition](CodeSystem-v3-SubstitutionCondition.md)
* [TableCellHorizontalAlign](CodeSystem-v3-TableCellHorizontalAlign.md)
* [TableCellScope](CodeSystem-v3-TableCellScope.md)
* [TableCellVerticalAlign](CodeSystem-v3-TableCellVerticalAlign.md)
* [TableFrame](CodeSystem-v3-TableFrame.md)
* [TableRules](CodeSystem-v3-TableRules.md)
* [TargetAwareness](CodeSystem-v3-TargetAwareness.md)
* [TelecommunicationAddressUse](CodeSystem-v3-TelecommunicationAddressUse.md)
* [TelecommunicationCapabilities](CodeSystem-v3-TelecommunicationCapabilities.md)
* [TimingEvent](CodeSystem-v3-TimingEvent.md)
* [TransmissionRelationshipTypeCode](CodeSystem-v3-TransmissionRelationshipTypeCode.md)
* [TribalEntityUS](CodeSystem-v3-TribalEntityUS.md)
* [Universal Resource Locator Scheme](CodeSystem-v3-URLScheme.md)
* [VaccineManufacturer](CodeSystem-v3-VaccineManufacturer.md)
* [VaccineType](CodeSystem-v3-VaccineType.md)
* [VocabularyDomainQualifier](CodeSystem-v3-VocabularyDomainQualifier.md)
* [Work Classification (Occupational Data for Health)](CodeSystem-v3-WorkClassificationODH.md)
* [Systematized Nomenclature of Dentistry (SNODENT)](CodeSystem-v3-ada-snodent.md)
* [HL7ApprovalStatus](CodeSystem-v3-hl7ApprovalStatus.md)
* [HL7CMETAttribution](CodeSystem-v3-hl7CMETAttribution.md)
* [HL7ITSType](CodeSystem-v3-hl7ITSType.md)
* [HL7 ITS Version Code](CodeSystem-v3-hl7ITSVersionCode.md)
* [HL7PublishingDomain](CodeSystem-v3-hl7PublishingDomain.md)
* [HL7PublishingSection](CodeSystem-v3-hl7PublishingSection.md)
* [HL7PublishingSubSection](CodeSystem-v3-hl7PublishingSubSection.md)
* [HL7Realm](CodeSystem-v3-hl7Realm.md)
* [HL7V3Conformance](CodeSystem-v3-hl7V3Conformance.md)
* [HL7VoteResolution](CodeSystem-v3-hl7VoteResolution.md)
* [ISO 4217 Currency code, HL7 use](CodeSystem-v3-iso4217-HL7.md)
* [Media Type](CodeSystem-v3-mediaType.md)
* [Orderable Drug Form](CodeSystem-v3-orderableDrugForm.md)
* [Style Type](CodeSystem-v3-styleType.md)
* [Substance Admin Substitution](CodeSystem-v3-substanceAdminSubstitution.md)
* [Validation-process](CodeSystem-validation-process.md)
* [Validation-status](CodeSystem-validation-status.md)
* [Validation-type](CodeSystem-validation-type.md)
* [EvidenceVariableRoleSubtype](CodeSystem-variable-role-subtype.md)
* [EvidenceVariableRole](CodeSystem-variable-role.md)
* [sequenceStatus](CodeSystem-variant-state.md)
* [VerificationResult Communication Method](CodeSystem-verificationresult-communication-method.md)
* [Virtual Healthcare Delivery Method](CodeSystem-virtual-healthcare-delivery-method.md)

### ValueSets

* [CMS Place of Service Codes (POS)](ValueSet-CMSPlaceOfServiceCodes.md)
* [Interagency Language Roundtable Speaking Skill Scale](ValueSet-ILRSpeakingSkillScale.md)
* [Languages](ValueSet-Languages.md)
* [Present on Admission Indicators](ValueSet-POAIndicators.md)
* [USPS Two Letter Alphabetic Codes](ValueSet-USPS-State.md)
* [Accepting Patients](ValueSet-accepting-patients.md)
* [Action Participant Role](ValueSet-action-participant-role.md)
* [ActionType](ValueSet-action-type.md)
* [ActivityDefinitionCategory](ValueSet-activity-definition-category.md)
* [AdjudicationError](ValueSet-adjudication-error.md)
* [Adjudication Reason Codes](ValueSet-adjudication-reason.md)
* [Adjudication Value Codes](ValueSet-adjudication.md)
* [AdverseEventCategory](ValueSet-adverse-event-category.md)
* [AdverseEventCausalityAssessment](ValueSet-adverse-event-causality-assess.md)
* [AdverseEventCausalityMethod](ValueSet-adverse-event-causality-method.md)
* [Adverse Event Clinical Research Causality Relatedness](ValueSet-adverse-event-clinical-research-causality-relatedness.md)
* [Adverse Event Clinical Research Grades](ValueSet-adverse-event-clinical-research-grades.md)
* [Adverse Event Clinical Research Outcomes](ValueSet-adverse-event-clinical-research-outcomes.md)
* [Adverse Event Clinical Research Seriousness Criteria](ValueSet-adverse-event-clinical-research-seriousness-criteria.md)
* [AdverseEventSeriousness](ValueSet-adverse-event-seriousness.md)
* [AdverseEventSeverity](ValueSet-adverse-event-severity.md)
* [AllergyIntoleranceSubstanceExposureRisk](ValueSet-allerg-intol-substance-exp-risk.md)
* [AllergyIntolerance Clinical Status Codes](ValueSet-allergyintolerance-clinical.md)
* [AllergyIntolerance Verification Status](ValueSet-allergyintolerance-verification.md)
* [Appointment cancellation reason](ValueSet-appointment-cancellation-reason.md)
* [Appropriateness Score](ValueSet-appropriateness-score.md)
* [Artifact Contribution Instance Type](ValueSet-artifact-contribution-instance-type.md)
* [Artifact Identifier Type](ValueSet-artifact-identifier-type.md)
* [Artifact Relationship Type](ValueSet-artifact-relationship-type.md)
* [Artifact Url Classifier](ValueSet-artifact-url-classifier.md)
* [Artifact Version Policy](ValueSet-artifact-version-policy.md)
* [StatisticAttributeEstimateType](ValueSet-attribute-estimate-type.md)
* [Audit Event Outcome](ValueSet-audit-event-outcome.md)
* [Audit Event Source Type](ValueSet-audit-source-type.md)
* [Basic Resource Types](ValueSet-basic-resource-type.md)
* [Network Type Codes](ValueSet-benefit-network.md)
* [Benefit Term Codes](ValueSet-benefit-term.md)
* [Benefit Type Codes](ValueSet-benefit-type.md)
* [Unit Type Codes](ValueSet-benefit-unit.md)
* [Care Service Accessibility](ValueSet-care-service-accessibility.md)
* [CatalogType](ValueSet-catalogType.md)
* [StatisticCertaintyRating](ValueSet-certainty-rating.md)
* [StatisticCertaintySubcomponentRating](ValueSet-certainty-subcomponent-rating.md)
* [StatisticCertaintySubcomponentType](ValueSet-certainty-subcomponent-type.md)
* [Evidence Certainty Type](ValueSet-certainty-type.md)
* [CharacteristicMethod](ValueSet-characteristic-method.md)
* [ChargeItemCode](ValueSet-chargeitem-billingcodes.md)
* [ChoiceListOrientation](ValueSet-choice-list-orientation.md)
* [chromosome-human](ValueSet-chromosome-human.md)
* [Citation Artifact Classifier](ValueSet-citation-artifact-classifier.md)
* [Citation Classification Type](ValueSet-citation-classification-type.md)
* [Citation Summary Style](ValueSet-citation-summary-style.md)
* [Cited Artifact Abstract Type](ValueSet-cited-artifact-abstract-type.md)
* [Cited Artifact Classification Type](ValueSet-cited-artifact-classification-type.md)
* [Cited Artifact Contribution Type](ValueSet-cited-artifact-contribution-type.md)
* [Cited Artifact Part Type](ValueSet-cited-artifact-part-type.md)
* [Cited Artifact Status Type](ValueSet-cited-artifact-status-type.md)
* [Cited Medium](ValueSet-cited-medium.md)
* [Claim Care Team Role Codes](ValueSet-claim-careteamrole.md)
* [Exception Codes](ValueSet-claim-exception.md)
* [Claim Information Category Codes](ValueSet-claim-informationcategory.md)
* [Modifier type Codes](ValueSet-claim-modifiers.md)
* [Example Claim SubType Codes](ValueSet-claim-subtype.md)
* [Claim Type Codes](ValueSet-claim-type.md)
* [Clinical Discharge Disposition](ValueSet-clinical-discharge-disposition.md)
* [AlternativeCodeKind](ValueSet-codesystem-altcode-kind.md)
* [Common Tags](ValueSet-common-tags.md)
* [CommunicationCategory](ValueSet-communication-category.md)
* [CommunicationNotDoneReason](ValueSet-communication-not-done-reason.md)
* [CommunicationTopic](ValueSet-communication-topic.md)
* [CompositeMeasureScoring](ValueSet-composite-measure-scoring.md)
* [AlternativeCodeKind](ValueSet-composition-altcode-kind.md)
* [Condition Category Codes](ValueSet-condition-category.md)
* [Condition Clinical Status Codes](ValueSet-condition-clinical.md)
* [ConditionState](ValueSet-condition-state.md)
* [ConditionVerificationStatus](ValueSet-condition-ver-status.md)
* [ConformanceExpectation](ValueSet-conformance-expectation.md)
* [Consent Action Codes](ValueSet-consent-action.md)
* [Consent PolicyRule Codes](ValueSet-consent-policy.md)
* [Consent Scope Codes](ValueSet-consent-scope.md)
* [Consent Verification Codes](ValueSet-consent-verification.md)
* [Contact entity type](ValueSet-contactentity-type.md)
* [ContainerCap](ValueSet-container-cap.md)
* [Contract Action Codes](ValueSet-contract-action.md)
* [Contract Actor Role Codes](ValueSet-contract-actorrole.md)
* [Contract Content Derivation Codes](ValueSet-contract-content-derivative.md)
* [ContractDataMeaning](ValueSet-contract-data-meaning.md)
* [Contract Signer Type Codes](ValueSet-contract-signer-type.md)
* [Contract Subtype Codes](ValueSet-contract-subtype.md)
* [Contract Term Subtype Codes](ValueSet-contract-term-subtype.md)
* [Contract Term Type Codes](ValueSet-contract-term-type.md)
* [Contract Type Codes](ValueSet-contract-type.md)
* [Contributor Role](ValueSet-contributor-role.md)
* [Contributor Summary Source](ValueSet-contributor-summary-source.md)
* [Contributor Summary Style](ValueSet-contributor-summary-style.md)
* [Contributor Summary Type](ValueSet-contributor-summary-type.md)
* [CopyNumberEvent](ValueSet-copy-number-event.md)
* [Coverage Class Codes](ValueSet-coverage-class.md)
* [Coverage Copay Type Codes](ValueSet-coverage-copay-type.md)
* [Example Coverage Financial Exception Codes](ValueSet-coverage-financial-exception.md)
* [Coverage SelfPay Codes](ValueSet-coverage-selfpay.md)
* [CoverageEligibilityResponse Auth Support Codes](ValueSet-coverageeligibilityresponse-ex-auth-support.md)
* [AMA CPT All Codes](ValueSet-cpt-all.md)
* [AMA CPT Base Codes](ValueSet-cpt-base.md)
* [AMA CPT Modifier Codes](ValueSet-cpt-modifiers.md)
* [AMA CPT Usable Codes](ValueSet-cpt-usable.md)
* [CQL Access Modifier](ValueSet-cql-access-modifier.md)
* [DefinitionStatus](ValueSet-definition-status.md)
* [DefinitionTopic](ValueSet-definition-topic.md)
* [Structure Definition Use Codes / Keywords](ValueSet-definition-use.md)
* [FHIR Device Types](ValueSet-device-kind.md)
* [FHIRDeviceStatusReason](ValueSet-device-status-reason.md)
* [DeviceAlert Activation State Codes](ValueSet-devicealert-activationState.md)
* [DeviceAlert Condition Codes](ValueSet-devicealert-condition.md)
* [DeviceAlert Priority Codes](ValueSet-devicealert-priority.md)
* [DiagnosisRole](ValueSet-diagnosis-role.md)
* [Diagnosis Type Codes](ValueSet-diagnosistype.md)
* [EvidenceDirectness](ValueSet-directness.md)
* [DoseAndRateType](ValueSet-dose-rate-type.md)
* [Types of Edible Substances](ValueSet-edible-substance-type.md)
* [Admit source](ValueSet-encounter-admit-source.md)
* [Encounter class](ValueSet-encounter-class.md)
* [Diet](ValueSet-encounter-diet.md)
* [Discharge disposition](ValueSet-encounter-discharge-disposition.md)
* [Special arrangements](ValueSet-encounter-special-arrangements.md)
* [Encounter subject status](ValueSet-encounter-subject-status.md)
* [Encounter type](ValueSet-encounter-type.md)
* [Endpoint Connection Type](ValueSet-endpoint-connection-type.md)
* [Enteral Formula Additive Type Code](ValueSet-entformula-additive.md)
* [Episode of care type](ValueSet-episodeofcare-type.md)
* [QualityOfEvidenceRating](ValueSet-evidence-quality.md)
* [Benefit Category Codes](ValueSet-ex-benefitcategory.md)
* [Example Diagnosis on Admission Codes](ValueSet-ex-diagnosis-on-admission.md)
* [Example Diagnosis Related Group Codes](ValueSet-ex-diagnosisrelatedgroup.md)
* [Example Diagnosis Type Codes](ValueSet-ex-diagnosistype.md)
* [ClaimPayeeResourceType](ValueSet-ex-payee-resource-type.md)
* [Example Payment Type Codes](ValueSet-ex-paymenttype.md)
* [Example Procedure Type Codes](ValueSet-ex-procedure-type.md)
* [Example Program Reason Codes](ValueSet-ex-program-code.md)
* [Example Revenue Center Codes](ValueSet-ex-revenue-center.md)
* [ExpansionParameterSource](ValueSet-expansion-parameter-source.md)
* [ExpansionProcessingRule](ValueSet-expansion-processing-rule.md)
* [FHIR Clinical Document Information Recipients Participant Types](ValueSet-fhir-clinical-doc-information-recipient.md)
* [FHIR Clinical Document Participant Types Value set](ValueSet-fhir-clinical-doc-participant.md)
* [Financial Task Codes](ValueSet-financial-taskcode.md)
* [Financial Task Input Type Codes](ValueSet-financial-taskinputtype.md)
* [Flag Category](ValueSet-flag-category.md)
* [Forms](ValueSet-forms.md)
* [Funds Reservation Codes](ValueSet-fundsreserve.md)
* [Gender Identity](ValueSet-gender-identity.md)
* [GoalAcceptanceStatus](ValueSet-goal-acceptance-status.md)
* [Goal achievement status](ValueSet-goal-achievement.md)
* [Goal category](ValueSet-goal-category.md)
* [Goal priority](ValueSet-goal-priority.md)
* [GoalRelationshipType](ValueSet-goal-relationship-type.md)
* [Group Code](ValueSet-group-code.md)
* [GuideParameterCode](ValueSet-guide-parameter-code.md)
* [HandlingConditionSet](ValueSet-handling-condition.md)
* [FamilyHistoryAbsentReason](ValueSet-history-absent-reason.md)
* [HL7Workgroup](ValueSet-hl7-work-group.md)
* [Image Reference Type](ValueSet-image-reference-type.md)
* [Immunization Evaluation Dose Status Reason codes](ValueSet-immunization-evaluation-dose-status-reason.md)
* [Immunization Evaluation Dose Status codes](ValueSet-immunization-evaluation-dose-status.md)
* [Immunization Function](ValueSet-immunization-function.md)
* [Immunization Funding Source](ValueSet-immunization-funding-source.md)
* [Immunization Program Eligibility](ValueSet-immunization-program-eligibility.md)
* [Immunization Recommendation Status Codes](ValueSet-immunization-recommendation-status.md)
* [Immunization Subpotent Reason](ValueSet-immunization-subpotent-reason.md)
* [Implant Status](ValueSet-implantStatus.md)
* [Insurance Coverage Type](ValueSet-insurance-coverage-type.md)
* [Insurance Product Type](ValueSet-insurance-product-type.md)
* [Benefit cost applicability](ValueSet-insuranceplan-applicability.md)
* [Insuranceplan Plan Type](ValueSet-insuranceplan-plan-type.md)
* [Insurance plan type](ValueSet-insuranceplan-type.md)
* [Jurisdiction ValueSet](ValueSet-jurisdiction.md)
* [LibraryType](ValueSet-library-type.md)
* [List Empty Reasons](ValueSet-list-empty-reason.md)
* [Example Use Codes for List](ValueSet-list-example-codes.md)
* [List Order Codes](ValueSet-list-order.md)
* [Location type](ValueSet-location-physical-type.md)
* [MatchGrade](ValueSet-match-grade.md)
* [Measure Aggregate Method](ValueSet-measure-aggregate-method.md)
* [MeasureDataUsage](ValueSet-measure-data-usage.md)
* [MeasureImprovementNotation](ValueSet-measure-improvement-notation.md)
* [MeasurePopulationType](ValueSet-measure-population.md)
* [Measure Scoring](ValueSet-measure-scoring.md)
* [Measure Supplemental Data](ValueSet-measure-supplemental-data.md)
* [MeasureType](ValueSet-measure-type.md)
* [Medication administration  performer  function  codes](ValueSet-med-admin-perform-function.md)
* [Medical Management Type](ValueSet-medical-management-type.md)
* [MedicationAdministrationLocation](ValueSet-medication-admin-location.md)
* [MedicationUsageAdministrationLocation](ValueSet-medication-usage-admin-location.md)
* [Medication dispense  performer  function  codes](ValueSet-medicationdispense-performer-function.md)
* [Medication knowledge  characteristic  codes](ValueSet-medicationknowledge-characteristic.md)
* [Medication knowledge  package  type  codes](ValueSet-medicationknowledge-package-type.md)
* [Medication knowledge  status  codes](ValueSet-medicationknowledge-status.md)
* [MedicationRequestAdministrationLocation](ValueSet-medicationrequest-admin-location.md)
* [Medication request  category  codes](ValueSet-medicationrequest-category.md)
* [Medication request  course of  therapy  codes](ValueSet-medicationrequest-course-of-therapy.md)
* [Medication request  status  reason  codes](ValueSet-medicationrequest-status-reason.md)
* [Example Message Reason Codes](ValueSet-message-reason-encounter.md)
* [MIF Concept Relationship Kind](ValueSet-mif-conceptRelationshipKind.md)
* [MIF Concept Relationship Reflexivity](ValueSet-mif-conceptRelationshipReflexivity.md)
* [MIF Concept Relationship Symmetry](ValueSet-mif-conceptRelationshipSymmetry.md)
* [MIF Concept Relationship Transitivity](ValueSet-mif-conceptRelationshipTransitivity.md)
* [Missing Tooth Reason Codes](ValueSet-missing-tooth-reason.md)
* [NDH Healthcare Service Category](ValueSet-ndh-healthcare-service-category.md)
* [Nutrition intake  category  codes](ValueSet-nutrition-intake-category.md)
* [AuditEventEntityRole](ValueSet-object-role.md)
* [Observation Category Codes](ValueSet-observation-category.md)
* [StatisticsCode](ValueSet-observation-statistics.md)
* [Organization Affiliation Role](ValueSet-organization-affiliation-role.md)
* [Organization Alias Type](ValueSet-organization-alias-type.md)
* [Organization type](ValueSet-organization-type.md)
* [DeviceDefinitionParameterGroup](ValueSet-parameter-group.md)
* [Payee Type Codes](ValueSet-payeetype.md)
* [Payment Adjustment Reason Codes](ValueSet-payment-adjustment-reason.md)
* [Payment Status Codes](ValueSet-payment-status.md)
* [Payment Type Codes](ValueSet-payment-type.md)
* [PlanDefinitionType](ValueSet-plan-definition-type.md)
* [Procedure Type Codes](ValueSet-procedure-type.md)
* [Process Priority Codes](ValueSet-process-priority.md)
* [rofessional Credential Status](ValueSet-professional-credential-status.md)
* [Program](ValueSet-program.md)
* [Personal Pronouns](ValueSet-pronouns.md)
* [Provenance participant type](ValueSet-provenance-agent-type.md)
* [Example Provider Qualification Codes](ValueSet-provider-qualification.md)
* [Published In Type](ValueSet-published-in-type.md)
* [MaxOccurs](ValueSet-question-max-occurs.md)
* [QuestionnaireItemUsageMode](ValueSet-questionnaire-usage-mode.md)
* [AllergyIntoleranceCertainty](ValueSet-reaction-event-certainty.md)
* [Reason Medication Given Codes](ValueSet-reason-medication-given-codes.md)
* [StrengthOfRecommendationRating](ValueSet-recommendation-strength.md)
* [Recorded Sex Or Gender Type](ValueSet-recorded-sex-or-gender-type.md)
* [Observation Reference Range Meaning Codes](ValueSet-referencerange-meaning.md)
* [RejectionCriterion](ValueSet-rejection-criteria.md)
* [Example Related Claim Relationship Codes](ValueSet-related-claim-relationship.md)
* [ResearchStudyObjectiveType](ValueSet-research-study-objective-type.md)
* [Research Study Party Role](ValueSet-research-study-party-role.md)
* [ResearchStudyPhase](ValueSet-research-study-phase.md)
* [ResearchStudyPrimaryPurposeType](ValueSet-research-study-prim-purp-type.md)
* [ResearchStudyReasonStopped](ValueSet-research-study-reason-stopped.md)
* [Research Study Status](ValueSet-research-study-status.md)
* [ResearchSubjectMilestone](ValueSet-research-subject-milestone.md)
* [Research Subject Milestones](ValueSet-research-subject-milestones.md)
* [ResearchSubjectStateType](ValueSet-research-subject-state-type.md)
* [ResearchSubjectState](ValueSet-research-subject-state.md)
* [ResourceSecurityCategory](ValueSet-resource-security-category.md)
* [PayeeResourceType](ValueSet-resource-type-link.md)
* [Risk Probability](ValueSet-risk-probability.md)
* [Service category](ValueSet-service-category.md)
* [Service Delivery Method](ValueSet-service-delivery-method.md)
* [Example Service Place Codes](ValueSet-service-place.md)
* [ServiceProvisionConditions](ValueSet-service-provision-conditions.md)
* [ReferralMethod](ValueSet-service-referral-method.md)
* [Service type](ValueSet-service-type.md)
* [USCLS Codes](ValueSet-service-uscls.md)
* [Sex Parameter for Clinical Use](ValueSet-sex-parameter-for-clinical-use.md)
* [SmartCapabilities](ValueSet-smart-capabilities.md)
* [SNOMED International Global Patient Set (GPS)](ValueSet-snomed-intl-gps.md)
* [Software System Type](ValueSet-software-system-type.md)
* [SpecialValues](ValueSet-special-values.md)
* [StandardsStatus](ValueSet-standards-status.md)
* [StateChangeReason](ValueSet-state-change-reason.md)
* [Statistic Model Code](ValueSet-statistic-model-code.md)
* [StatisticStatisticType](ValueSet-statistic-type.md)
* [Study Design](ValueSet-study-design.md)
* [StatisticStudyType](ValueSet-study-type.md)
* [SubscriberPolicyholder Relationship Codes](ValueSet-subscriber-relationship.md)
* [SubscriptionChannel Type Codes](ValueSet-subscription-channel-type.md)
* [Subscription Error Codes](ValueSet-subscription-error.md)
* [SubscriptionStatusAtEvent](ValueSet-subscription-status-at-event.md)
* [SubscriptionTag](ValueSet-subscription-tag.md)
* [Substance Category Codes](ValueSet-substance-category.md)
* [Supply Item Type](ValueSet-supplydelivery-type.md)
* [Supply Type](ValueSet-supplyrequest-kind.md)
* [SupplyRequestReason](ValueSet-supplyrequest-reason.md)
* [Surface Codes](ValueSet-surface.md)
* [StatisticSynthesisType](ValueSet-synthesis-type.md)
* [Test script operation code](ValueSet-testscript-operation-codes.md)
* [Test script profile destination type](ValueSet-testscript-profile-destination-types.md)
* [Test script profile origin type](ValueSet-testscript-profile-origin-types.md)
* [Time Period Ranges](ValueSet-time-period-ranges.md)
* [Title Type](ValueSet-title-type.md)
* [Oral Site Codes](ValueSet-tooth.md)
* [Common UCUM units](ValueSet-ucum-common.md)
* [UCUM Codes](ValueSet-ucum-units.md)
* [UsageContextType](ValueSet-usage-context-type.md)
* [hl7VS-administrativeSex](ValueSet-v2-0001.md)
* [hl7VS-maritalStatus](ValueSet-v2-0002.md)
* [hl7VS-eventCode](ValueSet-v2-0003.md)
* [hl7VS-patientClass](ValueSet-v2-0004.md)
* [PHVS_Race_HL7_2x](ValueSet-v2-0005.md)
* [hl7VS-religion2](ValueSet-v2-0006.md)
* [hl7VS-admissionType](ValueSet-v2-0007.md)
* [hl7VS-acknowledgmentCode](ValueSet-v2-0008.md)
* [hl7VS-ambulatoryStatus](ValueSet-v2-0009.md)
* [hl7VS-stockLocation](ValueSet-v2-0012.md)
* [hl7VS-transactionType](ValueSet-v2-0017.md)
* [hl7VS-priority](ValueSet-v2-0027.md)
* [hl7VS-route](ValueSet-v2-0033.md)
* [hl7VS-siteAdministered](ValueSet-v2-0034.md)
* [hl7VS-orderStatus](ValueSet-v2-0038.md)
* [hl7VS-whatSubjectFilter](ValueSet-v2-0048.md)
* [hl7VS-diagnosisType](ValueSet-v2-0052.md)
* [hl7VS-checkDigitScheme](ValueSet-v2-0061.md)
* [hl7VS-eventReason](ValueSet-v2-0062.md)
* [hl7VS-relationship](ValueSet-v2-0063.md)
* [hl7VS-actionCode](ValueSet-v2-0065.md)
* [hl7VS-employmentStatus](ValueSet-v2-0066.md)
* [hl7VS-hospitalService](ValueSet-v2-0069.md)
* [hl7VS-sourceOfSpecimen](ValueSet-v2-0070.md)
* [hl7VS-diagnosticServiceSectionId](ValueSet-v2-0074.md)
* [hl7VS-messageType](ValueSet-v2-0076.md)
* [hl7VS-natureOfAbnormalTesting](ValueSet-v2-0080.md)
* [hl7VS-outlierType](ValueSet-v2-0083.md)
* [hl7VS-observationResultStatus](ValueSet-v2-0085.md)
* [hl7VS-queryPriority](ValueSet-v2-0091.md)
* [hl7VS-re-admissionIndicator](ValueSet-v2-0092.md)
* [hl7VS-typeOfAgreement](ValueSet-v2-0098.md)
* [hl7VS-whenToCharge](ValueSet-v2-0100.md)
* [hl7VS-delayedAcknowledgmentType](ValueSet-v2-0102.md)
* [hl7VS-processingId](ValueSet-v2-0103.md)
* [hl7VS-versionControlTable](ValueSet-v2-0104.md)
* [hl7VS-sourceOfComment](ValueSet-v2-0105.md)
* [hl7VS-queryFormatCode](ValueSet-v2-0106.md)
* [hl7VS-deferredResponseType](ValueSet-v2-0107.md)
* [hl7VS-queryResultsLevel](ValueSet-v2-0108.md)
* [hl7VS-reportPriority](ValueSet-v2-0109.md)
* [hl7VS-bedStatus](ValueSet-v2-0116.md)
* [hl7VS-orderControl](ValueSet-v2-0119.md)
* [hl7VS-responseFlag](ValueSet-v2-0121.md)
* [hl7VS-chargeType](ValueSet-v2-0122.md)
* [hl7VS-resultStatus-Obr](ValueSet-v2-0123.md)
* [hl7VS-transportationMode](ValueSet-v2-0124.md)
* [hl7VS-valueType](ValueSet-v2-0125.md)
* [hl7VS-quantityLimitedRequest](ValueSet-v2-0126.md)
* [hl7VS-allergyType](ValueSet-v2-0127.md)
* [hl7VS-allergySeverity](ValueSet-v2-0128.md)
* [hl7VS-visitUserCode](ValueSet-v2-0130.md)
* [hl7VS-contactRole2](ValueSet-v2-0131.md)
* [hl7VS-procedurePractitionerType](ValueSet-v2-0133.md)
* [hl7VS-assignmentOfBenefits](ValueSet-v2-0135.md)
* [hl7VS-yes-no-Indicator](ValueSet-v2-0136.md)
* [hl7VS-mailClaimParty](ValueSet-v2-0137.md)
* [hl7VS-militaryService](ValueSet-v2-0140.md)
* [hl7VS-militaryStatus](ValueSet-v2-0142.md)
* [hl7VS-eligibilitySource](ValueSet-v2-0144.md)
* [hl7VS-roomType](ValueSet-v2-0145.md)
* [hl7VS-amountType](ValueSet-v2-0146.md)
* [hl7VS-policyType](ValueSet-v2-0147.md)
* [hl7VS-penaltyType](ValueSet-v2-0148.md)
* [hl7VS-dayType](ValueSet-v2-0149.md)
* [hl7VS-precertificationPatientType](ValueSet-v2-0150.md)
* [hl7VS-accept-applicationAcknowledgmentConditions](ValueSet-v2-0155.md)
* [hl7VS-whichDate-timeQualifier](ValueSet-v2-0156.md)
* [hl7VS-whichDate-timeStatusQualifier](ValueSet-v2-0157.md)
* [hl7VS-date-timeSelectionQualifier](ValueSet-v2-0158.md)
* [hl7VS-dietType](ValueSet-v2-0159.md)
* [hl7VS-trayType](ValueSet-v2-0160.md)
* [hl7VS-allowSubstitution](ValueSet-v2-0161.md)
* [hl7VS-routeOfAdministration](ValueSet-v2-0162.md)
* [hl7VS-administriveSite](ValueSet-v2-0163.md)
* [hl7VS-administrationDevice](ValueSet-v2-0164.md)
* [hl7VS-administrationMethod](ValueSet-v2-0165.md)
* [hl7VS-rxComponentType](ValueSet-v2-0166.md)
* [hl7VS-substitutionStatus](ValueSet-v2-0167.md)
* [hl7VS-processingPriority](ValueSet-v2-0168.md)
* [hl7VS-reportingPriority](ValueSet-v2-0169.md)
* [hl7VS-derivedSpecimen](ValueSet-v2-0170.md)
* [hl7VS-coordinationOfBenefits](ValueSet-v2-0173.md)
* [hl7VS-natureOfServiceTestObservation](ValueSet-v2-0174.md)
* [hl7VS-masterFileIdentifierCode](ValueSet-v2-0175.md)
* [hl7VS-confidentialityCode](ValueSet-v2-0177.md)
* [hl7VS-file-levelEventCode](ValueSet-v2-0178.md)
* [hl7VS-responseLevel](ValueSet-v2-0179.md)
* [hl7VS-masterfileActionCode](ValueSet-v2-0180.md)
* [hl7VS-mfnRecode-levelErrorReturn](ValueSet-v2-0181.md)
* [hl7VS-active-inactive](ValueSet-v2-0183.md)
* [hl7VS-preferredMethodOfContrct](ValueSet-v2-0185.md)
* [hl7VS-providerBilling](ValueSet-v2-0187.md)
* [hl7VS-ethnicGroup](ValueSet-v2-0189.md)
* [hl7VS-addressType](ValueSet-v2-0190.md)
* [hl7VS-typeOfData](ValueSet-v2-0191.md)
* [hl7VS-amountClass](ValueSet-v2-0193.md)
* [hl7VS-nameType](ValueSet-v2-0200.md)
* [hl7VS-telecommunicationUseCode](ValueSet-v2-0201.md)
* [hl7VS-telecommunicationEquipmentType](ValueSet-v2-0202.md)
* [hl7VS-identifierType](ValueSet-v2-0203.md)
* [hl7VS-organizationalNameType](ValueSet-v2-0204.md)
* [hl7VS-priceType](ValueSet-v2-0205.md)
* [hl7VS-segmentActionCode](ValueSet-v2-0206.md)
* [hl7VS-processingMode](ValueSet-v2-0207.md)
* [hl7VS-queryResponseStatus](ValueSet-v2-0208.md)
* [hl7VS-relationalOperator](ValueSet-v2-0209.md)
* [hl7VS-relationalConjunction](ValueSet-v2-0210.md)
* [hl7VS-alternateCharacterSets](ValueSet-v2-0211.md)
* [hl7VS-purgeStatus](ValueSet-v2-0213.md)
* [hl7VS-specialProgramCode](ValueSet-v2-0214.md)
* [hl7VS-publicityCode](ValueSet-v2-0215.md)
* [hl7VS-patientStatusCode](ValueSet-v2-0216.md)
* [hl7VS-visitPriorityCode](ValueSet-v2-0217.md)
* [hl7VS-livingArrangement](ValueSet-v2-0220.md)
* [hl7VS-livingDependency](ValueSet-v2-0223.md)
* [hl7VS-transportArranged](ValueSet-v2-0224.md)
* [hl7VS-escortRequired](ValueSet-v2-0225.md)
* [PHVS_ManufacturersOfVaccinesMVX_CDC_NIP](ValueSet-v2-0227.md)
* [hl7VS-diagnosisClassification](ValueSet-v2-0228.md)
* [hl7VS-procedureFunctionalType](ValueSet-v2-0230.md)
* [hl7VS-studentStatus](ValueSet-v2-0231.md)
* [hl7VS-insuranceCompanyContactReason](ValueSet-v2-0232.md)
* [hl7VS-reportTiming](ValueSet-v2-0234.md)
* [hl7VS-reportSource](ValueSet-v2-0235.md)
* [hl7VS-eventReportedTo](ValueSet-v2-0236.md)
* [hl7VS-eventQualification](ValueSet-v2-0237.md)
* [hl7VS-eventSeriousness](ValueSet-v2-0238.md)
* [hl7VS-eventExpected](ValueSet-v2-0239.md)
* [hl7VS-eventConsequence](ValueSet-v2-0240.md)
* [hl7VS-patientOutcome](ValueSet-v2-0241.md)
* [hl7VS-primaryObserver'sQualification](ValueSet-v2-0242.md)
* [hl7VS-identityMayBeDivulged](ValueSet-v2-0243.md)
* [hl7VS-startOfEvaluation](ValueSet-v2-0247.md)
* [hl7VS-productSource](ValueSet-v2-0248.md)
* [hl7VS-relatednessAssessment](ValueSet-v2-0250.md)
* [hl7VS-actionTakenInResponseToTheEvent](ValueSet-v2-0251.md)
* [hl7VS-causalityObservations](ValueSet-v2-0252.md)
* [hl7VS-indirectExposureMechanism](ValueSet-v2-0253.md)
* [hl7VS-kindOfQuantity](ValueSet-v2-0254.md)
* [hl7VS-durationCategories](ValueSet-v2-0255.md)
* [hl7VS-timeDelayPostChallenge](ValueSet-v2-0256.md)
* [hl7VS-natureOfChallenge](ValueSet-v2-0257.md)
* [hl7VS-relationshipModifier](ValueSet-v2-0258.md)
* [hl7VS-patientLocationType](ValueSet-v2-0260.md)
* [hl7VS-locationEquipment](ValueSet-v2-0261.md)
* [hl7VS-privacyLevel](ValueSet-v2-0262.md)
* [hl7VS-levelOfCare](ValueSet-v2-0263.md)
* [hl7VS-specialtyType](ValueSet-v2-0265.md)
* [hl7VS-daysOfTheWeek](ValueSet-v2-0267.md)
* [hl7VS-override](ValueSet-v2-0268.md)
* [hl7VS-chargeOnIndicator](ValueSet-v2-0269.md)
* [hl7VS-reportTypeCode](ValueSet-v2-0270.md)
* [hl7VS-documentCompletionStatus](ValueSet-v2-0271.md)
* [hl7VS-documentConfidentialityStatus](ValueSet-v2-0272.md)
* [hl7VS-documentAvailabilityStatus](ValueSet-v2-0273.md)
* [hl7VS-documentStorageStatus](ValueSet-v2-0275.md)
* [hl7VS-appointmentReasonCodes](ValueSet-v2-0276.md)
* [hl7VS-appointmentTypeCodes](ValueSet-v2-0277.md)
* [hl7VS-fillerStatusCodes](ValueSet-v2-0278.md)
* [hl7VS-allowSubstitutionCodes](ValueSet-v2-0279.md)
* [hl7VS-referralPriority](ValueSet-v2-0280.md)
* [hl7VS-referralType](ValueSet-v2-0281.md)
* [hl7VS-referralDisposition](ValueSet-v2-0282.md)
* [hl7VS-referralStatus](ValueSet-v2-0283.md)
* [hl7VS-referralCategory](ValueSet-v2-0284.md)
* [hl7VS-providerRole](ValueSet-v2-0286.md)
* [hl7VS-actionCode](ValueSet-v2-0287.md)
* [hl7VS-mimeBase64EncodingCharacters](ValueSet-v2-0290.md)
* [PHVS_VaccinesAdministeredCVX_CDC_NIP](ValueSet-v2-0292.md)
* [hl7VS-timeSelectionCriteriaParameterClassCodes](ValueSet-v2-0294.md)
* [hl7VS-rangeType](ValueSet-v2-0298.md)
* [hl7VS-encoding](ValueSet-v2-0299.md)
* [hl7VS-universalIdType](ValueSet-v2-0301.md)
* [hl7VS-personLocationType](ValueSet-v2-0305.md)
* [hl7VS-coverageType](ValueSet-v2-0309.md)
* [hl7VS-jobStatus](ValueSet-v2-0311.md)
* [hl7VS-livingWill](ValueSet-v2-0315.md)
* [hl7VS-organDonor](ValueSet-v2-0316.md)
* [hl7VS-annotations](ValueSet-v2-0317.md)
* [hl7VS-dispenseMethod](ValueSet-v2-0321.md)
* [hl7VS-completionStatus](ValueSet-v2-0322.md)
* [hl7VS-actionCode](ValueSet-v2-0323.md)
* [hl7VS-locationCharacteristicId](ValueSet-v2-0324.md)
* [hl7VS-locationRelationshipId](ValueSet-v2-0325.md)
* [hl7VS-visitIndicator](ValueSet-v2-0326.md)
* [hl7VS-quantityMethod](ValueSet-v2-0329.md)
* [hl7VS-marketingBasis](ValueSet-v2-0330.md)
* [hl7VS-facilityType](ValueSet-v2-0331.md)
* [hl7VS-networkSourceType](ValueSet-v2-0332.md)
* [hl7VS-disabledPerson](ValueSet-v2-0334.md)
* [hl7VS-repeatPattern](ValueSet-v2-0335.md)
* [hl7VS-referralReason](ValueSet-v2-0336.md)
* [hl7VS-certificationStatus](ValueSet-v2-0337.md)
* [hl7VS-practitionerIdNumberType](ValueSet-v2-0338.md)
* [hl7VS-advancedBeneficiaryNoticeCode](ValueSet-v2-0339.md)
* [hl7VS-patient’sRelationshipToInsured](ValueSet-v2-0344.md)
* [hl7VS-occurrenceCode](ValueSet-v2-0350.md)
* [hl7VS-occurrenceSpan](ValueSet-v2-0351.md)
* [hl7VS-cweStatuses](ValueSet-v2-0353.md)
* [hl7VS-messageStructure](ValueSet-v2-0354.md)
* [hl7VS-primaryKeyValueType](ValueSet-v2-0355.md)
* [hl7VS-alternateCharacterSetHandlingScheme](ValueSet-v2-0356.md)
* [hl7VS-messageErrorConditionCodes](ValueSet-v2-0357.md)
* [hl7VS-diagnosisPriority](ValueSet-v2-0359.md)
* [hl7VS-degreeLicenseCertificate](ValueSet-v2-0360.md)
* [hl7VS-commentType](ValueSet-v2-0364.md)
* [hl7VS-equipmentState](ValueSet-v2-0365.md)
* [hl7VS-local-remoteControlState](ValueSet-v2-0366.md)
* [hl7VS-alertLevel](ValueSet-v2-0367.md)
* [hl7VS-remoteControlCommand](ValueSet-v2-0368.md)
* [hl7VS-specimenRole](ValueSet-v2-0369.md)
* [hl7VS-containerStatus](ValueSet-v2-0370.md)
* [hl7VS-additivePreservative](ValueSet-v2-0371.md)
* [hl7VS-specimenComponent](ValueSet-v2-0372.md)
* [hl7VS-treatment](ValueSet-v2-0373.md)
* [hl7VS-systemInducedContaminants](ValueSet-v2-0374.md)
* [hl7VS-artificialBlood](ValueSet-v2-0375.md)
* [hl7VS-specialHandlingConsiderations](ValueSet-v2-0376.md)
* [hl7VS-otherEnvironmentalFactors](ValueSet-v2-0377.md)
* [hl7VS-substanceStatus](ValueSet-v2-0383.md)
* [hl7VS-substanceType](ValueSet-v2-0384.md)
* [hl7VS-commandResponse](ValueSet-v2-0387.md)
* [hl7VS-processingType](ValueSet-v2-0388.md)
* [hl7VS-analyteRepeatStatus](ValueSet-v2-0389.md)
* [hl7VS-segmentGroup](ValueSet-v2-0391.md)
* [hl7VS-matchReason](ValueSet-v2-0392.md)
* [hl7VS-matchAlgorithms](ValueSet-v2-0393.md)
* [hl7VS-responseModality](ValueSet-v2-0394.md)
* [hl7VS-modifyIndicator](ValueSet-v2-0395.md)
* [hl7VS-codingSystem](ValueSet-v2-0396.md)
* [hl7VS-sequencing](ValueSet-v2-0397.md)
* [hl7VS-continuationStyleCode](ValueSet-v2-0398.md)
* [hl7VS-governmentReimbursementProgram](ValueSet-v2-0401.md)
* [hl7VS-schoolType](ValueSet-v2-0402.md)
* [hl7VS-languageAbility](ValueSet-v2-0403.md)
* [hl7VS-languageProficiency](ValueSet-v2-0404.md)
* [hl7VS-organizationUnitType](ValueSet-v2-0406.md)
* [hl7VS-applicationChangeType](ValueSet-v2-0409.md)
* [hl7VS-drgTransferType](ValueSet-v2-0415.md)
* [hl7VS-procedureDrgType](ValueSet-v2-0416.md)
* [hl7VS-tissueTypeCode](ValueSet-v2-0417.md)
* [hl7VS-procedurePriority](ValueSet-v2-0418.md)
* [hl7VS-severityOfIllnessCode](ValueSet-v2-0421.md)
* [hl7VS-triageCode](ValueSet-v2-0422.md)
* [hl7VS-caseCategoryCode](ValueSet-v2-0423.md)
* [hl7VS-gestationCategoryCode](ValueSet-v2-0424.md)
* [hl7VS-newbornCode](ValueSet-v2-0425.md)
* [hl7VS-bloodProductCode](ValueSet-v2-0426.md)
* [hl7VS-riskManagementIncidentCode](ValueSet-v2-0427.md)
* [hl7VS-incidentTypeCode](ValueSet-v2-0428.md)
* [hl7VS-productionClassCode](ValueSet-v2-0429.md)
* [hl7VS-modeOfArrivalCode](ValueSet-v2-0430.md)
* [hl7VS-recreationalDrugUseCode](ValueSet-v2-0431.md)
* [hl7VS-admissionLevelOfCareCode](ValueSet-v2-0432.md)
* [hl7VS-precautionCode](ValueSet-v2-0433.md)
* [hl7VS-patientConditionCode](ValueSet-v2-0434.md)
* [hl7VS-advanceDirectiveCode](ValueSet-v2-0435.md)
* [hl7VS-sensitivityToCausativeAgentCode](ValueSet-v2-0436.md)
* [hl7VS-alertDeviceCode](ValueSet-v2-0437.md)
* [hl7VS-allergyClinicalStatus](ValueSet-v2-0438.md)
* [hl7VS-dataTypes](ValueSet-v2-0440.md)
* [hl7VS-immunizationRegistryStatus](ValueSet-v2-0441.md)
* [hl7VS-locationServiceCode](ValueSet-v2-0442.md)
* [hl7VS-providerRole](ValueSet-v2-0443.md)
* [hl7VS-nameAssemblyOrder](ValueSet-v2-0444.md)
* [hl7VS-identityReliabilityCode](ValueSet-v2-0445.md)
* [hl7VS-eventType](ValueSet-v2-0450.md)
* [hl7VS-revenueCode](ValueSet-v2-0456.md)
* [hl7VS-overallClaimDispositionCode](ValueSet-v2-0457.md)
* [hl7VS-name-addressRepresentation](ValueSet-v2-0465.md)
* [hl7VS-ambulatoryPaymentClassificationCode](ValueSet-v2-0466.md)
* [hl7VS-paymentAdjustmentCode](ValueSet-v2-0468.md)
* [hl7VS-packagingStatusCode](ValueSet-v2-0469.md)
* [hl7VS-reimbursementTypeCode](ValueSet-v2-0470.md)
* [hl7VS-tqConjunctionId](ValueSet-v2-0472.md)
* [hl7VS-formularyStatus](ValueSet-v2-0473.md)
* [hl7VS-organizationUnitType-Org](ValueSet-v2-0474.md)
* [hl7VS-chargeTypeReason](ValueSet-v2-0475.md)
* [hl7VS-controlledSubstanceSchedule](ValueSet-v2-0477.md)
* [hl7VS-formularyStatus](ValueSet-v2-0478.md)
* [hl7VS-pharmacyOrderTypes](ValueSet-v2-0480.md)
* [hl7VS-orderType](ValueSet-v2-0482.md)
* [hl7VS-authorizationMode](ValueSet-v2-0483.md)
* [hl7VS-dispenseType](ValueSet-v2-0484.md)
* [hl7VS-extendedPriorityCodes](ValueSet-v2-0485.md)
* [hl7VS-specimenType](ValueSet-v2-0487.md)
* [hl7VS-specimenCollectionMethod](ValueSet-v2-0488.md)
* [hl7VS-riskCodes](ValueSet-v2-0489.md)
* [hl7VS-specimenRejectReason](ValueSet-v2-0490.md)
* [hl7VS-specimenQuality](ValueSet-v2-0491.md)
* [hl7VS-specimenAppropriateness](ValueSet-v2-0492.md)
* [hl7VS-specimenCondition](ValueSet-v2-0493.md)
* [hl7VS-specimenChildRole](ValueSet-v2-0494.md)
* [hl7VS-bodySiteModifier](ValueSet-v2-0495.md)
* [hl7VS-consentType](ValueSet-v2-0496.md)
* [hl7VS-consentMode](ValueSet-v2-0497.md)
* [hl7VS-consentStatus](ValueSet-v2-0498.md)
* [hl7VS-consentBypassReason](ValueSet-v2-0499.md)
* [hl7VS-consentDisclosureLevel](ValueSet-v2-0500.md)
* [hl7VS-consentNon-disclosureReason](ValueSet-v2-0501.md)
* [hl7VS-non-subjectConsenterReason](ValueSet-v2-0502.md)
* [hl7VS-sequenceResultsFlag](ValueSet-v2-0503.md)
* [hl7VS-sequenceConditionCode](ValueSet-v2-0504.md)
* [hl7VS-cyclicEntryExitIndicator](ValueSet-v2-0505.md)
* [hl7VS-serviceRequestRelationship](ValueSet-v2-0506.md)
* [hl7VS-observationResultHandling](ValueSet-v2-0507.md)
* [hl7VS-bloodProductProcessingRequirements](ValueSet-v2-0508.md)
* [hl7VS-bloodProductDispenseStatus](ValueSet-v2-0510.md)
* [hl7VS-bpObservationStatusCodesInterpretation](ValueSet-v2-0511.md)
* [hl7VS-bloodProductTransfusion-dispositionStatus](ValueSet-v2-0513.md)
* [hl7VS-transfusionAdverseReaction](ValueSet-v2-0514.md)
* [hl7VS-errorSeverity](ValueSet-v2-0516.md)
* [hl7VS-informPersonCode](ValueSet-v2-0517.md)
* [hl7VS-overrideType](ValueSet-v2-0518.md)
* [hl7VS-messageWaitingPriority](ValueSet-v2-0520.md)
* [hl7VS-computationType](ValueSet-v2-0523.md)
* [hl7VS-sequenceCondition](ValueSet-v2-0524.md)
* [hl7VS-calendarAlignment](ValueSet-v2-0527.md)
* [hl7VS-eventRelatedPeriod](ValueSet-v2-0528.md)
* [hl7VS-precision](ValueSet-v2-0529.md)
* [hl7VS-organization-Agency-Department](ValueSet-v2-0530.md)
* [hl7VS-expandedYes-NoIndicator](ValueSet-v2-0532.md)
* [hl7VS-notifyClergyCode](ValueSet-v2-0534.md)
* [hl7VS-signatureCode](ValueSet-v2-0535.md)
* [hl7VS-certificateStatus](ValueSet-v2-0536.md)
* [hl7VS-institutionRelationshipType](ValueSet-v2-0538.md)
* [hl7VS-inactiveReasonCode](ValueSet-v2-0540.md)
* [hl7VS-containerCondition](ValueSet-v2-0544.md)
* [hl7VS-jurisdictionalBreadth](ValueSet-v2-0547.md)
* [hl7VS-signatory'sRelationshipToSubject](ValueSet-v2-0548.md)
* [hl7VS-bodyParts](ValueSet-v2-0550.md)
* [hl7VS-invoiceControlCode](ValueSet-v2-0553.md)
* [hl7VS-invoiceReasonCodes](ValueSet-v2-0554.md)
* [hl7VS-invoiceType](ValueSet-v2-0555.md)
* [hl7VS-benefitGroup](ValueSet-v2-0556.md)
* [hl7VS-payeeType](ValueSet-v2-0557.md)
* [hl7VS-payeeRelationshipToInvoice](ValueSet-v2-0558.md)
* [hl7VS-product-serviceStatus](ValueSet-v2-0559.md)
* [hl7VS-quantityUnits](ValueSet-v2-0560.md)
* [hl7VS-product-servicesClarification](ValueSet-v2-0561.md)
* [hl7VS-processingConsiderationCodes](ValueSet-v2-0562.md)
* [hl7VS-adjustmentCategoryCode](ValueSet-v2-0564.md)
* [hl7VS-providerAdjustmentReasonCode](ValueSet-v2-0565.md)
* [hl7VS-bloodUnitType](ValueSet-v2-0566.md)
* [hl7VS-weightUnits](ValueSet-v2-0567.md)
* [hl7VS-volumeUnits](ValueSet-v2-0568.md)
* [hl7VS-adjustmentAction](ValueSet-v2-0569.md)
* [hl7VS-paymentMethodCode](ValueSet-v2-0570.md)
* [hl7VS-invoiceProcessingResultsStatus](ValueSet-v2-0571.md)
* [hl7VS-taxStatus](ValueSet-v2-0572.md)
* [hl7VS-userAuthenticationCredentialTypeCode](ValueSet-v2-0615.md)
* [hl7VS-addressExpirationReason](ValueSet-v2-0616.md)
* [hl7VS-addressUsage](ValueSet-v2-0617.md)
* [hl7VS-protectionCode](ValueSet-v2-0618.md)
* [hl7VS-itemStatusCodes](ValueSet-v2-0625.md)
* [hl7VS-itemImportanceCodes](ValueSet-v2-0634.md)
* [hl7VS-reorderTheoryCodes](ValueSet-v2-0642.md)
* [hl7VS-laborCalculationType](ValueSet-v2-0651.md)
* [hl7VS-dateFormat](ValueSet-v2-0653.md)
* [hl7VS-deviceType](ValueSet-v2-0657.md)
* [hl7VS-lotControl](ValueSet-v2-0659.md)
* [hl7VS-deviceDataState](ValueSet-v2-0667.md)
* [hl7VS-loadStatus](ValueSet-v2-0669.md)
* [hl7VS-deviceStatus](ValueSet-v2-0682.md)
* [hl7VS-cycleType](ValueSet-v2-0702.md)
* [hl7VS-accessRestrictionValue](ValueSet-v2-0717.md)
* [InformationSensitivityPolicy](ValueSet-v2-0719.md)
* [hl7VS-moodCodes](ValueSet-v2-0725.md)
* [hl7VS-cclValue](ValueSet-v2-0728.md)
* [hl7VS-drgDiagnosisDeterminationStatus](ValueSet-v2-0731.md)
* [hl7VS-grouperStatus](ValueSet-v2-0734.md)
* [hl7VS-statusPatient](ValueSet-v2-0739.md)
* [hl7VS-drgStatusFinancialCalculation](ValueSet-v2-0742.md)
* [hl7VS-drgGroupingStatus](ValueSet-v2-0749.md)
* [hl7VS-statusWeightAtBirth](ValueSet-v2-0755.md)
* [hl7VS-statusRespirationMinutes](ValueSet-v2-0757.md)
* [hl7VS-statusAdmission](ValueSet-v2-0759.md)
* [hl7VS-drgProcedureDeterminationStatus](ValueSet-v2-0761.md)
* [hl7VS-drgProcedureRelevance](ValueSet-v2-0763.md)
* [hl7VS-itemStatus](ValueSet-v2-0776.md)
* [hl7VS-itemType](ValueSet-v2-0778.md)
* [hl7VS-approvingRegulatoryAgency](ValueSet-v2-0790.md)
* [hl7VS-rulingAct](ValueSet-v2-0793.md)
* [hl7VS-sterilizationType](ValueSet-v2-0806.md)
* [hl7VS-package](ValueSet-v2-0818.md)
* [hl7VS-telecommunicationExpirationReason](ValueSet-v2-0868.md)
* [hl7VS-supplyRiskCodes](ValueSet-v2-0871.md)
* [hl7VS-roleExecutingPhysician](ValueSet-v2-0881.md)
* [hl7VS-medicalRoleExecutingPhysician](ValueSet-v2-0882.md)
* [hl7VS-sideOfBody](ValueSet-v2-0894.md)
* [hl7VS-presentOnAdmission(poa)Indicator](ValueSet-v2-0895.md)
* [hl7VS-securityCheckScheme](ValueSet-v2-0904.md)
* [hl7VS-shipmentStatus](ValueSet-v2-0905.md)
* [hl7VS-actpriority](ValueSet-v2-0906.md)
* [hl7VS-confidentiality](ValueSet-v2-0907.md)
* [hl7VS-patientResultsReleaseCategorizationScheme](ValueSet-v2-0909.md)
* [hl7VS-participation](ValueSet-v2-0912.md)
* [hl7VS-rootCause](ValueSet-v2-0914.md)
* [hl7VS-relevantClincialInformation](ValueSet-v2-0916.md)
* [hl7VS-bolusType](ValueSet-v2-0917.md)
* [hl7VS-pcaType](ValueSet-v2-0918.md)
* [hl7VS-exclusiveTest](ValueSet-v2-0919.md)
* [hl7VS-preferredSpecimen-AttributeStatus](ValueSet-v2-0920.md)
* [hl7VS-certificationTypeCode](ValueSet-v2-0921.md)
* [hl7VS-certificationCategoryCode](ValueSet-v2-0922.md)
* [hl7VS-processInterruption](ValueSet-v2-0923.md)
* [hl7VS-cumulativeDosageLimitUom](ValueSet-v2-0924.md)
* [hl7VS-phlebotomyIssue](ValueSet-v2-0925.md)
* [hl7VS-phlebotomyStatus](ValueSet-v2-0926.md)
* [hl7VS-armStick](ValueSet-v2-0927.md)
* [hl7VS-weightUnits](ValueSet-v2-0929.md)
* [hl7VS-volumeUnits](ValueSet-v2-0930.md)
* [hl7VS-temperatureUnits](ValueSet-v2-0931.md)
* [hl7VS-donationDurationUnits](ValueSet-v2-0932.md)
* [hl7VS-intendedProcedureType](ValueSet-v2-0933.md)
* [hl7VS-processInterruptionReason](ValueSet-v2-0935.md)
* [hl7VS-VS-observationType](ValueSet-v2-0936.md)
* [hl7VS-VS-observationSubtype](ValueSet-v2-0937.md)
* [hl7VS-VS-collectionEvent](ValueSet-v2-0938.md)
* [hl7VS-VS-communicationLocation](ValueSet-v2-0939.md)
* [hl7VS-VS-limitationTypeCode](ValueSet-v2-0940.md)
* [V2 Table 0942 Version Master](ValueSet-v2-0942.md)
* [hl7VS-auto-DilutionType](ValueSet-v2-0945.md)
* [hl7VS-supplierType](ValueSet-v2-0946.md)
* [hl7VS-relationshipType](ValueSet-v2-0948.md)
* [hl7VS-orderControlCodeReason](ValueSet-v2-0949.md)
* [hl7VS-orderStatusModifier](ValueSet-v2-0950.md)
* [hl7VS-ReasonForStudy](ValueSet-v2-0951.md)
* [Confidentiality](ValueSet-v2-0952.md)
* [workClassificationODH](ValueSet-v2-0959.md)
* [DeviceType](ValueSet-v2-0961.md)
* [FHIRdeviceStatus](ValueSet-v2-0962.md)
* [hl7VS-onlineVerificationResult](ValueSet-v2-0970.md)
* [hl7VS-onlineVerificationResultErrorCodes](ValueSet-v2-0971.md)
* [hl7VS-name-addressRepresentation](ValueSet-v2-4000.md)
* [hl7VS-subtypeOfReferencedData](ValueSet-v2-notAllCodes-0291.md)
* [HL7 Value Set for State/Province](ValueSet-v2-notAllCodes-0347.md)
* [hl7VS-countryCode-3alpha](ValueSet-v2-notAllCodes-0399.md)
* [hl7VS-mimeTypes](ValueSet-v2-notAllCodes-0834.md)
* [Abenakian](ValueSet-v3-Abenakian.md)
* [AccessMedicalDevice](ValueSet-v3-AccessMedicalDevice.md)
* [AcknowledgementCondition](ValueSet-v3-AcknowledgementCondition.md)
* [AcknowledgementDetailCode](ValueSet-v3-AcknowledgementDetailCode.md)
* [AcknowledgementDetailNotSupportedCode](ValueSet-v3-AcknowledgementDetailNotSupportedCode.md)
* [AcknowledgementDetailSyntaxErrorCode](ValueSet-v3-AcknowledgementDetailSyntaxErrorCode.md)
* [AcknowledgementDetailType](ValueSet-v3-AcknowledgementDetailType.md)
* [AcknowledgementType](ValueSet-v3-AcknowledgementType.md)
* [ActAccommodationReason](ValueSet-v3-ActAccommodationReason.md)
* [ActAccountCode](ValueSet-v3-ActAccountCode.md)
* [ActAdjudicationCode](ValueSet-v3-ActAdjudicationCode.md)
* [ActAdjudicationGroupCode](ValueSet-v3-ActAdjudicationGroupCode.md)
* [ActAdjudicationResultActionCode](ValueSet-v3-ActAdjudicationResultActionCode.md)
* [ActAdministrativeAuthorizationDetectedIssueCode](ValueSet-v3-ActAdministrativeAuthorizationDetectedIssueCode.md)
* [ActAdministrativeDetectedIssueCode](ValueSet-v3-ActAdministrativeDetectedIssueCode.md)
* [ActAdministrativeDetectedIssueManagementCode](ValueSet-v3-ActAdministrativeDetectedIssueManagementCode.md)
* [ActAdministrativeRuleDetectedIssueCode](ValueSet-v3-ActAdministrativeRuleDetectedIssueCode.md)
* [ActAmbulatoryEncounterCode](ValueSet-v3-ActAmbulatoryEncounterCode.md)
* [ActAntigenInvalidReason](ValueSet-v3-ActAntigenInvalidReason.md)
* [ActBillableModifierCode](ValueSet-v3-ActBillableModifierCode.md)
* [ActBillingArrangementCode](ValueSet-v3-ActBillingArrangementCode.md)
* [ActBoundedROICode](ValueSet-v3-ActBoundedROICode.md)
* [ActCareProvisionCode](ValueSet-v3-ActCareProvisionCode.md)
* [ActClaimAttachmentCategoryCode](ValueSet-v3-ActClaimAttachmentCategoryCode.md)
* [ActClass](ValueSet-v3-ActClass.md)
* [ActClassAccession](ValueSet-v3-ActClassAccession.md)
* [ActClassAccommodation](ValueSet-v3-ActClassAccommodation.md)
* [ActClassAccount](ValueSet-v3-ActClassAccount.md)
* [ActClassAcquisitionExposure](ValueSet-v3-ActClassAcquisitionExposure.md)
* [ActClassAction](ValueSet-v3-ActClassAction.md)
* [ActClassBattery](ValueSet-v3-ActClassBattery.md)
* [ActClassBioSequence](ValueSet-v3-ActClassBioSequence.md)
* [ActClassBioSequenceVariation](ValueSet-v3-ActClassBioSequenceVariation.md)
* [ActClassBoundedRoi](ValueSet-v3-ActClassBoundedRoi.md)
* [ActClassCareProvision](ValueSet-v3-ActClassCareProvision.md)
* [ActClassCategory](ValueSet-v3-ActClassCategory.md)
* [ActClassCdaLevelOneClinicalDocument](ValueSet-v3-ActClassCdaLevelOneClinicalDocument.md)
* [ActClassClinicalDocument](ValueSet-v3-ActClassClinicalDocument.md)
* [ActClassClinicalTrial](ValueSet-v3-ActClassClinicalTrial.md)
* [ActClassClinicalTrialTimepointEvent](ValueSet-v3-ActClassClinicalTrialTimepointEvent.md)
* [ActClassCluster](ValueSet-v3-ActClassCluster.md)
* [ActClassCompositeOrder](ValueSet-v3-ActClassCompositeOrder.md)
* [ActClassComposition](ValueSet-v3-ActClassComposition.md)
* [ActClassConcern](ValueSet-v3-ActClassConcern.md)
* [ActClassCondition](ValueSet-v3-ActClassCondition.md)
* [ActClassConditionNode](ValueSet-v3-ActClassConditionNode.md)
* [ActClassConsent](ValueSet-v3-ActClassConsent.md)
* [ActClassContainer](ValueSet-v3-ActClassContainer.md)
* [ActClassContainerRegistration](ValueSet-v3-ActClassContainerRegistration.md)
* [ActClassContract](ValueSet-v3-ActClassContract.md)
* [ActClassControlAct](ValueSet-v3-ActClassControlAct.md)
* [ActClassCorrelatedObservationSequences](ValueSet-v3-ActClassCorrelatedObservationSequences.md)
* [ActClassCoverage](ValueSet-v3-ActClassCoverage.md)
* [ActClassDetectedIssue](ValueSet-v3-ActClassDetectedIssue.md)
* [ActClassDeterminantPeptide](ValueSet-v3-ActClassDeterminantPeptide.md)
* [ActClassDiagnosticImage](ValueSet-v3-ActClassDiagnosticImage.md)
* [ActClassDiet](ValueSet-v3-ActClassDiet.md)
* [ActClassDisciplinaryAction](ValueSet-v3-ActClassDisciplinaryAction.md)
* [ActClassDocument](ValueSet-v3-ActClassDocument.md)
* [ActClassDocumentBody](ValueSet-v3-ActClassDocumentBody.md)
* [ActClassDocumentSection](ValueSet-v3-ActClassDocumentSection.md)
* [ActClassElectronicHealthRecord](ValueSet-v3-ActClassElectronicHealthRecord.md)
* [ActClassEncounter](ValueSet-v3-ActClassEncounter.md)
* [ActClassExposure](ValueSet-v3-ActClassExposure.md)
* [ActClassExpressionLevel](ValueSet-v3-ActClassExpressionLevel.md)
* [ActClassExtract](ValueSet-v3-ActClassExtract.md)
* [ActClassFinancialAdjudication](ValueSet-v3-ActClassFinancialAdjudication.md)
* [ActClassFinancialContract](ValueSet-v3-ActClassFinancialContract.md)
* [ActClassFinancialTransaction](ValueSet-v3-ActClassFinancialTransaction.md)
* [ActClassFolder](ValueSet-v3-ActClassFolder.md)
* [ActClassGenomicObservation](ValueSet-v3-ActClassGenomicObservation.md)
* [ActClassGrouper](ValueSet-v3-ActClassGrouper.md)
* [ActClassIncident](ValueSet-v3-ActClassIncident.md)
* [ActClassInform](ValueSet-v3-ActClassInform.md)
* [ActClassInformation](ValueSet-v3-ActClassInformation.md)
* [ActClassInvestigation](ValueSet-v3-ActClassInvestigation.md)
* [ActClassInvoiceElement](ValueSet-v3-ActClassInvoiceElement.md)
* [ActClassJurisdictionalPolicy](ValueSet-v3-ActClassJurisdictionalPolicy.md)
* [ActClassLeftLateralDecubitus](ValueSet-v3-ActClassLeftLateralDecubitus.md)
* [ActClassLocus](ValueSet-v3-ActClassLocus.md)
* [ActClassMonitoringProgram](ValueSet-v3-ActClassMonitoringProgram.md)
* [ActClassObservation](ValueSet-v3-ActClassObservation.md)
* [ActClassObservationSeries](ValueSet-v3-ActClassObservationSeries.md)
* [ActClassOrganizationalPolicy](ValueSet-v3-ActClassOrganizationalPolicy.md)
* [ActClassOutbreak](ValueSet-v3-ActClassOutbreak.md)
* [ActClassOutbreak2](ValueSet-v3-ActClassOutbreak2.md)
* [ActClassOverlayRoi](ValueSet-v3-ActClassOverlayRoi.md)
* [ActClassPhenotype](ValueSet-v3-ActClassPhenotype.md)
* [ActClassPolicy](ValueSet-v3-ActClassPolicy.md)
* [ActClassPolypeptide](ValueSet-v3-ActClassPolypeptide.md)
* [ActClassPosition](ValueSet-v3-ActClassPosition.md)
* [ActClassPositionAccuracy](ValueSet-v3-ActClassPositionAccuracy.md)
* [ActClassPositionCoordinate](ValueSet-v3-ActClassPositionCoordinate.md)
* [ActClassProcedure](ValueSet-v3-ActClassProcedure.md)
* [ActClassProcessStep](ValueSet-v3-ActClassProcessStep.md)
* [ActClassProne](ValueSet-v3-ActClassProne.md)
* [ActClassPublicHealthCase](ValueSet-v3-ActClassPublicHealthCase.md)
* [ActClassPublicHealthCase2](ValueSet-v3-ActClassPublicHealthCase2.md)
* [ActClassROI](ValueSet-v3-ActClassROI.md)
* [ActClassRecordOrganizer](ValueSet-v3-ActClassRecordOrganizer.md)
* [ActClassRegistration](ValueSet-v3-ActClassRegistration.md)
* [ActClassReverseTrendelenburg](ValueSet-v3-ActClassReverseTrendelenburg.md)
* [ActClassReview](ValueSet-v3-ActClassReview.md)
* [ActClassRightLateralDecubitus](ValueSet-v3-ActClassRightLateralDecubitus.md)
* [ActClassRoot](ValueSet-v3-ActClassRoot.md)
* [ActClassScopeOfPracticePolicy](ValueSet-v3-ActClassScopeOfPracticePolicy.md)
* [ActClassSemiFowlers](ValueSet-v3-ActClassSemiFowlers.md)
* [ActClassSitting](ValueSet-v3-ActClassSitting.md)
* [ActClassSpecimenCollection](ValueSet-v3-ActClassSpecimenCollection.md)
* [ActClassSpecimenObservation](ValueSet-v3-ActClassSpecimenObservation.md)
* [ActClassSpecimenTreatment](ValueSet-v3-ActClassSpecimenTreatment.md)
* [ActClassStandardOfPracticePolicy](ValueSet-v3-ActClassStandardOfPracticePolicy.md)
* [ActClassStanding](ValueSet-v3-ActClassStanding.md)
* [ActClassStateTransitionControl](ValueSet-v3-ActClassStateTransitionControl.md)
* [ActClassStorage](ValueSet-v3-ActClassStorage.md)
* [ActClassSubjectBodyPosition](ValueSet-v3-ActClassSubjectBodyPosition.md)
* [ActClassSubjectPhysicalPosition](ValueSet-v3-ActClassSubjectPhysicalPosition.md)
* [ActClassSubstanceAdministration](ValueSet-v3-ActClassSubstanceAdministration.md)
* [ActClassSubstanceExtraction](ValueSet-v3-ActClassSubstanceExtraction.md)
* [ActClassSubstitution](ValueSet-v3-ActClassSubstitution.md)
* [ActClassSupine](ValueSet-v3-ActClassSupine.md)
* [ActClassSupply](ValueSet-v3-ActClassSupply.md)
* [ActClassTopic](ValueSet-v3-ActClassTopic.md)
* [ActClassTransfer](ValueSet-v3-ActClassTransfer.md)
* [ActClassTransmissionExposure](ValueSet-v3-ActClassTransmissionExposure.md)
* [ActClassTransportation](ValueSet-v3-ActClassTransportation.md)
* [ActClassTrendelenburg](ValueSet-v3-ActClassTrendelenburg.md)
* [ActClassVerification](ValueSet-v3-ActClassVerification.md)
* [ActClassWorkingList](ValueSet-v3-ActClassWorkingList.md)
* [v3 Code System ActCode](ValueSet-v3-ActCode.md)
* [ActCodeProcessStep](ValueSet-v3-ActCodeProcessStep.md)
* [ActConditionList](ValueSet-v3-ActConditionList.md)
* [ActConsentDirective](ValueSet-v3-ActConsentDirective.md)
* [ActConsentDirectiveType](ValueSet-v3-ActConsentDirectiveType.md)
* [ActConsentInformationAccessOverrideReason](ValueSet-v3-ActConsentInformationAccessOverrideReason.md)
* [ActConsentType](ValueSet-v3-ActConsentType.md)
* [ActContainerRegistrationCode](ValueSet-v3-ActContainerRegistrationCode.md)
* [ActControlVariable](ValueSet-v3-ActControlVariable.md)
* [ActCoverageAssessmentObservationValue](ValueSet-v3-ActCoverageAssessmentObservationValue.md)
* [ActCoverageAuthorizationConfirmationCode](ValueSet-v3-ActCoverageAuthorizationConfirmationCode.md)
* [ActCoverageConfirmationCode](ValueSet-v3-ActCoverageConfirmationCode.md)
* [ActCoverageLimitCode](ValueSet-v3-ActCoverageLimitCode.md)
* [ActCoverageMaximaCodes](ValueSet-v3-ActCoverageMaximaCodes.md)
* [ActCoverageQuantityLimitCode](ValueSet-v3-ActCoverageQuantityLimitCode.md)
* [ActCoverageReason](ValueSet-v3-ActCoverageReason.md)
* [ActCoverageTypeCode](ValueSet-v3-ActCoverageTypeCode.md)
* [ActCredentialedCareCode](ValueSet-v3-ActCredentialedCareCode.md)
* [ActCredentialedCareProvisionPersonCode](ValueSet-v3-ActCredentialedCareProvisionPersonCode.md)
* [ActCredentialedCareProvisionProgramCode](ValueSet-v3-ActCredentialedCareProvisionProgramCode.md)
* [ActDetectedIssueCode](ValueSet-v3-ActDetectedIssueCode.md)
* [ActDetectedIssueManagementCode](ValueSet-v3-ActDetectedIssueManagementCode.md)
* [ActDietCode](ValueSet-v3-ActDietCode.md)
* [ActEmergencyEncounterCode](ValueSet-v3-ActEmergencyEncounterCode.md)
* [ActEncounterAccommodationCode](ValueSet-v3-ActEncounterAccommodationCode.md)
* [ActEncounterCode](ValueSet-v3-ActEncounterCode.md)
* [ActExposureCode](ValueSet-v3-ActExposureCode.md)
* [ActExposureLevelCode](ValueSet-v3-ActExposureLevelCode.md)
* [ActFieldEncounterCode](ValueSet-v3-ActFieldEncounterCode.md)
* [ActFinancialStatusObservationValue](ValueSet-v3-ActFinancialStatusObservationValue.md)
* [ActFinancialTransactionCode](ValueSet-v3-ActFinancialTransactionCode.md)
* [ActHealthInformationManagementReason](ValueSet-v3-ActHealthInformationManagementReason.md)
* [ActHealthInsuranceTypeCode](ValueSet-v3-ActHealthInsuranceTypeCode.md)
* [ActHomeHealthEncounterCode](ValueSet-v3-ActHomeHealthEncounterCode.md)
* [ActIncidentCode](ValueSet-v3-ActIncidentCode.md)
* [ActIneligibilityReason](ValueSet-v3-ActIneligibilityReason.md)
* [ActInformationAccess](ValueSet-v3-ActInformationAccess.md)
* [ActInformationAccessCode](ValueSet-v3-ActInformationAccessCode.md)
* [ActInformationAccessContextCode](ValueSet-v3-ActInformationAccessContextCode.md)
* [ActInformationCategoryCode](ValueSet-v3-ActInformationCategoryCode.md)
* [ActInformationSensitivityPolicy](ValueSet-v3-ActInformationSensitivityPolicy.md)
* [ActInformationTransferCode](ValueSet-v3-ActInformationTransferCode.md)
* [ActInjuryCodeCSA](ValueSet-v3-ActInjuryCodeCSA.md)
* [ActInpatientEncounterCode](ValueSet-v3-ActInpatientEncounterCode.md)
* [ActInsurancePolicyCode](ValueSet-v3-ActInsurancePolicyCode.md)
* [ActInsuranceTypeCode](ValueSet-v3-ActInsuranceTypeCode.md)
* [ActInvoiceAdjudicationPaymentCode](ValueSet-v3-ActInvoiceAdjudicationPaymentCode.md)
* [ActInvoiceAdjudicationPaymentGroupCode](ValueSet-v3-ActInvoiceAdjudicationPaymentGroupCode.md)
* [ActInvoiceAdjudicationPaymentSummaryCode](ValueSet-v3-ActInvoiceAdjudicationPaymentSummaryCode.md)
* [ActInvoiceDetailClinicalProductCode](ValueSet-v3-ActInvoiceDetailClinicalProductCode.md)
* [ActInvoiceDetailCode](ValueSet-v3-ActInvoiceDetailCode.md)
* [ActInvoiceDetailDrugProductCode](ValueSet-v3-ActInvoiceDetailDrugProductCode.md)
* [ActInvoiceDetailGenericAdjudicatorCode](ValueSet-v3-ActInvoiceDetailGenericAdjudicatorCode.md)
* [ActInvoiceDetailGenericCode](ValueSet-v3-ActInvoiceDetailGenericCode.md)
* [ActInvoiceDetailGenericModifierCode](ValueSet-v3-ActInvoiceDetailGenericModifierCode.md)
* [ActInvoiceDetailGenericProviderCode](ValueSet-v3-ActInvoiceDetailGenericProviderCode.md)
* [ActInvoiceDetailPreferredAccommodationCode](ValueSet-v3-ActInvoiceDetailPreferredAccommodationCode.md)
* [ActInvoiceDetailTaxCode](ValueSet-v3-ActInvoiceDetailTaxCode.md)
* [ActInvoiceElementCode](ValueSet-v3-ActInvoiceElementCode.md)
* [ActInvoiceElementModifier](ValueSet-v3-ActInvoiceElementModifier.md)
* [ActInvoiceElementSummaryCode](ValueSet-v3-ActInvoiceElementSummaryCode.md)
* [ActInvoiceGroupCode](ValueSet-v3-ActInvoiceGroupCode.md)
* [ActInvoiceInterGroupCode](ValueSet-v3-ActInvoiceInterGroupCode.md)
* [ActInvoiceOverrideCode](ValueSet-v3-ActInvoiceOverrideCode.md)
* [ActInvoicePaymentCode](ValueSet-v3-ActInvoicePaymentCode.md)
* [ActInvoiceRootGroupCode](ValueSet-v3-ActInvoiceRootGroupCode.md)
* [ActListCode](ValueSet-v3-ActListCode.md)
* [ActMedicalServiceCode](ValueSet-v3-ActMedicalServiceCode.md)
* [ActMedicationList](ValueSet-v3-ActMedicationList.md)
* [ActMedicationTherapyDurationWorkingListCode](ValueSet-v3-ActMedicationTherapyDurationWorkingListCode.md)
* [ActMonitoringProtocolCode](ValueSet-v3-ActMonitoringProtocolCode.md)
* [ActMood](ValueSet-v3-ActMood.md)
* [ActMoodActRequest](ValueSet-v3-ActMoodActRequest.md)
* [ActMoodAppointment](ValueSet-v3-ActMoodAppointment.md)
* [ActMoodAppointmentRequest](ValueSet-v3-ActMoodAppointmentRequest.md)
* [ActMoodCompletionTrack](ValueSet-v3-ActMoodCompletionTrack.md)
* [ActMoodCriterion](ValueSet-v3-ActMoodCriterion.md)
* [ActMoodDefinition](ValueSet-v3-ActMoodDefinition.md)
* [ActMoodDesire](ValueSet-v3-ActMoodDesire.md)
* [ActMoodEventCriterion](ValueSet-v3-ActMoodEventCriterion.md)
* [ActMoodEventOccurrence](ValueSet-v3-ActMoodEventOccurrence.md)
* [ActMoodExpectation](ValueSet-v3-ActMoodExpectation.md)
* [ActMoodGoal](ValueSet-v3-ActMoodGoal.md)
* [ActMoodIntent](ValueSet-v3-ActMoodIntent.md)
* [ActMoodOption](ValueSet-v3-ActMoodOption.md)
* [ActMoodPermission](ValueSet-v3-ActMoodPermission.md)
* [ActMoodPermissionRequest](ValueSet-v3-ActMoodPermissionRequest.md)
* [ActMoodPotential](ValueSet-v3-ActMoodPotential.md)
* [ActMoodPredicate](ValueSet-v3-ActMoodPredicate.md)
* [ActMoodPromise](ValueSet-v3-ActMoodPromise.md)
* [ActMoodProposal](ValueSet-v3-ActMoodProposal.md)
* [ActMoodRecommendation](ValueSet-v3-ActMoodRecommendation.md)
* [ActMoodRequest](ValueSet-v3-ActMoodRequest.md)
* [ActMoodResourceSlot](ValueSet-v3-ActMoodResourceSlot.md)
* [ActMoodRisk](ValueSet-v3-ActMoodRisk.md)
* [ActNoImmunizationReason](ValueSet-v3-ActNoImmunizationReason.md)
* [ActNonObservationIndicationCode](ValueSet-v3-ActNonObservationIndicationCode.md)
* [ActObservationList](ValueSet-v3-ActObservationList.md)
* [ActObservationVerificationType](ValueSet-v3-ActObservationVerificationType.md)
* [ActPatientAnnotationType](ValueSet-v3-ActPatientAnnotationType.md)
* [ActPatientTransportationModeCode](ValueSet-v3-ActPatientTransportationModeCode.md)
* [ActPaymentCode](ValueSet-v3-ActPaymentCode.md)
* [ActPharmacySupplyType](ValueSet-v3-ActPharmacySupplyType.md)
* [ActPolicyType](ValueSet-v3-ActPolicyType.md)
* [ActPriority](ValueSet-v3-ActPriority.md)
* [ActPriorityCallback](ValueSet-v3-ActPriorityCallback.md)
* [ActPrivacyLaw](ValueSet-v3-ActPrivacyLaw.md)
* [ActPrivacyPolicy](ValueSet-v3-ActPrivacyPolicy.md)
* [Act Procedure Code CCI](ValueSet-v3-ActProcedureCodeCCI.md)
* [ActProductAcquisitionCode](ValueSet-v3-ActProductAcquisitionCode.md)
* [ActProgramTypeCode](ValueSet-v3-ActProgramTypeCode.md)
* [v3 Code System ActReason](ValueSet-v3-ActReason.md)
* [ActRelationshipAccounting](ValueSet-v3-ActRelationshipAccounting.md)
* [ActRelationshipActProvenance](ValueSet-v3-ActRelationshipActProvenance.md)
* [ActRelationshipActiveImmunizationAgainst](ValueSet-v3-ActRelationshipActiveImmunizationAgainst.md)
* [ActRelationshipAdjunctCurativeIndication](ValueSet-v3-ActRelationshipAdjunctCurativeIndication.md)
* [ActRelationshipAdjunctMitigation](ValueSet-v3-ActRelationshipAdjunctMitigation.md)
* [ActRelationshipAdjunctiveTreatment](ValueSet-v3-ActRelationshipAdjunctiveTreatment.md)
* [ActRelationshipArrival](ValueSet-v3-ActRelationshipArrival.md)
* [ActRelationshipAssignsName](ValueSet-v3-ActRelationshipAssignsName.md)
* [ActRelationshipAuthorizedBy](ValueSet-v3-ActRelationshipAuthorizedBy.md)
* [ActRelationshipBlocks](ValueSet-v3-ActRelationshipBlocks.md)
* [ActRelationshipCheckpoint](ValueSet-v3-ActRelationshipCheckpoint.md)
* [ActRelationshipCheckpointBeginning](ValueSet-v3-ActRelationshipCheckpointBeginning.md)
* [ActRelationshipCheckpointEnd](ValueSet-v3-ActRelationshipCheckpointEnd.md)
* [ActRelationshipCheckpointEntry](ValueSet-v3-ActRelationshipCheckpointEntry.md)
* [ActRelationshipCheckpointExit](ValueSet-v3-ActRelationshipCheckpointExit.md)
* [ActRelationshipCheckpointThrough](ValueSet-v3-ActRelationshipCheckpointThrough.md)
* [ActRelationshipCompliesWith](ValueSet-v3-ActRelationshipCompliesWith.md)
* [ActRelationshipConcurrentWith](ValueSet-v3-ActRelationshipConcurrentWith.md)
* [ActRelationshipConditional](ValueSet-v3-ActRelationshipConditional.md)
* [ActRelationshipContainsEndOf](ValueSet-v3-ActRelationshipContainsEndOf.md)
* [ActRelationshipContainsStartOf](ValueSet-v3-ActRelationshipContainsStartOf.md)
* [ActRelationshipContainsStartOfEndsBeforeEndOf](ValueSet-v3-ActRelationshipContainsStartOfEndsBeforeEndOf.md)
* [ActRelationshipContainsTimeOf](ValueSet-v3-ActRelationshipContainsTimeOf.md)
* [ActRelationshipCostTracking](ValueSet-v3-ActRelationshipCostTracking.md)
* [ActRelationshipCoveredBy](ValueSet-v3-ActRelationshipCoveredBy.md)
* [ActRelationshipCurativeIndication](ValueSet-v3-ActRelationshipCurativeIndication.md)
* [ActRelationshipDeparture](ValueSet-v3-ActRelationshipDeparture.md)
* [ActRelationshipDiagnosis](ValueSet-v3-ActRelationshipDiagnosis.md)
* [ActRelationshipDocumentHQMF](ValueSet-v3-ActRelationshipDocumentHQMF.md)
* [ActRelationshipDocumentProvenance](ValueSet-v3-ActRelationshipDocumentProvenance.md)
* [ActRelationshipDocuments](ValueSet-v3-ActRelationshipDocuments.md)
* [ActRelationshipDuring](ValueSet-v3-ActRelationshipDuring.md)
* [ActRelationshipEndsAfterEndOf](ValueSet-v3-ActRelationshipEndsAfterEndOf.md)
* [ActRelationshipEndsAfterOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithEndOf.md)
* [ActRelationshipEndsAfterOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithStartOf.md)
* [ActRelationshipEndsAfterStartOf](ValueSet-v3-ActRelationshipEndsAfterStartOf.md)
* [ActRelationshipEndsBeforeEnd](ValueSet-v3-ActRelationshipEndsBeforeEnd.md)
* [ActRelationshipEndsBeforeOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithEndOf.md)
* [ActRelationshipEndsBeforeOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithStartOf.md)
* [ActRelationshipEndsBeforeStartOf](ValueSet-v3-ActRelationshipEndsBeforeStartOf.md)
* [ActRelationshipEndsConcurrentWith](ValueSet-v3-ActRelationshipEndsConcurrentWith.md)
* [ActRelationshipEndsConcurrentWithStart](ValueSet-v3-ActRelationshipEndsConcurrentWithStart.md)
* [ActRelationshipEndsDuring](ValueSet-v3-ActRelationshipEndsDuring.md)
* [ActRelationshipEndsNearEnd](ValueSet-v3-ActRelationshipEndsNearEnd.md)
* [ActRelationshipEndsNearStarts](ValueSet-v3-ActRelationshipEndsNearStarts.md)
* [ActRelationshipEpisodelink](ValueSet-v3-ActRelationshipEpisodelink.md)
* [ActRelationshipEvaluatesGoal](ValueSet-v3-ActRelationshipEvaluatesGoal.md)
* [ActRelationshipExacerbatredBy](ValueSet-v3-ActRelationshipExacerbatredBy.md)
* [ActRelationshipExcerpt](ValueSet-v3-ActRelationshipExcerpt.md)
* [ActRelationshipExcerptVerbatim](ValueSet-v3-ActRelationshipExcerptVerbatim.md)
* [ActRelationshipFulfills](ValueSet-v3-ActRelationshipFulfills.md)
* [ActRelationshipHasBaseline](ValueSet-v3-ActRelationshipHasBaseline.md)
* [ActRelationshipHasBoundedSupport](ValueSet-v3-ActRelationshipHasBoundedSupport.md)
* [ActRelationshipHasCharge](ValueSet-v3-ActRelationshipHasCharge.md)
* [ActRelationshipHasComponent](ValueSet-v3-ActRelationshipHasComponent.md)
* [ActRelationshipHasContinuingObjective](ValueSet-v3-ActRelationshipHasContinuingObjective.md)
* [ActRelationshipHasContra-indication](ValueSet-v3-ActRelationshipHasContra-indication.md)
* [ActRelationshipHasControlVariable](ValueSet-v3-ActRelationshipHasControlVariable.md)
* [ActRelationshipHasCost](ValueSet-v3-ActRelationshipHasCost.md)
* [ActRelationshipHasCredit](ValueSet-v3-ActRelationshipHasCredit.md)
* [ActRelationshipHasDebit](ValueSet-v3-ActRelationshipHasDebit.md)
* [ActRelationshipHasExplanation](ValueSet-v3-ActRelationshipHasExplanation.md)
* [ActRelationshipHasFinalObjective](ValueSet-v3-ActRelationshipHasFinalObjective.md)
* [ActRelationshipHasGeneralization](ValueSet-v3-ActRelationshipHasGeneralization.md)
* [ActRelationshipHasGoal](ValueSet-v3-ActRelationshipHasGoal.md)
* [ActRelationshipHasMember](ValueSet-v3-ActRelationshipHasMember.md)
* [ActRelationshipHasMetadata](ValueSet-v3-ActRelationshipHasMetadata.md)
* [ActRelationshipHasOption](ValueSet-v3-ActRelationshipHasOption.md)
* [ActRelationshipHasPart](ValueSet-v3-ActRelationshipHasPart.md)
* [ActRelationshipHasPre-condition](ValueSet-v3-ActRelationshipHasPre-condition.md)
* [ActRelationshipHasPreviousInstance](ValueSet-v3-ActRelationshipHasPreviousInstance.md)
* [ActRelationshipHasQualifier](ValueSet-v3-ActRelationshipHasQualifier.md)
* [ActRelationshipHasReferenceValues](ValueSet-v3-ActRelationshipHasReferenceValues.md)
* [ActRelationshipHasRisk](ValueSet-v3-ActRelationshipHasRisk.md)
* [ActRelationshipHasStep](ValueSet-v3-ActRelationshipHasStep.md)
* [ActRelationshipHasSubject](ValueSet-v3-ActRelationshipHasSubject.md)
* [ActRelationshipHasSupport](ValueSet-v3-ActRelationshipHasSupport.md)
* [ActRelationshipHasTrigger](ValueSet-v3-ActRelationshipHasTrigger.md)
* [ActRelationshipHasValue](ValueSet-v3-ActRelationshipHasValue.md)
* [ActRelationshipICSRInvestigation](ValueSet-v3-ActRelationshipICSRInvestigation.md)
* [ActRelationshipImmunizationAgainst](ValueSet-v3-ActRelationshipImmunizationAgainst.md)
* [ActRelationshipIndependentOfTimeOf](ValueSet-v3-ActRelationshipIndependentOfTimeOf.md)
* [ActRelationshipInstantiatesMaster](ValueSet-v3-ActRelationshipInstantiatesMaster.md)
* [ActRelationshipInterferedBy](ValueSet-v3-ActRelationshipInterferedBy.md)
* [ActRelationshipIsAppendage](ValueSet-v3-ActRelationshipIsAppendage.md)
* [ActRelationshipIsDerivedFrom](ValueSet-v3-ActRelationshipIsDerivedFrom.md)
* [ActRelationshipIsEtiologyFor](ValueSet-v3-ActRelationshipIsEtiologyFor.md)
* [ActRelationshipIsManifestationOf](ValueSet-v3-ActRelationshipIsManifestationOf.md)
* [ActRelationshipItemsLocated](ValueSet-v3-ActRelationshipItemsLocated.md)
* [ActRelationshipJoin](ValueSet-v3-ActRelationshipJoin.md)
* [ActRelationshipJoinDetached](ValueSet-v3-ActRelationshipJoinDetached.md)
* [ActRelationshipJoinExclusiveWait](ValueSet-v3-ActRelationshipJoinExclusiveWait.md)
* [ActRelationshipJoinKill](ValueSet-v3-ActRelationshipJoinKill.md)
* [ActRelationshipJoinWait](ValueSet-v3-ActRelationshipJoinWait.md)
* [ActRelationshipLimitedBy](ValueSet-v3-ActRelationshipLimitedBy.md)
* [ActRelationshipMaintenanceTreatment](ValueSet-v3-ActRelationshipMaintenanceTreatment.md)
* [ActRelationshipMatchesTrigger](ValueSet-v3-ActRelationshipMatchesTrigger.md)
* [ActRelationshipMitigates](ValueSet-v3-ActRelationshipMitigates.md)
* [ActRelationshipModifies](ValueSet-v3-ActRelationshipModifies.md)
* [ActRelationshipObjective](ValueSet-v3-ActRelationshipObjective.md)
* [ActRelationshipOccurrence](ValueSet-v3-ActRelationshipOccurrence.md)
* [ActRelationshipOutcome](ValueSet-v3-ActRelationshipOutcome.md)
* [ActRelationshipOverlapsWith](ValueSet-v3-ActRelationshipOverlapsWith.md)
* [ActRelationshipPalliates](ValueSet-v3-ActRelationshipPalliates.md)
* [ActRelationshipPassiveImmunizationAgainst](ValueSet-v3-ActRelationshipPassiveImmunizationAgainst.md)
* [ActRelationshipPertains](ValueSet-v3-ActRelationshipPertains.md)
* [ActRelationshipPosting](ValueSet-v3-ActRelationshipPosting.md)
* [ActRelationshipProphylaxisOf](ValueSet-v3-ActRelationshipProphylaxisOf.md)
* [ActRelationshipProvidesEvidenceFor](ValueSet-v3-ActRelationshipProvidesEvidenceFor.md)
* [ActRelationshipRe-challenge](ValueSet-v3-ActRelationshipRe-challenge.md)
* [ActRelationshipReason](ValueSet-v3-ActRelationshipReason.md)
* [ActRelationshipRecovery](ValueSet-v3-ActRelationshipRecovery.md)
* [ActRelationshipReferencesOrder](ValueSet-v3-ActRelationshipReferencesOrder.md)
* [ActRelationshipRefersTo](ValueSet-v3-ActRelationshipRefersTo.md)
* [ActRelationshipRelievedBy](ValueSet-v3-ActRelationshipRelievedBy.md)
* [ActRelationshipReplaces](ValueSet-v3-ActRelationshipReplaces.md)
* [ActRelationshipReverses](ValueSet-v3-ActRelationshipReverses.md)
* [ActRelationshipSchedulesRequest](ValueSet-v3-ActRelationshipSchedulesRequest.md)
* [ActRelationshipSequel](ValueSet-v3-ActRelationshipSequel.md)
* [ActRelationshipSplit](ValueSet-v3-ActRelationshipSplit.md)
* [ActRelationshipSplitExclusiveTryOnce](ValueSet-v3-ActRelationshipSplitExclusiveTryOnce.md)
* [ActRelationshipSplitExclusiveWait](ValueSet-v3-ActRelationshipSplitExclusiveWait.md)
* [ActRelationshipSplitInclusiveTryOnce](ValueSet-v3-ActRelationshipSplitInclusiveTryOnce.md)
* [ActRelationshipSplitInclusiveWait](ValueSet-v3-ActRelationshipSplitInclusiveWait.md)
* [ActRelationshipStartAfterStartOfContainsEndOf](ValueSet-v3-ActRelationshipStartAfterStartOfContainsEndOf.md)
* [ActRelationshipStartsAfterEndOf](ValueSet-v3-ActRelationshipStartsAfterEndOf.md)
* [ActRelationshipStartsAfterOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithEndOf.md)
* [ActRelationshipStartsAfterOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithStartOf.md)
* [ActRelationshipStartsAfterStartOf](ValueSet-v3-ActRelationshipStartsAfterStartOf.md)
* [ActRelationshipStartsAfterStartOfEndsWith](ValueSet-v3-ActRelationshipStartsAfterStartOfEndsWith.md)
* [ActRelationshipStartsAfterStartofEndsAfterEndOf](ValueSet-v3-ActRelationshipStartsAfterStartofEndsAfterEndOf.md)
* [ActRelationshipStartsBeforeEnd](ValueSet-v3-ActRelationshipStartsBeforeEnd.md)
* [ActRelationshipStartsBeforeOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithEndOf.md)
* [ActRelationshipStartsBeforeOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithStartOf.md)
* [ActRelationshipStartsBeforeStartOf](ValueSet-v3-ActRelationshipStartsBeforeStartOf.md)
* [ActRelationshipStartsBeforeStartOfEndsBeforeEndOf](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsBeforeEndOf.md)
* [ActRelationshipStartsBeforeStartOfEndsWith](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsWith.md)
* [ActRelationshipStartsConcurrentWith](ValueSet-v3-ActRelationshipStartsConcurrentWith.md)
* [ActRelationshipStartsConcurrentWithEnd](ValueSet-v3-ActRelationshipStartsConcurrentWithEnd.md)
* [ActRelationshipStartsDuring](ValueSet-v3-ActRelationshipStartsDuring.md)
* [ActRelationshipStartsNearEnd](ValueSet-v3-ActRelationshipStartsNearEnd.md)
* [ActRelationshipStartsNearStart](ValueSet-v3-ActRelationshipStartsNearStart.md)
* [ActRelationshipStartsWithEndsAfterEndOf](ValueSet-v3-ActRelationshipStartsWithEndsAfterEndOf.md)
* [ActRelationshipStartsWithEndsBeforeEndOf](ValueSet-v3-ActRelationshipStartsWithEndsBeforeEndOf.md)
* [ActRelationshipSubset](ValueSet-v3-ActRelationshipSubset.md)
* [ActRelationshipSucceeds](ValueSet-v3-ActRelationshipSucceeds.md)
* [ActRelationshipSummarizedBy](ValueSet-v3-ActRelationshipSummarizedBy.md)
* [ActRelationshipSymptomaticRelief](ValueSet-v3-ActRelationshipSymptomaticRelief.md)
* [ActRelationshipTemporallyPertains](ValueSet-v3-ActRelationshipTemporallyPertains.md)
* [ActRelationshipTemporallyPertainsApproximates](ValueSet-v3-ActRelationshipTemporallyPertainsApproximates.md)
* [ActRelationshipTemporallyPertainsEnd](ValueSet-v3-ActRelationshipTemporallyPertainsEnd.md)
* [ActRelationshipTemporallyPertainsStart](ValueSet-v3-ActRelationshipTemporallyPertainsStart.md)
* [ActRelationshipTransformation](ValueSet-v3-ActRelationshipTransformation.md)
* [ActRelationshipTreats](ValueSet-v3-ActRelationshipTreats.md)
* [ActRelationshipType](ValueSet-v3-ActRelationshipType.md)
* [ActRelationshipUpdate](ValueSet-v3-ActRelationshipUpdate.md)
* [ActRelationshipUpdatesCondition](ValueSet-v3-ActRelationshipUpdatesCondition.md)
* [ActRelationshipUses](ValueSet-v3-ActRelationshipUses.md)
* [ActResearchInformationAccess](ValueSet-v3-ActResearchInformationAccess.md)
* [ActShortStayEncounterCode](ValueSet-v3-ActShortStayEncounterCode.md)
* [v3 Value Set ActSite](ValueSet-v3-ActSite.md)
* [ActSpecObsCode](ValueSet-v3-ActSpecObsCode.md)
* [ActSpecObsDilutionCode](ValueSet-v3-ActSpecObsDilutionCode.md)
* [ActSpecObsInterferenceCode](ValueSet-v3-ActSpecObsInterferenceCode.md)
* [ActSpecObsVolumeCode](ValueSet-v3-ActSpecObsVolumeCode.md)
* [ActSpecimenTreatmentCode](ValueSet-v3-ActSpecimenTreatmentCode.md)
* [ActStatus](ValueSet-v3-ActStatus.md)
* [ActStatusAborted](ValueSet-v3-ActStatusAborted.md)
* [ActStatusAbortedCancelledCompleted](ValueSet-v3-ActStatusAbortedCancelledCompleted.md)
* [ActStatusActive](ValueSet-v3-ActStatusActive.md)
* [ActStatusActiveAborted](ValueSet-v3-ActStatusActiveAborted.md)
* [ActStatusActiveSuspendedObsolete](ValueSet-v3-ActStatusActiveSuspendedObsolete.md)
* [ActStatusCancelled](ValueSet-v3-ActStatusCancelled.md)
* [ActStatusCompleted](ValueSet-v3-ActStatusCompleted.md)
* [ActStatusHeld](ValueSet-v3-ActStatusHeld.md)
* [ActStatusNew](ValueSet-v3-ActStatusNew.md)
* [ActStatusNormal](ValueSet-v3-ActStatusNormal.md)
* [ActStatusNullified](ValueSet-v3-ActStatusNullified.md)
* [ActStatusObsolete](ValueSet-v3-ActStatusObsolete.md)
* [ActStatusSuspended](ValueSet-v3-ActStatusSuspended.md)
* [ActSubstanceAdminSubstitutionCode](ValueSet-v3-ActSubstanceAdminSubstitutionCode.md)
* [ActSubstanceAdministrationCode](ValueSet-v3-ActSubstanceAdministrationCode.md)
* [ActSubstanceAdministrationImmunizationCode](ValueSet-v3-ActSubstanceAdministrationImmunizationCode.md)
* [ActSuppliedItemDetectedIssueCode](ValueSet-v3-ActSuppliedItemDetectedIssueCode.md)
* [ActSupplyFulfillmentRefusalReason](ValueSet-v3-ActSupplyFulfillmentRefusalReason.md)
* [ActTaskClinicalNoteEntryCode](ValueSet-v3-ActTaskClinicalNoteEntryCode.md)
* [ActTaskClinicalNoteReviewCode](ValueSet-v3-ActTaskClinicalNoteReviewCode.md)
* [ActTaskCode](ValueSet-v3-ActTaskCode.md)
* [ActTaskMedicationListReviewCode](ValueSet-v3-ActTaskMedicationListReviewCode.md)
* [ActTaskMicrobiologyResultsReviewCode](ValueSet-v3-ActTaskMicrobiologyResultsReviewCode.md)
* [ActTaskOrderEntryCode](ValueSet-v3-ActTaskOrderEntryCode.md)
* [ActTaskPatientDocumentationCode](ValueSet-v3-ActTaskPatientDocumentationCode.md)
* [ActTaskPatientInformationReviewCode](ValueSet-v3-ActTaskPatientInformationReviewCode.md)
* [ActTaskRiskAssessmentInstrumentCode](ValueSet-v3-ActTaskRiskAssessmentInstrumentCode.md)
* [ActTherapyDurationWorkingListCode](ValueSet-v3-ActTherapyDurationWorkingListCode.md)
* [ActTransportationModeCode](ValueSet-v3-ActTransportationModeCode.md)
* [ActUSPrivacyLaw](ValueSet-v3-ActUSPrivacyLaw.md)
* [ActUncertainty](ValueSet-v3-ActUncertainty.md)
* [ActVirtualEncounterCode](ValueSet-v3-ActVirtualEncounterCode.md)
* [AdditionalLocator](ValueSet-v3-AdditionalLocator.md)
* [AddressLine](ValueSet-v3-AddressLine.md)
* [AddressPartType](ValueSet-v3-AddressPartType.md)
* [AddressRepresentationUse](ValueSet-v3-AddressRepresentationUse.md)
* [AddressUse](ValueSet-v3-AddressUse.md)
* [AdjudicatedWithAdjustments](ValueSet-v3-AdjudicatedWithAdjustments.md)
* [AdministrableDrugForm](ValueSet-v3-AdministrableDrugForm.md)
* [AdministrationDetectedIssueCode](ValueSet-v3-AdministrationDetectedIssueCode.md)
* [AdministrationMedicalDevice](ValueSet-v3-AdministrationMedicalDevice.md)
* [AdministrativeContactRoleType](ValueSet-v3-AdministrativeContactRoleType.md)
* [AdministrativeGender](ValueSet-v3-AdministrativeGender.md)
* [AdoptedChild](ValueSet-v3-AdoptedChild.md)
* [AerosolDrugForm](ValueSet-v3-AerosolDrugForm.md)
* [AgeDetectedIssueCode](ValueSet-v3-AgeDetectedIssueCode.md)
* [AgeGroupObservationValue](ValueSet-v3-AgeGroupObservationValue.md)
* [Aleut](ValueSet-v3-Aleut.md)
* [Algic](ValueSet-v3-Algic.md)
* [Algonquian](ValueSet-v3-Algonquian.md)
* [AlgorithmicDecisionObservationMethod](ValueSet-v3-AlgorithmicDecisionObservationMethod.md)
* [Allergy Status](ValueSet-v3-AllergyStatus.md)
* [AllergyTestValue](ValueSet-v3-AllergyTestValue.md)
* [Ambulance](ValueSet-v3-Ambulance.md)
* [AmbulanceHIPAA](ValueSet-v3-AmbulanceHIPAA.md)
* [AmericanIndianAlaskaNativeLanguages](ValueSet-v3-AmericanIndianAlaskaNativeLanguages.md)
* [AmnioticFluidSacRoute](ValueSet-v3-AmnioticFluidSacRoute.md)
* [AnnotationType](ValueSet-v3-AnnotationType.md)
* [Apachean](ValueSet-v3-Apachean.md)
* [ApplicationMediaType](ValueSet-v3-ApplicationMediaType.md)
* [AppropriatenessDetectedIssueCode](ValueSet-v3-AppropriatenessDetectedIssueCode.md)
* [ArapahoGrosVentre](ValueSet-v3-ArapahoGrosVentre.md)
* [Arapahoan](ValueSet-v3-Arapahoan.md)
* [ArtificialDentition](ValueSet-v3-ArtificialDentition.md)
* [AskedButUnknown](ValueSet-v3-AskedButUnknown.md)
* [AssignedNonPersonLivingSubjectRoleType](ValueSet-v3-AssignedNonPersonLivingSubjectRoleType.md)
* [Athapaskan](ValueSet-v3-Athapaskan.md)
* [AthapaskanEyak](ValueSet-v3-AthapaskanEyak.md)
* [AudioMediaType](ValueSet-v3-AudioMediaType.md)
* [AuthorizationIssueManagementCode](ValueSet-v3-AuthorizationIssueManagementCode.md)
* [AuthorizedParticipationFunction](ValueSet-v3-AuthorizedParticipationFunction.md)
* [AuthorizedReceiverParticipationFunction](ValueSet-v3-AuthorizedReceiverParticipationFunction.md)
* [AutomobileInsurancePolicy](ValueSet-v3-AutomobileInsurancePolicy.md)
* [BarDrugForm](ValueSet-v3-BarDrugForm.md)
* [BarSoapDrugForm](ValueSet-v3-BarSoapDrugForm.md)
* [BiliaryRoute](ValueSet-v3-BiliaryRoute.md)
* [BindingRealm](ValueSet-v3-BindingRealm.md)
* [BiotherapeuticNon-personLivingSubjectRoleType](ValueSet-v3-BiotherapeuticNon-personLivingSubjectRoleType.md)
* [BlisterPackEntityType](ValueSet-v3-BlisterPackEntityType.md)
* [BodySurfaceRoute](ValueSet-v3-BodySurfaceRoute.md)
* [BottleEntityType](ValueSet-v3-BottleEntityType.md)
* [BuccalMucosaRoute](ValueSet-v3-BuccalMucosaRoute.md)
* [BuccalTablet](ValueSet-v3-BuccalTablet.md)
* [BuildingNumber](ValueSet-v3-BuildingNumber.md)
* [CUI](ValueSet-v3-CUI.md)
* [CUILabel](ValueSet-v3-CUILabel.md)
* [CVDiagTherPracticeSetting](ValueSet-v3-CVDiagTherPracticeSetting.md)
* [Caddoan](ValueSet-v3-Caddoan.md)
* [Cahitan](ValueSet-v3-Cahitan.md)
* [Calendar](ValueSet-v3-Calendar.md)
* [CalendarCycle](ValueSet-v3-CalendarCycle.md)
* [CalendarCycleOneLetter](ValueSet-v3-CalendarCycleOneLetter.md)
* [CalendarCycleTwoLetter](ValueSet-v3-CalendarCycleTwoLetter.md)
* [CalendarType](ValueSet-v3-CalendarType.md)
* [CaliforniaAthapaskan](ValueSet-v3-CaliforniaAthapaskan.md)
* [CapsuleDrugForm](ValueSet-v3-CapsuleDrugForm.md)
* [CardClinPracticeSetting](ValueSet-v3-CardClinPracticeSetting.md)
* [CaseTransmissionMode](ValueSet-v3-CaseTransmissionMode.md)
* [Catawba](ValueSet-v3-Catawba.md)
* [CecostomyRoute](ValueSet-v3-CecostomyRoute.md)
* [CentralAlaskaYukon](ValueSet-v3-CentralAlaskaYukon.md)
* [CentralMuskogean](ValueSet-v3-CentralMuskogean.md)
* [CentralNumic](ValueSet-v3-CentralNumic.md)
* [CentralSalish](ValueSet-v3-CentralSalish.md)
* [CervicalRoute](ValueSet-v3-CervicalRoute.md)
* [Charset](ValueSet-v3-Charset.md)
* [Chew](ValueSet-v3-Chew.md)
* [Child](ValueSet-v3-Child.md)
* [ChildInLaw](ValueSet-v3-ChildInLaw.md)
* [Chimakuan](ValueSet-v3-Chimakuan.md)
* [Chinookan](ValueSet-v3-Chinookan.md)
* [ChiwereWinnebago](ValueSet-v3-ChiwereWinnebago.md)
* [ChronicCareFacility](ValueSet-v3-ChronicCareFacility.md)
* [CitizenRoleType](ValueSet-v3-CitizenRoleType.md)
* [ClaimantCoveredPartyRoleType](ValueSet-v3-ClaimantCoveredPartyRoleType.md)
* [ClassNullFlavor](ValueSet-v3-ClassNullFlavor.md)
* [ClinicalResearchEventReason](ValueSet-v3-ClinicalResearchEventReason.md)
* [ClinicalResearchObservationReason](ValueSet-v3-ClinicalResearchObservationReason.md)
* [ClinicalResearchReason](ValueSet-v3-ClinicalResearchReason.md)
* [CochimiYuman](ValueSet-v3-CochimiYuman.md)
* [CodeIsNotValid](ValueSet-v3-CodeIsNotValid.md)
* [CodeSystem](ValueSet-v3-CodeSystem.md)
* [CodeSystemType](ValueSet-v3-CodeSystemType.md)
* [CodingRationale](ValueSet-v3-CodingRationale.md)
* [CombinedPharmacyOrderSuspendReasonCode](ValueSet-v3-CombinedPharmacyOrderSuspendReasonCode.md)
* [CommunicationFunctionType](ValueSet-v3-CommunicationFunctionType.md)
* [Compartment](ValueSet-v3-Compartment.md)
* [ComplianceAlert](ValueSet-v3-ComplianceAlert.md)
* [ComplianceDetectedIssueCode](ValueSet-v3-ComplianceDetectedIssueCode.md)
* [CompliancePackageEntityType](ValueSet-v3-CompliancePackageEntityType.md)
* [CompositeMeasureScoring](ValueSet-v3-CompositeMeasureScoring.md)
* [CompressionAlgorithm](ValueSet-v3-CompressionAlgorithm.md)
* [ConceptPropertyId](ValueSet-v3-ConceptPropertyId.md)
* [ConditionDetectedIssueCode](ValueSet-v3-ConditionDetectedIssueCode.md)
* [Conditional](ValueSet-v3-Conditional.md)
* [Confidentiality](ValueSet-v3-Confidentiality.md)
* [ConfidentialityModifiers](ValueSet-v3-ConfidentialityModifiers.md)
* [ConsenterParticipationFunction](ValueSet-v3-ConsenterParticipationFunction.md)
* [ConsultedPrescriberManagementCode](ValueSet-v3-ConsultedPrescriberManagementCode.md)
* [ContactRoleType](ValueSet-v3-ContactRoleType.md)
* [ContainerCap](ValueSet-v3-ContainerCap.md)
* [ContainerEntityType](ValueSet-v3-ContainerEntityType.md)
* [ContainerSeparator](ValueSet-v3-ContainerSeparator.md)
* [ContentProcessingMode](ValueSet-v3-ContentProcessingMode.md)
* [ContextConductionStyle](ValueSet-v3-ContextConductionStyle.md)
* [ContextControl](ValueSet-v3-ContextControl.md)
* [ContextControlAdditive](ValueSet-v3-ContextControlAdditive.md)
* [ContextControlAdditiveNon-propagating](ValueSet-v3-ContextControlAdditiveNon-propagating.md)
* [ContextControlAdditivePropagating](ValueSet-v3-ContextControlAdditivePropagating.md)
* [ContextControlNonPropagating](ValueSet-v3-ContextControlNonPropagating.md)
* [ContextControlOverriding](ValueSet-v3-ContextControlOverriding.md)
* [ContextControlOverridingNon-propagating](ValueSet-v3-ContextControlOverridingNon-propagating.md)
* [ContextControlOverridingPropagating](ValueSet-v3-ContextControlOverridingPropagating.md)
* [ContextControlPropagating](ValueSet-v3-ContextControlPropagating.md)
* [ControlActNullificationReasonCode](ValueSet-v3-ControlActNullificationReasonCode.md)
* [ControlActNullificationRefusalReasonType](ValueSet-v3-ControlActNullificationRefusalReasonType.md)
* [ControlActReason](ValueSet-v3-ControlActReason.md)
* [ControlledSubstanceMonitoringProtocol](ValueSet-v3-ControlledSubstanceMonitoringProtocol.md)
* [Coosan](ValueSet-v3-Coosan.md)
* [Country](ValueSet-v3-Country.md)
* [Country2](ValueSet-v3-Country2.md)
* [CountryEntityType](ValueSet-v3-CountryEntityType.md)
* [CoverageEligibilityReason](ValueSet-v3-CoverageEligibilityReason.md)
* [CoverageLevelObservationValue](ValueSet-v3-CoverageLevelObservationValue.md)
* [CoverageLimitObservationValue](ValueSet-v3-CoverageLimitObservationValue.md)
* [CoverageParticipationFunction](ValueSet-v3-CoverageParticipationFunction.md)
* [CoverageRoleType](ValueSet-v3-CoverageRoleType.md)
* [CoverageSponsorRoleType](ValueSet-v3-CoverageSponsorRoleType.md)
* [CoveredPartyRoleType](ValueSet-v3-CoveredPartyRoleType.md)
* [CreamDrugForm](ValueSet-v3-CreamDrugForm.md)
* [CreditCard](ValueSet-v3-CreditCard.md)
* [Cree](ValueSet-v3-Cree.md)
* [CreeMontagnais](ValueSet-v3-CreeMontagnais.md)
* [CriticalityObservationValue](ValueSet-v3-CriticalityObservationValue.md)
* [Cupan](ValueSet-v3-Cupan.md)
* [Currency](ValueSet-v3-Currency.md)
* [Dakotan](ValueSet-v3-Dakotan.md)
* [Decision Observation Method](ValueSet-v3-DecisionObservationMethod.md)
* [DedicatedClinicalLocationRoleType](ValueSet-v3-DedicatedClinicalLocationRoleType.md)
* [DedicatedNonClinicalLocationRoleType](ValueSet-v3-DedicatedNonClinicalLocationRoleType.md)
* [DedicatedServiceDeliveryLocationRoleType](ValueSet-v3-DedicatedServiceDeliveryLocationRoleType.md)
* [Delawaran](ValueSet-v3-Delawaran.md)
* [DeliveryAddressLine](ValueSet-v3-DeliveryAddressLine.md)
* [DeltaCalifornia](ValueSet-v3-DeltaCalifornia.md)
* [DentistHIPAA](ValueSet-v3-DentistHIPAA.md)
* [Dentition](ValueSet-v3-Dentition.md)
* [DependentCoveredPartyRoleType](ValueSet-v3-DependentCoveredPartyRoleType.md)
* [DeviceAlertLevel](ValueSet-v3-DeviceAlertLevel.md)
* [Dhegiha](ValueSet-v3-Dhegiha.md)
* [DiagTherPracticeSetting](ValueSet-v3-DiagTherPracticeSetting.md)
* [DiagnosisICD9CM](ValueSet-v3-DiagnosisICD9CM.md)
* [Diegueno](ValueSet-v3-Diegueno.md)
* [Diffusion](ValueSet-v3-Diffusion.md)
* [Discharge Disposition](ValueSet-v3-DischargeDisposition.md)
* [DiseaseProgram](ValueSet-v3-DiseaseProgram.md)
* [DispensableDrugForm](ValueSet-v3-DispensableDrugForm.md)
* [Dissolve](ValueSet-v3-Dissolve.md)
* [DocumentCompletion](ValueSet-v3-DocumentCompletion.md)
* [DocumentSectionType](ValueSet-v3-DocumentSectionType.md)
* [DocumentStorage](ValueSet-v3-DocumentStorage.md)
* [DocumentStorageActive](ValueSet-v3-DocumentStorageActive.md)
* [DosageProblem](ValueSet-v3-DosageProblem.md)
* [DosageProblemDetectedIssueCode](ValueSet-v3-DosageProblemDetectedIssueCode.md)
* [DoseDurationDetectedIssueCode](ValueSet-v3-DoseDurationDetectedIssueCode.md)
* [DoseDurationHighDetectedIssueCode](ValueSet-v3-DoseDurationHighDetectedIssueCode.md)
* [DoseDurationLowDetectedIssueCode](ValueSet-v3-DoseDurationLowDetectedIssueCode.md)
* [DoseHighDetectedIssueCode](ValueSet-v3-DoseHighDetectedIssueCode.md)
* [DoseIntervalDetectedIssueCode](ValueSet-v3-DoseIntervalDetectedIssueCode.md)
* [DoseLowDetectedIssueCode](ValueSet-v3-DoseLowDetectedIssueCode.md)
* [Douche](ValueSet-v3-Douche.md)
* [DropsDrugForm](ValueSet-v3-DropsDrugForm.md)
* [Drug Entity](ValueSet-v3-DrugEntity.md)
* [DuplicateTherapyAlert](ValueSet-v3-DuplicateTherapyAlert.md)
* [ECGObservationSeriesType](ValueSet-v3-ECGObservationSeriesType.md)
* [EPSG-GeodeticParameterDataset](ValueSet-v3-EPSG-GeodeticParameterDataset.md)
* [ERPracticeSetting](ValueSet-v3-ERPracticeSetting.md)
* [EasternAlgonquin](ValueSet-v3-EasternAlgonquin.md)
* [EasternApachean](ValueSet-v3-EasternApachean.md)
* [EasternMiwok](ValueSet-v3-EasternMiwok.md)
* [EducationLevel](ValueSet-v3-EducationLevel.md)
* [ElectroOsmosisRoute](ValueSet-v3-ElectroOsmosisRoute.md)
* [EligibilityActReasonCode](ValueSet-v3-EligibilityActReasonCode.md)
* [EmergencyMedicalServiceProviderHIPAA](ValueSet-v3-EmergencyMedicalServiceProviderHIPAA.md)
* [EmergencyPharmacySupplyType](ValueSet-v3-EmergencyPharmacySupplyType.md)
* [EmployeeJobClass](ValueSet-v3-EmployeeJobClass.md)
* [EmploymentStatusUB92](ValueSet-v3-EmploymentStatusUB92.md)
* [EncounterAdmissionSource](ValueSet-v3-EncounterAdmissionSource.md)
* [EncounterSpecialCourtesy](ValueSet-v3-EncounterSpecialCourtesy.md)
* [EndocervicalRoute](ValueSet-v3-EndocervicalRoute.md)
* [EndocrinologyClinic](ValueSet-v3-EndocrinologyClinic.md)
* [Enema](ValueSet-v3-Enema.md)
* [EnteralRoute](ValueSet-v3-EnteralRoute.md)
* [EntericCoatedCapsule](ValueSet-v3-EntericCoatedCapsule.md)
* [EntericCoatedTablet](ValueSet-v3-EntericCoatedTablet.md)
* [EntityClass](ValueSet-v3-EntityClass.md)
* [EntityClassAnimal](ValueSet-v3-EntityClassAnimal.md)
* [EntityClassCertificateRepresentation](ValueSet-v3-EntityClassCertificateRepresentation.md)
* [EntityClassChemicalSubstance](ValueSet-v3-EntityClassChemicalSubstance.md)
* [EntityClassCityOrTown](ValueSet-v3-EntityClassCityOrTown.md)
* [EntityClassContainer](ValueSet-v3-EntityClassContainer.md)
* [EntityClassCountry](ValueSet-v3-EntityClassCountry.md)
* [EntityClassCountyOrParish](ValueSet-v3-EntityClassCountyOrParish.md)
* [EntityClassDevice](ValueSet-v3-EntityClassDevice.md)
* [EntityClassFood](ValueSet-v3-EntityClassFood.md)
* [EntityClassGroup](ValueSet-v3-EntityClassGroup.md)
* [EntityClassHealthChartEntity](ValueSet-v3-EntityClassHealthChartEntity.md)
* [EntityClassHolder](ValueSet-v3-EntityClassHolder.md)
* [EntityClassImagingModality](ValueSet-v3-EntityClassImagingModality.md)
* [EntityClassLivingSubject](ValueSet-v3-EntityClassLivingSubject.md)
* [EntityClassManufacturedMaterial](ValueSet-v3-EntityClassManufacturedMaterial.md)
* [EntityClassMaterial](ValueSet-v3-EntityClassMaterial.md)
* [EntityClassMicroorganism](ValueSet-v3-EntityClassMicroorganism.md)
* [EntityClassNation](ValueSet-v3-EntityClassNation.md)
* [EntityClassNonPersonLivingSubject](ValueSet-v3-EntityClassNonPersonLivingSubject.md)
* [EntityClassOrganization](ValueSet-v3-EntityClassOrganization.md)
* [EntityClassPerson](ValueSet-v3-EntityClassPerson.md)
* [EntityClassPlace](ValueSet-v3-EntityClassPlace.md)
* [EntityClassPlant](ValueSet-v3-EntityClassPlant.md)
* [EntityClassPublicInstitution](ValueSet-v3-EntityClassPublicInstitution.md)
* [EntityClassRoot](ValueSet-v3-EntityClassRoot.md)
* [EntityClassState](ValueSet-v3-EntityClassState.md)
* [EntityClassStateOrProvince](ValueSet-v3-EntityClassStateOrProvince.md)
* [EntityCode](ValueSet-v3-EntityCode.md)
* [EntityDeterminer](ValueSet-v3-EntityDeterminer.md)
* [EntityDeterminerDescribedGroup](ValueSet-v3-EntityDeterminerDescribedGroup.md)
* [EntityDeterminerDescribedQuantified](ValueSet-v3-EntityDeterminerDescribedQuantified.md)
* [EntityDeterminerDetermined](ValueSet-v3-EntityDeterminerDetermined.md)
* [EntityDeterminerSpecific](ValueSet-v3-EntityDeterminerSpecific.md)
* [EntityDeterminerSpecificGroup](ValueSet-v3-EntityDeterminerSpecificGroup.md)
* [EntityHandling](ValueSet-v3-EntityHandling.md)
* [EntityInformationSensitivityPolicy](ValueSet-v3-EntityInformationSensitivityPolicy.md)
* [EntityNamePartQualifier](ValueSet-v3-EntityNamePartQualifier.md)
* [EntityNamePartQualifierR2](ValueSet-v3-EntityNamePartQualifierR2.md)
* [EntityNamePartType](ValueSet-v3-EntityNamePartType.md)
* [EntityNamePartTypeR2](ValueSet-v3-EntityNamePartTypeR2.md)
* [EntityNameUse](ValueSet-v3-EntityNameUse.md)
* [EntityNameUseR2](ValueSet-v3-EntityNameUseR2.md)
* [EntityRisk](ValueSet-v3-EntityRisk.md)
* [EntityStatus](ValueSet-v3-EntityStatus.md)
* [EntityStatusActive](ValueSet-v3-EntityStatusActive.md)
* [EntityStatusInactive](ValueSet-v3-EntityStatusInactive.md)
* [EntityStatusNormal](ValueSet-v3-EntityStatusNormal.md)
* [EntityStatusNullified](ValueSet-v3-EntityStatusNullified.md)
* [EpiduralRoute](ValueSet-v3-EpiduralRoute.md)
* [EquipmentAlertLevel](ValueSet-v3-EquipmentAlertLevel.md)
* [EskimoAleut](ValueSet-v3-EskimoAleut.md)
* [Eskimoan](ValueSet-v3-Eskimoan.md)
* [Ethnicity](ValueSet-v3-Ethnicity.md)
* [EthnicityHispanic](ValueSet-v3-EthnicityHispanic.md)
* [EthnicityHispanicCentralAmerican](ValueSet-v3-EthnicityHispanicCentralAmerican.md)
* [EthnicityHispanicMexican](ValueSet-v3-EthnicityHispanicMexican.md)
* [EthnicityHispanicSouthAmerican](ValueSet-v3-EthnicityHispanicSouthAmerican.md)
* [EthnicityHispanicSpaniard](ValueSet-v3-EthnicityHispanicSpaniard.md)
* [ExpectedSubset](ValueSet-v3-ExpectedSubset.md)
* [ExposureMode](ValueSet-v3-ExposureMode.md)
* [ExtendedReleaseCapsule](ValueSet-v3-ExtendedReleaseCapsule.md)
* [ExtendedReleaseSuspension](ValueSet-v3-ExtendedReleaseSuspension.md)
* [ExtendedReleaseTablet](ValueSet-v3-ExtendedReleaseTablet.md)
* [ExtraAmnioticRoute](ValueSet-v3-ExtraAmnioticRoute.md)
* [ExtracorporealCirculationRoute](ValueSet-v3-ExtracorporealCirculationRoute.md)
* [FamilyMember](ValueSet-v3-FamilyMember.md)
* [FirstFillPharmacySupplyType](ValueSet-v3-FirstFillPharmacySupplyType.md)
* [Flush](ValueSet-v3-Flush.md)
* [FoamDrugForm](ValueSet-v3-FoamDrugForm.md)
* [FontStyle](ValueSet-v3-FontStyle.md)
* [FosterChild](ValueSet-v3-FosterChild.md)
* [GIClinicPracticeSetting](ValueSet-v3-GIClinicPracticeSetting.md)
* [GIDiagTherPracticeSetting](ValueSet-v3-GIDiagTherPracticeSetting.md)
* [GTIN](ValueSet-v3-GTIN.md)
* [GTSAbbreviation](ValueSet-v3-GTSAbbreviation.md)
* [GTSAbbreviationBase](ValueSet-v3-GTSAbbreviationBase.md)
* [GTSAbbreviationHolidays](ValueSet-v3-GTSAbbreviationHolidays.md)
* [GTSAbbreviationHolidaysChristianRoman](ValueSet-v3-GTSAbbreviationHolidaysChristianRoman.md)
* [GTSAbbreviationHolidaysUSNational](ValueSet-v3-GTSAbbreviationHolidaysUSNational.md)
* [GTSAbbreviationOther](ValueSet-v3-GTSAbbreviationOther.md)
* [GasDrugForm](ValueSet-v3-GasDrugForm.md)
* [GasLiquidMixture](ValueSet-v3-GasLiquidMixture.md)
* [GasSolidSpray](ValueSet-v3-GasSolidSpray.md)
* [GastricRoute](ValueSet-v3-GastricRoute.md)
* [GelDrugForm](ValueSet-v3-GelDrugForm.md)
* [GenderStatus](ValueSet-v3-GenderStatus.md)
* [GeneralAcuteCareHospital](ValueSet-v3-GeneralAcuteCareHospital.md)
* [GeneralAddressUse](ValueSet-v3-GeneralAddressUse.md)
* [GeneralPurposeOfUse](ValueSet-v3-GeneralPurposeOfUse.md)
* [GenericUpdateReasonCode](ValueSet-v3-GenericUpdateReasonCode.md)
* [GeneticObservationInterpretation](ValueSet-v3-GeneticObservationInterpretation.md)
* [GeneticObservationMethod](ValueSet-v3-GeneticObservationMethod.md)
* [GeneticObservationType](ValueSet-v3-GeneticObservationType.md)
* [GeneticObservationValue](ValueSet-v3-GeneticObservationValue.md)
* [GenitourinaryRoute](ValueSet-v3-GenitourinaryRoute.md)
* [GingivalRoute](ValueSet-v3-GingivalRoute.md)
* [GrandChild](ValueSet-v3-GrandChild.md)
* [Grandparent](ValueSet-v3-Grandparent.md)
* [GreatGrandparent](ValueSet-v3-GreatGrandparent.md)
* [GregorianCalendarCycle](ValueSet-v3-GregorianCalendarCycle.md)
* [HL7AccommodationCode](ValueSet-v3-HL7AccommodationCode.md)
* [HL7CalendarCycle](ValueSet-v3-HL7CalendarCycle.md)
* [HL7 ValueSet of Format Codes for use with Document Sharing](ValueSet-v3-HL7FormatCodes.md)
* [HL7ITSVersionCode](ValueSet-v3-HL7ITSVersionCode.md)
* [HL7SearchUse](ValueSet-v3-HL7SearchUse.md)
* [HL7StandardVersionCode](ValueSet-v3-HL7StandardVersionCode.md)
* [HL7UpdateMode](ValueSet-v3-HL7UpdateMode.md)
* [HairRoute](ValueSet-v3-HairRoute.md)
* [HalfSibling](ValueSet-v3-HalfSibling.md)
* [HealthCareCommonProcedureCodingSystem](ValueSet-v3-HealthCareCommonProcedureCodingSystem.md)
* [HealthQualityMeasureDocument](ValueSet-v3-HealthQualityMeasureDocument.md)
* [HealthcareServiceLocation](ValueSet-v3-HealthcareServiceLocation.md)
* [HeightSurfaceAreaAlert](ValueSet-v3-HeightSurfaceAreaAlert.md)
* [HemClinPracticeSetting](ValueSet-v3-HemClinPracticeSetting.md)
* [Hokan](ValueSet-v3-Hokan.md)
* [HomeAddress](ValueSet-v3-HomeAddress.md)
* [Homeless](ValueSet-v3-Homeless.md)
* [HospitalPracticeSetting](ValueSet-v3-HospitalPracticeSetting.md)
* [HospitalUnitPracticeSetting](ValueSet-v3-HospitalUnitPracticeSetting.md)
* [HtmlLinkType](ValueSet-v3-HtmlLinkType.md)
* [HumanActSite](ValueSet-v3-HumanActSite.md)
* [HumanLanguage](ValueSet-v3-HumanLanguage.md)
* [HumanSubstanceAdministrationSite](ValueSet-v3-HumanSubstanceAdministrationSite.md)
* [ICUPracticeSetting](ValueSet-v3-ICUPracticeSetting.md)
* [IDClinPracticeSetting](ValueSet-v3-IDClinPracticeSetting.md)
* [IdentifierReliability](ValueSet-v3-IdentifierReliability.md)
* [IdentifierScope](ValueSet-v3-IdentifierScope.md)
* [ImageMediaType](ValueSet-v3-ImageMediaType.md)
* [ImmunizationObservationType](ValueSet-v3-ImmunizationObservationType.md)
* [Implantation](ValueSet-v3-Implantation.md)
* [IncidentalServiceDeliveryLocationRoleType](ValueSet-v3-IncidentalServiceDeliveryLocationRoleType.md)
* [IndividualCaseSafetyReportType](ValueSet-v3-IndividualCaseSafetyReportType.md)
* [IndividualInsuredCoveredPartyRoleType](ValueSet-v3-IndividualInsuredCoveredPartyRoleType.md)
* [IndividualPackageEntityType](ValueSet-v3-IndividualPackageEntityType.md)
* [IndustryClassificationSystem](ValueSet-v3-IndustryClassificationSystem.md)
* [InformationSensitivityPolicy](ValueSet-v3-InformationSensitivityPolicy.md)
* [Infusion](ValueSet-v3-Infusion.md)
* [InhalantDrugForm](ValueSet-v3-InhalantDrugForm.md)
* [Inhalation](ValueSet-v3-Inhalation.md)
* [InhalerMedicalDevice](ValueSet-v3-InhalerMedicalDevice.md)
* [Injection](ValueSet-v3-Injection.md)
* [InjectionMedicalDevice](ValueSet-v3-InjectionMedicalDevice.md)
* [Insertion](ValueSet-v3-Insertion.md)
* [Instillation](ValueSet-v3-Instillation.md)
* [Institution](ValueSet-v3-Institution.md)
* [IntegrityCheckAlgorithm](ValueSet-v3-IntegrityCheckAlgorithm.md)
* [InteractionDetectedIssueCode](ValueSet-v3-InteractionDetectedIssueCode.md)
* [InterameningealRoute](ValueSet-v3-InterameningealRoute.md)
* [InteriorSalish](ValueSet-v3-InteriorSalish.md)
* [InterstitialRoute](ValueSet-v3-InterstitialRoute.md)
* [IntraabdominalRoute](ValueSet-v3-IntraabdominalRoute.md)
* [IntraarterialInjection](ValueSet-v3-IntraarterialInjection.md)
* [IntraarterialRoute](ValueSet-v3-IntraarterialRoute.md)
* [IntraarticularRoute](ValueSet-v3-IntraarticularRoute.md)
* [IntrabronchialRoute](ValueSet-v3-IntrabronchialRoute.md)
* [IntrabursalRoute](ValueSet-v3-IntrabursalRoute.md)
* [IntracardiacInjection](ValueSet-v3-IntracardiacInjection.md)
* [IntracardiacRoute](ValueSet-v3-IntracardiacRoute.md)
* [IntracartilaginousRoute](ValueSet-v3-IntracartilaginousRoute.md)
* [IntracaudalRoute](ValueSet-v3-IntracaudalRoute.md)
* [IntracavernosalRoute](ValueSet-v3-IntracavernosalRoute.md)
* [IntracavitaryRoute](ValueSet-v3-IntracavitaryRoute.md)
* [IntracerebralRoute](ValueSet-v3-IntracerebralRoute.md)
* [IntracervicalRoute](ValueSet-v3-IntracervicalRoute.md)
* [IntracisternalRoute](ValueSet-v3-IntracisternalRoute.md)
* [IntracornealRoute](ValueSet-v3-IntracornealRoute.md)
* [IntracoronalRoute](ValueSet-v3-IntracoronalRoute.md)
* [IntracoronaryInjection](ValueSet-v3-IntracoronaryInjection.md)
* [IntracoronaryRoute](ValueSet-v3-IntracoronaryRoute.md)
* [IntracorpusCavernosumRoute](ValueSet-v3-IntracorpusCavernosumRoute.md)
* [IntradermalRoute](ValueSet-v3-IntradermalRoute.md)
* [IntradiscalRoute](ValueSet-v3-IntradiscalRoute.md)
* [IntraductalRoute](ValueSet-v3-IntraductalRoute.md)
* [IntraduodenalRoute](ValueSet-v3-IntraduodenalRoute.md)
* [IntraduralRoute](ValueSet-v3-IntraduralRoute.md)
* [IntraepidermalRoute](ValueSet-v3-IntraepidermalRoute.md)
* [IntraepithelialRoute](ValueSet-v3-IntraepithelialRoute.md)
* [IntraesophagealRoute](ValueSet-v3-IntraesophagealRoute.md)
* [IntragastricRoute](ValueSet-v3-IntragastricRoute.md)
* [IntrailealRoute](ValueSet-v3-IntrailealRoute.md)
* [IntralesionalRoute](ValueSet-v3-IntralesionalRoute.md)
* [IntraluminalRoute](ValueSet-v3-IntraluminalRoute.md)
* [IntralymphaticRoute](ValueSet-v3-IntralymphaticRoute.md)
* [IntramedullaryRoute](ValueSet-v3-IntramedullaryRoute.md)
* [IntramuscularInjection](ValueSet-v3-IntramuscularInjection.md)
* [IntramuscularRoute](ValueSet-v3-IntramuscularRoute.md)
* [IntraocularRoute](ValueSet-v3-IntraocularRoute.md)
* [IntraosseousRoute](ValueSet-v3-IntraosseousRoute.md)
* [IntraovarianRoute](ValueSet-v3-IntraovarianRoute.md)
* [IntrapericardialRoute](ValueSet-v3-IntrapericardialRoute.md)
* [IntraperitonealRoute](ValueSet-v3-IntraperitonealRoute.md)
* [IntrapleuralRoute](ValueSet-v3-IntrapleuralRoute.md)
* [IntraprostaticRoute](ValueSet-v3-IntraprostaticRoute.md)
* [IntrapulmonaryRoute](ValueSet-v3-IntrapulmonaryRoute.md)
* [IntrasinalRoute](ValueSet-v3-IntrasinalRoute.md)
* [IntraspinalRoute](ValueSet-v3-IntraspinalRoute.md)
* [IntrasternalRoute](ValueSet-v3-IntrasternalRoute.md)
* [IntrasynovialRoute](ValueSet-v3-IntrasynovialRoute.md)
* [IntratendinousRoute](ValueSet-v3-IntratendinousRoute.md)
* [IntratesticularRoute](ValueSet-v3-IntratesticularRoute.md)
* [IntrathecalRoute](ValueSet-v3-IntrathecalRoute.md)
* [IntrathoracicRoute](ValueSet-v3-IntrathoracicRoute.md)
* [IntratrachealRoute](ValueSet-v3-IntratrachealRoute.md)
* [IntratubularRoute](ValueSet-v3-IntratubularRoute.md)
* [IntratumorRoute](ValueSet-v3-IntratumorRoute.md)
* [IntratympanicRoute](ValueSet-v3-IntratympanicRoute.md)
* [IntrauterineRoute](ValueSet-v3-IntrauterineRoute.md)
* [IntravascularRoute](ValueSet-v3-IntravascularRoute.md)
* [IntravenousInfusion](ValueSet-v3-IntravenousInfusion.md)
* [IntravenousInjection](ValueSet-v3-IntravenousInjection.md)
* [IntravenousRoute](ValueSet-v3-IntravenousRoute.md)
* [IntraventricularRoute](ValueSet-v3-IntraventricularRoute.md)
* [IntravesicleRoute](ValueSet-v3-IntravesicleRoute.md)
* [IntravitrealRoute](ValueSet-v3-IntravitrealRoute.md)
* [InuitInupiaq](ValueSet-v3-InuitInupiaq.md)
* [InvoiceElementAdjudicated](ValueSet-v3-InvoiceElementAdjudicated.md)
* [InvoiceElementPaid](ValueSet-v3-InvoiceElementPaid.md)
* [InvoiceElementSubmitted](ValueSet-v3-InvoiceElementSubmitted.md)
* [IontophoresisRoute](ValueSet-v3-IontophoresisRoute.md)
* [Iroquoian](ValueSet-v3-Iroquoian.md)
* [Irrigation](ValueSet-v3-Irrigation.md)
* [IrrigationSolution](ValueSet-v3-IrrigationSolution.md)
* [IssueFilterCode](ValueSet-v3-IssueFilterCode.md)
* [JejunumRoute](ValueSet-v3-JejunumRoute.md)
* [Kalapuyan](ValueSet-v3-Kalapuyan.md)
* [Keresan](ValueSet-v3-Keresan.md)
* [KiowaTanoan](ValueSet-v3-KiowaTanoan.md)
* [KitEntityType](ValueSet-v3-KitEntityType.md)
* [KnowledgeSubjectObservationCode](ValueSet-v3-KnowledgeSubjectObservationCode.md)
* [KnowledgeSubjectObservationValue](ValueSet-v3-KnowledgeSubjectObservationValue.md)
* [KnowledgeSubtopicObservationCode](ValueSet-v3-KnowledgeSubtopicObservationCode.md)
* [KnowledgeSubtopicObservationValue](ValueSet-v3-KnowledgeSubtopicObservationValue.md)
* [KoyukonIngalik](ValueSet-v3-KoyukonIngalik.md)
* [KutchinHan](ValueSet-v3-KutchinHan.md)
* [LOINCObservationActContextAgeDefinitionCode](ValueSet-v3-LOINCObservationActContextAgeDefinitionCode.md)
* [LOINCObservationActContextAgeType](ValueSet-v3-LOINCObservationActContextAgeType.md)
* [LabResultReportingProcessStepCode](ValueSet-v3-LabResultReportingProcessStepCode.md)
* [LabResultTriggerEvents](ValueSet-v3-LabResultTriggerEvents.md)
* [LabSpecimenCollectionProviders](ValueSet-v3-LabSpecimenCollectionProviders.md)
* [Laboratory Observation Sub-Type](ValueSet-v3-LaboratoryObservationSubtype.md)
* [LacrimalPunctaRoute](ValueSet-v3-LacrimalPunctaRoute.md)
* [LanguageAbilityMode](ValueSet-v3-LanguageAbilityMode.md)
* [LanguageAbilityProficiency](ValueSet-v3-LanguageAbilityProficiency.md)
* [LaryngealRoute](ValueSet-v3-LaryngealRoute.md)
* [LavageRoute](ValueSet-v3-LavageRoute.md)
* [LengthOutOfRange](ValueSet-v3-LengthOutOfRange.md)
* [LifeInsurancePolicy](ValueSet-v3-LifeInsurancePolicy.md)
* [LineAccessMedicalDevice](ValueSet-v3-LineAccessMedicalDevice.md)
* [LingualRoute](ValueSet-v3-LingualRoute.md)
* [Liquid](ValueSet-v3-Liquid.md)
* [LiquidCleanser](ValueSet-v3-LiquidCleanser.md)
* [LiquidLiquidEmulsion](ValueSet-v3-LiquidLiquidEmulsion.md)
* [LiquidSolidSuspension](ValueSet-v3-LiquidSolidSuspension.md)
* [ListStyle](ValueSet-v3-ListStyle.md)
* [LivingArrangement](ValueSet-v3-LivingArrangement.md)
* [LivingSubjectProductionClass](ValueSet-v3-LivingSubjectProductionClass.md)
* [Loan](ValueSet-v3-Loan.md)
* [LocalMarkupIgnore](ValueSet-v3-LocalMarkupIgnore.md)
* [LocalRemoteControlState](ValueSet-v3-LocalRemoteControlState.md)
* [LogicalObservationIdentifierNamesAndCodes](ValueSet-v3-LogicalObservationIdentifierNamesAndCodes.md)
* [LoincDocumentOntologyInternational](ValueSet-v3-LoincDocumentOntologyInternational.md)
* [LotionDrugForm](ValueSet-v3-LotionDrugForm.md)
* [Maiduan](ValueSet-v3-Maiduan.md)
* [ManagedCarePolicy](ValueSet-v3-ManagedCarePolicy.md)
* [ManagedParticipationStatus](ValueSet-v3-ManagedParticipationStatus.md)
* [ManagedParticipationStatusActive](ValueSet-v3-ManagedParticipationStatusActive.md)
* [ManagedParticipationStatusCancelled](ValueSet-v3-ManagedParticipationStatusCancelled.md)
* [ManagedParticipationStatusCompleted](ValueSet-v3-ManagedParticipationStatusCompleted.md)
* [ManagedParticipationStatusNormal](ValueSet-v3-ManagedParticipationStatusNormal.md)
* [ManagedParticipationStatusNullified](ValueSet-v3-ManagedParticipationStatusNullified.md)
* [ManagedParticipationStatusPending](ValueSet-v3-ManagedParticipationStatusPending.md)
* [Manufacturer Model Name Example](ValueSet-v3-ManufacturerModelNameExample.md)
* [MapRelationship](ValueSet-v3-MapRelationship.md)
* [MaritalStatus](ValueSet-v3-MaritalStatus.md)
* [MaterialDangerInfectious](ValueSet-v3-MaterialDangerInfectious.md)
* [MaterialDangerInflammable](ValueSet-v3-MaterialDangerInflammable.md)
* [MaterialEntityClassType](ValueSet-v3-MaterialEntityClassType.md)
* [MedOncClinPracticeSetting](ValueSet-v3-MedOncClinPracticeSetting.md)
* [MediaType](ValueSet-v3-MediaType.md)
* [MedicalDevice](ValueSet-v3-MedicalDevice.md)
* [MedicationCap](ValueSet-v3-MedicationCap.md)
* [MedicationGeneralizationRoleType](ValueSet-v3-MedicationGeneralizationRoleType.md)
* [MedicationObservationType](ValueSet-v3-MedicationObservationType.md)
* [MedicationOrderAbortReasonCode](ValueSet-v3-MedicationOrderAbortReasonCode.md)
* [MedicationOrderReleaseReasonCode](ValueSet-v3-MedicationOrderReleaseReasonCode.md)
* [MemberRoleType](ValueSet-v3-MemberRoleType.md)
* [MessageWaitingPriority](ValueSet-v3-MessageWaitingPriority.md)
* [MilitaryHospital](ValueSet-v3-MilitaryHospital.md)
* [MilitaryRoleType](ValueSet-v3-MilitaryRoleType.md)
* [MississippiValley](ValueSet-v3-MississippiValley.md)
* [MissouriRiver](ValueSet-v3-MissouriRiver.md)
* [Miwokan](ValueSet-v3-Miwokan.md)
* [MobileUnit](ValueSet-v3-MobileUnit.md)
* [MobilityImpaired](ValueSet-v3-MobilityImpaired.md)
* [ModelMediaType](ValueSet-v3-ModelMediaType.md)
* [ModifyIndicator](ValueSet-v3-ModifyIndicator.md)
* [ModifyPrescriptionReasonType](ValueSet-v3-ModifyPrescriptionReasonType.md)
* [MucosalAbsorptionRoute](ValueSet-v3-MucosalAbsorptionRoute.md)
* [MucousMembraneRoute](ValueSet-v3-MucousMembraneRoute.md)
* [MultiUseContainerEntityType](ValueSet-v3-MultiUseContainerEntityType.md)
* [MultipartMediaType](ValueSet-v3-MultipartMediaType.md)
* [Muskogean](ValueSet-v3-Muskogean.md)
* [NUCCProviderCodes](ValueSet-v3-NUCCProviderCodes.md)
* [Nadene](ValueSet-v3-Nadene.md)
* [NailRoute](ValueSet-v3-NailRoute.md)
* [NameLegalUse](ValueSet-v3-NameLegalUse.md)
* [NasalInhalation](ValueSet-v3-NasalInhalation.md)
* [NasalRoute](ValueSet-v3-NasalRoute.md)
* [NationEntityType](ValueSet-v3-NationEntityType.md)
* [NativeEntityAlaska](ValueSet-v3-NativeEntityAlaska.md)
* [NativeEntityContiguous](ValueSet-v3-NativeEntityContiguous.md)
* [NaturalChild](ValueSet-v3-NaturalChild.md)
* [NaturalParent](ValueSet-v3-NaturalParent.md)
* [NaturalSibling](ValueSet-v3-NaturalSibling.md)
* [Nebulization](ValueSet-v3-Nebulization.md)
* [NebulizationInhalation](ValueSet-v3-NebulizationInhalation.md)
* [NephClinPracticeSetting](ValueSet-v3-NephClinPracticeSetting.md)
* [NieceNephew](ValueSet-v3-NieceNephew.md)
* [NoInformation](ValueSet-v3-NoInformation.md)
* [NonDrugAgentEntity](ValueSet-v3-NonDrugAgentEntity.md)
* [NonRigidContainerEntityType](ValueSet-v3-NonRigidContainerEntityType.md)
* [Nootkan](ValueSet-v3-Nootkan.md)
* [NorthernCaddoan](ValueSet-v3-NorthernCaddoan.md)
* [NorthernIroquoian](ValueSet-v3-NorthernIroquoian.md)
* [NullFlavor](ValueSet-v3-NullFlavor.md)
* [Numic](ValueSet-v3-Numic.md)
* [NursingOrCustodialCarePracticeSetting](ValueSet-v3-NursingOrCustodialCarePracticeSetting.md)
* [ObligationPolicy](ValueSet-v3-ObligationPolicy.md)
* [ObservationActContextAgeGroupType](ValueSet-v3-ObservationActContextAgeGroupType.md)
* [ObservationActContextAgeType](ValueSet-v3-ObservationActContextAgeType.md)
* [ObservationAlert](ValueSet-v3-ObservationAlert.md)
* [ObservationAllergyType](ValueSet-v3-ObservationAllergyType.md)
* [ObservationAssetValue](ValueSet-v3-ObservationAssetValue.md)
* [ObservationCategory](ValueSet-v3-ObservationCategory.md)
* [ObservationCoordinateAxisType](ValueSet-v3-ObservationCoordinateAxisType.md)
* [ObservationCoordinateSystemType](ValueSet-v3-ObservationCoordinateSystemType.md)
* [ObservationDetectedIssueCode](ValueSet-v3-ObservationDetectedIssueCode.md)
* [ObservationDiagnosisTypes](ValueSet-v3-ObservationDiagnosisTypes.md)
* [ObservationDrugIntoleranceType](ValueSet-v3-ObservationDrugIntoleranceType.md)
* [ObservationEligibilityIndicatorValue](ValueSet-v3-ObservationEligibilityIndicatorValue.md)
* [ObservationEnvironmentalIntoleranceType](ValueSet-v3-ObservationEnvironmentalIntoleranceType.md)
* [ObservationFoodIntoleranceType](ValueSet-v3-ObservationFoodIntoleranceType.md)
* [ObservationHealthStatusValue](ValueSet-v3-ObservationHealthStatusValue.md)
* [ObservationIncomeValue](ValueSet-v3-ObservationIncomeValue.md)
* [ObservationInterpretation](ValueSet-v3-ObservationInterpretation.md)
* [ObservationInterpretationChange](ValueSet-v3-ObservationInterpretationChange.md)
* [ObservationInterpretationDetected](ValueSet-v3-ObservationInterpretationDetected.md)
* [ObservationInterpretationExceptions](ValueSet-v3-ObservationInterpretationExceptions.md)
* [ObservationInterpretationExpectation](ValueSet-v3-ObservationInterpretationExpectation.md)
* [ObservationInterpretationNormality](ValueSet-v3-ObservationInterpretationNormality.md)
* [ObservationInterpretationNormalityAbnormal](ValueSet-v3-ObservationInterpretationNormalityAbnormal.md)
* [ObservationInterpretationNormalityCriticallyAbnormal](ValueSet-v3-ObservationInterpretationNormalityCriticallyAbnormal.md)
* [ObservationInterpretationNormalityHigh](ValueSet-v3-ObservationInterpretationNormalityHigh.md)
* [ObservationInterpretationNormalityLow](ValueSet-v3-ObservationInterpretationNormalityLow.md)
* [ObservationInterpretationOustsideThreshold](ValueSet-v3-ObservationInterpretationOustsideThreshold.md)
* [ObservationInterpretationProtocolInclusion](ValueSet-v3-ObservationInterpretationProtocolInclusion.md)
* [ObservationInterpretationSusceptibility](ValueSet-v3-ObservationInterpretationSusceptibility.md)
* [ObservationIntoleranceType](ValueSet-v3-ObservationIntoleranceType.md)
* [ObservationIssueTriggerCodedObservationType](ValueSet-v3-ObservationIssueTriggerCodedObservationType.md)
* [ObservationLivingDependencyValue](ValueSet-v3-ObservationLivingDependencyValue.md)
* [ObservationLivingExpenseValue](ValueSet-v3-ObservationLivingExpenseValue.md)
* [ObservationLivingSituationValue](ValueSet-v3-ObservationLivingSituationValue.md)
* [ObservationMeasureCountableItems](ValueSet-v3-ObservationMeasureCountableItems.md)
* [ObservationMeasureScoring](ValueSet-v3-ObservationMeasureScoring.md)
* [ObservationMeasureType](ValueSet-v3-ObservationMeasureType.md)
* [ObservationMethod](ValueSet-v3-ObservationMethod.md)
* [ObservationMethodAggregate](ValueSet-v3-ObservationMethodAggregate.md)
* [ObservationNonAllergyIntoleranceType](ValueSet-v3-ObservationNonAllergyIntoleranceType.md)
* [ObservationPopulationInclusion](ValueSet-v3-ObservationPopulationInclusion.md)
* [ObservationQualityMeasureAttribute](ValueSet-v3-ObservationQualityMeasureAttribute.md)
* [ObservationSequenceType](ValueSet-v3-ObservationSequenceType.md)
* [ObservationSeriesType](ValueSet-v3-ObservationSeriesType.md)
* [ObservationSocioEconomicStatusValue](ValueSet-v3-ObservationSocioEconomicStatusValue.md)
* [ObservationType](ValueSet-v3-ObservationType.md)
* [OilDrugForm](ValueSet-v3-OilDrugForm.md)
* [OintmentDrugForm](ValueSet-v3-OintmentDrugForm.md)
* [Ojibwayan](ValueSet-v3-Ojibwayan.md)
* [OphthalmicRoute](ValueSet-v3-OphthalmicRoute.md)
* [OralCapsule](ValueSet-v3-OralCapsule.md)
* [OralInhalation](ValueSet-v3-OralInhalation.md)
* [OralRoute](ValueSet-v3-OralRoute.md)
* [OralSolution](ValueSet-v3-OralSolution.md)
* [OralSuspension](ValueSet-v3-OralSuspension.md)
* [OralTablet](ValueSet-v3-OralTablet.md)
* [OrderableDrugForm](ValueSet-v3-OrderableDrugForm.md)
* [OrderedListStyle](ValueSet-v3-OrderedListStyle.md)
* [OregonAthapaskan](ValueSet-v3-OregonAthapaskan.md)
* [OrganizationEntityType](ValueSet-v3-OrganizationEntityType.md)
* [OrganizationIndustryClassNAICS](ValueSet-v3-OrganizationIndustryClassNAICS.md)
* [OrganizationNamePartQualifier](ValueSet-v3-OrganizationNamePartQualifier.md)
* [OrganizationNameUse](ValueSet-v3-OrganizationNameUse.md)
* [OromucosalRoute](ValueSet-v3-OromucosalRoute.md)
* [OropharyngealRoute](ValueSet-v3-OropharyngealRoute.md)
* [OrthoClinPracticeSetting](ValueSet-v3-OrthoClinPracticeSetting.md)
* [Other](ValueSet-v3-Other.md)
* [OtherActionTakenManagementCode](ValueSet-v3-OtherActionTakenManagementCode.md)
* [OticRoute](ValueSet-v3-OticRoute.md)
* [OutpatientFacilityPracticeSetting](ValueSet-v3-OutpatientFacilityPracticeSetting.md)
* [OverriderParticipationFunction](ValueSet-v3-OverriderParticipationFunction.md)
* [PacificCoastAthapaskan](ValueSet-v3-PacificCoastAthapaskan.md)
* [PackageEntityType](ValueSet-v3-PackageEntityType.md)
* [PadDrugForm](ValueSet-v3-PadDrugForm.md)
* [Pai](ValueSet-v3-Pai.md)
* [Palaihnihan](ValueSet-v3-Palaihnihan.md)
* [ParanasalSinusesRoute](ValueSet-v3-ParanasalSinusesRoute.md)
* [Parent](ValueSet-v3-Parent.md)
* [ParentInLaw](ValueSet-v3-ParentInLaw.md)
* [ParenteralRoute](ValueSet-v3-ParenteralRoute.md)
* [PartialCompletionScale](ValueSet-v3-PartialCompletionScale.md)
* [ParticipationAdmitter](ValueSet-v3-ParticipationAdmitter.md)
* [ParticipationAnalyte](ValueSet-v3-ParticipationAnalyte.md)
* [ParticipationAncillary](ValueSet-v3-ParticipationAncillary.md)
* [ParticipationAttender](ValueSet-v3-ParticipationAttender.md)
* [ParticipationAuthenticator](ValueSet-v3-ParticipationAuthenticator.md)
* [ParticipationAuthorOriginator](ValueSet-v3-ParticipationAuthorOriginator.md)
* [ParticipationBaby](ValueSet-v3-ParticipationBaby.md)
* [ParticipationBeneficiary](ValueSet-v3-ParticipationBeneficiary.md)
* [ParticipationCallbackContact](ValueSet-v3-ParticipationCallbackContact.md)
* [ParticipationCatalyst](ValueSet-v3-ParticipationCatalyst.md)
* [ParticipationCausativeAgent](ValueSet-v3-ParticipationCausativeAgent.md)
* [ParticipationConsultant](ValueSet-v3-ParticipationConsultant.md)
* [ParticipationConsumable](ValueSet-v3-ParticipationConsumable.md)
* [ParticipationCoverageTarget](ValueSet-v3-ParticipationCoverageTarget.md)
* [ParticipationCustodian](ValueSet-v3-ParticipationCustodian.md)
* [ParticipationDataEntryPerson](ValueSet-v3-ParticipationDataEntryPerson.md)
* [ParticipationDestination](ValueSet-v3-ParticipationDestination.md)
* [ParticipationDischarger](ValueSet-v3-ParticipationDischarger.md)
* [ParticipationDistributor](ValueSet-v3-ParticipationDistributor.md)
* [ParticipationDonor](ValueSet-v3-ParticipationDonor.md)
* [ParticipationEntryLocation](ValueSet-v3-ParticipationEntryLocation.md)
* [ParticipationEscort](ValueSet-v3-ParticipationEscort.md)
* [ParticipationExposureagent](ValueSet-v3-ParticipationExposureagent.md)
* [ParticipationExposureparticipation](ValueSet-v3-ParticipationExposureparticipation.md)
* [ParticipationExposuresource](ValueSet-v3-ParticipationExposuresource.md)
* [ParticipationExposuretarget](ValueSet-v3-ParticipationExposuretarget.md)
* [ParticipationFunction](ValueSet-v3-ParticipationFunction.md)
* [ParticipationGuarantorParty](ValueSet-v3-ParticipationGuarantorParty.md)
* [ParticipationHolder](ValueSet-v3-ParticipationHolder.md)
* [ParticipationIndirectTarget](ValueSet-v3-ParticipationIndirectTarget.md)
* [ParticipationInformant](ValueSet-v3-ParticipationInformant.md)
* [ParticipationInformationGenerator](ValueSet-v3-ParticipationInformationGenerator.md)
* [ParticipationInformationRecipient](ValueSet-v3-ParticipationInformationRecipient.md)
* [ParticipationInformationTranscriber](ValueSet-v3-ParticipationInformationTranscriber.md)
* [ParticipationLegalAuthenticator](ValueSet-v3-ParticipationLegalAuthenticator.md)
* [ParticipationMode](ValueSet-v3-ParticipationMode.md)
* [ParticipationModeElectronicData](ValueSet-v3-ParticipationModeElectronicData.md)
* [ParticipationModeVerbal](ValueSet-v3-ParticipationModeVerbal.md)
* [ParticipationModeWritten](ValueSet-v3-ParticipationModeWritten.md)
* [ParticipationNon-reuseableDevice](ValueSet-v3-ParticipationNon-reuseableDevice.md)
* [ParticipationOrigin](ValueSet-v3-ParticipationOrigin.md)
* [ParticipationParticipation](ValueSet-v3-ParticipationParticipation.md)
* [ParticipationPhysicalPerformer](ValueSet-v3-ParticipationPhysicalPerformer.md)
* [ParticipationPrimaryInformationRecipient](ValueSet-v3-ParticipationPrimaryInformationRecipient.md)
* [ParticipationPrimaryPerformer](ValueSet-v3-ParticipationPrimaryPerformer.md)
* [ParticipationProduct](ValueSet-v3-ParticipationProduct.md)
* [ParticipationReceiver](ValueSet-v3-ParticipationReceiver.md)
* [ParticipationRecordTarget](ValueSet-v3-ParticipationRecordTarget.md)
* [ParticipationReferredBy](ValueSet-v3-ParticipationReferredBy.md)
* [ParticipationReferredTo](ValueSet-v3-ParticipationReferredTo.md)
* [ParticipationReferrer](ValueSet-v3-ParticipationReferrer.md)
* [ParticipationRemote](ValueSet-v3-ParticipationRemote.md)
* [ParticipationResponsibleParty](ValueSet-v3-ParticipationResponsibleParty.md)
* [ParticipationReusableDevice](ValueSet-v3-ParticipationReusableDevice.md)
* [ParticipationSecondaryPerformer](ValueSet-v3-ParticipationSecondaryPerformer.md)
* [ParticipationSignature](ValueSet-v3-ParticipationSignature.md)
* [ParticipationSpecimen](ValueSet-v3-ParticipationSpecimen.md)
* [ParticipationSubset](ValueSet-v3-ParticipationSubset.md)
* [ParticipationTargetDevice](ValueSet-v3-ParticipationTargetDevice.md)
* [ParticipationTargetDirect](ValueSet-v3-ParticipationTargetDirect.md)
* [ParticipationTargetLocation](ValueSet-v3-ParticipationTargetLocation.md)
* [ParticipationTargetSubject](ValueSet-v3-ParticipationTargetSubject.md)
* [ParticipationTracker](ValueSet-v3-ParticipationTracker.md)
* [ParticipationType](ValueSet-v3-ParticipationType.md)
* [ParticipationTypeCDASectionOverride](ValueSet-v3-ParticipationTypeCDASectionOverride.md)
* [ParticipationUgentNotificationContact](ValueSet-v3-ParticipationUgentNotificationContact.md)
* [ParticipationVerifier](ValueSet-v3-ParticipationVerifier.md)
* [ParticipationVia](ValueSet-v3-ParticipationVia.md)
* [ParticipationWitness](ValueSet-v3-ParticipationWitness.md)
* [PastSubset](ValueSet-v3-PastSubset.md)
* [PasteDrugForm](ValueSet-v3-PasteDrugForm.md)
* [PatchDrugForm](ValueSet-v3-PatchDrugForm.md)
* [PatientImmunizationRelatedObservationType](ValueSet-v3-PatientImmunizationRelatedObservationType.md)
* [PatientImportance](ValueSet-v3-PatientImportance.md)
* [PatientProfileQueryReasonCode](ValueSet-v3-PatientProfileQueryReasonCode.md)
* [PaymentTerms](ValueSet-v3-PaymentTerms.md)
* [PayorParticipationFunction](ValueSet-v3-PayorParticipationFunction.md)
* [PayorRoleType](ValueSet-v3-PayorRoleType.md)
* [PedsClinPracticeSetting](ValueSet-v3-PedsClinPracticeSetting.md)
* [PedsICUPracticeSetting](ValueSet-v3-PedsICUPracticeSetting.md)
* [PedsPracticeSetting](ValueSet-v3-PedsPracticeSetting.md)
* [Penutian](ValueSet-v3-Penutian.md)
* [PerianalRoute](ValueSet-v3-PerianalRoute.md)
* [PeriarticularRoute](ValueSet-v3-PeriarticularRoute.md)
* [PeriduralRoute](ValueSet-v3-PeriduralRoute.md)
* [PerinealRoute](ValueSet-v3-PerinealRoute.md)
* [PerineuralRoute](ValueSet-v3-PerineuralRoute.md)
* [PeriodontalRoute](ValueSet-v3-PeriodontalRoute.md)
* [PermanentDentition](ValueSet-v3-PermanentDentition.md)
* [PersonDisabilityType](ValueSet-v3-PersonDisabilityType.md)
* [PersonNameUse](ValueSet-v3-PersonNameUse.md)
* [PersonalAndLegalRelationshipRoleType](ValueSet-v3-PersonalAndLegalRelationshipRoleType.md)
* [PersonalRelationshipRoleType](ValueSet-v3-PersonalRelationshipRoleType.md)
* [PharmacistHIPAA](ValueSet-v3-PharmacistHIPAA.md)
* [PharmacySupplyEventAbortReason](ValueSet-v3-PharmacySupplyEventAbortReason.md)
* [PharmacySupplyEventStockReasonCode](ValueSet-v3-PharmacySupplyEventStockReasonCode.md)
* [PharmacySupplyRequestFulfillerRevisionRefusalReasonCode](ValueSet-v3-PharmacySupplyRequestFulfillerRevisionRefusalReasonCode.md)
* [PharmacySupplyRequestRenewalRefusalReasonCode](ValueSet-v3-PharmacySupplyRequestRenewalRefusalReasonCode.md)
* [Pidgin](ValueSet-v3-Pidgin.md)
* [PillDrugForm](ValueSet-v3-PillDrugForm.md)
* [PlaceEntityType](ValueSet-v3-PlaceEntityType.md)
* [PlasticBottleEntityType](ValueSet-v3-PlasticBottleEntityType.md)
* [PlateauPenutian](ValueSet-v3-PlateauPenutian.md)
* [PolicyOrProgramCoverageRoleType](ValueSet-v3-PolicyOrProgramCoverageRoleType.md)
* [Pomoan](ValueSet-v3-Pomoan.md)
* [PopulationInclusionObservationType](ValueSet-v3-PopulationInclusionObservationType.md)
* [PostalAddressUse](ValueSet-v3-PostalAddressUse.md)
* [PowderDrugForm](ValueSet-v3-PowderDrugForm.md)
* [PowerOfAttorney](ValueSet-v3-PowerOfAttorney.md)
* [PrescriptionDispenseFilterCode](ValueSet-v3-PrescriptionDispenseFilterCode.md)
* [PrimaryDentition](ValueSet-v3-PrimaryDentition.md)
* [PrivacyMark](ValueSet-v3-PrivacyMark.md)
* [PrivateResidence](ValueSet-v3-PrivateResidence.md)
* [ProbabilityDistributionType](ValueSet-v3-ProbabilityDistributionType.md)
* [ProcessingID](ValueSet-v3-ProcessingID.md)
* [ProcessingMode](ValueSet-v3-ProcessingMode.md)
* [ProgramEligibleCoveredPartyRoleType](ValueSet-v3-ProgramEligibleCoveredPartyRoleType.md)
* [ProvenanceEventCurrentState-AS](ValueSet-v3-ProvenanceEventCurrentState-AS.md)
* [ProvenanceEventCurrentState-DC](ValueSet-v3-ProvenanceEventCurrentState-DC.md)
* [ProvenanceEventCurrentState](ValueSet-v3-ProvenanceEventCurrentState.md)
* [PublicHealthcareProgram](ValueSet-v3-PublicHealthcareProgram.md)
* [PulmonaryRoute](ValueSet-v3-PulmonaryRoute.md)
* [PurposeOfUse](ValueSet-v3-PurposeOfUse.md)
* [QualityMeasureSectionType](ValueSet-v3-QualityMeasureSectionType.md)
* [QualitySpecimenRoleType](ValueSet-v3-QualitySpecimenRoleType.md)
* [QueryPriority](ValueSet-v3-QueryPriority.md)
* [QueryRequestLimit](ValueSet-v3-QueryRequestLimit.md)
* [QueryResponse](ValueSet-v3-QueryResponse.md)
* [QueryStatusCode](ValueSet-v3-QueryStatusCode.md)
* [ROIOverlayShape](ValueSet-v3-ROIOverlayShape.md)
* [Race](ValueSet-v3-Race.md)
* [RaceAfricanAmericanAfrican](ValueSet-v3-RaceAfricanAmericanAfrican.md)
* [RaceAlaskanIndian](ValueSet-v3-RaceAlaskanIndian.md)
* [RaceAlaskanIndianAthabascan](ValueSet-v3-RaceAlaskanIndianAthabascan.md)
* [RaceAlaskanNative](ValueSet-v3-RaceAlaskanNative.md)
* [RaceAlaskanNativeAleut](ValueSet-v3-RaceAlaskanNativeAleut.md)
* [RaceAlaskanNativeAleutAlutiiq](ValueSet-v3-RaceAlaskanNativeAleutAlutiiq.md)
* [RaceAlaskanNativeAleutBristolBay](ValueSet-v3-RaceAlaskanNativeAleutBristolBay.md)
* [RaceAlaskanNativeAleutChugach](ValueSet-v3-RaceAlaskanNativeAleutChugach.md)
* [RaceAlaskanNativeAleutKoniag](ValueSet-v3-RaceAlaskanNativeAleutKoniag.md)
* [RaceAlaskanNativeAleutUnangan](ValueSet-v3-RaceAlaskanNativeAleutUnangan.md)
* [RaceAlaskanNativeEskimo](ValueSet-v3-RaceAlaskanNativeEskimo.md)
* [RaceAlaskanNativeInupiatEskimo](ValueSet-v3-RaceAlaskanNativeInupiatEskimo.md)
* [RaceAlaskanNativeSiberianEskimo](ValueSet-v3-RaceAlaskanNativeSiberianEskimo.md)
* [RaceAlaskanNativeYupikEskimo](ValueSet-v3-RaceAlaskanNativeYupikEskimo.md)
* [RaceAmericanIndian](ValueSet-v3-RaceAmericanIndian.md)
* [RaceAmericanIndianApache](ValueSet-v3-RaceAmericanIndianApache.md)
* [RaceAmericanIndianArapaho](ValueSet-v3-RaceAmericanIndianArapaho.md)
* [RaceAmericanIndianAssiniboineSioux](ValueSet-v3-RaceAmericanIndianAssiniboineSioux.md)
* [RaceAmericanIndianCaddo](ValueSet-v3-RaceAmericanIndianCaddo.md)
* [RaceAmericanIndianCahuilla](ValueSet-v3-RaceAmericanIndianCahuilla.md)
* [RaceAmericanIndianCalifornia](ValueSet-v3-RaceAmericanIndianCalifornia.md)
* [RaceAmericanIndianChemakuan](ValueSet-v3-RaceAmericanIndianChemakuan.md)
* [RaceAmericanIndianCherokee](ValueSet-v3-RaceAmericanIndianCherokee.md)
* [RaceAmericanIndianCheyenne](ValueSet-v3-RaceAmericanIndianCheyenne.md)
* [RaceAmericanIndianChickahominy](ValueSet-v3-RaceAmericanIndianChickahominy.md)
* [RaceAmericanIndianChinook](ValueSet-v3-RaceAmericanIndianChinook.md)
* [RaceAmericanIndianChippewa](ValueSet-v3-RaceAmericanIndianChippewa.md)
* [RaceAmericanIndianChippewaCree](ValueSet-v3-RaceAmericanIndianChippewaCree.md)
* [RaceAmericanIndianChoctaw](ValueSet-v3-RaceAmericanIndianChoctaw.md)
* [RaceAmericanIndianChumash](ValueSet-v3-RaceAmericanIndianChumash.md)
* [RaceAmericanIndianComanche](ValueSet-v3-RaceAmericanIndianComanche.md)
* [RaceAmericanIndianCoushatta](ValueSet-v3-RaceAmericanIndianCoushatta.md)
* [RaceAmericanIndianCreek](ValueSet-v3-RaceAmericanIndianCreek.md)
* [RaceAmericanIndianCupeno](ValueSet-v3-RaceAmericanIndianCupeno.md)
* [RaceAmericanIndianDelaware](ValueSet-v3-RaceAmericanIndianDelaware.md)
* [RaceAmericanIndianDiegueno](ValueSet-v3-RaceAmericanIndianDiegueno.md)
* [RaceAmericanIndianEasternTribes](ValueSet-v3-RaceAmericanIndianEasternTribes.md)
* [RaceAmericanIndianGrosVentres](ValueSet-v3-RaceAmericanIndianGrosVentres.md)
* [RaceAmericanIndianHoopa](ValueSet-v3-RaceAmericanIndianHoopa.md)
* [RaceAmericanIndianIowa](ValueSet-v3-RaceAmericanIndianIowa.md)
* [RaceAmericanIndianIroquois](ValueSet-v3-RaceAmericanIndianIroquois.md)
* [RaceAmericanIndianKickapoo](ValueSet-v3-RaceAmericanIndianKickapoo.md)
* [RaceAmericanIndianKiowa](ValueSet-v3-RaceAmericanIndianKiowa.md)
* [RaceAmericanIndianKlallam](ValueSet-v3-RaceAmericanIndianKlallam.md)
* [RaceAmericanIndianLongIsland](ValueSet-v3-RaceAmericanIndianLongIsland.md)
* [RaceAmericanIndianLuiseno](ValueSet-v3-RaceAmericanIndianLuiseno.md)
* [RaceAmericanIndianMaidu](ValueSet-v3-RaceAmericanIndianMaidu.md)
* [RaceAmericanIndianMiami](ValueSet-v3-RaceAmericanIndianMiami.md)
* [RaceAmericanIndianMicmac](ValueSet-v3-RaceAmericanIndianMicmac.md)
* [RaceAmericanIndianNavajo](ValueSet-v3-RaceAmericanIndianNavajo.md)
* [RaceAmericanIndianNorthwestTribes](ValueSet-v3-RaceAmericanIndianNorthwestTribes.md)
* [RaceAmericanIndianOttawa](ValueSet-v3-RaceAmericanIndianOttawa.md)
* [RaceAmericanIndianPaiute](ValueSet-v3-RaceAmericanIndianPaiute.md)
* [RaceAmericanIndianPassamaquoddy](ValueSet-v3-RaceAmericanIndianPassamaquoddy.md)
* [RaceAmericanIndianPawnee](ValueSet-v3-RaceAmericanIndianPawnee.md)
* [RaceAmericanIndianPeoria](ValueSet-v3-RaceAmericanIndianPeoria.md)
* [RaceAmericanIndianPequot](ValueSet-v3-RaceAmericanIndianPequot.md)
* [RaceAmericanIndianPima](ValueSet-v3-RaceAmericanIndianPima.md)
* [RaceAmericanIndianPomo](ValueSet-v3-RaceAmericanIndianPomo.md)
* [RaceAmericanIndianPonca](ValueSet-v3-RaceAmericanIndianPonca.md)
* [RaceAmericanIndianPotawatomi](ValueSet-v3-RaceAmericanIndianPotawatomi.md)
* [RaceAmericanIndianPueblo](ValueSet-v3-RaceAmericanIndianPueblo.md)
* [RaceAmericanIndianPugetSoundSalish](ValueSet-v3-RaceAmericanIndianPugetSoundSalish.md)
* [RaceAmericanIndianSacFox](ValueSet-v3-RaceAmericanIndianSacFox.md)
* [RaceAmericanIndianSeminole](ValueSet-v3-RaceAmericanIndianSeminole.md)
* [RaceAmericanIndianSerrano](ValueSet-v3-RaceAmericanIndianSerrano.md)
* [RaceAmericanIndianShawnee](ValueSet-v3-RaceAmericanIndianShawnee.md)
* [RaceAmericanIndianShoshone](ValueSet-v3-RaceAmericanIndianShoshone.md)
* [RaceAmericanIndianShoshonePaiute](ValueSet-v3-RaceAmericanIndianShoshonePaiute.md)
* [RaceAmericanIndianSioux](ValueSet-v3-RaceAmericanIndianSioux.md)
* [RaceAmericanIndianTohonoOOdham](ValueSet-v3-RaceAmericanIndianTohonoOOdham.md)
* [RaceAmericanIndianUmpqua](ValueSet-v3-RaceAmericanIndianUmpqua.md)
* [RaceAmericanIndianUte](ValueSet-v3-RaceAmericanIndianUte.md)
* [RaceAmericanIndianWampanoag](ValueSet-v3-RaceAmericanIndianWampanoag.md)
* [RaceAmericanIndianWashoe](ValueSet-v3-RaceAmericanIndianWashoe.md)
* [RaceAmericanIndianWinnebago](ValueSet-v3-RaceAmericanIndianWinnebago.md)
* [RaceAmericanIndianYuman](ValueSet-v3-RaceAmericanIndianYuman.md)
* [RaceAmericanIndianYurok](ValueSet-v3-RaceAmericanIndianYurok.md)
* [RaceAsian](ValueSet-v3-RaceAsian.md)
* [RaceBlackOrAfricanAmerican](ValueSet-v3-RaceBlackOrAfricanAmerican.md)
* [RaceCanadianLatinIndian](ValueSet-v3-RaceCanadianLatinIndian.md)
* [RaceHawaiianOrPacificIsland](ValueSet-v3-RaceHawaiianOrPacificIsland.md)
* [RaceNativeAmerican](ValueSet-v3-RaceNativeAmerican.md)
* [RacePacificIslandMelanesian](ValueSet-v3-RacePacificIslandMelanesian.md)
* [RacePacificIslandMicronesian](ValueSet-v3-RacePacificIslandMicronesian.md)
* [RacePacificIslandPolynesian](ValueSet-v3-RacePacificIslandPolynesian.md)
* [RaceSoutheastAlaskanIndian](ValueSet-v3-RaceSoutheastAlaskanIndian.md)
* [RaceSoutheastAlaskanIndianTlingit](ValueSet-v3-RaceSoutheastAlaskanIndianTlingit.md)
* [RaceSoutheastAlaskanIndianTsimshian](ValueSet-v3-RaceSoutheastAlaskanIndianTsimshian.md)
* [RaceWhite](ValueSet-v3-RaceWhite.md)
* [RaceWhiteArab](ValueSet-v3-RaceWhiteArab.md)
* [RaceWhiteEuropean](ValueSet-v3-RaceWhiteEuropean.md)
* [RaceWhiteMiddleEast](ValueSet-v3-RaceWhiteMiddleEast.md)
* [RadDiagTherPracticeSetting](ValueSet-v3-RadDiagTherPracticeSetting.md)
* [ReactionDetectedIssueCode](ValueSet-v3-ReactionDetectedIssueCode.md)
* [ReactionParticipant](ValueSet-v3-ReactionParticipant.md)
* [ReactivityObservationInterpretation](ValueSet-v3-ReactivityObservationInterpretation.md)
* [RectalInstillation](ValueSet-v3-RectalInstillation.md)
* [RectalRoute](ValueSet-v3-RectalRoute.md)
* [RefillPharmacySupplyType](ValueSet-v3-RefillPharmacySupplyType.md)
* [RefrainPolicy](ValueSet-v3-RefrainPolicy.md)
* [RefusalReasonCode](ValueSet-v3-RefusalReasonCode.md)
* [RegulationPolicyActCode](ValueSet-v3-RegulationPolicyActCode.md)
* [RehabilitationHospital](ValueSet-v3-RehabilitationHospital.md)
* [RelatedReactionDetectedIssueCode](ValueSet-v3-RelatedReactionDetectedIssueCode.md)
* [RelationalOperator](ValueSet-v3-RelationalOperator.md)
* [RelationshipConjunction](ValueSet-v3-RelationshipConjunction.md)
* [ReligiousAffiliation](ValueSet-v3-ReligiousAffiliation.md)
* [RepetitionsOutOfRange](ValueSet-v3-RepetitionsOutOfRange.md)
* [ResearchSubjectRoleBasis](ValueSet-v3-ResearchSubjectRoleBasis.md)
* [ResidentialTreatmentPracticeSetting](ValueSet-v3-ResidentialTreatmentPracticeSetting.md)
* [ResourceGroupEntityType](ValueSet-v3-ResourceGroupEntityType.md)
* [RespiratoryTractRoute](ValueSet-v3-RespiratoryTractRoute.md)
* [ResponseLevel](ValueSet-v3-ResponseLevel.md)
* [ResponseModality](ValueSet-v3-ResponseModality.md)
* [ResponseMode](ValueSet-v3-ResponseMode.md)
* [ResponsibleParty](ValueSet-v3-ResponsibleParty.md)
* [RetrobulbarRoute](ValueSet-v3-RetrobulbarRoute.md)
* [RheumClinPracticeSetting](ValueSet-v3-RheumClinPracticeSetting.md)
* [RigidContainerEntityType](ValueSet-v3-RigidContainerEntityType.md)
* [Rinse](ValueSet-v3-Rinse.md)
* [Ritwan](ValueSet-v3-Ritwan.md)
* [River](ValueSet-v3-River.md)
* [RoleClass](ValueSet-v3-RoleClass.md)
* [RoleClassAccess](ValueSet-v3-RoleClassAccess.md)
* [RoleClassActiveIngredient](ValueSet-v3-RoleClassActiveIngredient.md)
* [RoleClassActiveIngredientBasis](ValueSet-v3-RoleClassActiveIngredientBasis.md)
* [RoleClassActiveIngredientMoietyBasis](ValueSet-v3-RoleClassActiveIngredientMoietyBasis.md)
* [RoleClassActiveIngredientReferenceBasis](ValueSet-v3-RoleClassActiveIngredientReferenceBasis.md)
* [RoleClassActiveMoiety](ValueSet-v3-RoleClassActiveMoiety.md)
* [RoleClassAdditive](ValueSet-v3-RoleClassAdditive.md)
* [RoleClassAdjacency](ValueSet-v3-RoleClassAdjacency.md)
* [RoleClassAdjuvant](ValueSet-v3-RoleClassAdjuvant.md)
* [RoleClassAdministerableMaterial](ValueSet-v3-RoleClassAdministerableMaterial.md)
* [RoleClassAffiliate](ValueSet-v3-RoleClassAffiliate.md)
* [RoleClassAgent](ValueSet-v3-RoleClassAgent.md)
* [RoleClassAliquot](ValueSet-v3-RoleClassAliquot.md)
* [RoleClassAssignedEntity](ValueSet-v3-RoleClassAssignedEntity.md)
* [RoleClassAssociative](ValueSet-v3-RoleClassAssociative.md)
* [RoleClassBase](ValueSet-v3-RoleClassBase.md)
* [RoleClassBirthplace](ValueSet-v3-RoleClassBirthplace.md)
* [RoleClassCaregiver](ValueSet-v3-RoleClassCaregiver.md)
* [RoleClassCaseSubject](ValueSet-v3-RoleClassCaseSubject.md)
* [RoleClassChild](ValueSet-v3-RoleClassChild.md)
* [RoleClassCitizen](ValueSet-v3-RoleClassCitizen.md)
* [RoleClassClaimant](ValueSet-v3-RoleClassClaimant.md)
* [RoleClassClinicalResearchInvestigator](ValueSet-v3-RoleClassClinicalResearchInvestigator.md)
* [RoleClassClinicalResearchSponsor](ValueSet-v3-RoleClassClinicalResearchSponsor.md)
* [RoleClassColorAdditive](ValueSet-v3-RoleClassColorAdditive.md)
* [RoleClassCommissioningParty](ValueSet-v3-RoleClassCommissioningParty.md)
* [RoleClassConnection](ValueSet-v3-RoleClassConnection.md)
* [RoleClassContact](ValueSet-v3-RoleClassContact.md)
* [RoleClassContactCode](ValueSet-v3-RoleClassContactCode.md)
* [RoleClassContaminantIngredient](ValueSet-v3-RoleClassContaminantIngredient.md)
* [RoleClassContent](ValueSet-v3-RoleClassContent.md)
* [RoleClassContinuity](ValueSet-v3-RoleClassContinuity.md)
* [RoleClassCoverageSponsor](ValueSet-v3-RoleClassCoverageSponsor.md)
* [RoleClassCoveredParty](ValueSet-v3-RoleClassCoveredParty.md)
* [RoleClassCredentialedEntity](ValueSet-v3-RoleClassCredentialedEntity.md)
* [RoleClassDedicatedServiceDeliveryLocation](ValueSet-v3-RoleClassDedicatedServiceDeliveryLocation.md)
* [RoleClassDependent](ValueSet-v3-RoleClassDependent.md)
* [RoleClassDistributedMaterial](ValueSet-v3-RoleClassDistributedMaterial.md)
* [RoleClassEmergencyContact](ValueSet-v3-RoleClassEmergencyContact.md)
* [RoleClassEmployee](ValueSet-v3-RoleClassEmployee.md)
* [RoleClassEquivalentEntity](ValueSet-v3-RoleClassEquivalentEntity.md)
* [RoleClassEventLocation](ValueSet-v3-RoleClassEventLocation.md)
* [RoleClassExposedEntity](ValueSet-v3-RoleClassExposedEntity.md)
* [RoleClassExposureAgentCarrier](ValueSet-v3-RoleClassExposureAgentCarrier.md)
* [RoleClassExposureVector](ValueSet-v3-RoleClassExposureVector.md)
* [RoleClassFlavorAdditive](ValueSet-v3-RoleClassFlavorAdditive.md)
* [RoleClassFomite](ValueSet-v3-RoleClassFomite.md)
* [RoleClassGuarantor](ValueSet-v3-RoleClassGuarantor.md)
* [RoleClassGuardian](ValueSet-v3-RoleClassGuardian.md)
* [RoleClassHasGeneric](ValueSet-v3-RoleClassHasGeneric.md)
* [RoleClassHealthChart](ValueSet-v3-RoleClassHealthChart.md)
* [RoleClassHealthcareProvider](ValueSet-v3-RoleClassHealthcareProvider.md)
* [RoleClassHeldEntity](ValueSet-v3-RoleClassHeldEntity.md)
* [RoleClassICSRInvestigationSubject](ValueSet-v3-RoleClassICSRInvestigationSubject.md)
* [RoleClassIdentifiedEntity](ValueSet-v3-RoleClassIdentifiedEntity.md)
* [RoleClassInactiveIngredient](ValueSet-v3-RoleClassInactiveIngredient.md)
* [RoleClassIncidentalServiceDeliveryLocation](ValueSet-v3-RoleClassIncidentalServiceDeliveryLocation.md)
* [RoleClassIndividual](ValueSet-v3-RoleClassIndividual.md)
* [RoleClassIngredientEntity](ValueSet-v3-RoleClassIngredientEntity.md)
* [RoleClassInstance](ValueSet-v3-RoleClassInstance.md)
* [RoleClassInvestigationSubject](ValueSet-v3-RoleClassInvestigationSubject.md)
* [RoleClassInvoicePayor](ValueSet-v3-RoleClassInvoicePayor.md)
* [RoleClassIsSpeciesEntity](ValueSet-v3-RoleClassIsSpeciesEntity.md)
* [RoleClassIsolate](ValueSet-v3-RoleClassIsolate.md)
* [RoleClassLicensedEntity](ValueSet-v3-RoleClassLicensedEntity.md)
* [RoleClassLocatedEntity](ValueSet-v3-RoleClassLocatedEntity.md)
* [RoleClassMaintainedEntity](ValueSet-v3-RoleClassMaintainedEntity.md)
* [RoleClassManagedEntity](ValueSet-v3-RoleClassManagedEntity.md)
* [RoleClassManufacturedProduct](ValueSet-v3-RoleClassManufacturedProduct.md)
* [RoleClassMechanicalIngredient](ValueSet-v3-RoleClassMechanicalIngredient.md)
* [RoleClassMember](ValueSet-v3-RoleClassMember.md)
* [RoleClassMilitaryPerson](ValueSet-v3-RoleClassMilitaryPerson.md)
* [RoleClassMolecularBond](ValueSet-v3-RoleClassMolecularBond.md)
* [RoleClassMolecularFeatures](ValueSet-v3-RoleClassMolecularFeatures.md)
* [RoleClassMolecularPart](ValueSet-v3-RoleClassMolecularPart.md)
* [RoleClassMutualRelationship](ValueSet-v3-RoleClassMutualRelationship.md)
* [RoleClassNamedInsured](ValueSet-v3-RoleClassNamedInsured.md)
* [RoleClassNextOfKin](ValueSet-v3-RoleClassNextOfKin.md)
* [RoleClassNotaryPublic](ValueSet-v3-RoleClassNotaryPublic.md)
* [RoleClassNurse](ValueSet-v3-RoleClassNurse.md)
* [RoleClassNursePractitioner](ValueSet-v3-RoleClassNursePractitioner.md)
* [RoleClassOntological](ValueSet-v3-RoleClassOntological.md)
* [RoleClassOwnedEntity](ValueSet-v3-RoleClassOwnedEntity.md)
* [RoleClassPart](ValueSet-v3-RoleClassPart.md)
* [RoleClassPartitive](ValueSet-v3-RoleClassPartitive.md)
* [RoleClassPassive](ValueSet-v3-RoleClassPassive.md)
* [RoleClassPatient](ValueSet-v3-RoleClassPatient.md)
* [RoleClassPayee](ValueSet-v3-RoleClassPayee.md)
* [RoleClassPersonalRelationship](ValueSet-v3-RoleClassPersonalRelationship.md)
* [RoleClassPhysician](ValueSet-v3-RoleClassPhysician.md)
* [RoleClassPhysicianAssistant](ValueSet-v3-RoleClassPhysicianAssistant.md)
* [RoleClassPlaceOfDeath](ValueSet-v3-RoleClassPlaceOfDeath.md)
* [RoleClassPolicyHolder](ValueSet-v3-RoleClassPolicyHolder.md)
* [RoleClassPreservative](ValueSet-v3-RoleClassPreservative.md)
* [RoleClassProductRelated](ValueSet-v3-RoleClassProductRelated.md)
* [RoleClassProgramEligible](ValueSet-v3-RoleClassProgramEligible.md)
* [RoleClassQualifiedEntity](ValueSet-v3-RoleClassQualifiedEntity.md)
* [RoleClassRegulatedProduct](ValueSet-v3-RoleClassRegulatedProduct.md)
* [RoleClassRelationshipFormal](ValueSet-v3-RoleClassRelationshipFormal.md)
* [RoleClassResearchSubject](ValueSet-v3-RoleClassResearchSubject.md)
* [RoleClassRetailedMaterial](ValueSet-v3-RoleClassRetailedMaterial.md)
* [RoleClassRoot](ValueSet-v3-RoleClassRoot.md)
* [RoleClassSame](ValueSet-v3-RoleClassSame.md)
* [RoleClassServiceDeliveryLocation](ValueSet-v3-RoleClassServiceDeliveryLocation.md)
* [RoleClassSigningAuthorityOrOfficer](ValueSet-v3-RoleClassSigningAuthorityOrOfficer.md)
* [RoleClassSpecimen](ValueSet-v3-RoleClassSpecimen.md)
* [RoleClassStabilizer](ValueSet-v3-RoleClassStabilizer.md)
* [RoleClassStoredEntity](ValueSet-v3-RoleClassStoredEntity.md)
* [RoleClassStudent](ValueSet-v3-RoleClassStudent.md)
* [RoleClassSubscriber](ValueSet-v3-RoleClassSubscriber.md)
* [RoleClassSubstancePresence](ValueSet-v3-RoleClassSubstancePresence.md)
* [RoleClassSubsumedBy](ValueSet-v3-RoleClassSubsumedBy.md)
* [RoleClassSubsumer](ValueSet-v3-RoleClassSubsumer.md)
* [RoleClassTerritoryOfAuthority](ValueSet-v3-RoleClassTerritoryOfAuthority.md)
* [RoleClassTherapeuticAgent](ValueSet-v3-RoleClassTherapeuticAgent.md)
* [RoleClassUnderwriter](ValueSet-v3-RoleClassUnderwriter.md)
* [RoleClassUsedEntity](ValueSet-v3-RoleClassUsedEntity.md)
* [RoleClassWarrantedProduct](ValueSet-v3-RoleClassWarrantedProduct.md)
* [v3 Code System RoleCode](ValueSet-v3-RoleCode.md)
* [RoleInformationSensitivityPolicy](ValueSet-v3-RoleInformationSensitivityPolicy.md)
* [RoleLinkHasContact](ValueSet-v3-RoleLinkHasContact.md)
* [RoleLinkHasDirectAuthorityOver](ValueSet-v3-RoleLinkHasDirectAuthorityOver.md)
* [RoleLinkHasIndirectAuthorityOver](ValueSet-v3-RoleLinkHasIndirectAuthorityOver.md)
* [RoleLinkHasPart](ValueSet-v3-RoleLinkHasPart.md)
* [RoleLinkIdentification](ValueSet-v3-RoleLinkIdentification.md)
* [RoleLinkIsBackupFor](ValueSet-v3-RoleLinkIsBackupFor.md)
* [RoleLinkRelated](ValueSet-v3-RoleLinkRelated.md)
* [RoleLinkReplaces](ValueSet-v3-RoleLinkReplaces.md)
* [RoleLinkStatus](ValueSet-v3-RoleLinkStatus.md)
* [RoleLinkStatusActive](ValueSet-v3-RoleLinkStatusActive.md)
* [RoleLinkStatusCancelled](ValueSet-v3-RoleLinkStatusCancelled.md)
* [RoleLinkStatusCompleted](ValueSet-v3-RoleLinkStatusCompleted.md)
* [RoleLinkStatusNormal](ValueSet-v3-RoleLinkStatusNormal.md)
* [RoleLinkStatusNullified](ValueSet-v3-RoleLinkStatusNullified.md)
* [RoleLinkStatusPending](ValueSet-v3-RoleLinkStatusPending.md)
* [RoleLinkType](ValueSet-v3-RoleLinkType.md)
* [RoleLocationIdentifiedEntity](ValueSet-v3-RoleLocationIdentifiedEntity.md)
* [RoleStatus](ValueSet-v3-RoleStatus.md)
* [RoleStatusActive](ValueSet-v3-RoleStatusActive.md)
* [RoleStatusCancelled](ValueSet-v3-RoleStatusCancelled.md)
* [RoleStatusNormal](ValueSet-v3-RoleStatusNormal.md)
* [RoleStatusNullified](ValueSet-v3-RoleStatusNullified.md)
* [RoleStatusPending](ValueSet-v3-RoleStatusPending.md)
* [RoleStatusSuspended](ValueSet-v3-RoleStatusSuspended.md)
* [RoleStatusTerminated](ValueSet-v3-RoleStatusTerminated.md)
* [RouteByMethod](ValueSet-v3-RouteByMethod.md)
* [RouteBySite](ValueSet-v3-RouteBySite.md)
* [RouteOfAdministration](ValueSet-v3-RouteOfAdministration.md)
* [SCDHEC-GISSpatialAccuracyTiers](ValueSet-v3-SCDHEC-GISSpatialAccuracyTiers.md)
* [Sahaptian](ValueSet-v3-Sahaptian.md)
* [Salishan](ValueSet-v3-Salishan.md)
* [SaukFoxKickapoo](ValueSet-v3-SaukFoxKickapoo.md)
* [ScalpRoute](ValueSet-v3-ScalpRoute.md)
* [SchedulingActReason](ValueSet-v3-SchedulingActReason.md)
* [SecurityAlterationIntegrityObservationType](ValueSet-v3-SecurityAlterationIntegrityObservationType.md)
* [SecurityAlterationIntegrityObservationValue](ValueSet-v3-SecurityAlterationIntegrityObservationValue.md)
* [SecurityCategoryObservationType](ValueSet-v3-SecurityCategoryObservationType.md)
* [SecurityCategoryObservationValue](ValueSet-v3-SecurityCategoryObservationValue.md)
* [SecurityClassificationObservationType](ValueSet-v3-SecurityClassificationObservationType.md)
* [SecurityClassificationObservationValue](ValueSet-v3-SecurityClassificationObservationValue.md)
* [SecurityControlObservationType](ValueSet-v3-SecurityControlObservationType.md)
* [SecurityControlObservationValue](ValueSet-v3-SecurityControlObservationValue.md)
* [SecurityDataIntegrityObservationType](ValueSet-v3-SecurityDataIntegrityObservationType.md)
* [SecurityDataIntegrityObservationValue](ValueSet-v3-SecurityDataIntegrityObservationValue.md)
* [SecurityIntegrityConfidenceObservationType](ValueSet-v3-SecurityIntegrityConfidenceObservationType.md)
* [SecurityIntegrityConfidenceObservationValue](ValueSet-v3-SecurityIntegrityConfidenceObservationValue.md)
* [SecurityIntegrityObservationType](ValueSet-v3-SecurityIntegrityObservationType.md)
* [SecurityIntegrityObservationValue](ValueSet-v3-SecurityIntegrityObservationValue.md)
* [SecurityIntegrityProvenanceAssertedByObservationType](ValueSet-v3-SecurityIntegrityProvenanceAssertedByObservationType.md)
* [SecurityIntegrityProvenanceAssertedByObservationValue](ValueSet-v3-SecurityIntegrityProvenanceAssertedByObservationValue.md)
* [SecurityIntegrityProvenanceObservationType](ValueSet-v3-SecurityIntegrityProvenanceObservationType.md)
* [SecurityIntegrityProvenanceObservationValue](ValueSet-v3-SecurityIntegrityProvenanceObservationValue.md)
* [SecurityIntegrityProvenanceReportedByObservationType](ValueSet-v3-SecurityIntegrityProvenanceReportedByObservationType.md)
* [SecurityIntegrityProvenanceReportedByObservationValue](ValueSet-v3-SecurityIntegrityProvenanceReportedByObservationValue.md)
* [SecurityIntegrityStatusObservation](ValueSet-v3-SecurityIntegrityStatusObservation.md)
* [SecurityIntegrityStatusObservationType](ValueSet-v3-SecurityIntegrityStatusObservationType.md)
* [SecurityLabelMark](ValueSet-v3-SecurityLabelMark.md)
* [SecurityLabelMarkLabel](ValueSet-v3-SecurityLabelMarkLabel.md)
* [SecurityObservationType](ValueSet-v3-SecurityObservationType.md)
* [SecurityObservationValue](ValueSet-v3-SecurityObservationValue.md)
* [SecurityPolicy](ValueSet-v3-SecurityPolicy.md)
* [SecurityTrustAccreditationObservationType](ValueSet-v3-SecurityTrustAccreditationObservationType.md)
* [SecurityTrustAccreditationObservationValue](ValueSet-v3-SecurityTrustAccreditationObservationValue.md)
* [SecurityTrustAgreementObservationType](ValueSet-v3-SecurityTrustAgreementObservationType.md)
* [SecurityTrustAgreementObservationValue](ValueSet-v3-SecurityTrustAgreementObservationValue.md)
* [SecurityTrustAssuranceObservationType](ValueSet-v3-SecurityTrustAssuranceObservationType.md)
* [SecurityTrustAssuranceObservationValue](ValueSet-v3-SecurityTrustAssuranceObservationValue.md)
* [SecurityTrustCertificateObservationType](ValueSet-v3-SecurityTrustCertificateObservationType.md)
* [SecurityTrustCertificateObservationValue](ValueSet-v3-SecurityTrustCertificateObservationValue.md)
* [SecurityTrustFrameworkObservationType](ValueSet-v3-SecurityTrustFrameworkObservationType.md)
* [SecurityTrustFrameworkObservationValue](ValueSet-v3-SecurityTrustFrameworkObservationValue.md)
* [SecurityTrustMechanismObservationType](ValueSet-v3-SecurityTrustMechanismObservationType.md)
* [SecurityTrustMechanismObservationValue](ValueSet-v3-SecurityTrustMechanismObservationValue.md)
* [SecurityTrustObservationType](ValueSet-v3-SecurityTrustObservationType.md)
* [SecurityTrustObservationValue](ValueSet-v3-SecurityTrustObservationValue.md)
* [Sequencing](ValueSet-v3-Sequencing.md)
* [SerranoGabrielino](ValueSet-v3-SerranoGabrielino.md)
* [ServiceDeliveryLocationRoleType](ValueSet-v3-ServiceDeliveryLocationRoleType.md)
* [SetOperator](ValueSet-v3-SetOperator.md)
* [SeverityObservation](ValueSet-v3-SeverityObservation.md)
* [SeverityObservationCode](ValueSet-v3-SeverityObservationCode.md)
* [Shasta](ValueSet-v3-Shasta.md)
* [Sibling](ValueSet-v3-Sibling.md)
* [SiblingInLaw](ValueSet-v3-SiblingInLaw.md)
* [SignificantOtherRoleType](ValueSet-v3-SignificantOtherRoleType.md)
* [SinusUnspecifiedRoute](ValueSet-v3-SinusUnspecifiedRoute.md)
* [Siouan](ValueSet-v3-Siouan.md)
* [SiouanCatawba](ValueSet-v3-SiouanCatawba.md)
* [SirenikskiYupik](ValueSet-v3-SirenikskiYupik.md)
* [SkinRoute](ValueSet-v3-SkinRoute.md)
* [SnodentAnteriorInterarchDeviationTypeInternational](ValueSet-v3-SnodentAnteriorInterarchDeviationTypeInternational.md)
* [SnodentCraniofacialAnomalyInternational](ValueSet-v3-SnodentCraniofacialAnomalyInternational.md)
* [SnodentDentalAbnormalityInternational](ValueSet-v3-SnodentDentalAbnormalityInternational.md)
* [SnodentDentalFrenumRegionInternational](ValueSet-v3-SnodentDentalFrenumRegionInternational.md)
* [SnodentDentalPeriodontalProbingPositionInternational](ValueSet-v3-SnodentDentalPeriodontalProbingPositionInternational.md)
* [SnodentDentalToothFurcationSiteInternational](ValueSet-v3-SnodentDentalToothFurcationSiteInternational.md)
* [SnodentDentalToothMobilityMillerClassificationInternational](ValueSet-v3-SnodentDentalToothMobilityMillerClassificationInternational.md)
* [SnodentDentalUniversalNumberingSystemInternational](ValueSet-v3-SnodentDentalUniversalNumberingSystemInternational.md)
* [SnodentDentitionStateInternational](ValueSet-v3-SnodentDentitionStateInternational.md)
* [SnodentJawTypeInternational](ValueSet-v3-SnodentJawTypeInternational.md)
* [SnodentOralCavityAreaInternational](ValueSet-v3-SnodentOralCavityAreaInternational.md)
* [SnodentOrthodonticDiagnosticFeatureInternational](ValueSet-v3-SnodentOrthodonticDiagnosticFeatureInternational.md)
* [SnodentOrthodonticTreatmentPreconditionInternational](ValueSet-v3-SnodentOrthodonticTreatmentPreconditionInternational.md)
* [SnodentPosteriorInterarchDeviationTypeInternational](ValueSet-v3-SnodentPosteriorInterarchDeviationTypeInternational.md)
* [SnodentSalzmannInterarchDeviationMaxillaryToothInternational](ValueSet-v3-SnodentSalzmannInterarchDeviationMaxillaryToothInternational.md)
* [SoftTissueRoute](ValueSet-v3-SoftTissueRoute.md)
* [Software Name Example](ValueSet-v3-SoftwareNameExample.md)
* [SolidDrugForm](ValueSet-v3-SolidDrugForm.md)
* [SolutionDrugForm](ValueSet-v3-SolutionDrugForm.md)
* [SouthernAlaska](ValueSet-v3-SouthernAlaska.md)
* [SouthernCaddoan](ValueSet-v3-SouthernCaddoan.md)
* [SouthernNumic](ValueSet-v3-SouthernNumic.md)
* [SpecimenAdditiveEntity](ValueSet-v3-SpecimenAdditiveEntity.md)
* [SpecimenEntityType](ValueSet-v3-SpecimenEntityType.md)
* [SpecimenRoleType](ValueSet-v3-SpecimenRoleType.md)
* [SponsorParticipationFunction](ValueSet-v3-SponsorParticipationFunction.md)
* [Spouse](ValueSet-v3-Spouse.md)
* [StatusRevisionRefusalReasonCode](ValueSet-v3-StatusRevisionRefusalReasonCode.md)
* [StepChild](ValueSet-v3-StepChild.md)
* [StepParent](ValueSet-v3-StepParent.md)
* [StepSibling](ValueSet-v3-StepSibling.md)
* [StreetAddressLine](ValueSet-v3-StreetAddressLine.md)
* [StreetName](ValueSet-v3-StreetName.md)
* [StudentRoleType](ValueSet-v3-StudentRoleType.md)
* [StyleType](ValueSet-v3-StyleType.md)
* [SubarachnoidRoute](ValueSet-v3-SubarachnoidRoute.md)
* [SubconjunctivalRoute](ValueSet-v3-SubconjunctivalRoute.md)
* [SubcutaneousRoute](ValueSet-v3-SubcutaneousRoute.md)
* [SublesionalRoute](ValueSet-v3-SublesionalRoute.md)
* [SublingualRoute](ValueSet-v3-SublingualRoute.md)
* [SubmucosalRoute](ValueSet-v3-SubmucosalRoute.md)
* [SubscriberCoveredPartyRoleType](ValueSet-v3-SubscriberCoveredPartyRoleType.md)
* [SubsidizedHealthProgram](ValueSet-v3-SubsidizedHealthProgram.md)
* [SubstanceAdminGenericSubstitution](ValueSet-v3-SubstanceAdminGenericSubstitution.md)
* [SubstanceAdminSubstitutionNotAllowedReason](ValueSet-v3-SubstanceAdminSubstitutionNotAllowedReason.md)
* [SubstanceAdminSubstitutionReason](ValueSet-v3-SubstanceAdminSubstitutionReason.md)
* [SubstanceAdministrationPermissionRefusalReasonCode](ValueSet-v3-SubstanceAdministrationPermissionRefusalReasonCode.md)
* [SubstitutionCondition](ValueSet-v3-SubstitutionCondition.md)
* [SupernumeraryTooth](ValueSet-v3-SupernumeraryTooth.md)
* [SupplyAppropriateManagementCode](ValueSet-v3-SupplyAppropriateManagementCode.md)
* [SupplyDetectedIssueCode](ValueSet-v3-SupplyDetectedIssueCode.md)
* [SupplyOrderAbortReasonCode](ValueSet-v3-SupplyOrderAbortReasonCode.md)
* [SuppositoryDrugForm](ValueSet-v3-SuppositoryDrugForm.md)
* [SuppositoryRoute](ValueSet-v3-SuppositoryRoute.md)
* [SurgClinPracticeSetting](ValueSet-v3-SurgClinPracticeSetting.md)
* [SusceptibilityObservationMethodType](ValueSet-v3-SusceptibilityObservationMethodType.md)
* [SuspensionDrugForm](ValueSet-v3-SuspensionDrugForm.md)
* [SwabDrugForm](ValueSet-v3-SwabDrugForm.md)
* [Swish](ValueSet-v3-Swish.md)
* [TableCellHorizontalAlign](ValueSet-v3-TableCellHorizontalAlign.md)
* [TableCellScope](ValueSet-v3-TableCellScope.md)
* [TableCellVerticalAlign](ValueSet-v3-TableCellVerticalAlign.md)
* [TableFrame](ValueSet-v3-TableFrame.md)
* [TableRuleStyle](ValueSet-v3-TableRuleStyle.md)
* [TableRules](ValueSet-v3-TableRules.md)
* [TabletDrugForm](ValueSet-v3-TabletDrugForm.md)
* [Takelman](ValueSet-v3-Takelman.md)
* [Takic](ValueSet-v3-Takic.md)
* [Tanana](ValueSet-v3-Tanana.md)
* [TananaTutchone](ValueSet-v3-TananaTutchone.md)
* [Taracahitan](ValueSet-v3-Taracahitan.md)
* [TargetAwareness](ValueSet-v3-TargetAwareness.md)
* [TelecommunicationAddressUse](ValueSet-v3-TelecommunicationAddressUse.md)
* [TelecommunicationCapabilities](ValueSet-v3-TelecommunicationCapabilities.md)
* [Tepiman](ValueSet-v3-Tepiman.md)
* [TextMediaType](ValueSet-v3-TextMediaType.md)
* [TherapeuticProductDetectedIssueCode](ValueSet-v3-TherapeuticProductDetectedIssueCode.md)
* [TherapyAppropriateManagementCode](ValueSet-v3-TherapyAppropriateManagementCode.md)
* [TimingDetectedIssueCode](ValueSet-v3-TimingDetectedIssueCode.md)
* [TimingEvent](ValueSet-v3-TimingEvent.md)
* [Tiwa](ValueSet-v3-Tiwa.md)
* [TopicalAbsorptionRoute](ValueSet-v3-TopicalAbsorptionRoute.md)
* [TopicalApplication](ValueSet-v3-TopicalApplication.md)
* [TopicalPowder](ValueSet-v3-TopicalPowder.md)
* [TopicalSolution](ValueSet-v3-TopicalSolution.md)
* [TracheostomyRoute](ValueSet-v3-TracheostomyRoute.md)
* [Transdermal](ValueSet-v3-Transdermal.md)
* [TransdermalPatch](ValueSet-v3-TransdermalPatch.md)
* [Transfer](ValueSet-v3-Transfer.md)
* [TransferActReason](ValueSet-v3-TransferActReason.md)
* [TransmissionRelationshipTypeCode](ValueSet-v3-TransmissionRelationshipTypeCode.md)
* [TransmucosalRoute](ValueSet-v3-TransmucosalRoute.md)
* [TransplacentalRoute](ValueSet-v3-TransplacentalRoute.md)
* [TranstrachealRoute](ValueSet-v3-TranstrachealRoute.md)
* [TranstympanicRoute](ValueSet-v3-TranstympanicRoute.md)
* [TribalEntityUS](ValueSet-v3-TribalEntityUS.md)
* [TriggerEventID](ValueSet-v3-TriggerEventID.md)
* [TrustPolicy](ValueSet-v3-TrustPolicy.md)
* [Tsamosan](ValueSet-v3-Tsamosan.md)
* [Tsimshianic](ValueSet-v3-Tsimshianic.md)
* [UNSPSC](ValueSet-v3-UNSPSC.md)
* [UPC](ValueSet-v3-UPC.md)
* [URLScheme](ValueSet-v3-URLScheme.md)
* [USEncounterDischargeDisposition](ValueSet-v3-USEncounterDischargeDisposition.md)
* [USEncounterReferralSource](ValueSet-v3-USEncounterReferralSource.md)
* [UnderwriterParticipationFunction](ValueSet-v3-UnderwriterParticipationFunction.md)
* [UnitsOfMeasureCaseSensitive](ValueSet-v3-UnitsOfMeasureCaseSensitive.md)
* [Unknown](ValueSet-v3-Unknown.md)
* [UnorderedListStyle](ValueSet-v3-UnorderedListStyle.md)
* [UpdateRefusalReasonCode](ValueSet-v3-UpdateRefusalReasonCode.md)
* [UpperChinook](ValueSet-v3-UpperChinook.md)
* [UreteralRoute](ValueSet-v3-UreteralRoute.md)
* [UrethralRoute](ValueSet-v3-UrethralRoute.md)
* [UrinaryBladderIrrigation](ValueSet-v3-UrinaryBladderIrrigation.md)
* [UrinaryBladderRoute](ValueSet-v3-UrinaryBladderRoute.md)
* [UrinaryTractRoute](ValueSet-v3-UrinaryTractRoute.md)
* [Utian](ValueSet-v3-Utian.md)
* [UtoAztecan](ValueSet-v3-UtoAztecan.md)
* [VaccineEntityType](ValueSet-v3-VaccineEntityType.md)
* [VaccineManufacturer](ValueSet-v3-VaccineManufacturer.md)
* [VaccineType](ValueSet-v3-VaccineType.md)
* [VaginalCream](ValueSet-v3-VaginalCream.md)
* [VaginalFoam](ValueSet-v3-VaginalFoam.md)
* [VaginalGel](ValueSet-v3-VaginalGel.md)
* [VaginalOintment](ValueSet-v3-VaginalOintment.md)
* [VaginalRoute](ValueSet-v3-VaginalRoute.md)
* [ValidationIssue](ValueSet-v3-ValidationIssue.md)
* [VerificationMethod](ValueSet-v3-VerificationMethod.md)
* [VerificationOutcomeValue](ValueSet-v3-VerificationOutcomeValue.md)
* [VideoMediaType](ValueSet-v3-VideoMediaType.md)
* [VitreousHumourRoute](ValueSet-v3-VitreousHumourRoute.md)
* [Wakashan](ValueSet-v3-Wakashan.md)
* [WeightAlert](ValueSet-v3-WeightAlert.md)
* [WesternApachean](ValueSet-v3-WesternApachean.md)
* [WesternMiwok](ValueSet-v3-WesternMiwok.md)
* [WesternMuskogean](ValueSet-v3-WesternMuskogean.md)
* [WesternNumic](ValueSet-v3-WesternNumic.md)
* [Wintuan](ValueSet-v3-Wintuan.md)
* [Wiyot](ValueSet-v3-Wiyot.md)
* [WorkClassificationODH](ValueSet-v3-WorkClassificationODH.md)
* [WorkPlace](ValueSet-v3-WorkPlace.md)
* [WorkScheduleODH](ValueSet-v3-WorkScheduleODH.md)
* [Yaqui](ValueSet-v3-Yaqui.md)
* [Yokuts](ValueSet-v3-Yokuts.md)
* [Yokutsan](ValueSet-v3-Yokutsan.md)
* [Yukian](ValueSet-v3-Yukian.md)
* [Yuman](ValueSet-v3-Yuman.md)
* [employmentStatusODH](ValueSet-v3-employmentStatusODH.md)
* [immunizationForecastDate](ValueSet-v3-immunizationForecastDate.md)
* [immunizationForecastStatusObservationValue](ValueSet-v3-immunizationForecastStatusObservationValue.md)
* [materialForm](ValueSet-v3-materialForm.md)
* [_0272](ValueSet-v3-tst0272.md)
* [_0275a](ValueSet-v3-tst0275a.md)
* [_0280](ValueSet-v3-tst0280.md)
* [x_AccommodationRequestorRole](ValueSet-v3-xAccommodationRequestorRole.md)
* [x_ActBillableCode](ValueSet-v3-xActBillableCode.md)
* [x_ActClassCareProvisionEncounter](ValueSet-v3-xActClassCareProvisionEncounter.md)
* [x_ActClassCareProvisionObservation](ValueSet-v3-xActClassCareProvisionObservation.md)
* [x_ActClassCareProvisionProcedure](ValueSet-v3-xActClassCareProvisionProcedure.md)
* [x_ActClassDocumentEntryAct](ValueSet-v3-xActClassDocumentEntryAct.md)
* [x_ActClassDocumentEntryOrganizer](ValueSet-v3-xActClassDocumentEntryOrganizer.md)
* [x_ActEncounterReason](ValueSet-v3-xActEncounterReason.md)
* [x_ActFinancialProductAcquisitionCode](ValueSet-v3-xActFinancialProductAcquisitionCode.md)
* [x_ActInvoiceDetailPharmacyCode](ValueSet-v3-xActInvoiceDetailPharmacyCode.md)
* [x_ActInvoiceDetailPreferredAccommodationCode](ValueSet-v3-xActInvoiceDetailPreferredAccommodationCode.md)
* [x_ActMoodCompletionCriterion](ValueSet-v3-xActMoodCompletionCriterion.md)
* [x_ActMoodDefEvn](ValueSet-v3-xActMoodDefEvn.md)
* [x_ActMoodDefEvnRqo](ValueSet-v3-xActMoodDefEvnRqo.md)
* [x_ActMoodDefEvnRqoPrmsPrp](ValueSet-v3-xActMoodDefEvnRqoPrmsPrp.md)
* [x_ActMoodDocumentObservation](ValueSet-v3-xActMoodDocumentObservation.md)
* [x_ActMoodEvnOrdPrmsPrp](ValueSet-v3-xActMoodEvnOrdPrmsPrp.md)
* [x_ActMoodIntentEvent](ValueSet-v3-xActMoodIntentEvent.md)
* [x_ActMoodOrdPrms](ValueSet-v3-xActMoodOrdPrms.md)
* [x_ActMoodOrdPrmsEvn](ValueSet-v3-xActMoodOrdPrmsEvn.md)
* [x_ActMoodPermPermrq](ValueSet-v3-xActMoodPermPermrq.md)
* [x_ActMoodRequestEvent](ValueSet-v3-xActMoodRequestEvent.md)
* [x_ActMoodRqoPrpAptArq](ValueSet-v3-xActMoodRqoPrpAptArq.md)
* [x_ActOrderableOrBillable](ValueSet-v3-xActOrderableOrBillable.md)
* [x_ActRelationshipDocument](ValueSet-v3-xActRelationshipDocument.md)
* [x_ActRelationshipDocumentSPL](ValueSet-v3-xActRelationshipDocumentSPL.md)
* [x_ActRelationshipEntry](ValueSet-v3-xActRelationshipEntry.md)
* [x_ActRelationshipEntryRelationship](ValueSet-v3-xActRelationshipEntryRelationship.md)
* [x_ActRelationshipExternalReference](ValueSet-v3-xActRelationshipExternalReference.md)
* [x_ActRelationshipPatientTransport](ValueSet-v3-xActRelationshipPatientTransport.md)
* [x_ActRelationshipPertinentInfo](ValueSet-v3-xActRelationshipPertinentInfo.md)
* [x_ActRelationshipRelatedAuthorizations](ValueSet-v3-xActRelationshipRelatedAuthorizations.md)
* [x_ActReplaceOrRevise](ValueSet-v3-xActReplaceOrRevise.md)
* [x_ActStatusActiveComplete](ValueSet-v3-xActStatusActiveComplete.md)
* [x_ActStatusActiveSuspended](ValueSet-v3-xActStatusActiveSuspended.md)
* [x_ActStatusPrevious](ValueSet-v3-xActStatusPrevious.md)
* [x_AdministeredSubstance](ValueSet-v3-xAdministeredSubstance.md)
* [x_AdverseEventCausalityAssessmentMethods](ValueSet-v3-xAdverseEventCausalityAssessmentMethods.md)
* [x_BasicConfidentialityKind](ValueSet-v3-xBasicConfidentialityKind.md)
* [x_BillableProduct](ValueSet-v3-xBillableProduct.md)
* [x_ClinicalStatementActMood](ValueSet-v3-xClinicalStatementActMood.md)
* [x_ClinicalStatementEncounterMood](ValueSet-v3-xClinicalStatementEncounterMood.md)
* [x_ClinicalStatementExposureMood](ValueSet-v3-xClinicalStatementExposureMood.md)
* [x_ClinicalStatementObservationMood](ValueSet-v3-xClinicalStatementObservationMood.md)
* [x_ClinicalStatementProcedureMood](ValueSet-v3-xClinicalStatementProcedureMood.md)
* [x_ClinicalStatementSubstanceMood](ValueSet-v3-xClinicalStatementSubstanceMood.md)
* [x_ClinicalStatementSupplyMood](ValueSet-v3-xClinicalStatementSupplyMood.md)
* [x_DeterminerInstanceKind](ValueSet-v3-xDeterminerInstanceKind.md)
* [x_DocumentActMood](ValueSet-v3-xDocumentActMood.md)
* [x_DocumentEncounterMood](ValueSet-v3-xDocumentEncounterMood.md)
* [x_DocumentEntrySubject](ValueSet-v3-xDocumentEntrySubject.md)
* [x_DocumentProcedureMood](ValueSet-v3-xDocumentProcedureMood.md)
* [x_DocumentStatus](ValueSet-v3-xDocumentStatus.md)
* [x_DocumentSubject](ValueSet-v3-xDocumentSubject.md)
* [x_DocumentSubstanceMood](ValueSet-v3-xDocumentSubstanceMood.md)
* [x_EncounterAdmissionUrgency](ValueSet-v3-xEncounterAdmissionUrgency.md)
* [x_EncounterParticipant](ValueSet-v3-xEncounterParticipant.md)
* [x_EncounterPerformerParticipation](ValueSet-v3-xEncounterPerformerParticipation.md)
* [x_EntityClassDocumentReceiving](ValueSet-v3-xEntityClassDocumentReceiving.md)
* [x_EntityClassPersonOrOrgReceiving](ValueSet-v3-xEntityClassPersonOrOrgReceiving.md)
* [x_InformationRecipient](ValueSet-v3-xInformationRecipient.md)
* [x_InformationRecipientRole](ValueSet-v3-xInformationRecipientRole.md)
* [x_LabProcessClassCodes](ValueSet-v3-xLabProcessClassCodes.md)
* [x_MedicationOrImmunization](ValueSet-v3-xMedicationOrImmunization.md)
* [x_Medicine](ValueSet-v3-xMedicine.md)
* [x_OrganizationNamePartType](ValueSet-v3-xOrganizationNamePartType.md)
* [x_ParticipationAuthorPerformer](ValueSet-v3-xParticipationAuthorPerformer.md)
* [x_ParticipationEntVrf](ValueSet-v3-xParticipationEntVrf.md)
* [x_ParticipationPrfEntVrf](ValueSet-v3-xParticipationPrfEntVrf.md)
* [x_ParticipationVrfRespSprfWit](ValueSet-v3-xParticipationVrfRespSprfWit.md)
* [x_PayeeRelationshipRoleType](ValueSet-v3-xPayeeRelationshipRoleType.md)
* [x_PersonNamePartType](ValueSet-v3-xPersonNamePartType.md)
* [x_PhoneOrEmailURLScheme](ValueSet-v3-xPhoneOrEmailURLScheme.md)
* [x_PhoneURLScheme](ValueSet-v3-xPhoneURLScheme.md)
* [x_PhysicalVerbalParticipationMode](ValueSet-v3-xPhysicalVerbalParticipationMode.md)
* [x_RoleClassAccommodationRequestor](ValueSet-v3-xRoleClassAccommodationRequestor.md)
* [x_RoleClassCoverage](ValueSet-v3-xRoleClassCoverage.md)
* [x_RoleClassCoverageInvoice](ValueSet-v3-xRoleClassCoverageInvoice.md)
* [x_RoleClassCredentialedEntity](ValueSet-v3-xRoleClassCredentialedEntity.md)
* [x_RoleClassPayeePolicyRelationship](ValueSet-v3-xRoleClassPayeePolicyRelationship.md)
* [x_SUCC_REPL_PREV](ValueSet-v3-xSUCCREPLPREV.md)
* [x_ServiceEventPerformer](ValueSet-v3-xServiceEventPerformer.md)
* [x_SubstitutionConditionNoneOrUnconditional](ValueSet-v3-xSubstitutionConditionNoneOrUnconditional.md)
* [x_VeryBasicConfidentialityKind](ValueSet-v3-xVeryBasicConfidentialityKind.md)
* [EvidenceVariableRoleSubtype](ValueSet-variable-role-subtype.md)
* [EvidenceVariableRole](ValueSet-variable-role.md)
* [sequenceStatus](ValueSet-variant-state.md)
* [Can-push-updates](ValueSet-verificationresult-can-push-updates.md)
* [VerificationResult Communication Method](ValueSet-verificationresult-communication-method.md)
* [Failure-action](ValueSet-verificationresult-failure-action.md)
* [Need](ValueSet-verificationresult-need.md)
* [Primary-source-type](ValueSet-verificationresult-primary-source-type.md)
* [Push-type-available](ValueSet-verificationresult-push-type-available.md)
* [Validation-process](ValueSet-verificationresult-validation-process.md)
* [Validation-status](ValueSet-verificationresult-validation-status.md)
* [Validation-type](ValueSet-verificationresult-validation-type.md)
* [Virtual Healthcare Delivery Method](ValueSet-virtual-healthcare-delivery-method.md)
* [Example Vision Prescription Product Codes](ValueSet-vision-product.md)
* [Yes No Unknown NotApplicable](ValueSet-yes-no-unknown-not-applicable.md)
* [Yes No Unknown NotAsked](ValueSet-yes-no-unknown-not-asked.md)

### Extensions

* [MIF Associated concept property](StructureDefinition-ext-mif-assocConceptProp.md)
* [MIF concept relationship inverse name](StructureDefinition-ext-mif-relationship-inverseName.md)
* [MIF concept relationship is navigable](StructureDefinition-ext-mif-relationship-isNavigable.md)
* [MIF concept relationship is reflexivity](StructureDefinition-ext-mif-relationship-reflexivity.md)
* [MIF concept relationship kind](StructureDefinition-ext-mif-relationship-relationshipKind.md)
* [MIF concept relationship symmetry](StructureDefinition-ext-mif-relationship-symmetry.md)
* [MIF concept relationship transitivity](StructureDefinition-ext-mif-relationship-transitivity.md)
* [NamingSystem title](StructureDefinition-ext-namingsystem-title.md)
* [NamingSystem version](StructureDefinition-ext-namingsystem-version.md)

### Bundles

* [hxutg1-1-0-0](Bundle-hxutg1-1-0-0.md)
* [hxutg1-1-0-1](Bundle-hxutg1-1-0-1.md)
* [hxutg1-1-0-10](Bundle-hxutg1-1-0-10.md)
* [hxutg1-1-0-11](Bundle-hxutg1-1-0-11.md)
* [hxutg1-1-0-12](Bundle-hxutg1-1-0-12.md)
* [hxutg1-1-0-15](Bundle-hxutg1-1-0-15.md)
* [hxutg1-1-0-2](Bundle-hxutg1-1-0-2.md)
* [hxutg1-1-0-3](Bundle-hxutg1-1-0-3.md)
* [hxutg1-1-0-4](Bundle-hxutg1-1-0-4.md)
* [hxutg1-1-0-5](Bundle-hxutg1-1-0-5.md)
* [hxutg1-1-0-6](Bundle-hxutg1-1-0-6.md)
* [hxutg1-1-0-7](Bundle-hxutg1-1-0-7.md)
* [hxutg1-1-0-8](Bundle-hxutg1-1-0-8.md)
* [hxutg1-1-0-9](Bundle-hxutg1-1-0-9.md)
* [hxutg2-1-0-13](Bundle-hxutg2-1-0-13.md)
* [hxutg3-1-0-14](Bundle-hxutg3-1-0-14.md)

### ImplementationGuides

* [HL7 Terminology (THO)](index.md)

### Lists

* [All HL7 Content Rendering Manifest](List-allHL7-Rendering.md)
* [CDA Rendering Manifest](List-cda-Rendering.md)
* [Deprecated Code Systems Rendering Manifest](List-deprCSVS-Rendering.md)
* [FHIR Normative Manifest](List-fhir-Normative.md)
* [FHIR Rendering Manifest](List-fhir-Rendering.md)
* [Identifier Systems Manifest](List-identifiers-Rendering.md)
* [Retired Manifest](List-retired-Rendering.md)
* [Retired Code System Fragment Rendering Manifest](List-retired-ext-cs-fragment-Rendering.md)
* [Retired Code System Identification Records Manifest](List-retired-techids-Rendering.md)
* [Unified Rendering Manifest](List-unified-Rendering.md)
* [V2 Publishing Manifest](List-v2-Publishing.md)
* [V2 Rendering Manifest](List-v2-rendering.md)
* [V3 Publishing Manifest](List-v3-Publishing.md)
* [V3 Rendering Manifest](List-v3-rendering.md)

### NamingSystems

* [American College of Radiology Finding Codes](NamingSystem-ACR.md)
* [American Dental Association Area of Oral Cavity System](NamingSystem-ADAAreaOralCavitySystem.md)
* [American Dental Association Tooth Surface Codes](NamingSystem-ADAToothSurfaceCodes.md)
* [ADA Universal Tooth Designation System](NamingSystem-ADAUniversalToothDesignationSystem.md)
* [AHA NUBC Condition Codes](NamingSystem-AHANUBCConditionCodes.md)
* [AHA NUBC Patient Discharge Status Codes](NamingSystem-AHANUBCPatientDischargeStatus.md)
* [AHA NUBC Point of Origin for Newborn](NamingSystem-AHANUBCPointOfOriginNewborn.md)
* [AHA NUBC Point of Origin for Non-newborn](NamingSystem-AHANUBCPointOfOriginNonnewborn.md)
* [AHA NUBC Priority (Type) of Admission or Visit](NamingSystem-AHANUBCPriorityTypeOfAdmitOrVisit.md)
* [AHA NUBC Revenue Codes](NamingSystem-AHANUBCRevenueCodes.md)
* [AHA NUBC Type Of Bill Codes](NamingSystem-AHANUBCTypeOfBill.md)
* [AHA NUBC Value Codes and Amounts](NamingSystem-AHANUBCValueCodesAndAmounts.md)
* [All Patient Refined Diagnosis Related Groups (APR DRGs)](NamingSystem-APRDRG.md)
* [ASTM E1238/E1467 Universal](NamingSystem-AS4.md)
* [AS4 Neurophysiology Codes](NamingSystem-AS4E.md)
* [Alabama Driver's License](NamingSystem-AlabamaDLN.md)
* [Alaska Driver's License](NamingSystem-AlaskaDLN.md)
* [Arizona Driver's License](NamingSystem-ArizonaDLN.md)
* [Arkansas Driver's License](NamingSystem-ArkansasDLN.md)
* [CPT-5](NamingSystem-C5.md)
* [College of American Pathologists (CAP) eCC (electronic Cancer Checklists)](NamingSystem-CAPeCC.md)
* [Chemical Abstract Codes](NamingSystem-CAS.md)
* [Clinical Care Classification System](NamingSystem-CCC.md)
* [Canadian Clinical Drug Data Set](NamingSystem-CCDD.md)
* [CMS Certification Numbers](NamingSystem-CCN.md)
* [CDT-2 Codes](NamingSystem-CD2.md)
* [CDA_RUS](NamingSystem-CDARUS.md)
* [CDC Analyte Codes](NamingSystem-CDCA.md)
* [CDC Local Coding System](NamingSystem-CDCLocal.md)
* [CDC Methods/Instruments Codes](NamingSystem-CDCM.md)
* [NHSN Surveillance System Codes](NamingSystem-CDCNHSN.md)
* [CDC Race and Ethnicity](NamingSystem-CDCREC.md)
* [Vaccine Information Statements (VIS)](NamingSystem-CDCVIS.md)
* [Chronic Illness and Disability Payment System (CDPS)](NamingSystem-CDPS.md)
* [CDC Surveillance](NamingSystem-CDS.md)
* [Code on Dental Procedures and Nomenclature](NamingSystem-CDT.md)
* [CEN ECG diagnostic codes](NamingSystem-CE.md)
* [Clinical Laboratory Improvement Amendments](NamingSystem-CLIA.md)
* [CLIP](NamingSystem-CLP.md)
* [CMS Place of Service Codes (POS)](NamingSystem-CMSPlaceofServiceCodes.md)
* [CMS Prescription Drug Hierarchical Condition Categories](NamingSystem-CMSRxHCC.md)
* [Current Procedural Terminology (CPT®)](NamingSystem-CPT.md)
* [COSTART](NamingSystem-CST.md)
* [Canadian Triage and Acuity Scale](NamingSystem-CTAS.md)
* [Vaccine Administered Code Set (CVX)](NamingSystem-CVX.md)
* [California Driver's License](NamingSystem-CaliforniaDLN.md)
* [Canada Post Province Codes](NamingSystem-CanadaProvinceCodes.md)
* [ClinVar Variant ID](NamingSystem-ClinVarV.md)
* [ClinicalTrials.gov](NamingSystem-ClinicalTrialsGov.md)
* [Colorado Driver's License](NamingSystem-ColoradoDLN.md)
* [Connecticut Driver's License](NamingSystem-ConnecticutDLN.md)
* [DC Driver's License](NamingSystem-DCDLN.md)
* [DICOM Class Label](NamingSystem-DCL.md)
* [DEEDS vocabularies](NamingSystem-DEEDS.md)
* [DEEDS2.10](NamingSystem-DEEDS210.md)
* [DEEDS402](NamingSystem-DEEDS402.md)
* [DEEDS405](NamingSystem-DEEDS405.md)
* [DEEDS407](NamingSystem-DEEDS407.md)
* [DEEDS408](NamingSystem-DEEDS408.md)
* [DEEDS412](NamingSystem-DEEDS412.md)
* [DEEDS414](NamingSystem-DEEDS414.md)
* [DEEDS415](NamingSystem-DEEDS415.md)
* [DEEDS416](NamingSystem-DEEDS416.md)
* [DEEDS418](NamingSystem-DEEDS418.md)
* [DEEDS422](NamingSystem-DEEDS422.md)
* [DEEDS424](NamingSystem-DEEDS424.md)
* [DEEDS427](NamingSystem-DEEDS427.md)
* [DEEDS506](NamingSystem-DEEDS506.md)
* [DEEDS508](NamingSystem-DEEDS508.md)
* [DEEDS519](NamingSystem-DEEDS519.md)
* [Data Universal Numbering System (DUNS) Number](NamingSystem-DUNSNumber.md)
* [Delaware Driver's License](NamingSystem-DelawareDLN.md)
* [Euclides quantity codes](NamingSystem-E5.md)
* [Euclides Lab method codes](NamingSystem-E6.md)
* [Euclides Lab equipment codes](NamingSystem-E7.md)
* [Enzyme Codes](NamingSystem-ENZC.md)
* [EPSG Geodetic Parameter Dataset](NamingSystem-EPSG-GeodeticParameterDataset.md)
* [FDB HIC Code](NamingSystem-FDBHICCode.md)
* [First DataBank Drug Codes](NamingSystem-FDDC.md)
* [First DataBank Diagnostic Codes](NamingSystem-FDDX.md)
* [FDA Establishment Identifier](NamingSystem-FEI.md)
* [Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2)](NamingSystem-FIPS52.md)
* [Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4)](NamingSystem-FIPS64.md)
* [FEvIR Object Identifier](NamingSystem-FOI.md)
* [Florida Driver's License](NamingSystem-FloridaDLN.md)
* [GCDF](NamingSystem-GCDF.md)
* [GCRT](NamingSystem-GCRT.md)
* [Global Location Number (GLN)](NamingSystem-GLN.md)
* [Global Medical Device Nomenclature](NamingSystem-GMDN.md)
* [Genetic Testing Registry](NamingSystem-GTR.md)
* [Georgia Driver's License](NamingSystem-GeorgiaDLN.md)
* [HCFA Procedure Codes (HCPCS)](NamingSystem-HCPCS-all-codes.md)
* [HUGO Gene Nomenclature Committee Gene Group](NamingSystem-HGNCGeneGroup.md)
* [Health Insurance Prospective Payment System (HIPPS)](NamingSystem-HIPPS.md)
* [Human Phenotype Ontology](NamingSystem-HPO.md)
* [Hawaii Driver's License](NamingSystem-HawaiiDLN.md)
* [IANA Time Zone Database](NamingSystem-IANATimeZoneDatabase.md)
* [ICHPPC-2](NamingSystem-IC2.md)
* [ICD-10 Dual Coding](NamingSystem-ICD-10DualCoding.md)
* [ICD-9-CM (diagnosis codes)](NamingSystem-ICD-9CM-diagnosiscodes.md)
* [ICD-9-CM (procedure codes)](NamingSystem-ICD-9CM-procedurecodes.md)
* [ICD-9 Dual Coding](NamingSystem-ICD-9DualCoding.md)
* [ICD10, Dutch Translation](NamingSystem-ICD10dut.md)
* [International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS)](NamingSystem-ICD11MMS.md)
* [International Classification of Functioning, Disability and Health](NamingSystem-ICF.md)
* [International Classification of Functioning, Disability and Health, Dutch Translation](NamingSystem-ICFDut.md)
* [ICH Context of Use](NamingSystem-ICHContextOfUse.md)
* [International Classification of Primary Care - Third Revision](NamingSystem-ICPC3.md)
* [International Classification of Sleep Disorders](NamingSystem-ICSD.md)
* [IEC 61966-2-1: Colour measurement and management - Part 2-1: Colour management - Default RGB colour space - sRGB](NamingSystem-IECColourManagement.md)
* [IETF RFC 1766](NamingSystem-IETF1766.md)
* [ILRSpeakingSkillScale](NamingSystem-ILRSpeakingSkillScale.md)
* [Intelligent Medical Objects](NamingSystem-IMO.md)
* [ISBT 128 Standard Terminology for Medical Products of Human Origin Product Description Codes](NamingSystem-ISBT128ProductDescriptionCodes.md)
* [ISBT 128 Standard Terminology for Medical Products of Human Origin Property Types](NamingSystem-ISBT128PropertyTypes.md)
* [International System for Human Cytogenomic Nomenclature (ISCN)](NamingSystem-ISCN.md)
* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](NamingSystem-ISO3166Part1.md)
* [ISO 3166-2 Codes for the representation of names of countries and their subdivisions — Part 2: Country subdivision code](NamingSystem-ISO3166Part2.md)
* [ISO 3166-3 Codes for the representation of names of countries and their subdivisions — Part 3: Code for formerly used names of countries](NamingSystem-ISO3166Part3.md)
* [IUPAC/IFCC Component Codes](NamingSystem-IUPC.md)
* [IUPAC/IFCC Property Codes](NamingSystem-IUPP.md)
* [Idaho Driver's License](NamingSystem-IdahoDLN.md)
* [Illinois Driver's License](NamingSystem-IllinoisDLN.md)
* [Indiana Driver's License](NamingSystem-IndianaDLN.md)
* [Iowa Driver's License](NamingSystem-IowaDLN.md)
* [Japanese Chemistry](NamingSystem-JC8.md)
* [Kansas Driver's License](NamingSystem-KansasDLN.md)
* [Kentucky Driver's License](NamingSystem-KentuckyDLN.md)
* [Louisiana Driver's License](NamingSystem-LouisianaDLN.md)
* [Medispan Diagnostic Codes](NamingSystem-MDDX.md)
* [MedDRA Am Engl](NamingSystem-MDRAE.md)
* [MedDRA Dutch](NamingSystem-MDRDUT.md)
* [MedDRA Am Engl expanded](NamingSystem-MDREA.md)
* [MedDRA expanded](NamingSystem-MDREX.md)
* [MedDRA French](NamingSystem-MDRFRE.md)
* [MedDRA German](NamingSystem-MDRGER.md)
* [MedDRA Portuguese](NamingSystem-MDRPOR.md)
* [MedDRA Spanish](NamingSystem-MDRSPA.md)
* [Medical Economics Drug Codes](NamingSystem-MEDC.md)
* [Medication Reference Terminology (MED-RT)](NamingSystem-MEDRT.md)
* [Medical Economics Diagnostic Codes](NamingSystem-MEDX.md)
* [Medispan GPI](NamingSystem-MGPI.md)
* [Mondo Disease Ontology](NamingSystem-MONDO.md)
* [Medicare Severity Diagnosis Related Groups (MS-DRGs)](NamingSystem-MSDRG.md)
* [MTH MedDRA Spanish](NamingSystem-MTHMDRSPA.md)
* [Manufacturers of Vaccines (MVX)](NamingSystem-MVX.md)
* [Maine Driver's License](NamingSystem-MaineDLN.md)
* [Maryland Driver's License](NamingSystem-MarylandDLN.md)
* [Massachusetts Driver's License](NamingSystem-MassachusettsDLN.md)
* [Medical Subject Headings](NamingSystem-MeSH.md)
* [Michigan Driver's License](NamingSystem-MichiganDLN.md)
* [Minnesota Driver's License](NamingSystem-MinnesotaDLN.md)
* [Mississippi Driver's License](NamingSystem-MississippiDLN.md)
* [Missouri Driver's License](NamingSystem-MissouriDLN.md)
* [Montana Driver's License](NamingSystem-MontanaDLN.md)
* [National Association of Insurance Commissioners (NAIC) Company Codes](NamingSystem-NAICCompanyCodes.md)
* [NCPDP Brand Generic Indicator](NamingSystem-NCPDPBrandGenericIndicator.md)
* [NCPDP Compound Code](NamingSystem-NCPDPCompoundCode.md)
* [NCPDP Dispense As Written (DAW)/Product Selection Code](NamingSystem-NCPDPDispensedAsWrittenOrProductSelectionCode.md)
* [NCPDP Pharmacy Type](NamingSystem-NCPDPPharmacyType.md)
* [NCPDP Prescription Origin Code](NamingSystem-NCPDPPrescriptionOriginCode.md)
* [NCPDP Provider Identification Number](NamingSystem-NCPDPProviderIdentificationNumber.md)
* [NCPDP Reject Code](NamingSystem-NCPDPRejectCode.md)
* [National Council of State Boards of Nursing (NCSBN) ID](NamingSystem-NCSBNID.md)
* [National Drug File Reference Terminology (NDF-RT)](NamingSystem-NDFRT.md)
* [NHSN BSI Risk Factors](NamingSystem-NHSNBSIRiskFactors.md)
* [NHSN Hip Replacement](NamingSystem-NHSNHipReplacement.md)
* [NHSN Infection Type](NamingSystem-NHSNInfectionType.md)
* [NHSN KneeR eplacement](NamingSystem-NHSNKneeReplacement.md)
* [NHSN LCBI Pathways](NamingSystem-NHSNLCBIPathways.md)
* [NHSN Occasion Of Detection](NamingSystem-NHSNOccasionOfDetection.md)
* [NHSN Procedure Category](NamingSystem-NHSNProcedureCategory.md)
* [NHSN SSI Anatomic Site](NamingSystem-NHSNSSIAnatomicSite.md)
* [NHSN SSI Location Type](NamingSystem-NHSNSSILocationType.md)
* [NHSN Spinal Fusion Approach](NamingSystem-NHSNSpinalFusionApproach.md)
* [NHSN Spinal Fusion Level](NamingSystem-NHSNSpinalFusionLevel.md)
* [NHSN Summary Data](NamingSystem-NHSNSummaryData.md)
* [NHSN HAI Vocabulary](NamingSystem-NHSNVocabulary.md)
* [Nomenclature for Properties and Units (NPU)](NamingSystem-NPU.md)
* [Nebraska Driver's License](NamingSystem-NebraskaDLN.md)
* [Nevada Driver's License](NamingSystem-NevadaDLN.md)
* [New Hampshire Driver's License](NamingSystem-NewHampshireDLN.md)
* [New Jersey Driver's License](NamingSystem-NewJerseyDLN.md)
* [NewMexico Driver's License](NamingSystem-NewMexicoDLN.md)
* [New York Driver's License](NamingSystem-NewYorkDLN.md)
* [North Carolina Driver's License](NamingSystem-NorthCarolinaDLN.md)
* [North Dakota Driver's License](NamingSystem-NorthDakotaDLN.md)
* [OHDSI Standardized Vocabularies](NamingSystem-OMOP.md)
* [Ohio Driver's License](NamingSystem-OhioDLN.md)
* [Oklahoma Driver's License](NamingSystem-OklahomaDLN.md)
* [Open Eligibility Taxonomy](NamingSystem-OpenEligibilityTaxonomy.md)
* [Oregon Driver's License](NamingSystem-OregonDLN.md)
* [Industry CDC Census 2010](NamingSystem-PHIndustryCDCCensus2010.md)
* [Occupation CDC Census 2010](NamingSystem-PHOccupationCDCCensus2010.md)
* [Occupational Data for Health (ODH)](NamingSystem-PHOccupationalDataForHealthODH.md)
* [PMIX Method of Payment](NamingSystem-PMIXMethodofPayment.md)
* [PMIX Opioid Treatment Code](NamingSystem-PMIXOpioidTreatmentCode.md)
* [PMIX Patient Alert Category Code](NamingSystem-PMIXPatientAlertCatCode.md)
* [PMIX Species Type Code](NamingSystem-PMIXSpeciesTypeCode.md)
* [PMIX Status Code](NamingSystem-PMIXStatusCode.md)
* [PMIX Transmission Form Of Rx Origin Code Type](NamingSystem-PMIXTransmissionFormRxOriginCodeType.md)
* [POS Codes](NamingSystem-POS.md)
* [Pennsylvania Driver's License](NamingSystem-PennsylvaniaDLN.md)
* [Pharmacogene Variation](NamingSystem-PharmVar.md)
* [X12 Remittance Advice Remark Codes](NamingSystem-RARC.md)
* [RadLex radiology lexicon](NamingSystem-RadLex.md)
* [Rhode Island Driver's License](NamingSystem-RhodeIslandDLN.md)
* [SCDHEC GIS Spatial Accuracy Tiers](NamingSystem-SCDHEC-GISSpatialAccuracyTiers.md)
* [SNOMED-DICOM Microglossary](NamingSystem-SDM.md)
* [Scientific Evidence Code System (SEVCO)](NamingSystem-SEVCO.md)
* [SNOMED International](NamingSystem-SNM3.md)
* [SNOMED topology codes (anatomic sites)](NamingSystem-SNT.md)
* [Sequence Ontology](NamingSystem-SO.md)
* [Source of Payment Typology](NamingSystem-SOPT.md)
* [South Carolina Driver's License](NamingSystem-SouthCarolinaDLN.md)
* [South Dakota Driver's License](NamingSystem-SouthDakotaDLN.md)
* [TNM Staging System](NamingSystem-TNM.md)
* [OMAHA Tangram Medical Terminology](NamingSystem-TangramMedicalTerminology.md)
* [Tennessee Driver's License](NamingSystem-TennesseeDLN.md)
* [Texas Driver's License](NamingSystem-TexasDLN.md)
* [UCDS](NamingSystem-UC.md)
* [MDNS](NamingSystem-UMD.md)
* [Unified Medical Language](NamingSystem-UML.md)
* [Unique Ingredient Identifier (UNII)](NamingSystem-UNII.md)
* [Universal Product Code](NamingSystem-UPC.md)
* [US Census Occupation Code](NamingSystem-USCOC.md)
* [United States Drug Enforcement Agency (DEA) Number](NamingSystem-USDEANumber.md)
* [United States Employer Identification Number](NamingSystem-USEIN.md)
* [USPS State Codes](NamingSystem-USPSStateCodes.md)
* [United States Postal Service](NamingSystem-USZIPCODES.md)
* [Universal Protein Resource](NamingSystem-UniProt.md)
* [Utah Driver's License](NamingSystem-UtahDLN.md)
* [US Department of Veterans Affairs](NamingSystem-VHA.md)
* [Vermont Driver's License](NamingSystem-VermontDLN.md)
* [Virginia Driver's License](NamingSystem-VirginiaDLN.md)
* [WHO rec# drug codes](NamingSystem-W1-W2.md)
* [W3C Decentralized Identifier (DID)](NamingSystem-W3CDID.md)
* [WHO rec# code with ASTM extension](NamingSystem-W4.md)
* [Washington Driver's License](NamingSystem-WashingtonDLN.md)
* [West Virginia Driver's License](NamingSystem-WestVirginiaDLN.md)
* [Wisconsin Driver's License](NamingSystem-WisconsinDLN.md)
* [Wyoming Driver's License](NamingSystem-WyomingDLN.md)
* [X12.3 Data Elementary Dictionary](NamingSystem-X12.3.md)
* [X12 Ambulance Transport Reason Codes](NamingSystem-X12AmbulanceTransportReasonCodes.md)
* [X12 Claim Adjustment Reason Codes](NamingSystem-X12ClaimAdjustmentReasonCodes.md)
* [X12 Service Type Codes](NamingSystem-X12ServiceTypeCodes.md)
* [ABC Codes](NamingSystem-abcCodes.md)
* [AHFS Pharmacologic-Therapeutic Classification](NamingSystem-ahfs.md)
* [All Patient Diagnosis Related Groups (AP DRGs)](NamingSystem-apdrg.md)
* [WHO Adverse Reaction Terms](NamingSystem-art.md)
* [Bluetooth Address as a device identifier](NamingSystem-bluetooth-address-identifier.md)
* [Health Canada Drug Id Number](NamingSystem-ca-hc-din.md)
* [Health Canada Drug Product Database - Schedule](NamingSystem-ca-hc-dpd-schedule.md)
* [CAMNCVS](NamingSystem-camncvs.md)
* [Medicare Beneficiary Identifier (United States)](NamingSystem-cmsMBI.md)
* [CMS Hierarchical Condition Categories](NamingSystem-cmshcc.md)
* [Gold Standard's Clinical Pharmacology Monograph Number](NamingSystem-cpnum.md)
* [CAN/CSA-Z795-96](NamingSystem-csaid.md)
* [DEEDS(old)](NamingSystem-deeds-old.md)
* [DICOM modality codes](NamingSystem-dicomMDLTY.md)
* [DICOM Query Label](NamingSystem-dicomqry.md)
* [ICD-10 German](NamingSystem-dmdICD10.md)
* [DICOM Unique Id](NamingSystem-dui.md)
* [European Petroleum Survey Group Geodetic Parameter Dataset Coordinate Axis](NamingSystem-epsg-ca.md)
* [European Petroleum Survey Group Geodetic Parameter Dataset Coordinate Reference System](NamingSystem-epsg-crs.md)
* [Ethernet MAC Address as a device identifier](NamingSystem-ethernet-address-identifier.md)
* [EUCLIDES](NamingSystem-euclides.md)
* [HL7 Registered External Coding Systems](NamingSystem-externalCodeSystems.md)
* [FDA K10](NamingSystem-fdk.md)
* [FIPS_SOC](NamingSystem-fipspub92.md)
* [GTIN Global Trade Item Number](NamingSystem-gtin.md)
* [The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories](NamingSystem-hcp-lan-apm-framework.md)
* [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes](NamingSystem-HCPCS-all-codes.md)
* [Home Health Care](NamingSystem-hhcc.md)
* [Health Outcomes](NamingSystem-hi.md)
* [HIBCC](NamingSystem-hibccHIN.md)
* [NHSN Healthcare Facility Patient Care Location](NamingSystem-hsloc.md)
* [ISBT](NamingSystem-ib.md)
* [International Civil Aviation Organization Sex](NamingSystem-icaosex.md)
* [International Classification of Diseases for Oncology, version 3.](NamingSystem-icd-o-3.md)
* [International Classification of Diseases for Oncology](NamingSystem-icd-o.md)
* [Canadian DiagnosisCodes ICD-10-CA](NamingSystem-icd10-CA.md)
* [ICD-10](NamingSystem-icd10.md)
* [International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM)](NamingSystem-icd10CM.md)
* [ICD-10 Procedure Codes](NamingSystem-icd10PCS.md)
* [ICD-10 American English](NamingSystem-icd10ae.md)
* [ICD9](NamingSystem-icd9.md)
* [ICD-9CM](NamingSystem-icd9cm.md)
* [International Classification for Nursing Practice](NamingSystem-icnp.md)
* [International Classification of Primary Care 1993 Basque](NamingSystem-icpc-BAQ.md)
* [International Classification of Primary Care 1993 Danish](NamingSystem-icpc-DAN.md)
* [International Classification of Primary Care 1993 Dutch](NamingSystem-icpc-DUT.md)
* [International Classification of Primary Care 1993 (English)](NamingSystem-icpc-ENG.md)
* [International Classification of Primary Care 1993 Finnish](NamingSystem-icpc-FIN.md)
* [International Classification of Primary Care 1993 French](NamingSystem-icpc-FRE.md)
* [International Classification of Primary Care 1993 German](NamingSystem-icpc-GER.md)
* [International Classification of Primary Care 1993 Hebrew](NamingSystem-icpc-HEB.md)
* [International Classification of Primary Care 1993 Hungarian](NamingSystem-icpc-HUN.md)
* [International Classification of Primary Care 1993 Italian](NamingSystem-icpc-ITA.md)
* [International Classification of Primary Care 1993 Norwegian](NamingSystem-icpc-NOR.md)
* [International Classification of Primary Care 1993 Portuguese](NamingSystem-icpc-POR.md)
* [International Classification of Primary Care 1993 Spanish](NamingSystem-icpc-SPA.md)
* [International Classification of Primary Care 1993 Swedish](NamingSystem-icpc-SWE.md)
* [International Classification of Primary Care, 1993 edition](NamingSystem-icpc.md)
* [ICPC2-ICD10ENG Thesaurus, Dutch Translation](NamingSystem-icpc2-icd10-DUT.md)
* [ICPC2-ICD10 Thesaurus (English)](NamingSystem-icpc2-icd10-ENG.md)
* [ICPC2-ICD10 Thesaurus](NamingSystem-icpc2-icd10-THSRS.md)
* [ICPC2E, Dutch Translation](NamingSystem-icpc2E-DUT.md)
* [International Classification of Primary Care, second edition, English](NamingSystem-icpc2E-ENG.md)
* [ICPC2E 1998 Plus Am Engl](NamingSystem-icpc2E-P-AE.md)
* [ICPC2P 1998 Plus Austral Mod](NamingSystem-icpc2E-P-AUS.md)
* [ICPC2E 1998 Plus](NamingSystem-icpc2E-P.md)
* [ICCS](NamingSystem-ics.md)
* [Tags for the Identification of Languages](NamingSystem-ietf3066.md)
* [IMEI as a device identifier](NamingSystem-imei-identifier.md)
* [Internationalized Resource Identifier (IRI)](NamingSystem-iri.md)
* [ISO/IEC 21000-6:2004(E) Rights Data Dictionary](NamingSystem-iso21000-6-2004E-RDD.md)
* [ISO 3166 Part 1 Country Codes, 2nd Edition](NamingSystem-iso3166-1edition2.md)
* [ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-2](NamingSystem-iso3166-1edition2alpha2.md)
* [ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-3](NamingSystem-iso3166-1edition2alpha3.md)
* [ISO 3166 Part 1 Country Codes, 2nd Edition, Numeric](NamingSystem-iso3166-1edition2numeric.md)
* [ISO 3166 Part 2 Country Subdivision Codes](NamingSystem-iso3166-2.md)
* [ISO 4217 Currency Codes](NamingSystem-iso4217.md)
* [ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code](NamingSystem-iso639-1.md)
* [ISO 639-1 Alpha-2 Language Codes](NamingSystem-iso639-1ret.md)
* [ISO 639-2: Codes for the representation of names of languages -- Part 2: Alpha-3 code](NamingSystem-iso639-2.md)
* [ISO 639-2 Alpha-3 Language Codes](NamingSystem-iso639-2ret.md)
* [ISO 639-3 Language Codes Alpha 3](NamingSystem-iso639-3.md)
* [MDDID](NamingSystem-mddid.md)
* [Medical Dictionary for Regulatory Activities](NamingSystem-mdr.md)
* [MEDCIN](NamingSystem-medcin.md)
* [United States Medicare Number](NamingSystem-medicareHIC.md)
* [METABOLIC SYNDROME](NamingSystem-metabolicSyndrome.md)
* [ICPC2-ICD10 Thesaurus, 7-bit](NamingSystem-mth-icpc2-icd10-7B.md)
* [ICPC2-ICD10 Thesaurus, Am Engl](NamingSystem-mth-icpc2-icd10-AE.md)
* [ICPC2E Am Engl (Metathesaurus)](NamingSystem-mthicpc2E-AE.md)
* [Multum Lexicon](NamingSystem-multum.md)
* [NAACCR](NamingSystem-naaccrCodes.md)
* [North American Industry Classification System](NamingSystem-naics.md)
* [NANDA International](NamingSystem-nanda-i.md)
* [NCI Version of NDF-RT](NamingSystem-nciVersionOfNDF-RT.md)
* [National Drug Data File](NamingSystem-nddf.md)
* [Nursing Intervention Classification](NamingSystem-nic.md)
* [Nursing Minimum Data Set](NamingSystem-nmds.md)
* [Nursing Management Minimum Data Set](NamingSystem-nmmds.md)
* [NOC](NamingSystem-noc.md)
* [United States National Provider Identifier](NamingSystem-npi.md)
* [National Uniform Billing Council, UB 92](NamingSystem-nubc-UB92.md)
* [Omaha System](NamingSystem-oms.md)
* [Online Product Identification Number Index of Nova Scotia](NamingSystem-opinions.md)
* [Passport Numbers Namespace for ARUBA](NamingSystem-passportNumNS-ABW.md)
* [Passport Numbers Namespace for AFGHANISTAN](NamingSystem-passportNumNS-AFG.md)
* [Passport Numbers Namespace for ANGOLA](NamingSystem-passportNumNS-AGO.md)
* [Passport Numbers Namespace for ANGUILLA](NamingSystem-passportNumNS-AIA.md)
* [Passport Numbers Namespace for ALAND ISLANDS](NamingSystem-passportNumNS-ALA.md)
* [Passport Numbers Namespace for ALBANIA](NamingSystem-passportNumNS-ALB.md)
* [Passport Numbers Namespace for ANDORRA](NamingSystem-passportNumNS-AND.md)
* [Passport Numbers Namespace for NETHERLANDS ANTILLES](NamingSystem-passportNumNS-ANT.md)
* [Passport Numbers Namespace for UNITED ARAB EMIRATES](NamingSystem-passportNumNS-ARE.md)
* [Passport Numbers Namespace for ARGENTINA](NamingSystem-passportNumNS-ARG.md)
* [Passport Numbers Namespace for ARMENIA](NamingSystem-passportNumNS-ARM.md)
* [Passport Numbers Namespace for AMERICAN SAMOA](NamingSystem-passportNumNS-ASM.md)
* [Passport Numbers Namespace for ANTARCTICA](NamingSystem-passportNumNS-ATA.md)
* [Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES](NamingSystem-passportNumNS-ATF.md)
* [Passport Numbers Namespace for ANTIGUA AND BARBUDA](NamingSystem-passportNumNS-ATG.md)
* [Passport Numbers Namespace for AUSTRALIA](NamingSystem-passportNumNS-AUS.md)
* [Passport Numbers Namespace for AUSTRIA](NamingSystem-passportNumNS-AUT.md)
* [Passport Numbers Namespace for AZERBAIJAN](NamingSystem-passportNumNS-AZE.md)
* [Passport Numbers Namespace for BURUNDI](NamingSystem-passportNumNS-BDI.md)
* [Passport Numbers Namespace for BELGIUM](NamingSystem-passportNumNS-BEL.md)
* [Passport Numbers Namespace for BENIN](NamingSystem-passportNumNS-BEN.md)
* [Passport Numbers Namespace for BURKINA FASO](NamingSystem-passportNumNS-BFA.md)
* [Passport Numbers Namespace for BANGLADESH](NamingSystem-passportNumNS-BGD.md)
* [Passport Numbers Namespace for BULGARIA](NamingSystem-passportNumNS-BGR.md)
* [Passport Numbers Namespace for BAHRAIN](NamingSystem-passportNumNS-BHR.md)
* [Passport Numbers Namespace for BAHAMAS](NamingSystem-passportNumNS-BHS.md)
* [Passport Numbers Namespace for BOSNIA AND HERZEGOVINA](NamingSystem-passportNumNS-BIH.md)
* [Passport Numbers Namespace for SAINT BARTHELEMY](NamingSystem-passportNumNS-BLM.md)
* [Passport Numbers Namespace for BELARUS](NamingSystem-passportNumNS-BLR.md)
* [Passport Numbers Namespace for BELIZE](NamingSystem-passportNumNS-BLZ.md)
* [Passport Numbers Namespace for BERMUDA](NamingSystem-passportNumNS-BMU.md)
* [Passport Numbers Namespace for BOLIVIA](NamingSystem-passportNumNS-BOL.md)
* [Passport Numbers Namespace for BRAZIL](NamingSystem-passportNumNS-BRA.md)
* [Passport Numbers Namespace for BARBADOS](NamingSystem-passportNumNS-BRB.md)
* [Passport Numbers Namespace for BRUNEI DARUSSALAM](NamingSystem-passportNumNS-BRN.md)
* [Passport Numbers Namespace for BHUTAN](NamingSystem-passportNumNS-BTN.md)
* [Passport Numbers Namespace for BOUVET ISLAND](NamingSystem-passportNumNS-BVT.md)
* [Passport Numbers Namespace for BOTSWANA](NamingSystem-passportNumNS-BWA.md)
* [Passport Numbers Namespace for CENTRAL AFRICAN REPUBLIC](NamingSystem-passportNumNS-CAF.md)
* [Passport Numbers Namespace for CANADA](NamingSystem-passportNumNS-CAN.md)
* [Passport Numbers Namespace for COCOS (KEELING) ISLANDS](NamingSystem-passportNumNS-CCK.md)
* [Passport Numbers Namespace for SWITZERLAND](NamingSystem-passportNumNS-CHE.md)
* [Passport Numbers Namespace for CHILE](NamingSystem-passportNumNS-CHL.md)
* [Passport Numbers Namespace for CHINA](NamingSystem-passportNumNS-CHN.md)
* [Passport Numbers Namespace for COTE D'IVOIRE](NamingSystem-passportNumNS-CIV.md)
* [Passport Numbers Namespace for CAMEROON](NamingSystem-passportNumNS-CMR.md)
* [Passport Numbers Namespace for CONGO, THE DEMOCRATIC REPUBLIC OF THE](NamingSystem-passportNumNS-COD.md)
* [Passport Numbers Namespace for CONGO](NamingSystem-passportNumNS-COG.md)
* [Passport Numbers Namespace for COOK ISLANDS](NamingSystem-passportNumNS-COK.md)
* [Passport Numbers Namespace for COLOMBIA](NamingSystem-passportNumNS-COL.md)
* [Passport Numbers Namespace for COMOROS](NamingSystem-passportNumNS-COM.md)
* [Passport Numbers Namespace for CAPE VERDE](NamingSystem-passportNumNS-CPV.md)
* [Passport Numbers Namespace for COSTA RICA](NamingSystem-passportNumNS-CRI.md)
* [Passport Numbers Namespace for CUBA](NamingSystem-passportNumNS-CUB.md)
* [Passport Numbers Namespace for CHRISTMAS ISLAND](NamingSystem-passportNumNS-CXR.md)
* [Passport Numbers Namespace for CAYMAN ISLANDS](NamingSystem-passportNumNS-CYM.md)
* [Passport Numbers Namespace for CYPRUS](NamingSystem-passportNumNS-CYP.md)
* [Passport Numbers Namespace for CZECH REPUBLIC](NamingSystem-passportNumNS-CZE.md)
* [Passport Numbers Namespace for GERMANY](NamingSystem-passportNumNS-DEU.md)
* [Passport Numbers Namespace for DJIBOUTI](NamingSystem-passportNumNS-DJI.md)
* [Passport Numbers Namespace for DOMINICA](NamingSystem-passportNumNS-DMA.md)
* [Passport Numbers Namespace for DENMARK](NamingSystem-passportNumNS-DNK.md)
* [Passport Numbers Namespace for DOMINICAN REPUBLIC](NamingSystem-passportNumNS-DOM.md)
* [Passport Numbers Namespace for ALGERIA](NamingSystem-passportNumNS-DZA.md)
* [Passport Numbers Namespace for ECUADOR](NamingSystem-passportNumNS-ECU.md)
* [Passport Numbers Namespace for EGYPT](NamingSystem-passportNumNS-EGY.md)
* [Passport Numbers Namespace for ERITREA](NamingSystem-passportNumNS-ERI.md)
* [Passport Numbers Namespace for WESTERN SAHARA](NamingSystem-passportNumNS-ESH.md)
* [Passport Numbers Namespace for SPAIN](NamingSystem-passportNumNS-ESP.md)
* [Passport Numbers Namespace for ESTONIA](NamingSystem-passportNumNS-EST.md)
* [Passport Numbers Namespace for ETHIOPIA](NamingSystem-passportNumNS-ETH.md)
* [Passport Numbers Namespace for FINLAND](NamingSystem-passportNumNS-FIN.md)
* [Passport Numbers Namespace for FIJI](NamingSystem-passportNumNS-FJI.md)
* [Passport Numbers Namespace for FALKLAND ISLANDS (MALVINAS)](NamingSystem-passportNumNS-FLK.md)
* [Passport Numbers Namespace for FRANCE](NamingSystem-passportNumNS-FRA.md)
* [Passport Numbers Namespace for FAROE ISLANDS](NamingSystem-passportNumNS-FRO.md)
* [Passport Numbers Namespace for MICRONESIA, FEDERATED STATES OF](NamingSystem-passportNumNS-FSM.md)
* [Passport Numbers Namespace for GABON](NamingSystem-passportNumNS-GAB.md)
* [Passport Numbers Namespace for UNITED KINGDOM](NamingSystem-passportNumNS-GBR.md)
* [Passport Numbers Namespace for GEORGIA](NamingSystem-passportNumNS-GEO.md)
* [Passport Numbers Namespace for GUERNSEY](NamingSystem-passportNumNS-GGY.md)
* [Passport Numbers Namespace for GHANA](NamingSystem-passportNumNS-GHA.md)
* [Passport Numbers Namespace for GIBRALTAR](NamingSystem-passportNumNS-GIB.md)
* [Passport Numbers Namespace for GUINEA](NamingSystem-passportNumNS-GIN.md)
* [Passport Numbers Namespace for GUADELOUPE](NamingSystem-passportNumNS-GLP.md)
* [Passport Numbers Namespace for GAMBIA](NamingSystem-passportNumNS-GMB.md)
* [Passport Numbers Namespace for GUINEA-BISSAU](NamingSystem-passportNumNS-GNB.md)
* [Passport Numbers Namespace for EQUATORIAL GUINEA](NamingSystem-passportNumNS-GNQ.md)
* [Passport Numbers Namespace for GREECE](NamingSystem-passportNumNS-GRC.md)
* [Passport Numbers Namespace for GRENADA](NamingSystem-passportNumNS-GRD.md)
* [Passport Numbers Namespace for GREENLAND](NamingSystem-passportNumNS-GRL.md)
* [Passport Numbers Namespace for GUATEMALA](NamingSystem-passportNumNS-GTM.md)
* [Passport Numbers Namespace for FRENCH GUIANA](NamingSystem-passportNumNS-GUF.md)
* [Passport Numbers Namespace for GUAM](NamingSystem-passportNumNS-GUM.md)
* [Passport Numbers Namespace for GUYANA](NamingSystem-passportNumNS-GUY.md)
* [Passport Numbers Namespace for HONG KONG](NamingSystem-passportNumNS-HKG.md)
* [Passport Numbers Namespace for HEARD ISLAND AND MCDONALD ISLANDS](NamingSystem-passportNumNS-HMD.md)
* [Passport Numbers Namespace for HONDURAS](NamingSystem-passportNumNS-HND.md)
* [Passport Numbers Namespace for CROATIA](NamingSystem-passportNumNS-HRV.md)
* [Passport Numbers Namespace for HAITI](NamingSystem-passportNumNS-HTI.md)
* [Passport Numbers Namespace for HUNGARY](NamingSystem-passportNumNS-HUN.md)
* [Passport Numbers Namespace for INDONESIA](NamingSystem-passportNumNS-IDN.md)
* [Passport Numbers Namespace for ISLE OF MAN](NamingSystem-passportNumNS-IMM.md)
* [Passport Numbers Namespace for INDIA](NamingSystem-passportNumNS-IND.md)
* [Passport Numbers Namespace for BRITISH INDIAN OCEAN TERRITORY](NamingSystem-passportNumNS-IOT.md)
* [Passport Numbers Namespace for IRELAND](NamingSystem-passportNumNS-IRL.md)
* [Passport Numbers Namespace for IRAN (ISLAMIC REPUBLIC OF)](NamingSystem-passportNumNS-IRN.md)
* [Passport Numbers Namespace for IRAQ](NamingSystem-passportNumNS-IRQ.md)
* [Passport Numbers Namespace for ICELAND](NamingSystem-passportNumNS-ISL.md)
* [Passport Numbers Namespace for ISRAEL](NamingSystem-passportNumNS-ISR.md)
* [Passport Numbers Namespace for ITALY](NamingSystem-passportNumNS-ITA.md)
* [Passport Numbers Namespace for JAMAICA](NamingSystem-passportNumNS-JAM.md)
* [Passport Numbers Namespace for JERSEY](NamingSystem-passportNumNS-JEY.md)
* [Passport Numbers Namespace for JORDAN](NamingSystem-passportNumNS-JOR.md)
* [Passport Numbers Namespace for JAPAN](NamingSystem-passportNumNS-JPN.md)
* [Passport Numbers Namespace for KAZAKHSTAN](NamingSystem-passportNumNS-KAZ.md)
* [Passport Numbers Namespace for KENYA](NamingSystem-passportNumNS-KEN.md)
* [Passport Numbers Namespace for KYRGYZSTAN](NamingSystem-passportNumNS-KGZ.md)
* [Passport Numbers Namespace for CAMBODIA](NamingSystem-passportNumNS-KHM.md)
* [Passport Numbers Namespace for KIRIBATI](NamingSystem-passportNumNS-KIR.md)
* [Passport Numbers Namespace for SAINT KITTS AND NEVIS](NamingSystem-passportNumNS-KNA.md)
* [Passport Numbers Namespace for KOREA, REPUBLIC OF](NamingSystem-passportNumNS-KOR.md)
* [Passport Numbers Namespace for KUWAIT](NamingSystem-passportNumNS-KWT.md)
* [Passport Numbers Namespace for LAO PEOPLE'S DEMOCRATIC REPUBLIC](NamingSystem-passportNumNS-LAO.md)
* [Passport Numbers Namespace for LEBANON](NamingSystem-passportNumNS-LBN.md)
* [Passport Numbers Namespace for LIBERIA](NamingSystem-passportNumNS-LBR.md)
* [Passport Numbers Namespace for LIBYAN ARAB JAMAHIRIYA](NamingSystem-passportNumNS-LBY.md)
* [Passport Numbers Namespace for SAINT LUCIA](NamingSystem-passportNumNS-LCA.md)
* [Passport Numbers Namespace for LIECHTENSTEIN](NamingSystem-passportNumNS-LIE.md)
* [Passport Numbers Namespace for SRI LANKA](NamingSystem-passportNumNS-LKA.md)
* [Passport Numbers Namespace for LESOTHO](NamingSystem-passportNumNS-LSO.md)
* [Passport Numbers Namespace for LITHUANIA](NamingSystem-passportNumNS-LTU.md)
* [Passport Numbers Namespace for LUXEMBOURG](NamingSystem-passportNumNS-LUX.md)
* [Passport Numbers Namespace for LATVIA](NamingSystem-passportNumNS-LVA.md)
* [Passport Numbers Namespace for MACAO](NamingSystem-passportNumNS-MAC.md)
* [Passport Numbers Namespace for SAINT MARTIN (FRENCH PART)](NamingSystem-passportNumNS-MAF.md)
* [Passport Numbers Namespace for MOROCCO](NamingSystem-passportNumNS-MAR.md)
* [Passport Numbers Namespace for MONACO](NamingSystem-passportNumNS-MCO.md)
* [Passport Numbers Namespace for MOLDOVA, REPUBLIC OF](NamingSystem-passportNumNS-MDA.md)
* [Passport Numbers Namespace for MADAGASCAR](NamingSystem-passportNumNS-MDG.md)
* [Passport Numbers Namespace for MALDIVES](NamingSystem-passportNumNS-MDV.md)
* [Passport Numbers Namespace for MEXICO](NamingSystem-passportNumNS-MEX.md)
* [Passport Numbers Namespace for MARSHALL ISLANDS](NamingSystem-passportNumNS-MHL.md)
* [Passport Numbers Namespace for MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF](NamingSystem-passportNumNS-MKD.md)
* [Passport Numbers Namespace for MALI](NamingSystem-passportNumNS-MLI.md)
* [Passport Numbers Namespace for MALTA](NamingSystem-passportNumNS-MLT.md)
* [Passport Numbers Namespace for MYANMAR](NamingSystem-passportNumNS-MMR.md)
* [Passport Numbers Namespace for MONTENEGRO](NamingSystem-passportNumNS-MNE.md)
* [Passport Numbers Namespace for MONGOLIA](NamingSystem-passportNumNS-MNG.md)
* [Passport Numbers Namespace for NORTHERN MARIANA ISLANDS](NamingSystem-passportNumNS-MNP.md)
* [Passport Numbers Namespace for MOZAMBIQUE](NamingSystem-passportNumNS-MOZ.md)
* [Passport Numbers Namespace for MAURITANIA](NamingSystem-passportNumNS-MRT.md)
* [Passport Numbers Namespace for MONTSERRAT](NamingSystem-passportNumNS-MSR.md)
* [Passport Numbers Namespace for MARTINIQUE](NamingSystem-passportNumNS-MTQ.md)
* [Passport Numbers Namespace for MAURITIUS](NamingSystem-passportNumNS-MUS.md)
* [Passport Numbers Namespace for MALAWI](NamingSystem-passportNumNS-MWI.md)
* [Passport Numbers Namespace for MALAYSIA](NamingSystem-passportNumNS-MYS.md)
* [Passport Numbers Namespace for MAYOTTE](NamingSystem-passportNumNS-MYT.md)
* [Passport Numbers Namespace for NAMIBIA](NamingSystem-passportNumNS-NAM.md)
* [Passport Numbers Namespace for NEW CALEDONIA](NamingSystem-passportNumNS-NCL.md)
* [Passport Numbers Namespace for NIGER](NamingSystem-passportNumNS-NER.md)
* [Passport Numbers Namespace for NORFOLK ISLAND](NamingSystem-passportNumNS-NFK.md)
* [Passport Numbers Namespace for NIGERIA](NamingSystem-passportNumNS-NGA.md)
* [Passport Numbers Namespace for NICARAGUA](NamingSystem-passportNumNS-NIC.md)
* [Passport Numbers Namespace for NIUE](NamingSystem-passportNumNS-NIU.md)
* [Passport Numbers Namespace for NETHERLANDS](NamingSystem-passportNumNS-NLD.md)
* [Passport Numbers Namespace for NORWAY](NamingSystem-passportNumNS-NOR.md)
* [Passport Numbers Namespace for NEPAL](NamingSystem-passportNumNS-NPL.md)
* [Passport Numbers Namespace for NAURU](NamingSystem-passportNumNS-NRU.md)
* [Passport Numbers Namespace for NEW ZEALAND](NamingSystem-passportNumNS-NZL.md)
* [Passport Numbers Namespace for OMAN](NamingSystem-passportNumNS-OMN.md)
* [Passport Numbers Namespace for PAKISTAN](NamingSystem-passportNumNS-PAK.md)
* [Passport Numbers Namespace for PANAMA](NamingSystem-passportNumNS-PAN.md)
* [Passport Numbers Namespace for PITCAIRN](NamingSystem-passportNumNS-PCN.md)
* [Passport Numbers Namespace for PERU](NamingSystem-passportNumNS-PER.md)
* [Passport Numbers Namespace for PHILIPPINES](NamingSystem-passportNumNS-PHL.md)
* [Passport Numbers Namespace for PALAU](NamingSystem-passportNumNS-PLW.md)
* [Passport Numbers Namespace for PAPUA NEW GUINEA](NamingSystem-passportNumNS-PNG.md)
* [Passport Numbers Namespace for POLAND](NamingSystem-passportNumNS-POL.md)
* [Passport Numbers Namespace for PUERTO RICO](NamingSystem-passportNumNS-PRI.md)
* [Passport Numbers Namespace for KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF](NamingSystem-passportNumNS-PRK.md)
* [Passport Numbers Namespace for PORTUGAL](NamingSystem-passportNumNS-PRT.md)
* [Passport Numbers Namespace for PARAGUAY](NamingSystem-passportNumNS-PRY.md)
* [Passport Numbers Namespace for PALESTINIAN TERRITORY, OCCUPIED](NamingSystem-passportNumNS-PSE.md)
* [Passport Numbers Namespace for FRENCH POLYNESIA](NamingSystem-passportNumNS-PYF.md)
* [Passport Numbers Namespace for QATAR](NamingSystem-passportNumNS-QAT.md)
* [Passport Numbers Namespace for REUNION](NamingSystem-passportNumNS-REU.md)
* [Passport Numbers Namespace for ROMANIA](NamingSystem-passportNumNS-ROU.md)
* [Passport Numbers Namespace for RUSSIAN FEDERATION](NamingSystem-passportNumNS-RUS.md)
* [Passport Numbers Namespace for RWANDA](NamingSystem-passportNumNS-RWA.md)
* [Passport Numbers Namespace for SAUDI ARABIA](NamingSystem-passportNumNS-SAU.md)
* [Passport Numbers Namespace for SUDAN](NamingSystem-passportNumNS-SDN.md)
* [Passport Numbers Namespace for SENEGAL](NamingSystem-passportNumNS-SEN.md)
* [Passport Numbers Namespace for SINGAPORE](NamingSystem-passportNumNS-SGP.md)
* [Passport Numbers Namespace for SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS](NamingSystem-passportNumNS-SGS.md)
* [Passport Numbers Namespace for SAINT HELENA](NamingSystem-passportNumNS-SHN.md)
* [Passport Numbers Namespace for SVALBARD AND JAN MAYEN](NamingSystem-passportNumNS-SJM.md)
* [Passport Numbers Namespace for SOLOMON ISLANDS](NamingSystem-passportNumNS-SLB.md)
* [Passport Numbers Namespace for SIERRA LEONE](NamingSystem-passportNumNS-SLE.md)
* [Passport Numbers Namespace for EL SALVADOR](NamingSystem-passportNumNS-SLV.md)
* [Passport Numbers Namespace for SAN MARINO](NamingSystem-passportNumNS-SMR.md)
* [Passport Numbers Namespace for SOMALIA](NamingSystem-passportNumNS-SOM.md)
* [Passport Numbers Namespace for SAINT PIERRE AND MIQUELON](NamingSystem-passportNumNS-SPM.md)
* [Passport Numbers Namespace for SERBIA](NamingSystem-passportNumNS-SRB.md)
* [Passport Numbers Namespace for SAO TOME AND PRINCIPE](NamingSystem-passportNumNS-STP.md)
* [Passport Numbers Namespace for SURINAME](NamingSystem-passportNumNS-SUR.md)
* [Passport Numbers Namespace for SLOVAKIA](NamingSystem-passportNumNS-SVK.md)
* [Passport Numbers Namespace for SLOVENIA](NamingSystem-passportNumNS-SVN.md)
* [Passport Numbers Namespace for SWEDEN](NamingSystem-passportNumNS-SWE.md)
* [Passport Numbers Namespace for SWAZILAND](NamingSystem-passportNumNS-SWZ.md)
* [Passport Numbers Namespace for SEYCHELLES](NamingSystem-passportNumNS-SYC.md)
* [Passport Numbers Namespace for SYRIAN ARAB REPUBLIC](NamingSystem-passportNumNS-SYR.md)
* [Passport Numbers Namespace for TURKS AND CAICOS ISLANDS](NamingSystem-passportNumNS-TCA.md)
* [Passport Numbers Namespace for CHAD](NamingSystem-passportNumNS-TCD.md)
* [Passport Numbers Namespace for TOGO](NamingSystem-passportNumNS-TGO.md)
* [Passport Numbers Namespace for THAILAND](NamingSystem-passportNumNS-THA.md)
* [Passport Numbers Namespace for TAJIKISTAN](NamingSystem-passportNumNS-TJK.md)
* [Passport Numbers Namespace for TOKELAU](NamingSystem-passportNumNS-TKL.md)
* [Passport Numbers Namespace for TURKMENISTAN](NamingSystem-passportNumNS-TKM.md)
* [Passport Numbers Namespace for TIMOR-LESTE](NamingSystem-passportNumNS-TLS.md)
* [Passport Numbers Namespace for TONGA](NamingSystem-passportNumNS-TON.md)
* [Passport Numbers Namespace for TRINIDAD AND TOBAGO](NamingSystem-passportNumNS-TTO.md)
* [Passport Numbers Namespace for TUNISIA](NamingSystem-passportNumNS-TUN.md)
* [Passport Numbers Namespace for TURKEY](NamingSystem-passportNumNS-TUR.md)
* [Passport Numbers Namespace for TUVALU](NamingSystem-passportNumNS-TUV.md)
* [Passport Numbers Namespace for TAIWAN, PROVINCE OF CHINA](NamingSystem-passportNumNS-TWN.md)
* [Passport Numbers Namespace for TANZANIA, UNITED REPUBLIC OF](NamingSystem-passportNumNS-TZA.md)
* [Passport Numbers Namespace for UGANDA](NamingSystem-passportNumNS-UGA.md)
* [Passport Numbers Namespace for UKRAINE](NamingSystem-passportNumNS-UKR.md)
* [Passport Numbers Namespace for UNITED STATES MINOR OUTLYING ISLANDS](NamingSystem-passportNumNS-UMI.md)
* [Passport Numbers Namespace for URUGUAY](NamingSystem-passportNumNS-URY.md)
* [Passport Numbers Namespace for UNITED STATES](NamingSystem-passportNumNS-USA.md)
* [Passport Numbers Namespace for UZBEKISTAN](NamingSystem-passportNumNS-UZB.md)
* [Passport Numbers Namespace for HOLY SEE (VATICAN CITY STATE)](NamingSystem-passportNumNS-VAT.md)
* [Passport Numbers Namespace for SAINT VINCENT AND THE GRENADINES](NamingSystem-passportNumNS-VCT.md)
* [Passport Numbers Namespace for VENEZUELA](NamingSystem-passportNumNS-VEN.md)
* [Passport Numbers Namespace for VIRGIN ISLANDS (BRITISH)](NamingSystem-passportNumNS-VGB.md)
* [Passport Numbers Namespace for VIRGIN ISLANDS (U.S.)](NamingSystem-passportNumNS-VIR.md)
* [Passport Numbers Namespace for VIET NAM](NamingSystem-passportNumNS-VNM.md)
* [Passport Numbers Namespace for VANUATU](NamingSystem-passportNumNS-VUT.md)
* [Passport Numbers Namespace for WALLIS AND FUTUNA](NamingSystem-passportNumNS-WLF.md)
* [Passport Numbers Namespace for SAMOA](NamingSystem-passportNumNS-WSM.md)
* [Passport Numbers Namespace for YEMEN](NamingSystem-passportNumNS-YEM.md)
* [Passport Numbers Namespace for YUGOSLAVIA](NamingSystem-passportNumNS-YUG.md)
* [Passport Numbers Namespace for SOUTH AFRICA](NamingSystem-passportNumNS-ZAF.md)
* [Passport Numbers Namespace for ZAMBIA](NamingSystem-passportNumNS-ZMB.md)
* [Passport Numbers Namespace for ZIMBABWE](NamingSystem-passportNumNS-ZWE.md)
* [pan-Canadian LOINC Observation Code Database](NamingSystem-pclocd.md)
* [Perioperative Nursing Data Set](NamingSystem-pnds.md)
* [CMS Present on Admission (POA) Indicator](NamingSystem-presentOnAdmission.md)
* [The Read Codes Four Byte Set:](NamingSystem-rcFB.md)
* [The Read Codes Version 2](NamingSystem-rcV2.md)
* [Read Classification](NamingSystem-read-Codes.md)
* [US Census Bureau](NamingSystem-sic.md)
* [Systemized Nomenclature of Medicine (SNOMED)](NamingSystem-snm.md)
* [Standard Occupation Code](NamingSystem-soc.md)
* [United States Social Security Number](NamingSystem-ssn.md)
* [Standard Billing Unit](NamingSystem-standardBillingUnit.md)
* [Unified Medical Language System](NamingSystem-umls.md)
* [Uniform Resource Identifier (URI)](NamingSystem-uri.md)
* [URL](NamingSystem-url.md)
* [US EPA Substance Registry System](NamingSystem-usEPAsrs.md)
* [USB VID and PID as a device identifier](NamingSystem-usb-address-identifier.md)
* [nubc-OccurrenceCode](NamingSystem-v2-0350.md)
* [nubc-OccurrenceSpan](NamingSystem-v2-0351.md)
* [nubc-ServiceLineRevenue](NamingSystem-v2-0456.md)
* [nubc-PresentOnAdmission](NamingSystem-v2-0895.md)
* [DICOM Controlled Terminology](NamingSystem-v3-DCM.md)
* [Healthcare Provider Taxonomy HIPAA](NamingSystem-v3-HealthcareProviderTaxonomyHIPAA.md)
* [PeriodicIntervalOfTimeAbbreviation](NamingSystem-v3-PeriodicIntervalOfTimeAbbreviation.md)
* [ProcedureMethod](NamingSystem-v3-ProcedureMethod.md)
* [SpecialArrangement](NamingSystem-v3-SpecialArrangement.md)
* [Unit of Measure Prefix](NamingSystem-v3-UnitOfMeasurePrefix.md)
* [WHO ATC](NamingSystem-v3-WC.md)
* [American Dental Association Systematized Nomenclature of Dentistry (SNODENT)](NamingSystem-v3-ada-snodent.md)
* [Brazilian Procedure Codes SUS](NamingSystem-v3-brazilianProcedureCodesSUS.md)
* [Canadian Classification of Health Interventions](NamingSystem-v3-cci.md)
* [Genetic Sequence polymorphism database](NamingSystem-v3-dbSNP.md)
* [Food and Drug Administration Food Canning Establishments](NamingSystem-v3-fda-FCE.md)
* [Food and Drug Administration Food Facility Registration Numbers](NamingSystem-v3-fda-FFRN.md)
* [Active Ingredient Code](NamingSystem-v3-hc-aic.md)
* [Active Ingredient Group Code](NamingSystem-v3-hc-aigc.md)
* [Active Ingredient Group Number](NamingSystem-v3-hc-aign.md)
* [Health Canada Natural Product Number](NamingSystem-v3-hc-npn.md)
* [HUGO Gene Nomenclature Committee Genes](NamingSystem-v3-hgnc.md)
* [Human Genome Variation Society nomenclature](NamingSystem-v3-hgvs.md)
* [International Classification of Primary Care, second edition (1998)](NamingSystem-v3-icpc2E.md)
* [ISO 3166 Part 1 Country Codes](NamingSystem-v3-iso3166-1.md)
* [Logical Observation Identifier Names and Codes (LOINC)](NamingSystem-v3-loinc.md)
* [Locus Reference Genomic Sequences (LRG)](NamingSystem-v3-lrg.md)
* [ISO 11073-10101 Health informatics - Point-of-care](NamingSystem-v3-mdc.md)
* [IANA Media Types](NamingSystem-v3-mediaType.md)
* [MIME](NamingSystem-v3-mime.md)
* [NCI Thesaurus](NamingSystem-v3-nciThesaurus.md)
* [National drug codes](NamingSystem-v3-ndc.md)
* [NUCC Health Care Provider Taxonomy](NamingSystem-v3-nuccProviderCodes.md)
* [Policy Holder Role](NamingSystem-v3-policyHolderRole.md)
* [Gene Reference Sequence Collection](NamingSystem-v3-refSeq.md)
* [RxNorm](NamingSystem-v3-rxNorm.md)
* [pan-Canadian Provider Qualification Types](NamingSystem-v3-scpqual.md)
* [pan-Canadian Provider Types](NamingSystem-v3-scptype.md)
* [pan-Canadian Temporary Codes](NamingSystem-v3-sctemp.md)
* [SNOMED CT International Edition](NamingSystem-v3-snomed-CT.md)
* [Unified Code for Units of Measure (UCUM)](NamingSystem-v3-ucum.md)
* [WHO Adverse Reaction Terms foreign language translations](NamingSystem-whoARTfl.md)
* [WHO Adverse Reaction Terms French](NamingSystem-whoFRE.md)
* [WHO Adverse Reaction Terms German](NamingSystem-whoGER.md)
* [WHO Adverse Reaction Terms Portuguese](NamingSystem-whoPOR.md)
* [WHO Adverse Reaction Terms Spanish](NamingSystem-whoSPA.md)
* [ZigBee Address as a device identifier](NamingSystem-zigbee-address-identifier.md)
