# THO License - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* **THO License**

## THO License

This page describes the license terms for everything contained in these HL7 Terminology pages that has been developed by HL7®(Health Level Seven, Inc.), but does not include any content developed by third parties that may be available on these pages.

### Disclaimer and Warning of Use

The HL7®(Health Level Seven, Inc.) Terminology content developed by HL7 are derived from the collective experience of the HL7 membership and community feedback from the development and application of a spectrum of health care interoperability solutions. However, because HL7 Terminology supports multiple contexts of use, it is the responsibility of the persons or organizations using this content to ensure their use is fit for their particular purpose, including validation for clinical and operational use.

### HL7® (Health Level Seven, Inc.) Terminology Copyright and License

Copyright © 1989+ HL7.

This content is made widely and freely available for unrestricted use, and at no cost, in accordance with the Creative Commons Zero ([CC0](http://creativecommons.org/publicdomain/zero/1.0/)) designation.

The HL7 Terminology is produced by HL7 under the terms of HL7® [Governance and Operations Manual](http://www.hl7.org/permalink/?GOM) relating to Intellectual Property (Section 09, at the time of this publication), specifically its copyright, trademark, and patent provisions.

HL7®, HEALTH LEVEL SEVEN®, FHIR® and the FHIR ![](icon-fhir-16.png)® are trademarks owned by Health Level Seven International, registered with the United States Patent and Trademark Office.

### Additional information

* The right to maintain the HL7 Terminology remains vested in HL7
* You can redistribute the HL7 Terminology
* You can create derivative specifications or implementation-related products and services
* You cannot claim that HL7 or any of its members endorses your derived [thing] because it uses content from this specification
* Neither HL7 nor any of the contributors to this specification accept any liability for your use of the HL7 Terminology
* You cannot publish an altered version of the HL7 Terminology unless it clearly identifies that it is a derivative work, not the HL7 Terminology itself
* Derivative works cannot redefine what conformance to HL7 standards (including FHIR) means
* HL7 is not responsible for either identifying patents for which a license may be required to implement the HL7 Terminology or for conducting inquiries into the legal validity or scope of those patents that are brought to its attention (Governance and Operations Manual[, section 09.03.04 as of the time this release was published](http://www.hl7.org/documentcenter/public_temp_4108B35F-1C23-BA17-0C38BD44A97683FB/membership/HL7_Governance_and_Operations_Manual.pdf))"

While HL7 places no restrictions on the right to copy the HL7 Terminology or to create derivative works per the Creative Commons Zero (CC0) designation, we implore users to follow best practices for the use and development of controlled terminologies. For example, avoid alterting the representation of a concept in ways that change its meaning. HL7 welcomes [community feedback and proposals for enhancing the HL7 Terminology](https://confluence.hl7.org/display/VMAH/Vocabulary+Maintenance+at+HL7). 

Furthermore, please note that HL7 protects its trademarks (including "FHIR") carefully. This means that:

* You can use the trademarks "FHIR" and the ![](icon-fhir-16.png) logo to refer the FHIR specification itself (nominatively, or under the terms of [fair use](https://en.wikipedia.org/wiki/Fair_use_(U.S._trademark_law))
* When referencing the FHIR® standard in a website, document, presentation, or otherwise, please in a place of prominence refer to it as the "HL7® FHIR® standard". In subsequent uses, please refer to it as the "FHIR® standard" or "FHIR®", using the ® symbol as often as is practical, at least once on each page of printed matter, generally in connection with the first or dominant usage.
* When using the ![](icon-fhir-16.png) logo, always include the ® symbol
* All non-trademark uses of the foregoing marks should include the ® symbol and indicate in text that:
 "HL7, FHIR and the FHIR [FLAME DESIGN] are the registered trademarks of Health Level Seven International and their use does not constitute endorsement by HL7."
* Use of Health Level Seven International trademarks in URL domains or to brand your product or service without the express written consent of Health Level Seven International is strictly prohibited. See application forms for consent to use the trademark "FHIR" in an [event name](http://www.fhir.org/community-license) or a [product name](http://www.fhir.org/product-license) (including domain names)

Trademark FAQs are posted on the [HL7 International website](http://www.hl7.org/legal/trademarks.cfm). Questions? Please contact [HL7trademarks@HL7.org](mailto:HL7trademarks@HL7.org) for more information.

### Third-party artifacts and terminologies

The HL7 Terminology contains and references intellectual property owned by third parties ("Third Party IP"). Acceptance of these License Terms does not grant any rights with respect to Third Party IP. The licensee alone is responsible for identifying and obtaining any necessary licenses or authorizations to utilize Third Party IP in connection with the specification or otherwise.

Following is a non-exhaustive list of third-party artifacts and terminologies that may require a separate license:

| | |
| :--- | :--- |
| **Artifact/Terminology** | **Statement/Owner/Contact** |
| SNOMED CT | International Healthcare Terminology Standards Developing Organization ([IHTSDO](http://snomed.org)).This specification includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO) and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement |
| DICOM | National Electrical Manufacturers Association ([NEMA](http://dicom.nema.org/)).This specification includes content from DICOM, which is copyright NEMA, and distributed by agreement between NEMA/DICOM and HL7. Implementer use of DICOM is not covered by this agreement |
| Logical Observation Identifiers Names & Codes (LOINC) | This material contains content from LOINC ([http://loinc.org](http://loinc.org)). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at[http://loinc.org/license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc. |
| International Classification of Diseases (ICD) codes | Consult the World Health Organization ([WHO](http://who.int)) |
| Current Procedures Terminology (CPT) code set | American Medical Association ([AMA](http://www.ama-assn.org/))CPT copyright 2014 American Medical Association. All rights reserved. |

