# ObservationType - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ObservationType**

## ValueSet: ObservationType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ObservationType | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ObservationType |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.16226 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifies the kinds of observations that can be performed 

 **References** 

* Included into [XActBillableCode](ValueSet-v3-xActBillableCode.md)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0 where concept is-a [_ObservationType](http://tx.fhir.org/r5/ValueSet/v3-ActCode#v3-ActCode-_ObservationType)
* Import all the codes that are contained in [ObservationDiagnosisTypes](ValueSet-v3-ObservationDiagnosisTypes.md)
* Import all the codes that are contained in [LogicalObservationIdentifierNamesAndCodes](ValueSet-v3-LogicalObservationIdentifierNamesAndCodes.md)
* Import all the codes that are contained in [ObservationSeriesType](ValueSet-v3-ObservationSeriesType.md)
* Import all the codes that are contained in [ObservationSequenceType](ValueSet-v3-ObservationSequenceType.md)
* Import all the codes that are contained in [AnnotationType](ValueSet-v3-AnnotationType.md)
* Import all the codes that are contained in [ObservationIntoleranceType](ValueSet-v3-ObservationIntoleranceType.md)
* Import all the codes that are contained in [ObservationIssueTriggerCodedObservationType](ValueSet-v3-ObservationIssueTriggerCodedObservationType.md)
* Import all the codes that are contained in [MedicationObservationType](ValueSet-v3-MedicationObservationType.md)
* Import all the codes that are contained in [ObservationActContextAgeType](ValueSet-v3-ObservationActContextAgeType.md)
* Import all the codes that are contained in [GeneticObservationType](ValueSet-v3-GeneticObservationType.md)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0 
* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0 

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem ActCode v9.0.0 (CodeSystem)](http://tx.fhir.org/r5/ValueSet/v3-ActCode)
* [valueset ObservationDiagnosisTypes v3.0.0 (ValueSet)](ValueSet-v3-ObservationDiagnosisTypes.md)

This value set cannot be fully expanded, but a selection (293 codes) of the whole set of codes is shown here.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ObservationType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ObservationType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.16226"
    }
  ],
  "version" : "3.0.0",
  "name" : "ObservationType",
  "title" : "ObservationType",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Identifies the kinds of observations that can be performed",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_ObservationType"
          }
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ObservationDiagnosisTypes"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-LogicalObservationIdentifierNamesAndCodes"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ObservationSeriesType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ObservationSequenceType"
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-AnnotationType"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ObservationIntoleranceType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ObservationIssueTriggerCodedObservationType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-MedicationObservationType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ObservationActContextAgeType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-GeneticObservationType"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "concept" : [
          {
            "code" : "_ObservationType"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "concept" : [
          {
            "code" : "_ObservationIssueTriggerCodedObservationType"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "concept" : [
          {
            "code" : "_GeneticObservationType"
          }
        ]
      }
    ]
  }
}

```
