# LogicalObservationIdentifierNamesAndCodes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LogicalObservationIdentifierNamesAndCodes**

## ValueSet: LogicalObservationIdentifierNamesAndCodes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-LogicalObservationIdentifierNamesAndCodes | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:LogicalObservationIdentifierNamesAndCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.16492 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The LOINC database provides a set of universal names and ID codes for identifying laboratory and clinical test results. The purpose is to facilitate the exchange and pooling of results, such as blood hemoglobin, serum potassium, or vital signs, for clinical care, outcomes management, and research. The LOINC codes are not intended to transmit all possible information about a test or observation. They are only intended to identify the test result or clinical observation. http://www.regenstrief.org/LOINC/LOINC.htm 

 **References** 

* Included into [ObservationType](ValueSet-v3-ObservationType.md)

### Logical Definition (CLD)

Language: en

* Include all codes defined in [`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server)

 

### Expansion

Expansion from tx.fhir.org based on Loinc v2.81

This value set has >1000 codes in it. In order to keep the publication size manageable, only a selection (1000 codes) of the whole set of codes is shown

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-LogicalObservationIdentifierNamesAndCodes",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-LogicalObservationIdentifierNamesAndCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.16492"
    }
  ],
  "version" : "3.0.0",
  "name" : "LogicalObservationIdentifierNamesAndCodes",
  "title" : "LogicalObservationIdentifierNamesAndCodes",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The LOINC database provides a set of universal names and ID codes for identifying laboratory and clinical test results. The purpose is to facilitate the exchange and pooling of results, such as blood hemoglobin, serum potassium, or vital signs, for clinical care, outcomes management, and research. The LOINC codes are not intended to transmit all possible information about a test or observation. They are only intended to identify the test result or clinical observation. http://www.regenstrief.org/LOINC/LOINC.htm",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org"
      }
    ]
  }
}

```
