# KnowledgeSubjectObservationValue - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KnowledgeSubjectObservationValue**

## ValueSet: KnowledgeSubjectObservationValue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-KnowledgeSubjectObservationValue | *Version*:5.0.0 | |
| Active as of 2010-03-16 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:KnowledgeSubjectObservationValue |
| *Other Identifiers:*OID:2.16.840.1.113883.11.76 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Observation values used to indicate a knowledge subject of interest for which knowledge content is requested (e.g., a medication, a laboratory test, a medical condition). 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include all codes defined in [`http://snomed.info/sct`](http://www.snomed.org/)version Not Stated (use latest from terminology server)
* Include all codes defined in `https://www.nlm.nih.gov/mesh`version Not Stated (use latest from terminology server)
* Include all codes defined in `http://terminology.hl7.org/CodeSystem/icd9cm`version Not Stated (use latest from terminology server)
* Include all codes defined in `http://terminology.hl7.org/CodeSystem/icd10`version Not Stated (use latest from terminology server)
* Include all codes defined in [`http://www.nlm.nih.gov/research/umls/rxnorm`](http://www.nlm.nih.gov/research/umls/rxnorm)version Not Stated (use latest from terminology server)
* Include all codes defined in `http://hl7.org/fhir/sid/ndc`version Not Stated (use latest from terminology server)
* Include all codes defined in [`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server)

 

### Expansion

This value set cannot be expanded because the terminology server(s) deemed it too costly to do so

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-KnowledgeSubjectObservationValue",
  "url" : "http://terminology.hl7.org/ValueSet/v3-KnowledgeSubjectObservationValue",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.11.76"
    }
  ],
  "version" : "5.0.0",
  "name" : "KnowledgeSubjectObservationValue",
  "title" : "KnowledgeSubjectObservationValue",
  "status" : "active",
  "experimental" : false,
  "date" : "2010-03-16",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Observation values used to indicate a knowledge subject of interest for which knowledge content is requested (e.g., a medication, a laboratory test, a medical condition).",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct"
      },
      {
        "system" : "https://www.nlm.nih.gov/mesh"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/icd9cm"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/icd10"
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm"
      },
      {
        "system" : "http://hl7.org/fhir/sid/ndc"
      },
      {
        "system" : "http://loinc.org"
      }
    ]
  }
}

```
