# ActRelationshipHasSubject - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActRelationshipHasSubject**

## ValueSet: ActRelationshipHasSubject 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActRelationshipHasSubject | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActRelationshipHasSubject |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20014 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Relates an Act to its subject Act that the first Act is primarily concerned with. 
Examples 
1. The first Act may be a ControlAct manipulating the subject Act
1. The first act is a region of interest (ROI) that defines a region within the subject Act.
1. The first act is a reporting or notification Act, that echos the subject Act for a specific new purpose.
 
Constraints 
An Act may have multiple subject acts. 
Rationale 
The ActRelationshipType "has subject" is similar to the ParticipationType "subject", Acts that primarily operate on physical subjects use the Participation, those Acts that primarily operate on other Acts (other information) use the ActRelationship. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType`](CodeSystem-v3-ActRelationshipType.md)version 📦4.0.0 where concept is-a [SUBJ](CodeSystem-v3-ActRelationshipType.md#v3-ActRelationshipType-SUBJ)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActRelationshipHasSubject",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActRelationshipHasSubject",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20014"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActRelationshipHasSubject",
  "title" : "ActRelationshipHasSubject",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Relates an Act to its subject Act that the first Act is primarily concerned with.\r\n\r\nExamples\r\n\r\n1.  The first Act may be a ControlAct manipulating the subject Act\r\n2.  The first act is a region of interest (ROI) that defines a region within the subject Act.\r\n3.  The first act is a reporting or notification Act, that echos the subject Act for a specific new purpose.\r\n\r\nConstraints\r\n\r\nAn Act may have multiple subject acts.\r\n\r\nRationale\r\n\r\nThe ActRelationshipType \"has subject\" is similar to the ParticipationType \"subject\", Acts that primarily operate on physical subjects use the Participation, those Acts that primarily operate on other Acts (other information) use the ActRelationship.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "SUBJ"
          }
        ]
      }
    ]
  }
}

```
