# ActPrivacyPolicy - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActPrivacyPolicy**

## ValueSet: ActPrivacyPolicy 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActPrivacyPolicy | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActPrivacyPolicy |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20424 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
ActPrivacyPolicyType codes support the designation of the 1..* policies that are applicable to an Act such as a Consent Directive, a Role such as a VIP Patient, or an Entity such as a patient who is a minor. 1..* ActPrivacyPolicyType values may be associated with an Act or Role to indicate the policies that govern the assignment of an Act or Role confidentialityCode. Use of multiple ActPrivacyPolicyType values enables fine grain specification of applicable policies, but must be carefully assigned to ensure cogency and avoid creation of conflicting policy mandates. Statutory title may be named in the ActClassPolicy Act Act.title to specify which privacy policy is being referenced. 

 **References** 

* Included into [SecurityCategoryObservationValue](ValueSet-v3-SecurityCategoryObservationValue.md)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0 where concept is-a [_ActPrivacyPolicy](http://tx.fhir.org/r5/ValueSet/v3-ActCode#v3-ActCode-_ActPrivacyPolicy)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActPrivacyPolicy",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActPrivacyPolicy",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20424"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActPrivacyPolicy",
  "title" : "ActPrivacyPolicy",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "ActPrivacyPolicyType codes support the designation of the 1..\\* policies that are applicable to an Act such as a Consent Directive, a Role such as a VIP Patient, or an Entity such as a patient who is a minor. 1..\\* ActPrivacyPolicyType values may be associated with an Act or Role to indicate the policies that govern the assignment of an Act or Role confidentialityCode. Use of multiple ActPrivacyPolicyType values enables fine grain specification of applicable policies, but must be carefully assigned to ensure cogency and avoid creation of conflicting policy mandates. Statutory title may be named in the ActClassPolicy Act Act.title to specify which privacy policy is being referenced.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_ActPrivacyPolicy"
          }
        ]
      }
    ]
  }
}

```
