# ActMoodRisk - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActMoodRisk**

## ValueSet: ActMoodRisk 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActMoodRisk | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActMoodRisk |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19948 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Definition:**An act that may occur in the future and which is regarded as undesirable. The essential feature of a risk is that if it occurs this would be regarded as a marker of a negative outcome or of deterioration towards a negative outcome. Recording a risk indicates that it is seen as more likely to occur in the subject than in a general member of the population but does not mean it is expected to occur. 
**Examples:**Increased risk of DVT, at risk for sub-acute bacterial endocarditis. 
**Discussion:**Note: An observation in RSK mood expresses the undesirable act, and not the underlying risk factor. A risk factor that is present (e.g. obesity, smoking, etc) should be expressed in event mood. INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen. GOL (goal) reflects a hope to achieve something. EXPEC (expectation) is the prediction of a positive or negative event. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen, and may not be expected to happen. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActMood`](http://tx.fhir.org/r5)version ⏿3.0.0 where concept is-a [RSK](http://tx.fhir.org/r5/ValueSet/v3-ActMood#v3-ActMood-RSK)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActMoodRisk",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActMoodRisk",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19948"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActMoodRisk",
  "title" : "ActMoodRisk",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Definition:**An act that may occur in the future and which is regarded as undesirable. The essential feature of a risk is that if it occurs this would be regarded as a marker of a negative outcome or of deterioration towards a negative outcome. Recording a risk indicates that it is seen as more likely to occur in the subject than in a general member of the population but does not mean it is expected to occur.\r\n\r\n**Examples:**Increased risk of DVT, at risk for sub-acute bacterial endocarditis.\r\n\r\n**Discussion:**Note: An observation in RSK mood expresses the undesirable act, and not the underlying risk factor. A risk factor that is present (e.g. obesity, smoking, etc) should be expressed in event mood. INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen. GOL (goal) reflects a hope to achieve something. EXPEC (expectation) is the prediction of a positive or negative event. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen, and may not be expected to happen.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActMood",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "RSK"
          }
        ]
      }
    ]
  }
}

```
