# ActClassExposure - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActClassExposure**

## ValueSet: ActClassExposure 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActClassExposure | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActClassExposure |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19832 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The action of coming into sufficient physical proximity to allow physical or chemical interaction. Examples include: exposure to radiation, inhalation of peanut aerosol or viral particles. This includes intended exposure (e.g. administering a drug product) as well as accidental or environmental exposure. Actual vs. potential exposure can be differentiated using Act.uncertaintyCode. 
The agent to which the subject was exposed is conveyed as a**Direct**participation or specialization there-of. 
**Constraints:**The following Participations should be used with the following Roles and Entities to distinguish the specific entities: 
* The ****exposed entity**** is the entity of interest that is the recipient of the exposure and potentially affected. This is conveyed through the subject (SBJ) Participation.
* An entity that has carried the agent transmitted in the exposure is the "****exposure source****" (EXSRC). For example:
* When it is unknown whether a participating entity is the source of the agent (EXSRC) or the target of the transmission (SBJ), also known as "****exposure contact****", the "participant" (PART) is used.
* The substance to which the subject is exposed that carries the exposure agent or the chemical substance of interest itself, participates as a "consumable" (CSM). There are at least two configurations: (a) the player of the Role that participates as CSM is the chemical or biological substance mixed or carried by the scoper-entity of the Role (e.g., ingredient role); or (b) the player of the Role that participates as CSM is a mixture known to contain the chemical, radiological or biological substance of interest.
* The device specifically used to administer the substance is associated using the device (DEV) Participation. This may be a device intentionally used (such as applicator device) or it may be a thing that accidentally carried this substance; for instance, an infected needle or knife. The same entity may be related in the act as both EXSRC and DEV.
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActClass`](CodeSystem-v3-ActClass.md)version 📦4.0.0 where concept is-a [EXPOS](CodeSystem-v3-ActClass.md#v3-ActClass-EXPOS)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActClassExposure",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActClassExposure",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19832"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActClassExposure",
  "title" : "ActClassExposure",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The action of coming into sufficient physical proximity to allow physical or chemical interaction. Examples include: exposure to radiation, inhalation of peanut aerosol or viral particles. This includes intended exposure (e.g. administering a drug product) as well as accidental or environmental exposure. Actual vs. potential exposure can be differentiated using Act.uncertaintyCode.\r\n\r\nThe agent to which the subject was exposed is conveyed as a *Direct* participation or specialization there-of.\r\n\r\n*Constraints:* The following Participations should be used with the following Roles and Entities to distinguish the specific entities:\r\n\r\n *  The ***exposed entity*** is the entity of interest that is the recipient of the exposure and potentially affected. This is conveyed through the subject (SBJ) Participation.\r\n *  An entity that has carried the agent transmitted in the exposure is the \"***exposure source***\" (EXSRC). For example:\r\n    \r\n     *  a person or animal who carried an infectious disease and interacts (EXSRC) with another person or animal (SBJ) transmitting the disease agent; or\r\n     *  a place or other environment (EXSRC) and a person or animal (SBJ) who is exposed in the presence of this environment.\r\n *  When it is unknown whether a participating entity is the source of the agent (EXSRC) or the target of the transmission (SBJ), also known as \"***exposure contact***\", the \"participant\" (PART) is used.\r\n *  The substance to which the subject is exposed that carries the exposure agent or the chemical substance of interest itself, participates as a \"consumable\" (CSM). There are at least two configurations: (a) the player of the Role that participates as CSM is the chemical or biological substance mixed or carried by the scoper-entity of the Role (e.g., ingredient role); or (b) the player of the Role that participates as CSM is a mixture known to contain the chemical, radiological or biological substance of interest.\r\n *  The device specifically used to administer the substance is associated using the device (DEV) Participation. This may be a device intentionally used (such as applicator device) or it may be a thing that accidentally carried this substance; for instance, an infected needle or knife. The same entity may be related in the act as both EXSRC and DEV.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "EXPOS"
          }
        ]
      }
    ]
  }
}

```
