# hl7VS-countryCode-3alpha - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **hl7VS-countryCode-3alpha**

## ValueSet: hl7VS-countryCode-3alpha 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v2-notAllCodes-0399 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Hl7VSCountryCode3 |
| *Other Identifiers:*OID:2.16.840.1.113883.21.266 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Value Set of codes that identifies a country of origin for a message. It will be used primarily to specify default elements, such as currency denominations. The values to be used are those of ISO 3166. The ISO 3166 table has three separate forms for the codes for each country, this value set includes only the 3-character alpha form. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include codes from`urn:iso:std:iso:3166`version Not Stated (use latest from terminology server) where code matches (by regex) [A-Z]{3}

 

### Expansion

Expansion from tx.fhir.org based on codesystem unknown version 2018

This value set contains 249 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v2-notAllCodes-0399",
  "url" : "http://terminology.hl7.org/ValueSet/v2-notAllCodes-0399",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.21.266"
    }
  ],
  "version" : "2.0.0",
  "name" : "Hl7VSCountryCode3",
  "title" : "hl7VS-countryCode-3alpha",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Value Set of codes that identifies a country of origin for a message.  It will be used primarily to specify default elements, such as currency denominations. The values to be used are those of ISO 3166. The ISO 3166 table has three separate forms for the codes for each country, this value set includes only the 3-character alpha form.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "urn:iso:std:iso:3166",
        "filter" : [
          {
            "property" : "code",
            "op" : "regex",
            "value" : "[A-Z]{3}"
          }
        ]
      }
    ]
  }
}

```
