# UCUM Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **UCUM Codes**

## ValueSet: UCUM Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/ucum-units | *Version*:1.0.0 | |
| Active as of 2023-11-29 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:UCUMCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.3.912 | | |
| **Copyright/Legal**: The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright © 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html. | | |

 
Unified Code for Units of Measure (UCUM). This value set includes all UCUM codes 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`http://unitsofmeasure.org`](http://unitsofmeasure.org)version Not Stated (use latest from terminology server)

 

### Expansion

Expansion from tx.fhir.org based on codesystem UCUM version 2.2

This value set cannot be fully expanded, but a selection (840 codes) of the whole set of codes is shown here.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ucum-units",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/ucum-units",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.3.912"
    }
  ],
  "version" : "1.0.0",
  "name" : "UCUMCodes",
  "title" : "UCUM Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-11-29T22:07:37+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Unified Code for Units of Measure (UCUM). This value set includes all UCUM codes",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright    © 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures    (UCUM) Organization. All rights reserved.  This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html.",
  "compose" : {
    "include" : [
      {
        "system" : "http://unitsofmeasure.org"
      }
    ]
  }
}

```
