# Image Reference Type - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Image Reference Type**

## ValueSet: Image Reference Type 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/image-reference-type | *Version*:1.0.0 | |
| Active as of 2025-10-14 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ImageReferenceType |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The type of image reference specified by an imaging selection. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "image-reference-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/image-reference-type",
  "version" : "1.0.0",
  "name" : "ImageReferenceType",
  "title" : "Image Reference Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-14T15:33:05+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of image reference specified by an imaging selection.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "concept" : [
          {
            "code" : "111030"
          },
          {
            "code" : "113000"
          },
          {
            "code" : "121080"
          },
          {
            "code" : "121112"
          },
          {
            "code" : "121200"
          },
          {
            "code" : "121191"
          },
          {
            "code" : "121214"
          },
          {
            "code" : "121231"
          },
          {
            "code" : "121232"
          },
          {
            "code" : "121233"
          },
          {
            "code" : "125201"
          },
          {
            "code" : "126100"
          },
          {
            "code" : "130401"
          },
          {
            "code" : "130488"
          },
          {
            "code" : "130489"
          },
          {
            "code" : "128180"
          },
          {
            "code" : "128181"
          },
          {
            "code" : "128182"
          },
          {
            "code" : "128183"
          },
          {
            "code" : "128184"
          },
          {
            "code" : "128185"
          },
          {
            "code" : "128186"
          },
          {
            "code" : "128187"
          },
          {
            "code" : "128188"
          },
          {
            "code" : "128189"
          },
          {
            "code" : "128190"
          },
          {
            "code" : "128191"
          },
          {
            "code" : "128192"
          },
          {
            "code" : "128193"
          },
          {
            "code" : "128194"
          },
          {
            "code" : "128195"
          },
          {
            "code" : "128196"
          },
          {
            "code" : "128197"
          },
          {
            "code" : "128198"
          },
          {
            "code" : "128199"
          },
          {
            "code" : "128200"
          }
        ]
      },
      {
        "valueSet" : [
          "http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_7013.html"
        ]
      },
      {
        "valueSet" : [
          "http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_7201.html"
        ]
      },
      {
        "valueSet" : [
          "http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_7151.html"
        ]
      }
    ]
  }
}

```
