# Action Participant Role - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Action Participant Role**

## ValueSet: Action Participant Role 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/action-participant-role | *Version*:1.0.0 | |
| Draft as of 2017-02-15 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActionParticipantRole |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Either a practitioner role or a relationship type. Note from UTG import - may have been a temporary entry that subsequently disappeared from the FHIR source; unable to locate. Version set to 0.1.0 

 **References** 

* [ActivityDefinition](http://hl7.org/fhir/R5/activitydefinition.html)
* [PlanDefinition](http://hl7.org/fhir/R5/plandefinition.html)
* [RequestOrchestration](http://hl7.org/fhir/R5/requestorchestration.html)

### Logical Definition (CLD)

Last updated: 2017-02-15 16:33:00-0700

Profile: [Shareable ValueSet](http://hl7.org/fhir/R5/shareablevalueset.html)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [Practitioner Role](http://hl7.org/fhir/R5/valueset-practitioner-role.html)
* Import all the codes that are contained in [Patient Relationship Type](http://hl7.org/fhir/R5/valueset-relatedperson-relationshiptype.html)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT International edition 01-Feb. 2025
* [codesystem Practitioner role v1.0.1 (CodeSystem)](CodeSystem-practitioner-role.md)
* [codesystem contactRole2 v2.0.0 (CodeSystem)](CodeSystem-v2-0131.md)
* [codesystem ParticipationType v5.0.0 (CodeSystem)](CodeSystem-v3-ParticipationType.md)
* [codesystem RoleClass v4.0.0 (CodeSystem)](CodeSystem-v3-RoleClass.md)
* [codesystem RoleCode v3.0.0 (CodeSystem)](CodeSystem-v3-RoleCode.md)
* [valueset Practitioner Role v5.0.0 (ValueSet)](http://hl7.org/fhir/R5/valueset-practitioner-role.html)
* [valueset Patient Relationship Type v5.0.0 (ValueSet)](http://hl7.org/fhir/R5/valueset-relatedperson-relationshiptype.html)

This value set expansion contains 554 concepts.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "action-participant-role",
  "meta" : {
    "lastUpdated" : "2017-02-15T16:33:00.000-07:00",
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://terminology.hl7.org/ValueSet/action-participant-role",
  "version" : "1.0.0",
  "name" : "ActionParticipantRole",
  "title" : "Action Participant Role",
  "status" : "draft",
  "experimental" : false,
  "date" : "2017-02-15T16:33:00.000-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Either a practitioner role or a relationship type.  Note from UTG import - may have been a temporary entry that subsequently disappeared from the FHIR source; unable to locate.   Version set to 0.1.0",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://hl7.org/fhir/ValueSet/practitioner-role"]
      },
      {
        "valueSet" : [
          "http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype"
        ]
      }
    ]
  }
}

```
