# MIF concept relationship is reflexivity - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MIF concept relationship is reflexivity**

## Extension: MIF concept relationship is reflexivity 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity | *Version*:0.0.34 |
| Active as of 2025-11-15 | *Computable Name*:SupportedConceptRelationshipReflexivity |

Indicates if the association always holds for a concept with itself (refexive), never holds for a concept with itself (irreflexive)

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.terminology|current/StructureDefinition/ext-mif-relationship-reflexivity)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-mif-relationship-reflexivity.csv), [Excel](StructureDefinition-ext-mif-relationship-reflexivity.xlsx), [Schematron](StructureDefinition-ext-mif-relationship-reflexivity.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-mif-relationship-reflexivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
  "version" : "0.0.34",
  "name" : "SupportedConceptRelationshipReflexivity",
  "title" : "MIF concept relationship is reflexivity",
  "status" : "active",
  "date" : "2025-11-15T12:56:11-07:00",
  "description" : "Indicates if the association always holds for a concept with itself (refexive), never holds for a concept with itself (irreflexive)",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "mif",
      "uri" : "urn:hl7-org:v3/mif2",
      "name" : "HL7 V3 Model Interchange Format 2"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CodeSystem.property"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "MIF concept relationship reflexivity",
        "definition" : "Indicates if the association always holds for a concept with itself (refexive), never holds for a concept with itself (irreflexive)",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/mif-conceptRelationshipReflexivity"
        },
        "mapping" : [
          {
            "identity" : "mif",
            "map" : "SupportedConceptRelationship.reflexivity"
          }
        ]
      }
    ]
  }
}

```
