# MIF concept relationship inverse name - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MIF concept relationship inverse name**

## Extension: MIF concept relationship inverse name 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName | *Version*:0.0.34 |
| Active as of 2025-11-15 | *Computable Name*:SupportedConceptRelationshipInverseName |

Identifies the name of the relationship that references the inverse of the current relationship. Allows linking a relationship and its derived inverse.

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.terminology|current/StructureDefinition/ext-mif-relationship-inverseName)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-mif-relationship-inverseName.csv), [Excel](StructureDefinition-ext-mif-relationship-inverseName.xlsx), [Schematron](StructureDefinition-ext-mif-relationship-inverseName.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-mif-relationship-inverseName",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
  "version" : "0.0.34",
  "name" : "SupportedConceptRelationshipInverseName",
  "title" : "MIF concept relationship inverse name",
  "status" : "active",
  "date" : "2025-11-15T12:56:11-07:00",
  "description" : "Identifies the name of the relationship that references the inverse of the current relationship.  Allows linking a relationship and its derived inverse.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "mif",
      "uri" : "urn:hl7-org:v3/mif2",
      "name" : "HL7 V3 Model Interchange Format 2"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CodeSystem.property"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "MIF concept relationship inverse name",
        "definition" : "Identifies the name of the relationship that references the inverse of the current relationship.  Allows linking a relationship and its derived inverse.",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "mif",
            "map" : "SupportedConceptRelationship.inverseName"
          }
        ]
      }
    ]
  }
}

```
