# pan-Canadian Temporary Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **pan-Canadian Temporary Codes**

## NamingSystem: pan-Canadian Temporary Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-sctemp | *Version*:3.1.0 | |
| Active as of 2019-03-20 | *Responsible:*Canada Health Infoway | *Computable Name*:Sctemp |

 
These pan-Canadian codes are maintained in circumstances where the desired code is not yet available in another code system (HL7 code systems, LOINC, SNOMED, etc.) In general, the codes will be deprecated once an equivalent code is available in the preferred code system. The SCTEMP is a transitional or temporary CodeSystem supported and maintained by Canada Health Infoway. It houses the code(s) required and accepted by Canadian implementers if the implementation cannot wait for the code to be harmonized with the international terminology authority. The SCTEMP CodeSystem also served as a source for tracking submissions that need to be made to the various terminology authorities. The SCTEMP CodeSystem applies to HL7, non-SNOMED CT and non-LOINC /pCLOCD used within pan-Canadian specifications. The SCTEMP is not used for the Unified Code for Units of Measure (UCUM). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-sctemp |
| Version | 3.1.0 |
| Name | Sctemp |
| Title | pan-Canadian Temporary Codes |
| Status | active |
| Definition | These pan-Canadian codes are maintained in circumstances where the desired code is not yet available in another code system (HL7 code systems, LOINC, SNOMED, etc.) In general, the codes will be deprecated once an equivalent code is available in the preferred code system. The SCTEMP is a transitional or temporary CodeSystem supported and maintained by Canada Health Infoway. It houses the code(s) required and accepted by Canadian implementers if the implementation cannot wait for the code to be harmonized with the international terminology authority. The SCTEMP CodeSystem also served as a source for tracking submissions that need to be made to the various terminology authorities. The SCTEMP CodeSystem applies to HL7, non-SNOMED CT and non-LOINC /pCLOCD used within pan-Canadian specifications. The SCTEMP is not used for the Unified Code for Units of Measure (UCUM). |
| Publisher | Canada Health Infoway |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.2.20.5.2
  * **Preferred**: true
* **Type**: URI
  * **Value**: https://fhir.infoway-inforoute.ca/CodeSystem/sctemp
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-sctemp",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-sctemp",
  "version" : "3.1.0",
  "name" : "Sctemp",
  "title" : "pan-Canadian Temporary Codes",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Canada Health Infoway",
  "contact" : [
    {
      "name" : "Canada Health Infoway",
      "telecom" : [
        {
          "system" : "email",
          "value" : "standards@infoway-inforoute.ca"
        }
      ]
    }
  ],
  "responsible" : "Canada Health Infoway",
  "description" : "These pan-Canadian codes are maintained in circumstances where the desired code is not yet available in another code system (HL7 code systems, LOINC, SNOMED, etc.) In general, the codes will be deprecated once an equivalent code is available in the preferred code system. The SCTEMP is a transitional or temporary CodeSystem supported and maintained by Canada Health Infoway.  It houses the code(s) required and accepted by Canadian implementers if the implementation cannot wait for the code to be harmonized  with the international terminology authority. The SCTEMP CodeSystem also served as a  source for tracking  submissions that need to be made to the various terminology authorities. The SCTEMP CodeSystem applies to HL7, non-SNOMED CT and non-LOINC /pCLOCD used within pan-Canadian specifications. The SCTEMP is not used for the Unified Code for Units of Measure (UCUM).",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.2.20.5.2",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://fhir.infoway-inforoute.ca/CodeSystem/sctemp",
      "preferred" : true
    }
  ]
}

```
