# Gene Reference Sequence Collection - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Gene Reference Sequence Collection**

## NamingSystem: Gene Reference Sequence Collection 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-refSeq | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*NCBI | *Computable Name*:RefSeq |

 
The Reference Sequence (RefSeq) is one of the NCBI projects, the RefSeq collection aims to provide a comprehensive, integrated, non-redundant, well-annotated set of sequences, including genomic DNA, transcripts, and proteins. ReqSeq is accessible via BLAST, Entrez, and the NCBI FTP site. Information is also available in Entrez Genomes and Entrez Gene, and for some genomes additional information is available in the Map Viewer. 
RefSeq entries can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, RefSeq entries can be used to as the observation values for genomic reference sequence identifiers (LOINC #: 48013-7). 
More information may be found at: http://www.ncbi.nlm.nih.gov/RefSeq 
Versioning informaiton: The latest release of RefSeq was released on May 13, 2009 with the release number of 35. 
RefSeq generates new releases roughly every two months. The dates of the three previous releases were: Release 34, March 12, 2009 Release 33, January 20, 2009 Release 32, November 17, 2008 
RefSeq is a free database for the public. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-refSeq |
| Version | 2.1.0 |
| Name | RefSeq |
| Title | Gene Reference Sequence Collection |
| Status | retired |
| Definition | The Reference Sequence (RefSeq) is one of the NCBI projects, the RefSeq collection aims to provide a comprehensive, integrated, non-redundant, well-annotated set of sequences, including genomic DNA, transcripts, and proteins. ReqSeq is accessible via BLAST, Entrez, and the NCBI FTP site. Information is also available in Entrez Genomes and Entrez Gene, and for some genomes additional information is available in the Map Viewer.RefSeq entries can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, RefSeq entries can be used to as the observation values for genomic reference sequence identifiers (LOINC #: 48013-7).More information may be found at: http://www.ncbi.nlm.nih.gov/RefSeqVersioning informaiton: The latest release of RefSeq was released on May 13, 2009 with the release number of 35.RefSeq generates new releases roughly every two months. The dates of the three previous releases were: Release 34, March 12, 2009 Release 33, January 20, 2009 Release 32, November 17, 2008RefSeq is a free database for the public. |
| Publisher | NCBI |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.280
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://www.ncbi.nlm.nih.gov/refseq
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-refSeq",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-refSeq",
  "version" : "2.1.0",
  "name" : "RefSeq",
  "title" : "Gene Reference Sequence Collection",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "NCBI",
  "contact" : [
    {
      "name" : "National Center for Biotechnology Information,National Center for Biotechnology Information"
    }
  ],
  "responsible" : "NCBI",
  "description" : "The Reference Sequence (RefSeq) is one of the NCBI projects, the RefSeq collection aims to provide a comprehensive, integrated, non-redundant, well-annotated set of sequences, including genomic DNA, transcripts, and proteins. ReqSeq is accessible via BLAST, Entrez, and the NCBI FTP site. Information is also available in Entrez Genomes and Entrez Gene, and for some genomes additional information is available in the Map Viewer.\r\n\r\nRefSeq entries can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, RefSeq entries can be used to as the observation values for genomic reference sequence identifiers (LOINC \\#: 48013-7).\r\n\r\nMore information may be found at: http://www.ncbi.nlm.nih.gov/RefSeq\r\n\r\nVersioning informaiton: The latest release of RefSeq was released on May 13, 2009 with the release number of 35.\r\n\r\nRefSeq generates new releases roughly every two months. The dates of the three previous releases were: Release 34, March 12, 2009 Release 33, January 20, 2009 Release 32, November 17, 2008\r\n\r\nRefSeq is a free database for the public.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.280",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://www.ncbi.nlm.nih.gov/refseq",
      "preferred" : true
    }
  ]
}

```
