# NUCC Health Care Provider Taxonomy - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NUCC Health Care Provider Taxonomy**

## NamingSystem: NUCC Health Care Provider Taxonomy 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-nuccProviderCodes | *Version*:2.0.1 |
| Active as of 2024-02-09 | *Computable Name*:NuccProviderCodes |

 
The Provider Taxonomy Code List is published (released) twice a year on July 1st and January 1st. The July publication is effective for use on October 1st and the January publication is effective for use on April 1st. The time between the publication release and the effective date is considered an implementation period to allow providers, payers and vendors an opportunity to incorporate any changes into their systems. This listing includes Active codes approved for use effective April 1st, 2003, version 3.0; and codes that are New and approved for use effective October 1st, 2003, version 3.1. 
It was identified that there is an IP licensure issue with the republishing of the content for this code system by HL7, so the content was removed as of the July 2016 Harmonization cycle release. This external code system content may be accessed from the web page located at http://www.nucc.org/index.php/code-sets-mainmenu-41/provider-taxonomy-mainmenu-40. Multiple formats and means of accessing the content are available from this page. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-nuccProviderCodes |
| Version | 2.0.1 |
| Name | NuccProviderCodes |
| Title | NUCC Health Care Provider Taxonomy |
| Status | active |
| Definition | The Provider Taxonomy Code List is published (released) twice a year on July 1st and January 1st. The July publication is effective for use on October 1st and the January publication is effective for use on April 1st. The time between the publication release and the effective date is considered an implementation period to allow providers, payers and vendors an opportunity to incorporate any changes into their systems. This listing includes Active codes approved for use effective April 1st, 2003, version 3.0; and codes that are New and approved for use effective October 1st, 2003, version 3.1.It was identified that there is an IP licensure issue with the republishing of the content for this code system by HL7, so the content was removed as of the July 2016 Harmonization cycle release. This external code system content may be accessed from the web page located at http://www.nucc.org/index.php/code-sets-mainmenu-41/provider-taxonomy-mainmenu-40. Multiple formats and means of accessing the content are available from this page. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.101
  * **Preferred**: true
  * **Comment**: 
* **Type**: URI
  * **Value**: http://nucc.org/provider-taxonomy
  * **Preferred**: true
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v3-nuccProviderCodes
  * **Preferred**: false
  * **Comment**: Published for many years in HL7 Standards with this name, but has now been corrected to refer to the IP owner. Retained here for backwards-compatibility and reference.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-nuccProviderCodes",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-nuccProviderCodes",
  "version" : "2.0.1",
  "name" : "NuccProviderCodes",
  "title" : "NUCC Health Care Provider Taxonomy",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-02-09T00:00:00-04:00",
  "description" : "The Provider Taxonomy Code List is published (released) twice a year on July 1st and January 1st. The July publication is effective for use on October 1st and the January publication is effective for use on April 1st. The time between the publication release and the effective date is considered an implementation period to allow providers, payers and vendors an opportunity to incorporate any changes into their systems. This listing includes Active codes approved for use effective April 1st, 2003, version 3.0; and codes that are New and approved for use effective October 1st, 2003, version 3.1.\r\n\r\nIt was identified that there is an IP licensure issue with the republishing of the content for this code system by HL7, so the content was removed as of the July 2016 Harmonization cycle release. This external code system content may be accessed from the web page located at http://www.nucc.org/index.php/code-sets-mainmenu-41/provider-taxonomy-mainmenu-40. Multiple formats and means of accessing the content are available from this page.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.101",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://nucc.org/provider-taxonomy",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v3-nuccProviderCodes",
      "preferred" : false,
      "comment" : "Published for many years in HL7 Standards with this name, but has now been corrected to refer to the IP owner.   Retained here for backwards-compatibility and reference."
    }
  ]
}

```
