# pan-Canadian LOINC Observation Code Database - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **pan-Canadian LOINC Observation Code Database**

## NamingSystem: pan-Canadian LOINC Observation Code Database 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/pclocd | *Version*:2.2.0 | |
| Active as of 2019-03-20 | *Responsible:*Canada Health Infoway | *Computable Name*:Pclocd |

 
The pan Canadian LOINC Observation Code Database (pCLOCD) is the Canadian version of the LOINC(tm) database. It was created using the LOINC(tm) records and attributes that were constrained for Canadian use and supplemented to specifically meet Canadian requirements. It contains the core LOINC(tm) attributes as required by Regenstrief copyright rules. The LOINC(tm) Component has been customized to meet Canadian requirements and is displayed as the pan Canadian Component Name. This component name is the basis for the pan Canadian Display Name. Core attributes are include both English and Canadian French. 
This code system contains supplemental "X" codes defined in the pCLOCD that do not yet exist in the LOINC code system. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/pclocd |
| Version | 2.2.0 |
| Name | Pclocd |
| Title | pan-Canadian LOINC Observation Code Database |
| Status | active |
| Definition | The pan Canadian LOINC Observation Code Database (pCLOCD) is the Canadian version of the LOINC(tm) database. It was created using the LOINC(tm) records and attributes that were constrained for Canadian use and supplemented to specifically meet Canadian requirements. It contains the core LOINC(tm) attributes as required by Regenstrief copyright rules. The LOINC(tm) Component has been customized to meet Canadian requirements and is displayed as the pan Canadian Component Name. This component name is the basis for the pan Canadian Display Name. Core attributes are include both English and Canadian French.This code system contains supplemental "X" codes defined in the pCLOCD that do not yet exist in the LOINC code system. |
| Publisher | Canada Health Infoway |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.2.20.5.1
  * **Preferred**: true
* **Type**: URI
  * **Value**: https://fhir.infoway-inforoute.ca/CodeSystem/pCLOCD
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "pclocd",
  "url" : "http://terminology.hl7.org/NamingSystem/pclocd",
  "version" : "2.2.0",
  "name" : "Pclocd",
  "title" : "pan-Canadian LOINC Observation Code Database",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Canada Health Infoway",
  "contact" : [
    {
      "name" : "Canada Health Infoway",
      "telecom" : [
        {
          "system" : "email",
          "value" : "standards@infoway-inforoute.ca"
        }
      ]
    }
  ],
  "responsible" : "Canada Health Infoway",
  "description" : "The pan Canadian LOINC Observation Code Database (pCLOCD) is the Canadian version of the LOINC(tm) database. It was created using the LOINC(tm) records and attributes that were constrained for Canadian use and supplemented to specifically meet Canadian requirements. It contains the core LOINC(tm) attributes as required by Regenstrief copyright rules. The LOINC(tm) Component has been customized to meet Canadian requirements and is displayed as the pan Canadian Component Name. This component name is the basis for the pan Canadian Display Name. Core attributes are include both English and Canadian French.\r\n\r\nThis code system contains supplemental \"X\" codes defined in the pCLOCD that do not yet exist in the LOINC code system.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.2.20.5.1",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://fhir.infoway-inforoute.ca/CodeSystem/pCLOCD",
      "preferred" : true
    }
  ]
}

```
