# Passport Numbers Namespace for LUXEMBOURG - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for LUXEMBOURG**

## NamingSystem: Passport Numbers Namespace for LUXEMBOURG 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-LUX | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_LUX |

 
Identifier of the namespace for Passport Numbers issued by the country of LUXEMBOURG. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-LUX |
| Version | 1.0.0 |
| Name | PassportNumNS_LUX |
| Title | Passport Numbers Namespace for LUXEMBOURG |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of LUXEMBOURG. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.442
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-LUX
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-LUX",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-LUX",
  "version" : "1.0.0",
  "name" : "PassportNumNS_LUX",
  "title" : "Passport Numbers Namespace for LUXEMBOURG",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of LUXEMBOURG.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.442",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-LUX",
      "preferred" : true
    }
  ]
}

```
