# ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code**

## NamingSystem: ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/iso639-1 | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*ISO | *Computable Name*:Iso6391 |

 
**Description:**Codes for the Representation of Names of Languages Part 1: Alpha-2 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification. 
This part of ISO 639 provides a code consisting of language code elements comprising two-letter language identifiers for the representation of names of languages. The language identifiers according to this part of ISO 639 were devised originally for use in terminology, lexicography and linguistics, but may be adopted for any application requiring the expression of language in two- letter coded form, especially in computerized systems. The alpha-2 code was devised for practical use for most of the major languages of the world that are not only most frequently represented in the total body of the world's literature, but which also comprise a considerable volume of specialized languages and terminologies. Additional language identifiers are created when it becomes apparent that a significant body of documentation written in specialized languages and terminologies exists. Languages designed exclusively for machine use, such as computer-programming languages, are not included in this code. 
The code set is available from http://www.iso.org/iso/iso_catalogue/catalogue_ics/catalogue_detail_ics.htm? csnumber=22109&ICS1=1&ICS2=140&ICS3=20 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/iso639-1 |
| Version | 2.1.0 |
| Name | Iso6391 |
| Title | ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code |
| Status | retired |
| Definition | **Description:** Codes for the Representation of Names of Languages Part 1: Alpha-2 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification.This part of ISO 639 provides a code consisting of language code elements comprising two-letter language identifiers for the representation of names of languages. The language identifiers according to this part of ISO 639 were devised originally for use in terminology, lexicography and linguistics, but may be adopted for any application requiring the expression of language in two- letter coded form, especially in computerized systems. The alpha-2 code was devised for practical use for most of the major languages of the world that are not only most frequently represented in the total body of the world's literature, but which also comprise a considerable volume of specialized languages and terminologies. Additional language identifiers are created when it becomes apparent that a significant body of documentation written in specialized languages and terminologies exists. Languages designed exclusively for machine use, such as computer-programming languages, are not included in this code.The code set is available from http://www.iso.org/iso/iso_catalogue/catalogue_ics/catalogue_detail_ics.htm? csnumber=22109&ICS1=1&ICS2=140&ICS3=20 |
| Publisher | ISO |

### Identifiers

* **Type**: OID
  * **Value**: 1.0.639.1
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/iso639-1
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "iso639-1",
  "url" : "http://terminology.hl7.org/NamingSystem/iso639-1",
  "version" : "2.1.0",
  "name" : "Iso6391",
  "title" : "ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "ISO",
  "contact" : [
    {
      "name" : "International Organization for Standardization (ISO)"
    }
  ],
  "responsible" : "ISO",
  "description" : "**Description:** Codes for the Representation of Names of Languages Part 1: Alpha-2 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification.\r\n\r\nThis part of ISO 639 provides a code consisting of language code elements comprising two-letter language identifiers for the representation of names of languages. The language identifiers according to this part of ISO 639 were devised originally for use in terminology, lexicography and linguistics, but may be adopted for any application requiring the expression of language in two- letter coded form, especially in computerized systems. The alpha-2 code was devised for practical use for most of the major languages of the world that are not only most frequently represented in the total body of the world's literature, but which also comprise a considerable volume of specialized languages and terminologies. Additional language identifiers are created when it becomes apparent that a significant body of documentation written in specialized languages and terminologies exists. Languages designed exclusively for machine use, such as computer-programming languages, are not included in this code.\r\n\r\nThe code set is available from http://www.iso.org/iso/iso\\_catalogue/catalogue\\_ics/catalogue\\_detail\\_ics.htm? csnumber=22109&ICS1=1&ICS2=140&ICS3=20",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "1.0.639.1",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/iso639-1",
      "preferred" : true
    }
  ]
}

```
