# CMS Hierarchical Condition Categories - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CMS Hierarchical Condition Categories**

## NamingSystem: CMS Hierarchical Condition Categories 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/cmshcc | *Version*:1.1.0 |
| Active as of 2024-01-26 | *Responsible:*Centers for Medicare & Medicaid Services /td>*Computable Name*:CMSHCCThe CMS-HCC model uses more than 9,000 ICD-10-CM codes, which are mapped to condition categories that predict costs well. The condition categories are based on diagnoses clinically related to one another and with similar predicted cost implications. Hierarchies are imposed on the condition categories to capture the most costly diagnoses. Hierarchy logic is imposed on certain condition categories to account for different hierarchical costs, thus, the term Hierarchical Condition Category, or HCC.For more information, see https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors.The CMS HCCs are in the public domain and are free to use without restriction.### Summary
| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/cmshcc |
| Version | 1.1.0 |
| Name | CMSHCC |
| Title | CMS Hierarchical Condition Categories |
| Status | active |
| Definition | The CMS-HCC model uses more than 9,000 ICD-10-CM codes, which are mapped to condition categories that predict costs well. The condition categories are based on diagnoses clinically related to one another and with similar predicted cost implications. Hierarchies are imposed on the condition categories to capture the most costly diagnoses. Hierarchy logic is imposed on certain condition categories to account for different hierarchical costs, thus, the term Hierarchical Condition Category, or HCC.For more information, see https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors.The CMS HCCs are in the public domain and are free to use without restriction. |
| Publisher | Centers for Medicare & Medicaid Services |
### Identifiers
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/cmshcc
  * **Preferred**: true
  * **Period**: 2021-12-02 --> (ongoing)
* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.349
  * **Preferred**: true
  * **Period**: 

-------
**History** |



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "cmshcc",
  "url" : "http://terminology.hl7.org/NamingSystem/cmshcc",
  "version" : "1.1.0",
  "name" : "CMSHCC",
  "title" : "CMS Hierarchical Condition Categories",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-01-26T00:00:00-00:00",
  "publisher" : "Centers for Medicare & Medicaid Services",
  "responsible" : "Centers for Medicare & Medicaid Services",
  "description" : "The CMS-HCC model uses more than 9,000 ICD-10-CM codes, which are mapped to condition categories that predict costs well. The condition categories are based on diagnoses clinically related to one another and with similar predicted cost implications. Hierarchies are imposed on the condition categories to capture the most costly diagnoses. Hierarchy logic is imposed on certain condition categories to account for different hierarchical costs, thus, the term Hierarchical Condition Category, or HCC.\r\n\r\nFor more information, see https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors.\r\n\r\nThe CMS HCCs are in the public domain and are free to use without restriction.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/cmshcc",
      "preferred" : true,
      "period" : {
        "start" : "2021-12-02"
      }
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.349",
      "preferred" : true
    }
  ]
}

```
