# W3C Decentralized Identifier (DID) - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **W3C Decentralized Identifier (DID)**

## NamingSystem: W3C Decentralized Identifier (DID) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/W3CDID | *Version*:1.0.0 |
| Active as of 2022-11-21 | *Computable Name*:W3CDID |
| **Copyright/Legal**: W3C offers several licenses depending on the nature of the material, and whether derivative works are permitted.* The [Document License](https://www.w3.org/Consortium/Legal/copyright-documents) governs documents such as technical reports. See also the [policy for relicensing unfinished W3C specifications](https://www.w3.org/2014/12/relicense.html)
 | |

 
"[Decentralized identifiers](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers)(DIDs) are a new type of identifier that enables verifiable, decentralized digital identity. A DID refers to any subject (e.g., a person, organization, thing, data model, abstract entity, etc.) as determined by the controller of the[DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers). In contrast to typical, federated identifiers,[DIDs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers)have been designed so that they may be decoupled from centralized registries, identity providers, and certificate authorities. Specifically, while other parties might be used to help enable the discovery of information related to a[DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers), the design enables the controller of a[DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers)to prove control over it without requiring permission from any other party.[DIDs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers)are[URIs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-uri)that associate a[DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects)with a[DID document](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-documents)allowing trustable interactions associated with that subject. 
Each[DID document](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-documents)can express cryptographic material,[verification methods](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-verification-method), or[services](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-service), which provide a set of mechanisms enabling a[DID controller](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-controllers)to prove control of the[DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers).[Services](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-service)enable trusted interactions associated with the[DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects). A[DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers)might provide the means to return the[DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects)itself, if the[DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects)is an information resource such as a data model." 
For more information, see[https://www.w3.org/TR/did-core/](https://www.w3.org/TR/did-core/) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/W3CDID |
| Version | 1.0.0 |
| Name | W3CDID |
| Title | W3C Decentralized Identifier (DID) |
| Status | active |
| Definition | "[Decentralized identifiers](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) (DIDs) are a new type of identifier that enables verifiable, decentralized digital identity. A DID refers to any subject (e.g., a person, organization, thing, data model, abstract entity, etc.) as determined by the controller of the [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers). In contrast to typical, federated identifiers, [DIDs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) have been designed so that they may be decoupled from centralized registries, identity providers, and certificate authorities. Specifically, while other parties might be used to help enable the discovery of information related to a [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers), the design enables the controller of a [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) to prove control over it without requiring permission from any other party. [DIDs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) are [URIs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-uri) that associate a [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) with a [DID document](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-documents) allowing trustable interactions associated with that subject.Each [DID document](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-documents) can express cryptographic material, [verification methods](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-verification-method), or [services](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-service), which provide a set of mechanisms enabling a [DID controller](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-controllers) to prove control of the [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers). [Services](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-service) enable trusted interactions associated with the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects). A [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) might provide the means to return the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) itself, if the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) is an information resource such as a data model."For more information, see [https://www.w3.org/TR/did-core/](https://www.w3.org/TR/did-core/) |
| Copyright | W3C offers several licenses depending on the nature of the material, and whether derivative works are permitted.* The [Document License](https://www.w3.org/Consortium/Legal/copyright-documents) governs documents such as technical reports. See also the [policy for relicensing unfinished W3C specifications](https://www.w3.org/2014/12/relicense.html)
 |

### Identifiers

* **Type**: URI
  * **Value**: https://www.w3.org/ns/did
  * **Preferred**: true
  * **Period**: 2022-10-27 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "W3CDID",
  "url" : "http://terminology.hl7.org/NamingSystem/W3CDID",
  "version" : "1.0.0",
  "name" : "W3CDID",
  "title" : "W3C Decentralized Identifier (DID)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-11-21T00:00:00-00:00",
  "contact" : [
    {
      "name" : "W3C",
      "telecom" : [
        {
          "system" : "email",
          "value" : "public-did-wg@w3.org"
        },
        {
          "system" : "url",
          "value" : "https://www.w3.org/"
        }
      ]
    }
  ],
  "description" : "\"[Decentralized identifiers](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) (DIDs) are a new type of identifier that enables verifiable, decentralized digital identity. A DID refers to any subject (e.g., a person, organization, thing, data model, abstract entity, etc.) as determined by the controller of the [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers). In contrast to typical, federated identifiers, [DIDs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) have been designed so that they may be decoupled from centralized registries, identity providers, and certificate authorities. Specifically, while other parties might be used to help enable the discovery of information related to a [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers), the design enables the controller of a [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) to prove control over it without requiring permission from any other party. [DIDs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) are [URIs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-uri) that associate a [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) with a [DID document](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-documents) allowing trustable interactions associated with that subject.\r\n\r\nEach [DID document](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-documents) can express cryptographic material, [verification methods](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-verification-method), or [services](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-service), which provide a set of mechanisms enabling a [DID controller](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-controllers) to prove control of the [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers). [Services](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-service) enable trusted interactions associated with the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects). A [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) might provide the means to return the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) itself, if the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) is an information resource such as a data model.\"\r\n\r\nFor more information, see [https://www.w3.org/TR/did-core/](https://www.w3.org/TR/did-core/)",
  "copyright" : "W3C offers several licenses depending on the nature of the material, and whether derivative works are permitted.\r\n\r\n - The [Document License](https://www.w3.org/Consortium/Legal/copyright-documents) governs documents such as technical reports. See also the [policy for relicensing unfinished W3C specifications](https://www.w3.org/2014/12/relicense.html)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://www.w3.org/ns/did",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-10-27"
      }
    }
  ]
}

```
