# SCDHEC GIS Spatial Accuracy Tiers - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SCDHEC GIS Spatial Accuracy Tiers**

## NamingSystem: SCDHEC GIS Spatial Accuracy Tiers 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/SCDHEC-GISSpatialAccuracyTiers | *Version*:2.1.0 |
| Retired as of 2021-11-09 | *Computable Name*:SCDHECGISSpatialAccuracyTiers |

 
**Description:**The South Carolina Department of Health and Environmental Control GIS Spatial Data Accuracy Tiers have been derived from the National Standard for Spatial Data Accuracy as a means to categorize the accuracy of spatial data assignment utilizing a variety of tools for capturing coordinates including digitizers, geocoding software and global positioning system devices. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/SCDHEC-GISSpatialAccuracyTiers |
| Version | 2.1.0 |
| Name | SCDHECGISSpatialAccuracyTiers |
| Title | SCDHEC GIS Spatial Accuracy Tiers |
| Status | retired |
| Definition | **Description:** The South Carolina Department of Health and Environmental Control GIS Spatial Data Accuracy Tiers have been derived from the National Standard for Spatial Data Accuracy as a means to categorize the accuracy of spatial data assignment utilizing a variety of tools for capturing coordinates including digitizers, geocoding software and global positioning system devices. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.241
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/SCDHEC-GISSpatialAccuracyTiers
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "SCDHEC-GISSpatialAccuracyTiers",
  "url" : "http://terminology.hl7.org/NamingSystem/SCDHEC-GISSpatialAccuracyTiers",
  "version" : "2.1.0",
  "name" : "SCDHECGISSpatialAccuracyTiers",
  "title" : "SCDHEC GIS Spatial Accuracy Tiers",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "description" : "**Description:** The South Carolina Department of Health and Environmental Control GIS Spatial Data Accuracy Tiers have been derived from the National Standard for Spatial Data Accuracy as a means to categorize the accuracy of spatial data assignment utilizing a variety of tools for capturing coordinates including digitizers, geocoding software and global positioning system devices.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.241",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/SCDHEC-GISSpatialAccuracyTiers",
      "preferred" : true
    }
  ]
}

```
