# National Council of State Boards of Nursing (NCSBN) ID - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **National Council of State Boards of Nursing (NCSBN) ID**

## NamingSystem: National Council of State Boards of Nursing (NCSBN) ID 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/NCSBNID | *Version*:1.0.0 | |
| Active as of 2025-10-02 | *Responsible:*[National Council of State Boards of Nursing](https://www.ncsbn.org/index.page) | *Computable Name*:NCSBNID |
| **Copyright/Legal**: No license or other permission is required for this use. | | |

 
Every licensed nurse is assigned an NCSBN ID. This unique number connects all licenses held by a nurse—regardless of license type and across jurisdictions. It supports efficient license management and verification while protecting personal identifiable information (PII), enabling data sharing between systems without compromising privacy. With one number, a nurse can easily access all licensure information in one place. 
Nursys is the only national database for verification of nurse licensure, discipline and practice privileges for RNs, LPN/VNs and APRNs licensed in participating jurisdictions, including all states in the Nurse Licensure Compact (NLC). 
For more information, see[https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page](https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/NCSBNID |
| Version | 1.0.0 |
| Name | NCSBNID |
| Title | National Council of State Boards of Nursing (NCSBN) ID |
| Status | active |
| Definition | Every licensed nurse is assigned an NCSBN ID. This unique number connects all licenses held by a nurse—regardless of license type and across jurisdictions. It supports efficient license management and verification while protecting personal identifiable information (PII), enabling data sharing between systems without compromising privacy. With one number, a nurse can easily access all licensure information in one place.Nursys is the only national database for verification of nurse licensure, discipline and practice privileges for RNs, LPN/VNs and APRNs licensed in participating jurisdictions, including all states in the Nurse Licensure Compact (NLC).For more information, see [https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page](https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page). |
| Publisher | National Council of State Boards of Nursing |
| Copyright | No license or other permission is required for this use. |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/NamingSystem/NCSBNID
  * **Preferred**: true
  * **Period**: 2025-10-02 --> (ongoing)



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "NCSBNID",
  "url" : "http://terminology.hl7.org/NamingSystem/NCSBNID",
  "version" : "1.0.0",
  "name" : "NCSBNID",
  "title" : "National Council of State Boards of Nursing (NCSBN) ID",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2025-10-02T00:00:00-00:00",
  "publisher" : "National Council of State Boards of Nursing",
  "contact" : [
    {
      "name" : "National Council of State Boards of Nursing; PO Box 5300, Scranton, PA 18505",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "312-525-3600"
        },
        {
          "system" : "url",
          "value" : "https://www.ncsbn.org/index.page"
        }
      ]
    }
  ],
  "responsible" : "National Council of State Boards of Nursing",
  "description" : "Every licensed nurse is assigned an NCSBN ID. This unique number connects all licenses held by a nurse—regardless of license type and across jurisdictions. It supports efficient license management and verification while protecting personal identifiable information (PII), enabling data sharing between systems without compromising privacy. With one number, a nurse can easily access all licensure information in one place.\r\n\r\nNursys is the only national database for verification of nurse licensure, discipline and practice privileges for RNs, LPN/VNs and APRNs licensed in participating jurisdictions, including all states in the Nurse Licensure Compact (NLC).\r\n\r\nFor more information, see [https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page](https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page).",
  "copyright" : "No license or other permission is required for this use.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/NamingSystem/NCSBNID",
      "preferred" : true,
      "period" : {
        "start" : "2025-10-02"
      }
    }
  ]
}

```
