# Intelligent Medical Objects - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Intelligent Medical Objects**

## NamingSystem: Intelligent Medical Objects 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/IMO | *Version*:1.0.0 | |
| Active as of 2021-06-25 | *Responsible:*[Intelligent Medical Objects](https://www.imohealth.com/) | *Computable Name*:IMO |

 
IMO is a clinical interface terminology, which helps to map diagnostic, procedure and other terminologies to medical concepts and codes. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/IMO |
| Version | 1.0.0 |
| Name | IMO |
| Title | Intelligent Medical Objects |
| Status | active |
| Definition | IMO is a clinical interface terminology, which helps to map diagnostic, procedure and other terminologies to medical concepts and codes. |
| Publisher | Intelligent Medical Objects |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.3.247
  * **Preferred**: true
  * **Period**: 2021-06-25 --> (ongoing)
* **Type**: URI
  * **Value**: http://imohealth.com/ontology/
  * **Preferred**: true
  * **Period**: 2021-06-25 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "IMO",
  "url" : "http://terminology.hl7.org/NamingSystem/IMO",
  "version" : "1.0.0",
  "name" : "IMO",
  "title" : "Intelligent Medical Objects",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-06-25T00:00:00-00:00",
  "publisher" : "Intelligent Medical Objects",
  "contact" : [
    {
      "name" : "Intelligent Medical Objects; Ann Phillips",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "847.613.6655"
        },
        {
          "system" : "email",
          "value" : "support@imohealth.com"
        },
        {
          "system" : "url",
          "value" : "https://www.imohealth.com/"
        }
      ]
    }
  ],
  "description" : "IMO is a clinical interface terminology, which helps to map diagnostic, procedure and other terminologies to medical concepts and codes.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.3.247",
      "preferred" : true,
      "period" : {
        "start" : "2021-06-25"
      }
    },
    {
      "type" : "uri",
      "value" : "http://imohealth.com/ontology/",
      "preferred" : true,
      "period" : {
        "start" : "2021-06-25"
      }
    }
  ]
}

```
