# FEvIR Object Identifier - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FEvIR Object Identifier**

## NamingSystem: FEvIR Object Identifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/FOI | *Version*:1.0.0 | |
| Active as of 2025-08-07 | *Responsible:*[Computable Publishing LLC](https://computablepublishing.com) | *Computable Name*:FOI |
| **Copyright/Legal**: The FEvIR Platform is owned by Computable Publishing LLC. Content on the FEvIR Platform can have varied copyright and is determined by the content owner. The default copyright value for content is[https://creativecommons.org/licenses/by-nc-sa/4.0/](https://creativecommons.org/licenses/by-nc-sa/4.0/). | | |

 
The FEvIR Object Identifier (FOI) is a globally unique persistent digital object identifier for Resources accessible through the FEvIR Platform. The FEvIR Platform is a platform to support creation, viewing, notification, and interaction for computable expression of scientific knowledge. The FEvIR Platform is used to facilitate many projects, including the HL7 EBMonFHIR project and the Evidence Based Medicine on FHIR Implementation Guide. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/FOI |
| Version | 1.0.0 |
| Name | FOI |
| Title | FEvIR Object Identifier |
| Status | active |
| Definition | The FEvIR Object Identifier (FOI) is a globally unique persistent digital object identifier for Resources accessible through the FEvIR Platform. The FEvIR Platform is a platform to support creation, viewing, notification, and interaction for computable expression of scientific knowledge. The FEvIR Platform is used to facilitate many projects, including the HL7 EBMonFHIR project and the Evidence Based Medicine on FHIR Implementation Guide. |
| Publisher | Computable Publishing LLC |
| Copyright | The FEvIR Platform is owned by Computable Publishing LLC. Content on the FEvIR Platform can have varied copyright and is determined by the content owner. The default copyright value for content is [https://creativecommons.org/licenses/by-nc-sa/4.0/](https://creativecommons.org/licenses/by-nc-sa/4.0/). |

### Identifiers

* **Type**: URI
  * **Value**: https://fevir.net/FOI
  * **Preferred**: true
  * **Period**: 2025-08-07 00:00:00+0000 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "FOI",
  "url" : "http://terminology.hl7.org/NamingSystem/FOI",
  "version" : "1.0.0",
  "name" : "FOI",
  "title" : "FEvIR Object Identifier",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2025-08-07T00:00:00-00:00",
  "publisher" : "Computable Publishing LLC",
  "contact" : [
    {
      "name" : "Computable Publishing LLC; Brian Alper; 212 Crawford Lane, Franklin, NC 28734",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://computablepublishing.com"
        },
        {
          "system" : "email",
          "value" : "support@computablepublishing.com"
        }
      ]
    }
  ],
  "responsible" : "Computable Publishing LLC; Brian S. Alper",
  "description" : "The FEvIR Object Identifier (FOI) is a globally unique persistent digital object identifier for Resources accessible through the FEvIR Platform. The FEvIR Platform is a platform to support creation, viewing, notification, and interaction for computable expression of scientific knowledge. The FEvIR Platform is used to facilitate many projects, including the HL7 EBMonFHIR project and the Evidence Based Medicine on FHIR Implementation Guide.",
  "copyright" : "The FEvIR Platform is owned by Computable Publishing LLC. Content on the FEvIR Platform can have varied copyright and is determined by the content owner. The default copyright value for content is [https://creativecommons.org/licenses/by-nc-sa/4.0/](https://creativecommons.org/licenses/by-nc-sa/4.0/).",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://fevir.net/FOI",
      "preferred" : true,
      "period" : {
        "start" : "2025-08-07T00:00:00-00:00"
      }
    }
  ]
}

```
