# Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4) - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4)**

## NamingSystem: Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/FIPS64 | *Version*:1.0.0 | |
| Active as of 2024-10-21 | *Responsible:*[U.S. Department of Commerce; National Institute of Standards and Technology (NIST)](https://www.nist.gov/about-nist) | *Computable Name*:FIPS6_4 |
| **Copyright/Legal**: Data/works created by NIST employees that are not covered by the Standard Reference Data Act are subject to[17 U.S.C. §105](https://www.govinfo.gov/content/pkg/USCODE-2014-title17/pdf/USCODE-2014-title17-chap1-sec105.pdf)and generally are not subject to copyright protection within the United States. NIST data or other works may be subject to copyright protection in foreign countries. NIST may also obtain and hold copyright in data/works created by non-NIST employees (e.g., NIST contractors) when copyright is assigned to NIST. | | |

 
"The FIPS county code is a five-digit Federal Information Processing Standard (FIPS) code (FIPS 6-4) which uniquely identifies counties and county equivalents in the United States, certain U.S. possessions, and certain freely associated states. This is the 3-digit part of the 5-digit county FIPS code specifically standing for the county." 
For more information, see[https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/FIPS64 |
| Version | 1.0.0 |
| Name | FIPS6_4 |
| Title | Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4) |
| Status | active |
| Definition | "The FIPS county code is a five-digit Federal Information Processing Standard (FIPS) code (FIPS 6-4) which uniquely identifies counties and county equivalents in the United States, certain U.S. possessions, and certain freely associated states. This is the 3-digit part of the 5-digit county FIPS code specifically standing for the county."For more information, see [https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf) |
| Publisher | U.S. Department of Commerce; National Institute of Standards and Technology (NIST) |
| Copyright | Data/works created by NIST employees that are not covered by the Standard Reference Data Act are subject to [17 U.S.C. §105](https://www.govinfo.gov/content/pkg/USCODE-2014-title17/pdf/USCODE-2014-title17-chap1-sec105.pdf) and generally are not subject to copyright protection within the United States. NIST data or other works may be subject to copyright protection in foreign countries. NIST may also obtain and hold copyright in data/works created by non-NIST employees (e.g., NIST contractors) when copyright is assigned to NIST. |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/FIPS64
  * **Preferred**: true
  * **Period**: 2024-10-21 --> (ongoing)
* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.93
  * **Preferred**: true
  * **Period**: 

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "FIPS64",
  "url" : "http://terminology.hl7.org/NamingSystem/FIPS64",
  "version" : "1.0.0",
  "name" : "FIPS6_4",
  "title" : "Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-10-21T00:00:00-00:00",
  "publisher" : "U.S. Department of Commerce; National Institute of Standards and Technology (NIST)",
  "contact" : [
    {
      "name" : "National Institute of Standards and Technology (NIST); 100 Bureau Drive, Gaithersburg, MD 20899",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nist.gov/about-nist"
        },
        {
          "system" : "phone",
          "value" : "301-975-2000"
        }
      ]
    }
  ],
  "responsible" : "National Institute of Standards and Technology (NIST)",
  "description" : "\"The FIPS county code is a five-digit Federal Information Processing Standard (FIPS) code (FIPS 6-4) which uniquely identifies counties and county equivalents in the United States, certain U.S. possessions, and certain freely associated states. This is the 3-digit part of the 5-digit county FIPS code specifically standing for the county.\"\r\n\r\nFor more information, see [https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf)",
  "copyright" : "Data/works created by NIST employees that are not covered by the Standard Reference Data Act are subject to [17 U.S.C. §105](https://www.govinfo.gov/content/pkg/USCODE-2014-title17/pdf/USCODE-2014-title17-chap1-sec105.pdf) and generally are not subject to copyright protection within the United States.  NIST data or other works may be subject to copyright protection in foreign countries.  NIST may also obtain and hold copyright in data/works created by non-NIST employees (e.g., NIST contractors) when copyright is assigned to NIST.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/FIPS64",
      "preferred" : true,
      "period" : {
        "start" : "2024-10-21"
      }
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.93",
      "preferred" : true
    }
  ]
}

```
