# ClinicalTrials.gov - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ClinicalTrials.gov**

## NamingSystem: ClinicalTrials.gov 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ClinicalTrialsGov | *Version*:1.0.0 | |
| Active as of 2024-04-24 | *Responsible:*[National Library of Medicine](https://www.nlm.nih.gov/) | *Computable Name*:ClinicalTrialsGov |
| **Copyright/Legal**: See[https://clinicaltrials.gov/about-site/terms-conditions](https://clinicaltrials.gov/about-site/terms-conditions)for the Terms and Conditions that apply for use of ClinicalTrials.gov data. | | |

 
The U.S. National Institutes of Health, Department of Health and Human Services, through its National Library of Medicine, has developed[ClinicalTrials.gov](http://clinicaltrials.gov)to provide patients, family members, and members of the public current information about clinical research studies.[ClinicalTrials.gov](http://clinicaltrials.gov)contains summary information about clinical studies being conducted throughout the United States and in many countries throughout the world. These data are provided to the National Library of Medicine by organizations and institutions that sponsor and implement the studies. 
[ClinicalTrials.gov](http://clinicaltrials.gov)is updated daily. You should check[ClinicalTrials.gov](http://clinicaltrials.gov)frequently for updated information. 
More information about ClinicalTrials.gov can be found[here](https://clinicaltrials.gov/about-site/about-ctg). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ClinicalTrialsGov |
| Version | 1.0.0 |
| Name | ClinicalTrialsGov |
| Title | ClinicalTrials.gov |
| Status | active |
| Definition | The U.S. National Institutes of Health, Department of Health and Human Services, through its National Library of Medicine, has developed [ClinicalTrials.gov](http://clinicaltrials.gov) to provide patients, family members, and members of the public current information about clinical research studies. [ClinicalTrials.gov](http://clinicaltrials.gov) contains summary information about clinical studies being conducted throughout the United States and in many countries throughout the world. These data are provided to the National Library of Medicine by organizations and institutions that sponsor and implement the studies.[ClinicalTrials.gov](http://clinicaltrials.gov) is updated daily. You should check [ClinicalTrials.gov](http://clinicaltrials.gov) frequently for updated information.More information about ClinicalTrials.gov can be found [here](https://clinicaltrials.gov/about-site/about-ctg). |
| Publisher | National Library of Medicine |
| Copyright | See [https://clinicaltrials.gov/about-site/terms-conditions](https://clinicaltrials.gov/about-site/terms-conditions) for the Terms and Conditions that apply for use of ClinicalTrials.gov data. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.3.1077
  * **Preferred**: true
  * **Period**: 
* **Type**: URI
  * **Value**: http://clinicaltrials.gov
  * **Preferred**: true
  * **Period**: 2024-04-24 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ClinicalTrialsGov",
  "url" : "http://terminology.hl7.org/NamingSystem/ClinicalTrialsGov",
  "version" : "1.0.0",
  "name" : "ClinicalTrialsGov",
  "title" : "ClinicalTrials.gov",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-04-24T00:00:00-00:00",
  "publisher" : "National Library of Medicine",
  "contact" : [
    {
      "name" : "National Library of Medicine; 8600 Rockville Pike, Bethesda, MD 20894",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nlm.nih.gov/"
        },
        {
          "system" : "url",
          "value" : "https://support.nlm.nih.gov/support/create-case/"
        }
      ]
    }
  ],
  "responsible" : "National Library of Medicine; 8600 Rockville Pike, Bethesda, MD 20894",
  "description" : "The U.S. National Institutes of Health, Department of Health and Human Services, through its National Library of Medicine, has developed [ClinicalTrials.gov](http://clinicaltrials.gov) to provide patients, family members, and members of the public current information about clinical research studies. [ClinicalTrials.gov](http://clinicaltrials.gov) contains summary information about clinical studies being conducted throughout the United States and in many countries throughout the world. These data are provided to the National Library of Medicine by organizations and institutions that sponsor and implement the studies.\r\n\r\n[ClinicalTrials.gov](http://clinicaltrials.gov) is updated daily. You should check [ClinicalTrials.gov](http://clinicaltrials.gov) frequently for updated information.\r\n\r\nMore information about ClinicalTrials.gov can be found [here](https://clinicaltrials.gov/about-site/about-ctg).",
  "copyright" : "See [https://clinicaltrials.gov/about-site/terms-conditions](https://clinicaltrials.gov/about-site/terms-conditions) for the Terms and Conditions that apply for use of ClinicalTrials.gov data.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.3.1077",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://clinicaltrials.gov",
      "preferred" : true,
      "period" : {
        "start" : "2024-04-24"
      }
    }
  ]
}

```
