# Using ISO3166 with HL7 Standards - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**External Content**](external_content.md)
* [**External Code Systems**](external_code_systems.md)
* **Using ISO3166 with HL7 Standards**

## Using ISO3166 with HL7 Standards

This page describes how to use ISO 3166 with HL7 Standards.

### Using ISO 3166 with FHIR R5

#### Summary

| | |
| :--- | :--- |
| Source | [ISO 3166 Home Page](http://www.iso.org/iso/country_codes.htm) |
| System | ISO 3166 is a 3 part standard, each of which defines a code system:* `urn:iso:std:iso:3166`: Part 1, Country Codes (2-letter and 3-letter, and numerical codes)
* `urn:iso:std:iso:3166:-2`: Part 2, Subdivision (State/Province) Codes
* `urn:iso:std:iso:3166:-3`: Part 3, Historical Country Names
Note: the URI used for Part 1 would be urn:iso:std:iso:3166:-1 if it were consistent with the other URIs, but urn:iso:std:iso:3166 is used for legacy reasons. |
| Version | If necessary to exchange the version (see below), use the year of release in the format YYYY |
| Code | * `Part 1`: Any of the 2-letter, 3-letter, or numerical country name codes defined in Part 1
* `Part 2`: Any of the codes for principal subdivisions (e.g province or state) of countries coded in Part 1
* `Part 3`: One of the 4 letter historical country name codes defined in Part 3
The codes SHALL always be represented in upper case, but (for robustness) comparisons are case insensitive. |
| Display | Use the Country or State/Province Name |
| Inactive | There are no codes that are inactive |
| Subsumption | No Subsumption relationships are defined amongst the Country Codes |
| Filter Properties | Regex on code - see below |

#### Version Issues

A few country codes have been reused (e.g. CS). If a version is needed, simply use the year of publication e.g. 1998.

#### Copyright/License Issues

ISO Maintains the copyright on the country codes, and controls it's use carefully. For further details, see the [ISO 3166 Home Page](http://www.iso.org/iso/country_codes.htm)

#### ISO 3166 Filter Properties

The Part 1 Code system identified by the URI `urn:iso:std:iso:3166` contains 3 types of codes for country: 

* 2-letter
* 3-letter
* Numeric

In almost all contexts of use, only one of these 3 subsets of codes are used / allowed. Value sets can be defined for these by [enumerating the relevant codes](https://hl7.org/fhir/valueset-definitions.html#ValueSet.compose.include.concept). Alternatively, a regex can be used to define the value set intensionally. For example, this filter specifies only 3 letter codes:

```

  "filter" : [{
    "property" : "code", 
    "op" : "regex", 
    "value" : "[A-Z]{3}" 
  }]

```

#### ISO 3166 Value Sets

The FHIR specification defines 3 commonly used value sets for use with ISO 3166 Country Codes:

* [2 letter Country Codes](https://hl7.org/fhir/valueset-iso3166-1-2.html)
* [3 letter Country Codes](https://hl7.org/fhir/valueset-iso3166-1-3.html)
* [Numerical Country Codes](https://hl7.org/fhir/valueset-iso3166-1-N.html)

The latter two value sets are defined intensionally in this specification as a consequence of ISO Intellectual Property Restrictions.

