# Validation-process - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Validation-process**

## CodeSystem: Validation-process 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/validation-process | *Version*:2.0.0 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Validation_process |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.889 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The primary process by which the target is validated 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Validation_process](ValueSet-verificationresult-validation-process.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "validation-process",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/validation-process",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.889"
    }
  ],
  "version" : "2.0.0",
  "name" : "Validation_process",
  "title" : "Validation-process",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The primary process by which the target is validated",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/verificationresult-validation-process",
  "content" : "complete",
  "concept" : [
    {
      "code" : "edit-check",
      "display" : "edit check"
    },
    {
      "code" : "valueset",
      "display" : "value set"
    },
    {
      "code" : "primary",
      "display" : "primary source"
    },
    {
      "code" : "multi",
      "display" : "multiple sources"
    },
    {
      "code" : "standalone",
      "display" : "standalone"
    },
    {
      "code" : "in-context",
      "display" : "in context"
    },
    {
      "code" : "manual",
      "display" : "Manual"
    },
    {
      "code" : "attester",
      "display" : "Attester"
    },
    {
      "code" : "extsource",
      "display" : "External source"
    }
  ]
}

```
