# MessageWaitingPriority - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MessageWaitingPriority**

## CodeSystem: MessageWaitingPriority 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-MessageWaitingPriority | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MessageWaitingPriority |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1083 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Indicates that the receiver has messages for the sender 
**OpenIssue:**Description does not make sense relative to name of coding system. Must be reviewed and improved. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MessageWaitingPriority](ValueSet-v3-MessageWaitingPriority.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-MessageWaitingPriority",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-MessageWaitingPriority",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1083"
    }
  ],
  "version" : "3.0.0",
  "name" : "MessageWaitingPriority",
  "title" : "MessageWaitingPriority",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates that the receiver has messages for the sender\r\n\r\n*OpenIssue:* Description does not make sense relative to name of coding system. Must be reviewed and improved.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "LessThan"
        }
      ],
      "code" : "SmallerThan",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#SmallerThan",
      "description" : "The source concept code is \"less than\" the target concept in a strictly ordinal sense.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "H",
      "display" : "High",
      "definition" : "High priority messages are available",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19790"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Low",
      "definition" : "Low priority messages are available",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "SmallerThan",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-MessageWaitingPriority",
            "code" : "M"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "19792"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Medium",
      "definition" : "Medium priority messages are available",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19791"
        }
      ]
    }
  ]
}

```
