# ManagedParticipationStatus - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ManagedParticipationStatus**

## CodeSystem: ManagedParticipationStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ManagedParticipationStatus | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ManagedParticipationStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1062 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes representing the defined possible states of a Managed Participation, as defined by the Managed Participation class state machine. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ManagedParticipationStatus](ValueSet-v3-ManagedParticipationStatus.md)
* [ManagedParticipationStatusActive](ValueSet-v3-ManagedParticipationStatusActive.md)
* [ManagedParticipationStatusCancelled](ValueSet-v3-ManagedParticipationStatusCancelled.md)
* [ManagedParticipationStatusCompleted](ValueSet-v3-ManagedParticipationStatusCompleted.md)
* [ManagedParticipationStatusNormal](ValueSet-v3-ManagedParticipationStatusNormal.md)
* [ManagedParticipationStatusNullified](ValueSet-v3-ManagedParticipationStatusNullified.md)
* [ManagedParticipationStatusPending](ValueSet-v3-ManagedParticipationStatusPending.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ManagedParticipationStatus",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ManagedParticipationStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1062"
    }
  ],
  "version" : "3.0.0",
  "name" : "ManagedParticipationStatus",
  "title" : "ManagedParticipationStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes representing the defined possible states of a Managed Participation, as defined by the Managed Participation class state machine.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "normal",
      "display" : "normal",
      "definition" : "The 'typical' state. Excludes \"nullified\" which represents the termination state of a participation instance that was created in error.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15993"
        }
      ],
      "concept" : [
        {
          "code" : "active",
          "display" : "active",
          "definition" : "The state representing the fact that the Participation is in progress.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15996"
            }
          ]
        },
        {
          "code" : "cancelled",
          "display" : "cancelled",
          "definition" : "The terminal state resulting from cancellation of the Participation prior to activation.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15995"
            }
          ]
        },
        {
          "code" : "completed",
          "display" : "completed",
          "definition" : "The terminal state representing the successful completion of the Participation.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15997"
            }
          ]
        },
        {
          "code" : "pending",
          "display" : "pending",
          "definition" : "The state representing that fact that the Participation has not yet become active.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15994"
            }
          ]
        }
      ]
    },
    {
      "code" : "nullified",
      "display" : "nullified",
      "definition" : "The state representing the termination of a Participation instance that was created in error.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15998"
        }
      ]
    }
  ]
}

```
