# LocalRemoteControlState - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LocalRemoteControlState**

## CodeSystem: LocalRemoteControlState 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-LocalRemoteControlState | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:LocalRemoteControlState |
| *Other Identifiers:*OID:2.16.840.1.113883.5.66 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A value representing the current state of control associated with the device. 
**Examples:**A device can either work autonomously (localRemoteControlStateCode="Local") or it can be controlled by another system (localRemoteControlStateCode="Remote"). 
**Rationale:**The control status of a device must be communicated between devices prior to remote commands being transmitted. If the device is not in "Remote" status then external commands will be ignored. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [LocalRemoteControlState](ValueSet-v3-LocalRemoteControlState.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-LocalRemoteControlState",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-LocalRemoteControlState",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.66"
    }
  ],
  "version" : "3.0.0",
  "name" : "LocalRemoteControlState",
  "title" : "LocalRemoteControlState",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A value representing the current state of control associated with the device.\r\n\r\n*Examples:* A device can either work autonomously (localRemoteControlStateCode=\"Local\") or it can be controlled by another system (localRemoteControlStateCode=\"Remote\").\r\n\r\n*Rationale:* The control status of a device must be communicated between devices prior to remote commands being transmitted. If the device is not in \"Remote\" status then external commands will be ignored.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "L",
      "display" : "Local",
      "definition" : "An equipment can either work autonomously ('Local' control state).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10894"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Remote",
      "definition" : "An equipment can be controlled by another system, e.g., LAS computer ('Remote' control state).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10895"
        }
      ]
    }
  ]
}

```
