# HL7CommitteeIDInRIM - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7CommitteeIDInRIM**

## CodeSystem: HL7CommitteeIDInRIM 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-HL7CommitteeIDInRIM | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*Health Level 7 | *Computable Name*:HL7CommitteeIDInRIM |
| *Other Identifiers:*OID:2.16.840.1.113883.5.54 | | |

 
Holds the codes used to identify the committees and SIGS of HL7 in RIM repository tables. 
**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-HL7CommitteeIDInRIM",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-HL7CommitteeIDInRIM",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.54"
    }
  ],
  "version" : "2.0.1",
  "name" : "HL7CommitteeIDInRIM",
  "title" : "HL7CommitteeIDInRIM",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "Holds the codes used to identify the committees and SIGS of HL7 in RIM repository tables.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "C00",
      "display" : "Modeling and Methodology",
      "definition" : "Modeling and Methodology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10035"
        }
      ]
    },
    {
      "code" : "C01",
      "display" : "Technical Steering Committee",
      "definition" : "Technical Steering Committee",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10036"
        }
      ]
    },
    {
      "code" : "C02",
      "display" : "Control/Query/MasterFiles",
      "definition" : "Control/Query/MasterFiles",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10037"
        }
      ]
    },
    {
      "code" : "C03",
      "display" : "Patient Administration",
      "definition" : "Patient Administration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10038"
        }
      ]
    },
    {
      "code" : "C04",
      "display" : "Orders/Observation",
      "definition" : "Orders/Observation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10039"
        }
      ]
    },
    {
      "code" : "C06",
      "display" : "Financial Management",
      "definition" : "Financial Management",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10040"
        }
      ]
    },
    {
      "code" : "C09",
      "display" : "Medical records",
      "definition" : "Information Management (Medical Records)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10041"
        }
      ]
    },
    {
      "code" : "C10",
      "display" : "Scheduling",
      "definition" : "Scheduling & Referral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10042"
        }
      ]
    },
    {
      "code" : "C12",
      "display" : "Patient Care",
      "definition" : "Patient Care",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10043"
        }
      ]
    },
    {
      "code" : "C20",
      "display" : "Structured Document Committee",
      "definition" : "PRA Technical Committee",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10044"
        }
      ]
    },
    {
      "code" : "C21",
      "display" : "Vocabulary Committee",
      "definition" : "PRA Technical Committee",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10757"
        }
      ]
    }
  ]
}

```
