# EntityStatus - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityStatus**

## CodeSystem: EntityStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-EntityStatus | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1061 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes representing the defined possible states of an Entity, as defined by the Entity class state machine. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EntityStatus](ValueSet-v3-EntityStatus.md)
* [EntityStatusActive](ValueSet-v3-EntityStatusActive.md)
* [EntityStatusInactive](ValueSet-v3-EntityStatusInactive.md)
* [EntityStatusNormal](ValueSet-v3-EntityStatusNormal.md)
* [EntityStatusNullified](ValueSet-v3-EntityStatusNullified.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-EntityStatus",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-EntityStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1061"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityStatus",
  "title" : "EntityStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes representing the defined possible states of an Entity, as defined by the Entity class state machine.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "normal",
      "display" : "normal",
      "definition" : "The 'typical' state. Excludes \"nullified\" which represents the termination state of an Entity record instance that was created in error.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16006"
        }
      ],
      "concept" : [
        {
          "code" : "active",
          "display" : "active",
          "definition" : "The state representing the fact that the Entity record is currently active.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "16007"
            }
          ]
        },
        {
          "code" : "inactive",
          "display" : "inactive",
          "definition" : "**Definition:** The state representing the fact that the entity is inactive.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22187"
            }
          ]
        },
        {
          "code" : "terminated",
          "display" : "terminated",
          "definition" : "The state representing the normal termination of an Entity record.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "16008"
            }
          ]
        }
      ]
    },
    {
      "code" : "nullified",
      "display" : "nullified",
      "definition" : "The state representing the termination of an Entity record instance that was created in error.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16009"
        }
      ]
    }
  ]
}

```
