# EntityRisk - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityRisk**

## CodeSystem: EntityRisk 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-EntityRisk | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityRisk |
| *Other Identifiers:*OID:2.16.840.1.113883.5.46 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Kinds of risks associated with the handling of the material.. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EntityRisk](ValueSet-v3-EntityRisk.md)
* [MaterialDangerInfectious](ValueSet-v3-MaterialDangerInfectious.md)
* [MaterialDangerInflammable](ValueSet-v3-MaterialDangerInflammable.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-EntityRisk",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-EntityRisk",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.46"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityRisk",
  "title" : "EntityRisk",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Kinds of risks associated with the handling of the material..",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AGG",
      "display" : "aggressive",
      "definition" : "A danger that can be associated with certain living subjects, including humans.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10415"
        }
      ]
    },
    {
      "code" : "BIO",
      "display" : "Biological",
      "definition" : "The dangers associated with normal biological materials. I.e. potential risk of unknown infections. Routine biological materials from living subjects.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14074"
        }
      ]
    },
    {
      "code" : "COR",
      "display" : "Corrosive",
      "definition" : "Material is corrosive and may cause severe injury to skin, mucous membranes and eyes. Avoid any unprotected contact.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14076"
        }
      ]
    },
    {
      "code" : "ESC",
      "display" : "Escape Risk",
      "definition" : "The entity is at risk for escaping from containment or control.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14077"
        }
      ]
    },
    {
      "code" : "IFL",
      "display" : "inflammable",
      "definition" : "Material is highly inflammable and in certain mixtures (with air) may lead to explosions. Keep away from fire, sparks and excessive heat.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10412"
        }
      ],
      "concept" : [
        {
          "code" : "EXP",
          "display" : "explosive",
          "definition" : "Material is an explosive mixture. Keep away from fire, sparks, and heat.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10413"
            }
          ]
        }
      ]
    },
    {
      "code" : "INF",
      "display" : "infectious",
      "definition" : "Material known to be infectious with human pathogenic microorganisms. Those who handle this material must take precautions for their protection.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10407"
        }
      ],
      "concept" : [
        {
          "code" : "BHZ",
          "display" : "biohazard",
          "definition" : "Material contains microorganisms that is an environmental hazard. Must be handled with special care.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10408"
            }
          ]
        }
      ]
    },
    {
      "code" : "INJ",
      "display" : "injury hazard",
      "definition" : "Material is solid and sharp (e.g., cannulas). Dispose in hard container.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10414"
        }
      ]
    },
    {
      "code" : "POI",
      "display" : "poison",
      "definition" : "Material is poisonous to humans and/or animals. Special care must be taken to avoid incorporation, even of small amounts.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10410"
        }
      ]
    },
    {
      "code" : "RAD",
      "display" : "radioactive",
      "definition" : "Material is a source for ionizing radiation and must be handled with special care to avoid injury of those who handle it and to avoid environmental hazards.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10409"
        }
      ]
    }
  ]
}

```
