# Dentition - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Dentition**

## CodeSystem: Dentition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-Dentition | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Dentition |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1080 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**** MISSING DESCRIPTION **** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ArtificialDentition](ValueSet-v3-ArtificialDentition.md)
* [Dentition](ValueSet-v3-Dentition.md)
* [PermanentDentition](ValueSet-v3-PermanentDentition.md)
* [PrimaryDentition](ValueSet-v3-PrimaryDentition.md)
* [SupernumeraryTooth](ValueSet-v3-SupernumeraryTooth.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-Dentition",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-Dentition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1080"
    }
  ],
  "version" : "3.0.0",
  "name" : "Dentition",
  "title" : "Dentition",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**** MISSING DESCRIPTION ****",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "ArtificialDentition",
      "display" : "Artificial dentition",
      "definition" : "Artificial dentition, artificial subsitutes for the natural dentition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19523"
        }
      ],
      "concept" : [
        {
          "code" : "TID10a",
          "display" : "10a",
          "definition" : "Maxillary left lateral incisor abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19673"
            }
          ]
        },
        {
          "code" : "TID10i",
          "display" : "10i",
          "definition" : "Maxillary left lateral incisor implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19533"
            }
          ]
        },
        {
          "code" : "TID10p",
          "display" : "10p",
          "definition" : "Maxillary left lateral incisor prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19596"
            }
          ]
        },
        {
          "code" : "TID10pd",
          "display" : "10pd",
          "definition" : "Maxillary left lateral incisor distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19597"
            }
          ]
        },
        {
          "code" : "TID10pm",
          "display" : "10pm",
          "definition" : "Maxillary left lateral incisor mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19595"
            }
          ]
        },
        {
          "code" : "TID11a",
          "display" : "11a",
          "definition" : "Maxillary left canine abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19674"
            }
          ]
        },
        {
          "code" : "TID11i",
          "display" : "11i",
          "definition" : "Maxillary left canine implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19534"
            }
          ]
        },
        {
          "code" : "TID11p",
          "display" : "11p",
          "definition" : "Maxillary left canine prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19599"
            }
          ]
        },
        {
          "code" : "TID11pd",
          "display" : "11pd",
          "definition" : "Maxillary left canine distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19600"
            }
          ]
        },
        {
          "code" : "TID11pm",
          "display" : "11pm",
          "definition" : "Maxillary left canine mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19598"
            }
          ]
        },
        {
          "code" : "TID12a",
          "display" : "12a",
          "definition" : "Maxillary left first premolar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19675"
            }
          ]
        },
        {
          "code" : "TID12i",
          "display" : "12i",
          "definition" : "Maxillary left first premolar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19535"
            }
          ]
        },
        {
          "code" : "TID12p",
          "display" : "12p",
          "definition" : "Maxillary left first premolar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19602"
            }
          ]
        },
        {
          "code" : "TID12pd",
          "display" : "12pd",
          "definition" : "Maxillary left first premolar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19603"
            }
          ]
        },
        {
          "code" : "TID12pm",
          "display" : "12pm",
          "definition" : "Maxillary left first premolar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19601"
            }
          ]
        },
        {
          "code" : "TID13a",
          "display" : "13a",
          "definition" : "Maxillary left second premolar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19676"
            }
          ]
        },
        {
          "code" : "TID13i",
          "display" : "13i",
          "definition" : "Maxillary left second premolar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19536"
            }
          ]
        },
        {
          "code" : "TID13p",
          "display" : "13p",
          "definition" : "Maxillary left second premolar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19605"
            }
          ]
        },
        {
          "code" : "TID13pd",
          "display" : "13pd",
          "definition" : "Maxillary left second premolar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19606"
            }
          ]
        },
        {
          "code" : "TID13pm",
          "display" : "13pm",
          "definition" : "Maxillary left second premolar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19604"
            }
          ]
        },
        {
          "code" : "TID14a",
          "display" : "14a",
          "definition" : "Maxillary left first molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19677"
            }
          ]
        },
        {
          "code" : "TID14i",
          "display" : "14i",
          "definition" : "Maxillary left first molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19537"
            }
          ]
        },
        {
          "code" : "TID14p",
          "display" : "14p",
          "definition" : "Maxillary left first molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19608"
            }
          ]
        },
        {
          "code" : "TID14pd",
          "display" : "14pd",
          "definition" : "Maxillary left first molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19609"
            }
          ]
        },
        {
          "code" : "TID14pm",
          "display" : "14pm",
          "definition" : "Maxillary left first molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19607"
            }
          ]
        },
        {
          "code" : "TID15a",
          "display" : "15a",
          "definition" : "Maxillary left second molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19678"
            }
          ]
        },
        {
          "code" : "TID15i",
          "display" : "15i",
          "definition" : "Maxillary left second molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19538"
            }
          ]
        },
        {
          "code" : "TID15p",
          "display" : "15p",
          "definition" : "Maxillary left second molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19611"
            }
          ]
        },
        {
          "code" : "TID15pd",
          "display" : "15pd",
          "definition" : "Maxillary left second molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19612"
            }
          ]
        },
        {
          "code" : "TID15pm",
          "display" : "15pm",
          "definition" : "Maxillary left second molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19610"
            }
          ]
        },
        {
          "code" : "TID16a",
          "display" : "16a",
          "definition" : "Maxillary left third molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19679"
            }
          ]
        },
        {
          "code" : "TID16i",
          "display" : "16i",
          "definition" : "Maxillary left third molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19539"
            }
          ]
        },
        {
          "code" : "TID16p",
          "display" : "16p",
          "definition" : "Maxillary left third molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19614"
            }
          ]
        },
        {
          "code" : "TID16pd",
          "display" : "16pd",
          "definition" : "Maxillary left third molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19615"
            }
          ]
        },
        {
          "code" : "TID16pm",
          "display" : "16pm",
          "definition" : "Maxillary left third molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19613"
            }
          ]
        },
        {
          "code" : "TID17a",
          "display" : "17a",
          "definition" : "Mandibular left third molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19680"
            }
          ]
        },
        {
          "code" : "TID17ad",
          "display" : "17ad",
          "definition" : "Mandibular left third molar abutment distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19682"
            }
          ]
        },
        {
          "code" : "TID17am",
          "display" : "17am",
          "definition" : "Mandibular left third molar abutment mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19681"
            }
          ]
        },
        {
          "code" : "TID17i",
          "display" : "17i",
          "definition" : "Mandibular left third molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19540"
            }
          ]
        },
        {
          "code" : "TID17id",
          "display" : "17id",
          "definition" : "Mandibular left third molar implant distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19542"
            }
          ]
        },
        {
          "code" : "TID17im",
          "display" : "17im",
          "definition" : "Mandibular left third molar implant mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19541"
            }
          ]
        },
        {
          "code" : "TID17p",
          "display" : "17p",
          "definition" : "Mandibular left third molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19617"
            }
          ]
        },
        {
          "code" : "TID17pd",
          "display" : "17pd",
          "definition" : "Mandibular left third molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19616"
            }
          ]
        },
        {
          "code" : "TID17pm",
          "display" : "17pm",
          "definition" : "Mandibular left third molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19618"
            }
          ]
        },
        {
          "code" : "TID18a",
          "display" : "18a",
          "definition" : "Mandibular left second molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19683"
            }
          ]
        },
        {
          "code" : "TID18ad",
          "display" : "18ad",
          "definition" : "Mandibular left second molar abutment distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19685"
            }
          ]
        },
        {
          "code" : "TID18am",
          "display" : "18am",
          "definition" : "Mandibular left second molar abutment mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19684"
            }
          ]
        },
        {
          "code" : "TID18i",
          "display" : "18i",
          "definition" : "Mandibular left second molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19543"
            }
          ]
        },
        {
          "code" : "TID18id",
          "display" : "18id",
          "definition" : "Mandibular left second molar implant distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19545"
            }
          ]
        },
        {
          "code" : "TID18im",
          "display" : "18im",
          "definition" : "Mandibular left second molar implant mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19544"
            }
          ]
        },
        {
          "code" : "TID18p",
          "display" : "18p",
          "definition" : "Mandibular left second molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19620"
            }
          ]
        },
        {
          "code" : "TID18pd",
          "display" : "18pd",
          "definition" : "Mandibular left second molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19619"
            }
          ]
        },
        {
          "code" : "TID18pm",
          "display" : "18pm",
          "definition" : "Mandibular left second molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19621"
            }
          ]
        },
        {
          "code" : "TID19a",
          "display" : "19a",
          "definition" : "Mandibular left first molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19686"
            }
          ]
        },
        {
          "code" : "TID19ad",
          "display" : "19ad",
          "definition" : "Mandibular left first molar abutment distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19688"
            }
          ]
        },
        {
          "code" : "TID19am",
          "display" : "19am",
          "definition" : "Mandibular left first molar abutment mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19687"
            }
          ]
        },
        {
          "code" : "TID19i",
          "display" : "19i",
          "definition" : "Mandibular left first molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19546"
            }
          ]
        },
        {
          "code" : "TID19id",
          "display" : "19id",
          "definition" : "Mandibular left first molar implant distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19548"
            }
          ]
        },
        {
          "code" : "TID19im",
          "display" : "19im",
          "definition" : "Mandibular left first molar implant mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19547"
            }
          ]
        },
        {
          "code" : "TID19p",
          "display" : "19p",
          "definition" : "Mandibular left first molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19623"
            }
          ]
        },
        {
          "code" : "TID19pd",
          "display" : "19pd",
          "definition" : "Mandibular left first molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19622"
            }
          ]
        },
        {
          "code" : "TID19pm",
          "display" : "19pm",
          "definition" : "Mandibular left first molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19624"
            }
          ]
        },
        {
          "code" : "TID1a",
          "display" : "1a",
          "definition" : "Maxillary right third molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19664"
            }
          ]
        },
        {
          "code" : "TID1i",
          "display" : "1i",
          "definition" : "Maxillary right third molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19524"
            }
          ]
        },
        {
          "code" : "TID1p",
          "display" : "1p",
          "definition" : "Maxillary right third molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19569"
            }
          ]
        },
        {
          "code" : "TID1pd",
          "display" : "1pd",
          "definition" : "Maxillary right third molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19568"
            }
          ]
        },
        {
          "code" : "TID1pm",
          "display" : "1pm",
          "definition" : "Maxillary right third molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19570"
            }
          ]
        },
        {
          "code" : "TID20a",
          "display" : "20a",
          "definition" : "Mandibular left second premolar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19689"
            }
          ]
        },
        {
          "code" : "TID20i",
          "display" : "20i",
          "definition" : "Mandibular left second premolar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19549"
            }
          ]
        },
        {
          "code" : "TID20p",
          "display" : "20p",
          "definition" : "Mandibular left second premolar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19626"
            }
          ]
        },
        {
          "code" : "TID20pd",
          "display" : "20pd",
          "definition" : "Mandibular left second premolar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19625"
            }
          ]
        },
        {
          "code" : "TID20pm",
          "display" : "20pm",
          "definition" : "Mandibular left second premolar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19627"
            }
          ]
        },
        {
          "code" : "TID21a",
          "display" : "21a",
          "definition" : "Mandibular left first premolar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19690"
            }
          ]
        },
        {
          "code" : "TID21i",
          "display" : "21i",
          "definition" : "Mandibular left first premolar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19550"
            }
          ]
        },
        {
          "code" : "TID21p",
          "display" : "21p",
          "definition" : "Mandibular left first premolar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19629"
            }
          ]
        },
        {
          "code" : "TID21pd",
          "display" : "21pd",
          "definition" : "Mandibular left first premolar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19628"
            }
          ]
        },
        {
          "code" : "TID21pm",
          "display" : "21pm",
          "definition" : "Mandibular left first premolar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19630"
            }
          ]
        },
        {
          "code" : "TID22a",
          "display" : "22a",
          "definition" : "Mandibular left canine abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19691"
            }
          ]
        },
        {
          "code" : "TID22i",
          "display" : "22i",
          "definition" : "Mandibular left canine implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19551"
            }
          ]
        },
        {
          "code" : "TID22p",
          "display" : "22p",
          "definition" : "Mandibular left canine prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19632"
            }
          ]
        },
        {
          "code" : "TID22pd",
          "display" : "22pd",
          "definition" : "Mandibular left canine distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19631"
            }
          ]
        },
        {
          "code" : "TID22pm",
          "display" : "22pm",
          "definition" : "Mandibular left canine mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19633"
            }
          ]
        },
        {
          "code" : "TID23a",
          "display" : "23a",
          "definition" : "Mandibular left lateral incisor abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19692"
            }
          ]
        },
        {
          "code" : "TID23i",
          "display" : "23i",
          "definition" : "Mandibular left lateral incisor implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19552"
            }
          ]
        },
        {
          "code" : "TID23p",
          "display" : "23p",
          "definition" : "Mandibular left lateral incisor prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19635"
            }
          ]
        },
        {
          "code" : "TID23pd",
          "display" : "23pd",
          "definition" : "Mandibular left lateral incisor distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19634"
            }
          ]
        },
        {
          "code" : "TID23pm",
          "display" : "23pm",
          "definition" : "Mandibular left lateral incisor mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19636"
            }
          ]
        },
        {
          "code" : "TID24a",
          "display" : "24a",
          "definition" : "Mandibular left central incisor abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19693"
            }
          ]
        },
        {
          "code" : "TID24i",
          "display" : "24i",
          "definition" : "Mandibular left central incisor implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19553"
            }
          ]
        },
        {
          "code" : "TID24p",
          "display" : "24p",
          "definition" : "Mandibular left central incisor prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19638"
            }
          ]
        },
        {
          "code" : "TID24pd",
          "display" : "24pd",
          "definition" : "Mandibular left central incisor distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19637"
            }
          ]
        },
        {
          "code" : "TID24pm",
          "display" : "24pm",
          "definition" : "Mandibular left central incisor mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19639"
            }
          ]
        },
        {
          "code" : "TID25a",
          "display" : "25a",
          "definition" : "Mandibular right central incisor abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19694"
            }
          ]
        },
        {
          "code" : "TID25i",
          "display" : "25i",
          "definition" : "Mandibular right central incisor implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19554"
            }
          ]
        },
        {
          "code" : "TID25p",
          "display" : "25p",
          "definition" : "Mandibular right central incisor prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19641"
            }
          ]
        },
        {
          "code" : "TID25pd",
          "display" : "25pd",
          "definition" : "Mandibular right central incisor distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19642"
            }
          ]
        },
        {
          "code" : "TID25pm",
          "display" : "25pm",
          "definition" : "Mandibular right central incisor mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19640"
            }
          ]
        },
        {
          "code" : "TID26a",
          "display" : "26a",
          "definition" : "Mandibular right lateral incisor abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19695"
            }
          ]
        },
        {
          "code" : "TID26i",
          "display" : "26i",
          "definition" : "Mandibular right lateral incisor implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19555"
            }
          ]
        },
        {
          "code" : "TID26p",
          "display" : "26p",
          "definition" : "Mandibular right lateral incisor prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19644"
            }
          ]
        },
        {
          "code" : "TID26pd",
          "display" : "26pd",
          "definition" : "Mandibular right lateral incisor distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19645"
            }
          ]
        },
        {
          "code" : "TID26pm",
          "display" : "26pm",
          "definition" : "Mandibular right lateral incisor mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19643"
            }
          ]
        },
        {
          "code" : "TID27a",
          "display" : "27a",
          "definition" : "Mandibular right canine abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19696"
            }
          ]
        },
        {
          "code" : "TID27i",
          "display" : "27i",
          "definition" : "Mandibular right canine implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19556"
            }
          ]
        },
        {
          "code" : "TID27p",
          "display" : "27p",
          "definition" : "Mandibular right canine prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19647"
            }
          ]
        },
        {
          "code" : "TID27pd",
          "display" : "27pd",
          "definition" : "Mandibular right canine distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19648"
            }
          ]
        },
        {
          "code" : "TID27pm",
          "display" : "27pm",
          "definition" : "Mandibular right canine mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19646"
            }
          ]
        },
        {
          "code" : "TID28a",
          "display" : "28a",
          "definition" : "Mandibular right first premolar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19697"
            }
          ]
        },
        {
          "code" : "TID28i",
          "display" : "28i",
          "definition" : "Mandibular right first premolar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19557"
            }
          ]
        },
        {
          "code" : "TID28p",
          "display" : "28p",
          "definition" : "Mandibular right first premolar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19650"
            }
          ]
        },
        {
          "code" : "TID28pd",
          "display" : "28pd",
          "definition" : "Mandibular right first premolar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19651"
            }
          ]
        },
        {
          "code" : "TID28pm",
          "display" : "28pm",
          "definition" : "Mandibular right first premolar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19649"
            }
          ]
        },
        {
          "code" : "TID29a",
          "display" : "29a",
          "definition" : "Mandibular right second premolar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19698"
            }
          ]
        },
        {
          "code" : "TID29i",
          "display" : "29i",
          "definition" : "Mandibular right second premolar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19558"
            }
          ]
        },
        {
          "code" : "TID29p",
          "display" : "29p",
          "definition" : "Mandibular right second premolar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19653"
            }
          ]
        },
        {
          "code" : "TID29pd",
          "display" : "29pd",
          "definition" : "Mandibular right second premolar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19654"
            }
          ]
        },
        {
          "code" : "TID29pm",
          "display" : "29pm",
          "definition" : "Mandibular right second premolar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19652"
            }
          ]
        },
        {
          "code" : "TID2a",
          "display" : "2a",
          "definition" : "Maxillary right second molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19665"
            }
          ]
        },
        {
          "code" : "TID2i",
          "display" : "2i",
          "definition" : "Maxillary right second molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19525"
            }
          ]
        },
        {
          "code" : "TID2p",
          "display" : "2p",
          "definition" : "Maxillary right second molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19572"
            }
          ]
        },
        {
          "code" : "TID2pd",
          "display" : "2pd",
          "definition" : "Maxillary right second molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19571"
            }
          ]
        },
        {
          "code" : "TID2pm",
          "display" : "2pm",
          "definition" : "Maxillary right second molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19573"
            }
          ]
        },
        {
          "code" : "TID30a",
          "display" : "30a",
          "definition" : "Mandibular right first molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19699"
            }
          ]
        },
        {
          "code" : "TID30ad",
          "display" : "30ad",
          "definition" : "Mandibular right first molar abutment distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19701"
            }
          ]
        },
        {
          "code" : "TID30am",
          "display" : "30am",
          "definition" : "Mandibular right first molar abutment mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19700"
            }
          ]
        },
        {
          "code" : "TID30i",
          "display" : "30i",
          "definition" : "Mandibular right first molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19559"
            }
          ]
        },
        {
          "code" : "TID30id",
          "display" : "30id",
          "definition" : "Mandibular right first molar implant distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19561"
            }
          ]
        },
        {
          "code" : "TID30im",
          "display" : "30im",
          "definition" : "Mandibular right first molar implant mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19560"
            }
          ]
        },
        {
          "code" : "TID30p",
          "display" : "30p",
          "definition" : "Mandibular right first molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19656"
            }
          ]
        },
        {
          "code" : "TID30pd",
          "display" : "30pd",
          "definition" : "Mandibular right first molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19657"
            }
          ]
        },
        {
          "code" : "TID30pm",
          "display" : "30pm",
          "definition" : "Mandibular right first molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19655"
            }
          ]
        },
        {
          "code" : "TID31a",
          "display" : "31a",
          "definition" : "Mandibular right second molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19702"
            }
          ]
        },
        {
          "code" : "TID31ad",
          "display" : "31ad",
          "definition" : "Mandibular right second molar abutment distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19704"
            }
          ]
        },
        {
          "code" : "TID31am",
          "display" : "31am",
          "definition" : "Mandibular right second molar abutment mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19703"
            }
          ]
        },
        {
          "code" : "TID31i",
          "display" : "31i",
          "definition" : "Mandibular right second molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19562"
            }
          ]
        },
        {
          "code" : "TID31id",
          "display" : "31id",
          "definition" : "Mandibular right second molar implant distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19564"
            }
          ]
        },
        {
          "code" : "TID31im",
          "display" : "31im",
          "definition" : "Mandibular right second molar implant mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19563"
            }
          ]
        },
        {
          "code" : "TID31p",
          "display" : "31p",
          "definition" : "Mandibular right second molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19659"
            }
          ]
        },
        {
          "code" : "TID31pd",
          "display" : "31pd",
          "definition" : "Mandibular right second molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19660"
            }
          ]
        },
        {
          "code" : "TID31pm",
          "display" : "31pm",
          "definition" : "Mandibular right second molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19658"
            }
          ]
        },
        {
          "code" : "TID32a",
          "display" : "32a",
          "definition" : "Mandibular right third molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19705"
            }
          ]
        },
        {
          "code" : "TID32ad",
          "display" : "32ad",
          "definition" : "Mandibular right third molar abutment distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19707"
            }
          ]
        },
        {
          "code" : "TID32am",
          "display" : "32am",
          "definition" : "Mandibular right third molar abutment mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19706"
            }
          ]
        },
        {
          "code" : "TID32i",
          "display" : "32i",
          "definition" : "Mandibular right third molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19565"
            }
          ]
        },
        {
          "code" : "TID32id",
          "display" : "32id",
          "definition" : "Mandibular right third molar implant distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19567"
            }
          ]
        },
        {
          "code" : "TID32im",
          "display" : "32im",
          "definition" : "Mandibular right third molar implant mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19566"
            }
          ]
        },
        {
          "code" : "TID32p",
          "display" : "32p",
          "definition" : "Mandibular right third molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19662"
            }
          ]
        },
        {
          "code" : "TID32pd",
          "display" : "32pd",
          "definition" : "Mandibular right third molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19663"
            }
          ]
        },
        {
          "code" : "TID32pm",
          "display" : "32pm",
          "definition" : "Mandibular right third molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19661"
            }
          ]
        },
        {
          "code" : "TID3a",
          "display" : "3a",
          "definition" : "Maxillary right first molar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19666"
            }
          ]
        },
        {
          "code" : "TID3i",
          "display" : "3i",
          "definition" : "Maxillary right first molar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19526"
            }
          ]
        },
        {
          "code" : "TID3p",
          "display" : "3p",
          "definition" : "Maxillary right first molar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19575"
            }
          ]
        },
        {
          "code" : "TID3pd",
          "display" : "3pd",
          "definition" : "Maxillary right first molar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19574"
            }
          ]
        },
        {
          "code" : "TID3pm",
          "display" : "3pm",
          "definition" : "Maxillary right first molar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19576"
            }
          ]
        },
        {
          "code" : "TID4a",
          "display" : "4a",
          "definition" : "Maxillary right second premolar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19667"
            }
          ]
        },
        {
          "code" : "TID4i",
          "display" : "4i",
          "definition" : "Maxillary right second premolar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19527"
            }
          ]
        },
        {
          "code" : "TID4p",
          "display" : "4p",
          "definition" : "Maxillary right second premolar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19578"
            }
          ]
        },
        {
          "code" : "TID4pd",
          "display" : "4pd",
          "definition" : "Maxillary right second premolar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19577"
            }
          ]
        },
        {
          "code" : "TID4pm",
          "display" : "4pm",
          "definition" : "Maxillary right second premolar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19579"
            }
          ]
        },
        {
          "code" : "TID5a",
          "display" : "5a",
          "definition" : "Maxillary right first premolar abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19668"
            }
          ]
        },
        {
          "code" : "TID5i",
          "display" : "5i",
          "definition" : "Maxillary right first premolar implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19528"
            }
          ]
        },
        {
          "code" : "TID5p",
          "display" : "5p",
          "definition" : "Maxillary right first premolar prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19581"
            }
          ]
        },
        {
          "code" : "TID5pd",
          "display" : "5pd",
          "definition" : "Maxillary right first premolar distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19580"
            }
          ]
        },
        {
          "code" : "TID5pm",
          "display" : "5pm",
          "definition" : "Maxillary right first premolar mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19582"
            }
          ]
        },
        {
          "code" : "TID6a",
          "display" : "6a",
          "definition" : "Maxillary right canine abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19669"
            }
          ]
        },
        {
          "code" : "TID6i",
          "display" : "6i",
          "definition" : "Maxillary right canine implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19529"
            }
          ]
        },
        {
          "code" : "TID6p",
          "display" : "6p",
          "definition" : "Maxillary right canine prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19584"
            }
          ]
        },
        {
          "code" : "TID6pd",
          "display" : "6pd",
          "definition" : "Maxillary right canine distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19583"
            }
          ]
        },
        {
          "code" : "TID6pm",
          "display" : "6pm",
          "definition" : "Maxillary right canine mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19585"
            }
          ]
        },
        {
          "code" : "TID7a",
          "display" : "7a",
          "definition" : "Maxillary right lateral incisor abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19670"
            }
          ]
        },
        {
          "code" : "TID7i",
          "display" : "7i",
          "definition" : "Maxillary right lateral incisor implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19530"
            }
          ]
        },
        {
          "code" : "TID7p",
          "display" : "7p",
          "definition" : "Maxillary right lateral incisor prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19587"
            }
          ]
        },
        {
          "code" : "TID7pd",
          "display" : "7pd",
          "definition" : "Maxillary right lateral incisor distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19586"
            }
          ]
        },
        {
          "code" : "TID7pm",
          "display" : "7pm",
          "definition" : "Maxillary right lateral incisor mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19588"
            }
          ]
        },
        {
          "code" : "TID8a",
          "display" : "8a",
          "definition" : "Maxillary right central incisor abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19671"
            }
          ]
        },
        {
          "code" : "TID8i",
          "display" : "8i",
          "definition" : "Maxillary right central incisor implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19531"
            }
          ]
        },
        {
          "code" : "TID8p",
          "display" : "8p",
          "definition" : "Maxillary right central incisor prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19590"
            }
          ]
        },
        {
          "code" : "TID8pd",
          "display" : "8pd",
          "definition" : "Maxillary right central incisor distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19589"
            }
          ]
        },
        {
          "code" : "TID8pm",
          "display" : "8pm",
          "definition" : "Maxillary right central incisor mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19591"
            }
          ]
        },
        {
          "code" : "TID9a",
          "display" : "9a",
          "definition" : "Maxillary left central incisor abutment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19672"
            }
          ]
        },
        {
          "code" : "TID9i",
          "display" : "9i",
          "definition" : "Maxillary left central incisor implant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19532"
            }
          ]
        },
        {
          "code" : "TID9p",
          "display" : "9p",
          "definition" : "Maxillary left central incisor prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19593"
            }
          ]
        },
        {
          "code" : "TID9pd",
          "display" : "9pd",
          "definition" : "Maxillary left central incisor distal prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19594"
            }
          ]
        },
        {
          "code" : "TID9pm",
          "display" : "9pm",
          "definition" : "Maxillary left central incisor mesial prosthesis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19592"
            }
          ]
        }
      ]
    },
    {
      "code" : "PermanentDentition",
      "display" : "Permanent dentition",
      "definition" : "Permanent dentition, the natural teeth of adulthood that replace or are added to the deciduous teeth",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19404"
        }
      ],
      "concept" : [
        {
          "code" : "TID1",
          "display" : "1",
          "definition" : "Maxillary right third molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19405"
            }
          ]
        },
        {
          "code" : "TID10",
          "display" : "10",
          "definition" : "Maxillary left lateral incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19414"
            }
          ]
        },
        {
          "code" : "TID11",
          "display" : "11",
          "definition" : "Maxillary left canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19415"
            }
          ]
        },
        {
          "code" : "TID12",
          "display" : "12",
          "definition" : "Maxillary left first premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19416"
            }
          ]
        },
        {
          "code" : "TID13",
          "display" : "13",
          "definition" : "Maxillary left second premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19417"
            }
          ]
        },
        {
          "code" : "TID14",
          "display" : "14",
          "definition" : "Maxillary left first molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19418"
            }
          ]
        },
        {
          "code" : "TID15",
          "display" : "15",
          "definition" : "Maxillary left second molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19419"
            }
          ]
        },
        {
          "code" : "TID16",
          "display" : "16",
          "definition" : "Maxillary left third molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19420"
            }
          ]
        },
        {
          "code" : "TID17",
          "display" : "17",
          "definition" : "Mandibular left third molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19421"
            }
          ]
        },
        {
          "code" : "TID17d",
          "display" : "17d",
          "definition" : "Mandibular left third molar distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19423"
            }
          ]
        },
        {
          "code" : "TID17m",
          "display" : "17m",
          "definition" : "Mandibular left third molar mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19422"
            }
          ]
        },
        {
          "code" : "TID18",
          "display" : "18",
          "definition" : "Mandibular left second molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19424"
            }
          ]
        },
        {
          "code" : "TID18d",
          "display" : "18d",
          "definition" : "Mandibular left second molar distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19426"
            }
          ]
        },
        {
          "code" : "TID18m",
          "display" : "18m",
          "definition" : "Mandibular left second molar mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19425"
            }
          ]
        },
        {
          "code" : "TID19",
          "display" : "19",
          "definition" : "Mandibular left first molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19427"
            }
          ]
        },
        {
          "code" : "TID19d",
          "display" : "19d",
          "definition" : "Mandibular left first molar distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19429"
            }
          ]
        },
        {
          "code" : "TID19m",
          "display" : "19m",
          "definition" : "Mandibular left first molar mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19428"
            }
          ]
        },
        {
          "code" : "TID2",
          "display" : "2",
          "definition" : "Maxillary right second molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19406"
            }
          ]
        },
        {
          "code" : "TID20",
          "display" : "20",
          "definition" : "Mandibular left second premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19430"
            }
          ]
        },
        {
          "code" : "TID21",
          "display" : "21",
          "definition" : "Mandibular left first premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19431"
            }
          ]
        },
        {
          "code" : "TID22",
          "display" : "22",
          "definition" : "Mandibular left canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19432"
            }
          ]
        },
        {
          "code" : "TID23",
          "display" : "23",
          "definition" : "Mandibular left lateral incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19433"
            }
          ]
        },
        {
          "code" : "TID24",
          "display" : "24",
          "definition" : "Mandibular left central incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19434"
            }
          ]
        },
        {
          "code" : "TID25",
          "display" : "25",
          "definition" : "Mandibular right central incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19435"
            }
          ]
        },
        {
          "code" : "TID26",
          "display" : "26",
          "definition" : "Mandibular right lateral incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19436"
            }
          ]
        },
        {
          "code" : "TID27",
          "display" : "27",
          "definition" : "Mandibular right canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19437"
            }
          ]
        },
        {
          "code" : "TID28",
          "display" : "28",
          "definition" : "Mandibular right first premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19438"
            }
          ]
        },
        {
          "code" : "TID29",
          "display" : "29",
          "definition" : "Mandibular right second premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19439"
            }
          ]
        },
        {
          "code" : "TID3",
          "display" : "3",
          "definition" : "Maxillary right first molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19407"
            }
          ]
        },
        {
          "code" : "TID30",
          "display" : "30",
          "definition" : "Mandibular right first molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19440"
            }
          ]
        },
        {
          "code" : "TID30d",
          "display" : "30d",
          "definition" : "Mandibular right first molar distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19442"
            }
          ]
        },
        {
          "code" : "TID30m",
          "display" : "30m",
          "definition" : "Mandibular right first molar mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19441"
            }
          ]
        },
        {
          "code" : "TID31",
          "display" : "31",
          "definition" : "Mandibular right second molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19443"
            }
          ]
        },
        {
          "code" : "TID31d",
          "display" : "31d",
          "definition" : "Mandibular right second molar distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19445"
            }
          ]
        },
        {
          "code" : "TID31m",
          "display" : "31m",
          "definition" : "Mandibular right second molar mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19444"
            }
          ]
        },
        {
          "code" : "TID32",
          "display" : "32",
          "definition" : "Mandibular right third molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19446"
            }
          ]
        },
        {
          "code" : "TID32d",
          "display" : "32d",
          "definition" : "Mandibular right third molar distal hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19448"
            }
          ]
        },
        {
          "code" : "TID32m",
          "display" : "32m",
          "definition" : "Mandibular right third molar mesial hemisection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19447"
            }
          ]
        },
        {
          "code" : "TID4",
          "display" : "4",
          "definition" : "Maxillary right second premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19408"
            }
          ]
        },
        {
          "code" : "TID5",
          "display" : "5",
          "definition" : "Maxillary right first premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19409"
            }
          ]
        },
        {
          "code" : "TID6",
          "display" : "6",
          "definition" : "Maxillary right canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19410"
            }
          ]
        },
        {
          "code" : "TID7",
          "display" : "7",
          "definition" : "Maxillary right lateral incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19411"
            }
          ]
        },
        {
          "code" : "TID8",
          "display" : "8",
          "definition" : "Maxillary right central incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19412"
            }
          ]
        },
        {
          "code" : "TID9",
          "display" : "9",
          "definition" : "Maxillary left central incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19413"
            }
          ]
        }
      ]
    },
    {
      "code" : "PrimaryDentition",
      "display" : "Primary dentition",
      "definition" : "Primary dentition, the first teeth to errupt and usually replaced with permanent dentition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19502"
        }
      ],
      "concept" : [
        {
          "code" : "TIDA",
          "display" : "A",
          "definition" : "Maxillary right second primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19503"
            }
          ]
        },
        {
          "code" : "TIDB",
          "display" : "B",
          "definition" : "Maxillary right first primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19504"
            }
          ]
        },
        {
          "code" : "TIDC",
          "display" : "C",
          "definition" : "Maxillary right primary canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19505"
            }
          ]
        },
        {
          "code" : "TIDD",
          "display" : "D",
          "definition" : "Maxillary right lateral primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19506"
            }
          ]
        },
        {
          "code" : "TIDE",
          "display" : "E",
          "definition" : "Maxillary right central primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19507"
            }
          ]
        },
        {
          "code" : "TIDF",
          "display" : "F",
          "definition" : "Maxillary left central primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19508"
            }
          ]
        },
        {
          "code" : "TIDG",
          "display" : "G",
          "definition" : "Maxillary left lateral primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19509"
            }
          ]
        },
        {
          "code" : "TIDH",
          "display" : "H",
          "definition" : "Maxillary left primary canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19510"
            }
          ]
        },
        {
          "code" : "TIDI",
          "display" : "I",
          "definition" : "Maxillary left first primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19511"
            }
          ]
        },
        {
          "code" : "TIDJ",
          "display" : "J",
          "definition" : "Maxillary left second primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19512"
            }
          ]
        },
        {
          "code" : "TIDK",
          "display" : "K",
          "definition" : "Mandibular left second primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19513"
            }
          ]
        },
        {
          "code" : "TIDL",
          "display" : "L",
          "definition" : "Mandibular left first primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19514"
            }
          ]
        },
        {
          "code" : "TIDM",
          "display" : "M",
          "definition" : "Mandibular left primary canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19515"
            }
          ]
        },
        {
          "code" : "TIDN",
          "display" : "N",
          "definition" : "Mandibular left lateral primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19516"
            }
          ]
        },
        {
          "code" : "TIDO",
          "display" : "O",
          "definition" : "Mandibular left central primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19517"
            }
          ]
        },
        {
          "code" : "TIDP",
          "display" : "P",
          "definition" : "Mandibular right central primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19518"
            }
          ]
        },
        {
          "code" : "TIDQ",
          "display" : "Q",
          "definition" : "Mandibular right lateral primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19519"
            }
          ]
        },
        {
          "code" : "TIDR",
          "display" : "R",
          "definition" : "Mandibular right primary canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19520"
            }
          ]
        },
        {
          "code" : "TIDS",
          "display" : "S",
          "definition" : "Mandibular right first primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19521"
            }
          ]
        },
        {
          "code" : "TIDT",
          "display" : "T",
          "definition" : "Mandibular right second primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19522"
            }
          ]
        }
      ]
    },
    {
      "code" : "SupernumeraryTooth",
      "display" : "Supernumerary Tooth",
      "definition" : "Supernumerary tooth, any tooth in addition to the normal permanent and primary dentition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19449"
        }
      ],
      "concept" : [
        {
          "code" : "TID10s",
          "display" : "10s",
          "definition" : "Supernumerary maxillary left lateral incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19459"
            }
          ]
        },
        {
          "code" : "TID11s",
          "display" : "11s",
          "definition" : "Supernumerary maxillary left canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19460"
            }
          ]
        },
        {
          "code" : "TID12s",
          "display" : "12s",
          "definition" : "Supernumerary maxillary left first premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19461"
            }
          ]
        },
        {
          "code" : "TID13s",
          "display" : "13s",
          "definition" : "Supernumerary maxillary left second premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19462"
            }
          ]
        },
        {
          "code" : "TID14s",
          "display" : "14s",
          "definition" : "Supernumerary maxillary left first molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19463"
            }
          ]
        },
        {
          "code" : "TID15s",
          "display" : "15s",
          "definition" : "Supernumerary maxillary left second molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19464"
            }
          ]
        },
        {
          "code" : "TID16s",
          "display" : "16s",
          "definition" : "Supernumerary maxillary left third molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19465"
            }
          ]
        },
        {
          "code" : "TID17s",
          "display" : "17s",
          "definition" : "Supernumerary mandibular left third molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19466"
            }
          ]
        },
        {
          "code" : "TID18s",
          "display" : "18s",
          "definition" : "Supernumerary mandibular left second molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19467"
            }
          ]
        },
        {
          "code" : "TID19s",
          "display" : "19s",
          "definition" : "Supernumerary mandibular left first molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19468"
            }
          ]
        },
        {
          "code" : "TID1s",
          "display" : "1s",
          "definition" : "Supernumerary maxillary right third molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19450"
            }
          ]
        },
        {
          "code" : "TID20s",
          "display" : "20s",
          "definition" : "Supernumerary mandibular left second premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19469"
            }
          ]
        },
        {
          "code" : "TID21s",
          "display" : "21s",
          "definition" : "Supernumerary mandibular left first premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19470"
            }
          ]
        },
        {
          "code" : "TID22s",
          "display" : "22s",
          "definition" : "Supernumerary mandibular left canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19471"
            }
          ]
        },
        {
          "code" : "TID23s",
          "display" : "23s",
          "definition" : "Supernumerary mandibular left lateral incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19472"
            }
          ]
        },
        {
          "code" : "TID24s",
          "display" : "24s",
          "definition" : "Supernumerary mandibular left central incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19473"
            }
          ]
        },
        {
          "code" : "TID25s",
          "display" : "25s",
          "definition" : "Supernumerary mandibular right central incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19474"
            }
          ]
        },
        {
          "code" : "TID26s",
          "display" : "26s",
          "definition" : "Supernumerary mandibular right lateral incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19475"
            }
          ]
        },
        {
          "code" : "TID27s",
          "display" : "27s",
          "definition" : "Supernumerary mandibular right canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19476"
            }
          ]
        },
        {
          "code" : "TID28s",
          "display" : "28s",
          "definition" : "Supernumerary mandibular right first premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19477"
            }
          ]
        },
        {
          "code" : "TID29s",
          "display" : "29s",
          "definition" : "Supernumerary mandibular right second premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19478"
            }
          ]
        },
        {
          "code" : "TID2s",
          "display" : "2s",
          "definition" : "Supernumerary maxillary right second molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19451"
            }
          ]
        },
        {
          "code" : "TID30s",
          "display" : "30s",
          "definition" : "Supernumerary mandibular right first molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19479"
            }
          ]
        },
        {
          "code" : "TID31s",
          "display" : "31s",
          "definition" : "Supernumerary mandibular right second molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19480"
            }
          ]
        },
        {
          "code" : "TID32s",
          "display" : "32s",
          "definition" : "Supernumerary mandibular right third molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19481"
            }
          ]
        },
        {
          "code" : "TID3s",
          "display" : "3s",
          "definition" : "Supernumerary maxillary right first molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19452"
            }
          ]
        },
        {
          "code" : "TID4s",
          "display" : "4s",
          "definition" : "Supernumerary maxillary right second premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19453"
            }
          ]
        },
        {
          "code" : "TID5s",
          "display" : "5s",
          "definition" : "Supernumerary maxillary right first premolar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19454"
            }
          ]
        },
        {
          "code" : "TID6s",
          "display" : "6s",
          "definition" : "Supernumerary maxillary right canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19455"
            }
          ]
        },
        {
          "code" : "TID7s",
          "display" : "7s",
          "definition" : "Supernumerary maxillary right lateral incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19456"
            }
          ]
        },
        {
          "code" : "TID8s",
          "display" : "8s",
          "definition" : "Supernumerary maxillary right central incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19457"
            }
          ]
        },
        {
          "code" : "TID9s",
          "display" : "9s",
          "definition" : "Supernumerary maxillary left central incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19458"
            }
          ]
        },
        {
          "code" : "TIDAs",
          "display" : "As",
          "definition" : "Supernumerary maxillary right second primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19482"
            }
          ]
        },
        {
          "code" : "TIDBs",
          "display" : "Bs",
          "definition" : "Supernumerary maxillary right first primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19483"
            }
          ]
        },
        {
          "code" : "TIDCs",
          "display" : "Cs",
          "definition" : "Supernumerary maxillary right primary canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19484"
            }
          ]
        },
        {
          "code" : "TIDDs",
          "display" : "Ds",
          "definition" : "Supernumerary maxillary right lateral primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19485"
            }
          ]
        },
        {
          "code" : "TIDEs",
          "display" : "Es",
          "definition" : "Supernumerary maxillary right central primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19486"
            }
          ]
        },
        {
          "code" : "TIDFs",
          "display" : "Fs",
          "definition" : "Supernumerary maxillary left central primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19487"
            }
          ]
        },
        {
          "code" : "TIDGs",
          "display" : "Gs",
          "definition" : "Supernumerary maxillary left lateral primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19488"
            }
          ]
        },
        {
          "code" : "TIDHs",
          "display" : "Hs",
          "definition" : "Supernumerary maxillary left primary canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19489"
            }
          ]
        },
        {
          "code" : "TIDIs",
          "display" : "Is",
          "definition" : "Supernumerary maxillary left first primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19490"
            }
          ]
        },
        {
          "code" : "TIDJs",
          "display" : "Js",
          "definition" : "Supernumerary maxillary left second primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19491"
            }
          ]
        },
        {
          "code" : "TIDKs",
          "display" : "Ks",
          "definition" : "Supernumerary mandibular left second primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19492"
            }
          ]
        },
        {
          "code" : "TIDLs",
          "display" : "Ls",
          "definition" : "Supernumerary mandibular left first primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19493"
            }
          ]
        },
        {
          "code" : "TIDMs",
          "display" : "Ms",
          "definition" : "Supernumerary mandibular left primary canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19494"
            }
          ]
        },
        {
          "code" : "TIDNs",
          "display" : "Ns",
          "definition" : "Supernumerary mandibular left lateral primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19495"
            }
          ]
        },
        {
          "code" : "TIDOs",
          "display" : "Os",
          "definition" : "Supernumerary mandibular left central primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19496"
            }
          ]
        },
        {
          "code" : "TIDPs",
          "display" : "Ps",
          "definition" : "Supernumerary mandibular right central primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19497"
            }
          ]
        },
        {
          "code" : "TIDQs",
          "display" : "Qs",
          "definition" : "Supernumerary mandibular right lateral primary incisor",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19498"
            }
          ]
        },
        {
          "code" : "TIDRs",
          "display" : "Rs",
          "definition" : "Supernumerary mandibular right primary canine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19499"
            }
          ]
        },
        {
          "code" : "TIDSs",
          "display" : "Ss",
          "definition" : "Supernumerary mandibular right first primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19500"
            }
          ]
        },
        {
          "code" : "TIDTs",
          "display" : "Ts",
          "definition" : "Supernumerary mandibular right second primary molar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19501"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ArtificialDentition",
      "display" : "ArtificialDentition",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21296"
        }
      ]
    },
    {
      "code" : "_Dentition",
      "display" : "Dentition",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21297"
        }
      ]
    },
    {
      "code" : "_PermanentDentition",
      "display" : "PermanentDentition",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21298"
        }
      ]
    },
    {
      "code" : "_PrimaryDentition",
      "display" : "PrimaryDentition",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21299"
        }
      ]
    },
    {
      "code" : "_SupernumeraryTooth",
      "display" : "SupernumeraryTooth",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21300"
        }
      ]
    }
  ]
}

```
